/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Shape;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

public class SVGShapeImpl
extends SVGInputBase
implements Shape {
    protected static final String SHAPE_ID_EDEFAULT = null;
    protected Object dataSetId = SHAPE_ID_EDEFAULT;
    protected DCurve curve = null;

    public SVGShapeImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic(), null);
    }

    public SVGShapeImpl(Chart chart, DGraphic dgraphic, DCurve curve) {
        this._chart = chart;
        this._dgraphic = dgraphic;
        this.curve = curve;
    }

    public String getShapeId() {
        String id = this.curve.getProperties().get("SYMBOL.DCurve.core.jscrib", SHAPE_ID_EDEFAULT);
        if (id instanceof String) {
            return id;
        }
        return SHAPE_ID_EDEFAULT;
    }

    public void setShapeId(String newShapeId) {
        this.curve.getProperties().store("SYMBOL.DCurve.core.jscrib", newShapeId);
    }

    public Object getDataSetId() {
        if (this.dataSetId == null && this._dgraphic != null) {
            String refId = Integer.toString(EventTools.getHashCode(this.curve));
            Data data = this._chart.getData();
            DataSets dataSets = data.getDataSets();
            List dataSetList = dataSets.getDataSet();
            int i = 0;
            while (i < dataSetList.size()) {
                DataSet dataSet = (DataSet)dataSetList.get(i);
                if (dataSet.getId() != null && dataSet.getId().equals(refId)) {
                    this.dataSetId = dataSet;
                    break;
                }
                ++i;
            }
        }
        return this.dataSetId;
    }

    public void setDataSetId(Object newDataSetId) {
    }

    public void assignDataSetId(Object newDataSetId) {
        try {
            DataSet dataSet = (DataSet)newDataSetId;
            String dataSetIdStr = dataSet.getId();
            if (this.curve != null) {
                this.curve.getProperties().store("P_ID.DCurve.core.jscrib", dataSetIdStr);
            }
        }
        catch (ClassCastException classCastException) {}
    }

    public String fetchDataSetId() {
        return this.curve.getProperties().get("P_ID.DCurve.core.jscrib").toString();
    }

    public void setDCurve(DCurve dcurve) {
        this.curve = dcurve;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (shapeId: ");
        result.append(this.getShapeId());
        result.append(')');
        return result.toString();
    }
}

