/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.cim;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGInputBase;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;

public class SVGUnitDefinitionImpl
extends SVGInputBase
implements UnitDefinition {
    protected DAxis axis;
    protected String showGridAttr;
    protected String showTickAttr;
    protected String valueAttr;
    protected static final boolean SHOW_GRID_LINE_EDEFAULT = false;
    protected boolean showGridLineESet = false;
    protected static final boolean SHOW_TICK_EDEFAULT = false;
    protected boolean showTickESet = false;
    protected static final double VALUE_EDEFAULT = 0.0;
    protected boolean valueESet = false;

    protected SVGUnitDefinitionImpl() {
    }

    public SVGUnitDefinitionImpl(SVGChartImpl chart) {
        this(chart, chart.getDGraphic(), null, null, null, null);
    }

    public SVGUnitDefinitionImpl(Chart chart, DGraphic dgraphic, DAxis axis, String showTickAttr, String showGridAttr, String valueAttr) {
        this._chart = chart;
        this._dgraphic = dgraphic;
        this.axis = axis;
        this.showTickAttr = showTickAttr;
        this.valueAttr = valueAttr;
        this.showGridAttr = showGridAttr;
    }

    public void unsetShowGridLine() {
        this.showGridLineESet = false;
        this.axis.getProperties().remove(this.showGridAttr);
    }

    public double getValue() {
        Object value = this.axis.getProperties().get(this.valueAttr);
        if (value instanceof Double) {
            this.valueESet = true;
            return (Double)value;
        }
        return 0.0;
    }

    public boolean isShowGridLine() {
        if ((Boolean)this.axis.getProperties().get(this.showGridAttr) != null) {
            this.showGridLineESet = true;
            return (Boolean)this.axis.getProperties().get(this.showGridAttr);
        }
        return false;
    }

    public boolean isShowTick() {
        if ((Boolean)this.axis.getProperties().get(this.showTickAttr) != null) {
            this.showTickESet = true;
            return (Boolean)this.axis.getProperties().get(this.showTickAttr);
        }
        return false;
    }

    public void setShowGridLine(boolean showGridLine) {
        this.showGridLineESet = true;
        this.axis.getProperties().store(this.showGridAttr, showGridLine);
    }

    public void setShowTick(boolean showTick) {
        this.showTickESet = true;
        this.axis.getProperties().store(this.showTickAttr, showTick);
    }

    public void setValue(double value) {
        this.valueESet = true;
        this.axis.getProperties().store(this.valueAttr, value);
    }

    public boolean isSetShowGridLine() {
        if (!this.showGridLineESet) {
            this.isShowGridLine();
        }
        return this.showGridLineESet;
    }

    public void unsetShowTick() {
        this.showTickESet = false;
        this.axis.getProperties().remove(this.showTickAttr);
    }

    public boolean isSetShowTick() {
        if (!this.showTickESet) {
            this.isShowTick();
        }
        return this.showTickESet;
    }

    public void unsetValue() {
        this.valueESet = false;
        this.axis.getProperties().remove(this.valueAttr);
    }

    public boolean isSetValue() {
        if (!this.valueESet) {
            this.getValue();
        }
        return this.valueESet;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (showGridLine: ");
        if (this.showGridLineESet) {
            result.append(this.isShowGridLine());
        } else {
            result.append("<unset>");
        }
        result.append(", showTick: ");
        if (this.showTickESet) {
            result.append(this.isSetShowTick());
        } else {
            result.append("<unset>");
        }
        result.append(", value: ");
        if (this.valueESet) {
            result.append(this.getValue());
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }
}

