/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AccessibilityImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.EventHandlerImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.TooltipImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.ElementList;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;

public class CategoricalDataImpl
extends InputBase
implements CategoricalData {
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;
    protected static final String TYPE_EDEFAULT = "actual";
    protected String type = "actual";
    protected boolean typeESet = false;
    protected static final double VALUE_EDEFAULT = 0.0;
    protected double value = 0.0;
    protected boolean valueESet = false;
    protected Accessibility accessibility = null;
    protected List eventHandler = null;
    protected Tooltip tooltip = null;
    protected Object categoryId = null;

    protected CategoricalDataImpl() {
    }

    public CategoricalDataImpl(Chart chart) {
        this._chart = chart;
        if (this._chart.getElement() != null) {
            this._element = this._chart.getElement().getOwnerDocument().createElement("categoricalData");
        }
    }

    public CategoricalDataImpl(Chart chart, Element element) {
        this._chart = chart;
        this._element = element;
    }

    public String getId() {
        if (this.id == ID_EDEFAULT && this._element != null && this._element.hasAttribute("id")) {
            this.id = this._element.getAttribute("id");
        }
        return this.id;
    }

    public void setId(String newId) {
        this.id = newId;
        if (this._element != null) {
            this._element.setAttribute("id", newId);
        }
    }

    public String getType() {
        if (this.type.equals(TYPE_EDEFAULT) && this._element != null && this._element.hasAttribute("type")) {
            this.type = this._element.getAttribute("type");
            this.typeESet = true;
        }
        return this.type;
    }

    public void setType(String newType) {
        this.type = newType;
        this.typeESet = true;
        if (this._element != null) {
            this._element.setAttribute("type", newType);
        }
    }

    public void unsetType() {
        this.typeESet = false;
        this.type = TYPE_EDEFAULT;
        if (this._element != null && this._element.hasAttribute("type")) {
            this._element.removeAttribute("type");
        }
    }

    public boolean isSetType() {
        if (!this.typeESet) {
            this.getType();
        }
        return this.typeESet;
    }

    public double getValue() {
        String attr;
        if (this.value == 0.0 && this._element != null && this._element.hasAttribute("value") && (attr = this._element.getAttribute("value")).length() != 0) {
            this.value = new Double(attr);
            this.valueESet = true;
        }
        return this.value;
    }

    public void setValue(double newValue) {
        this.value = newValue;
        this.valueESet = true;
        if (this._element != null) {
            this._element.setAttribute("value", Double.toString(newValue));
        }
    }

    public void unsetValue() {
        this.valueESet = false;
        this.value = 0.0;
        if (this._element != null && this._element.hasAttribute("value")) {
            this._element.removeAttribute("value");
        }
    }

    public boolean isSetValue() {
        if (!this.valueESet) {
            this.getValue();
        }
        return this.valueESet;
    }

    public Accessibility getAccessibility() {
        Element resultElement;
        if (this.accessibility == null && this._element != null && (resultElement = Utilities.getElement(this._element, "accessibility")) != null) {
            this.accessibility = new AccessibilityImpl(this._chart, resultElement);
        }
        return this.accessibility;
    }

    public void setAccessibility(Accessibility newAccessibility) {
        this.accessibility = newAccessibility;
        if (this._element != null && newAccessibility != null && newAccessibility.getElement() != null) {
            Utilities.appendChild(this, newAccessibility, "accessibility");
        }
    }

    public List getEventHandler() {
        if (this.eventHandler == null) {
            if (this._element != null) {
                List elementList = Utilities.getElementList(this._element, "eventHandler");
                this.eventHandler = new ElementList(this, "eventHandler");
                ElementList elemList = (ElementList)this.eventHandler;
                int i = 0;
                while (i < elementList.size()) {
                    elemList.add(new EventHandlerImpl(this._chart, (Element)elementList.get(i)), false);
                    ++i;
                }
            } else {
                this.eventHandler = new ArrayList();
            }
        }
        return this.eventHandler;
    }

    public Tooltip getTooltip() {
        Element resultElement;
        if (this.tooltip == null && this._element != null && (resultElement = Utilities.getElement(this._element, "tooltip")) != null) {
            this.tooltip = new TooltipImpl(this._chart, resultElement);
        }
        return this.tooltip;
    }

    public void setTooltip(Tooltip newTooltip) {
        this.tooltip = newTooltip;
        if (this._element != null && newTooltip != null && newTooltip.getElement() != null) {
            Utilities.appendChild(this, newTooltip, "tooltip");
        }
    }

    public Object getCategoryId() {
        if (this.categoryId == null && this._element != null) {
            String refId = this._element.getAttribute("categoryId");
            Data data = this._chart.getData();
            Categories categories = data.getCategories();
            List categoryList = categories.getCategory();
            int i = 0;
            while (i < categoryList.size()) {
                Category category = (Category)categoryList.get(i);
                if (category.getId().equals(refId)) {
                    this.categoryId = category;
                    break;
                }
                ++i;
            }
        }
        return this.categoryId;
    }

    public void setCategoryId(Object newCategoryId) {
        this.categoryId = newCategoryId;
        Category category = null;
        try {
            category = (Category)newCategoryId;
            String categoryIdStr = category.getId();
            if (this._element != null) {
                this._element.setAttribute("categoryId", categoryIdStr);
            }
        }
        catch (ClassCastException classCastException) {}
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (id: ");
        result.append(this.id);
        result.append(", type: ");
        if (this.typeESet) {
            result.append(this.type);
        } else {
            result.append("<unset>");
        }
        result.append(", value: ");
        if (this.valueESet) {
            result.append(this.value);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }
}

