/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.NumberFormatImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;

public class DataValueImpl
extends InputBase
implements DataValue {
    protected static final String PERCENTAGE_VISIBILITY_EDEFAULT = null;
    protected String percentageVisibility = PERCENTAGE_VISIBILITY_EDEFAULT;
    protected static final String VALUE_VISIBILITY_EDEFAULT = null;
    protected String valueVisibility = VALUE_VISIBILITY_EDEFAULT;
    protected NumberFormat numberFormat = null;

    protected DataValueImpl() {
    }

    public DataValueImpl(Chart chart) {
        this._chart = chart;
        if (this._chart.getElement() != null) {
            this._element = this._chart.getElement().getOwnerDocument().createElement("dataValue");
        }
    }

    public DataValueImpl(Chart chart, Element element) {
        this._chart = chart;
        this._element = element;
    }

    public String getPercentageVisibility() {
        if (this.percentageVisibility == PERCENTAGE_VISIBILITY_EDEFAULT && this._element != null && this._element.hasAttribute("percentageVisibility")) {
            this.percentageVisibility = this._element.getAttribute("percentageVisibility");
        }
        return this.percentageVisibility;
    }

    public void setPercentageVisibility(String newPercentageVisibility) {
        this.percentageVisibility = newPercentageVisibility;
        if (this._element != null) {
            this._element.setAttribute("percentageVisibility", newPercentageVisibility);
        }
    }

    public String getValueVisibility() {
        if (this.valueVisibility == VALUE_VISIBILITY_EDEFAULT && this._element != null && this._element.hasAttribute("valueVisibility")) {
            this.valueVisibility = this._element.getAttribute("valueVisibility");
        }
        return this.valueVisibility;
    }

    public void setValueVisibility(String newValueVisibility) {
        this.valueVisibility = newValueVisibility;
        if (this._element != null) {
            this._element.setAttribute("valueVisibility", newValueVisibility);
        }
    }

    public NumberFormat getNumberFormat() {
        Element resultElement;
        if (this.numberFormat == null && this._element != null && (resultElement = Utilities.getElement(this._element, "numberFormat")) != null) {
            this.numberFormat = new NumberFormatImpl(this._chart, resultElement);
        }
        return this.numberFormat;
    }

    public void setNumberFormat(NumberFormat newNumberFormat) {
        this.numberFormat = newNumberFormat;
        if (this._element != null && newNumberFormat != null && newNumberFormat.getElement() != null) {
            Utilities.appendChild(this, newNumberFormat, "numberFormat");
        }
    }
}

