/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Ecmascript;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class EcmascriptImpl
extends InputBase
implements Ecmascript {
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    protected static final String HREF_EDEFAULT = null;
    protected String href = HREF_EDEFAULT;

    protected EcmascriptImpl() {
    }

    public EcmascriptImpl(Chart chart) {
        this._chart = chart;
        if (this._chart.getElement() != null) {
            this._element = this._chart.getElement().getOwnerDocument().createElement("ecmascript");
        }
    }

    public EcmascriptImpl(Chart chart, Element element) {
        this._chart = chart;
        this._element = element;
    }

    public String getValue() {
        if (this.value == VALUE_EDEFAULT && this._element != null) {
            this.value = Utilities.getText(this._element);
        }
        return this.value;
    }

    public void setValue(String newValue) {
        this.value = newValue;
        if (this._element != null) {
            Text textNode = this._element.getOwnerDocument().createTextNode(newValue);
            this._element.appendChild(textNode);
        }
    }

    public String getHref() {
        if (this.href == HREF_EDEFAULT && this._element != null && this._element.hasAttribute("href")) {
            this.href = this._element.getAttribute("href");
        }
        return this.href;
    }

    public void setHref(String newHref) {
        this.href = newHref;
        if (this._element != null) {
            this._element.setAttribute("href", newHref);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(", href: ");
        result.append(this.href);
        result.append(')');
        return result.toString();
    }
}

