/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.input.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.TitleBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.AccessibilityImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.EventHandlerImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.InputBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.impl.TooltipImpl;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.ElementList;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.w3c.dom.Element;

public class TitleBarImpl
extends InputBase
implements TitleBar {
    protected static final String BACKGROUND_COLOR_EDEFAULT = null;
    protected String backgroundColor = BACKGROUND_COLOR_EDEFAULT;
    protected static final String LABEL_EDEFAULT = null;
    protected String label = LABEL_EDEFAULT;
    protected static final boolean SHOW_EDEFAULT = true;
    protected boolean show = true;
    protected boolean showESet = false;
    protected static final boolean WITH_SEPARATOR_EDEFAULT = true;
    protected boolean withSeparator = true;
    protected boolean withSeparatorESet = false;
    protected Accessibility accessibility = null;
    protected List eventHandler = null;
    protected Tooltip tooltip = null;

    protected TitleBarImpl() {
    }

    public TitleBarImpl(Chart chart) {
        this._chart = chart;
        if (this._chart.getElement() != null) {
            this._element = this._chart.getElement().getOwnerDocument().createElement("titleBar");
        }
    }

    public TitleBarImpl(Chart chart, Element element) {
        this._chart = chart;
        this._element = element;
    }

    public String getBackgroundColor() {
        if (this.backgroundColor == LABEL_EDEFAULT && this._element != null && this._element.hasAttribute("backgroundColor")) {
            this.backgroundColor = this._element.getAttribute("backgroundColor");
        }
        return this.backgroundColor;
    }

    public void setBackgroundColor(String newBackgroundColor) {
        this.backgroundColor = newBackgroundColor;
        if (this._element != null) {
            this._element.setAttribute("backgroundColor", newBackgroundColor);
        }
    }

    public String getLabel() {
        if (this.label == LABEL_EDEFAULT && this._element != null && this._element.hasAttribute("label")) {
            this.label = this._element.getAttribute("label");
        }
        return this.label;
    }

    public void setLabel(String newLabel) {
        this.label = newLabel;
        if (this._element != null) {
            this._element.setAttribute("label", newLabel);
        }
    }

    public boolean isShow() {
        String attr;
        if (this.show && this._element != null && this._element.hasAttribute("show") && (attr = this._element.getAttribute("show")).length() != 0) {
            if (attr.equalsIgnoreCase("false")) {
                this.show = false;
            }
            this.showESet = true;
        }
        return this.show;
    }

    public void setShow(boolean newShow) {
        this.show = newShow;
        this.showESet = true;
        if (this._element != null) {
            if (this.show) {
                this._element.setAttribute("show", "true");
            } else {
                this._element.setAttribute("show", "false");
            }
        }
    }

    public void unsetShow() {
        this.showESet = false;
        this.show = true;
        if (this._element != null && this._element.hasAttribute("show")) {
            this._element.removeAttribute("show");
        }
    }

    public boolean isSetShow() {
        if (!this.showESet) {
            this.isShow();
        }
        return this.showESet;
    }

    public boolean isWithSeparator() {
        String attr;
        if (this.withSeparator && this._element != null && this._element.hasAttribute("withSeparator") && (attr = this._element.getAttribute("withSeparator")).length() != 0) {
            if (attr.equalsIgnoreCase("false")) {
                this.withSeparator = false;
            }
            this.withSeparatorESet = true;
        }
        return this.withSeparator;
    }

    public void setWithSeparator(boolean newWithSeparator) {
        this.withSeparator = newWithSeparator;
        this.withSeparatorESet = true;
        if (this._element != null) {
            if (this.withSeparator) {
                this._element.setAttribute("withSeparator", "true");
            } else {
                this._element.setAttribute("withSeparator", "false");
            }
        }
    }

    public void unsetWithSeparator() {
        this.withSeparatorESet = false;
        this.withSeparator = true;
        if (this._element != null && this._element.hasAttribute("withSeparator")) {
            this._element.removeAttribute("withSeparator");
        }
    }

    public boolean isSetWithSeparator() {
        if (!this.withSeparatorESet) {
            this.isWithSeparator();
        }
        return this.withSeparatorESet;
    }

    public Accessibility getAccessibility() {
        Element resultElement;
        if (this.accessibility == null && this._element != null && (resultElement = Utilities.getElement(this._element, "accessibility")) != null) {
            this.accessibility = new AccessibilityImpl(this._chart, resultElement);
        }
        return this.accessibility;
    }

    public void setAccessibility(Accessibility newAccessibility) {
        this.accessibility = newAccessibility;
        if (this._element != null && newAccessibility != null && newAccessibility.getElement() != null) {
            Utilities.appendChild(this, newAccessibility, "accessibility");
        }
    }

    public List getEventHandler() {
        if (this.eventHandler == null) {
            if (this._element != null) {
                List elementList = Utilities.getElementList(this._element, "eventHandler");
                this.eventHandler = new ElementList(this, "eventHandler");
                ElementList elemList = (ElementList)this.eventHandler;
                int i = 0;
                while (i < elementList.size()) {
                    elemList.add(new EventHandlerImpl(this._chart, (Element)elementList.get(i)), false);
                    ++i;
                }
            } else {
                this.eventHandler = new ArrayList();
            }
        }
        return this.eventHandler;
    }

    public Tooltip getTooltip() {
        Element resultElement;
        if (this.tooltip == null && this._element != null && (resultElement = Utilities.getElement(this._element, "tooltip")) != null) {
            this.tooltip = new TooltipImpl(this._chart, resultElement);
        }
        return this.tooltip;
    }

    public void setTooltip(Tooltip newTooltip) {
        this.tooltip = newTooltip;
        if (this._element != null && newTooltip != null && newTooltip.getElement() != null) {
            Utilities.appendChild(this, newTooltip, "tooltip");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (label: ");
        result.append(this.label);
        result.append(", withSeparator: ");
        if (this.withSeparatorESet) {
            result.append(this.withSeparator);
        } else {
            result.append("<unset>");
        }
        if (this.showESet) {
            result.append(this.show);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }
}

