/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategoryVertical;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisLabel;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class AxisCategoryVertical3D
extends AxisCategoryVertical {
    static final long serialVersionUID = 2184364356962451015L;
    protected double x3Doffset;
    protected double y3Doffset;

    public AxisCategoryVertical3D(Chart input, boolean isLTR, double x3Doffset, double y3Doffset, NLString nls) {
        super(input, isLTR, nls);
        this.x3Doffset = x3Doffset;
        this.y3Doffset = y3Doffset;
    }

    public AxisCategoryVertical3D(Chart input, boolean isLTR, short labelOrientation, double x3Doffset, double y3Doffset, NLString nls) {
        super(input, isLTR, labelOrientation, nls);
        this.x3Doffset = x3Doffset;
        this.y3Doffset = y3Doffset;
    }

    protected SVGBase drawTickMarks() {
        SVGPolyline tickDef = new SVGPolyline();
        if (this.left) {
            tickDef.setPoints(String.valueOf(this.x3Doffset) + " " + -this.y3Doffset + " 0 0");
        } else {
            tickDef.setPoints(String.valueOf(this.x3Doffset + this.x3Doffset) + " " + -this.y3Doffset + " " + this.x3Doffset + " 0");
        }
        return tickDef;
    }

    protected SVGBase drawHorizontalLabels() {
        double[] labelPositions = this.getGroupDataPositions();
        SVGGroup labelGroup = new SVGGroup();
        SVGBase[] svglabels = new SVGBase[labelPositions.length];
        labelGroup.setChildren(svglabels);
        int i = 0;
        while (i < labelPositions.length) {
            Category category = (Category)this.categoryList.get(i);
            String labelText = category.getLabel();
            if (labelText != null) {
                SVGGroup label = new SVGGroup();
                SVGBase[] rowText = new SVGBase[2];
                label.setChildren(rowText);
                label.setIdentifier(category.getId());
                rowText[1] = EventTools.generateUserTooltip(label, category.getTooltip(), this.nls);
                EventTools.generateUserEvents(label, category.getEventHandler());
                EventTools.generateAccessibility(label, category.getAccessibility(), this.nls);
                AxisLabel labelLine = null;
                if (this.left) {
                    labelLine = new AxisLabel(0, 0);
                    labelLine.setXCoordinate(Double.toString(this.getTitleWidth() + this.getLabelWidth()));
                    labelLine.setYCoordinate(Double.toString(labelPositions[labelPositions.length - 1 - i] + this.y3Doffset));
                } else {
                    labelLine = new AxisLabel(0, 1);
                    labelLine.setXCoordinate(Double.toString(13.0));
                    labelLine.setYCoordinate(Double.toString(labelPositions[labelPositions.length - 1 - i] + this.y3Doffset));
                }
                labelLine.setDegrees(this.labelDegrees);
                labelLine.setIdentifier("SVGGEN_axisLabel" + EventTools.getUniqueID());
                labelLine.setText(this.nls.getString(labelText));
                rowText[0] = labelLine;
                svglabels[i] = label;
            }
            ++i;
        }
        return labelGroup;
    }

    public void setCrossPoint(double x, double y) {
        if (this.left) {
            this.setXCoordinate(Double.toString(x - this.getAxisWidth() + 5.0));
            this.setYCoordinate(Double.toString(y - this.getAxisLength() - this.y3Doffset));
        } else {
            this.setXCoordinate(Double.toString(x - 5.0));
            this.setYCoordinate(Double.toString(y - this.getAxisLength() - this.y3Doffset));
        }
    }

    protected void constructPart() {
        SVGUse useTick;
        int i;
        String tick_x;
        SVGBase[] ticks;
        SVGGroup tickGroup;
        double[] tickPositions;
        this.setYCoordinate("" + (Double.parseDouble(this.getYCoordinate()) - (double)this.marginForMax));
        SVGGroup axisGroup = new SVGGroup();
        axisGroup.setTransformation("translate(0," + this.marginForMax + ")");
        SVGBase[] axisParts = new SVGBase[5];
        axisGroup.setChildren(axisParts);
        if (this.axisDef != null) {
            axisGroup.setIdentifier(this.axisDef.getId());
        }
        SVGBase[] child = new SVGBase[]{axisGroup};
        this.setChildren(child);
        SVGLine axis = new SVGLine();
        String axis_x = this.left ? Double.toString(this.getTitleWidth() + this.getLabelWidth() + 8.0) : Integer.toString(5);
        axis.setX1(axis_x);
        axis.setY1(Double.toString(this.y3Doffset));
        axis.setX2(axis_x);
        axis.setY2(Double.toString(this.y3Doffset + this.axisHeight));
        axis.setStyleClass("axisLines");
        SVGGroup axisGroup2 = new SVGGroup();
        SVGBase[] axisGroup2Children = new SVGBase[2];
        axisGroup2Children[0] = axis;
        axisGroup2.setChildren(axisGroup2Children);
        if (this.axisDef != null) {
            axisGroup2Children[1] = EventTools.generateUserTooltip(axisGroup2, this.axisDef.getTooltip(), this.nls);
            EventTools.generateUserEvents(axisGroup2, this.axisDef.getEventHandler());
            EventTools.generateAccessibility(axisGroup2, this.axisDef.getAccessibility(), this.nls);
        }
        axisParts[0] = axisGroup2;
        SVGGroup tickDefGroup = new SVGGroup();
        tickDefGroup.setIdentifier("tickline");
        SVGBase tickDef = this.drawTickMarks();
        tickDef.setStyleClass("axisTicks");
        tickDef.setIdentifier("tickline");
        SVGBase[] tick = new SVGBase[]{tickDef};
        tickDefGroup.setChildren(tick);
        this.addDefinition(tickDef);
        if (this.showMajorTicks) {
            tickPositions = this.getGroupBoundaryPositions();
            tickGroup = new SVGGroup();
            ticks = new SVGBase[tickPositions.length];
            axisParts[1] = tickGroup;
            tickGroup.setChildren(ticks);
            tick_x = this.left ? axis_x : "0";
            i = 0;
            while (i < tickPositions.length) {
                useTick = new SVGUse();
                useTick.setHref("#tickline");
                useTick.setXCoordinate(tick_x);
                useTick.setYCoordinate(Double.toString(tickPositions[i] + this.y3Doffset));
                ticks[i] = useTick;
                ++i;
            }
        }
        if (this.showMinorTicks) {
            tickPositions = this.getGroupDataPositions();
            tickGroup = new SVGGroup();
            ticks = new SVGBase[tickPositions.length];
            axisParts[2] = tickGroup;
            tickGroup.setChildren(ticks);
            tick_x = this.left ? axis_x : "0";
            i = 0;
            while (i < tickPositions.length) {
                useTick = new SVGUse();
                useTick.setHref("#tickline");
                useTick.setXCoordinate(tick_x);
                useTick.setYCoordinate(Double.toString(tickPositions[i] + this.y3Doffset));
                ticks[i] = useTick;
                ++i;
            }
        }
        axisParts[3] = this.labelOrientation == 0 ? this.drawHorizontalLabels() : this.drawVerticalLabels();
        if (this.title != null) {
            String title_x = this.left ? Double.toString(9.0) : Double.toString(this.getAxisWidth());
            SVGText svgTitle = new SVGText();
            svgTitle.setText(this.nls.getString(this.title));
            String xanchor = title_x;
            String yanchor = Double.toString(this.getAxisLength() / 2.0);
            svgTitle.setXCoordinate(xanchor);
            svgTitle.setYCoordinate("" + (Double.parseDouble(yanchor) + this.y3Doffset));
            svgTitle.setStyleClass("axisTitles anchorAtMiddle");
            svgTitle.setTransformation("rotate(270," + xanchor + "," + yanchor + ")");
            svgTitle.setIdentifier("SVGGEN_labelsValues0");
            axisParts[4] = svgTitle;
        }
    }
}

