/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisLabel;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.FontHelper;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class AxisNumberHorizontal
extends AxisNumber {
    static final long serialVersionUID = -7315397100775509637L;
    private boolean bottom = true;
    private boolean isLTR = true;
    protected String topString = "";
    private double offset = 100.0;
    private int AXIS_LABEL_LINE_HEIGHT = 14;

    public int getMarginForMax() {
        int margin = super.getMarginForMax();
        if (this.labelDegrees > 90.0) {
            margin = 2 * (margin + 5) - 5;
        }
        return margin;
    }

    public AxisNumberHorizontal(Chart input, boolean isLTR, List datasets, short axisType, boolean cumulative, NLString nls) {
        super(input, datasets, axisType, cumulative, nls);
        if (axisType == 2) {
            this.bottom = false;
        }
        this.isLTR = isLTR;
    }

    public AxisNumberHorizontal(Chart input, boolean isLTR, List datasets, short axisType, boolean cumulative, short labelOrientation, NLString nls) {
        super(input, datasets, axisType, cumulative, labelOrientation, nls);
        if (axisType == 2) {
            this.bottom = false;
        }
        this.isLTR = isLTR;
    }

    public void setAxisLength(double length) {
        this.axisWidth = length;
        this.setWidth(Double.toString(length + this.offset * 2.0));
    }

    public double getAxisLength() {
        return this.axisWidth;
    }

    public void setCrossPoint(double x, double y) {
        if (this.bottom) {
            this.setXCoordinate(Double.toString(x - this.offset));
            this.setYCoordinate(Double.toString(y - 5.0));
        } else {
            this.setXCoordinate(Double.toString(x - this.offset));
            this.setYCoordinate(Double.toString(y - this.getAxisHeight() + 5.0));
        }
    }

    protected SVGBase drawHorizontalLabels(double[] positions) {
        SVGGroup labelGroup = new SVGGroup();
        SVGBase[] svgLabels = new SVGBase[positions.length];
        labelGroup.setChildren(svgLabels);
        this.topString = "";
        double topY = -4.9E-324;
        int i = 0;
        while (i < positions.length) {
            int currentY = this.bottom ? 17 : this.getTitleHeight() + this.AXIS_LABEL_LINE_HEIGHT;
            if (this.labels[i] != null) {
                SVGGroup label = new SVGGroup();
                SVGBase[] rowText = new SVGBase[1];
                label.setChildren(rowText);
                AxisLabel labelLine = new AxisLabel(2, 1);
                labelLine.setDegrees(this.labelDegrees);
                labelLine.setXCoordinate(Double.toString(positions[i]));
                labelLine.setYCoordinate(Integer.toString(currentY));
                labelLine.setIdentifier("SVGGEN_axisLabel" + EventTools.getUniqueID());
                labelLine.setText(this.labels[i]);
                rowText[0] = labelLine;
                if ((double)currentY > topY) {
                    topY = currentY;
                    this.topString = this.labels[i];
                }
                svgLabels[i] = label;
            }
            ++i;
        }
        return labelGroup;
    }

    protected SVGBase drawVerticalLabels(double[] positions) {
        return null;
    }

    public short getAxisOrientation() {
        return 0;
    }

    public double getAxisWidth() {
        return this.axisWidth;
    }

    private int getTitleHeight() {
        if (this.title == null) {
            return 0;
        }
        return 14;
    }

    public double getAxisHeight() {
        return 13.0 + this.getLabelHeight() + (double)this.getTitleHeight();
    }

    protected void constructPart() {
        SVGUse useTick;
        double tick_x;
        int i;
        SVGBase[] ticks;
        SVGGroup tickGroup;
        double[] tick_x_coordinates = new double[this.majorUnitValues.length];
        SVGGroup axisGroup = new SVGGroup();
        SVGBase[] axisParts = new SVGBase[5];
        axisGroup.setChildren(axisParts);
        SVGBase[] child = new SVGBase[]{axisGroup};
        this.setChildren(child);
        SVGLine axis = new SVGLine();
        String axis_y = this.bottom ? Integer.toString(5) : Double.toString(this.getAxisHeight() - 5.0);
        axis.setX1(Double.toString(this.offset));
        axis.setY1(axis_y);
        axis.setX2(Double.toString(this.offset + this.axisWidth));
        axis.setY2(axis_y);
        axis.setStyleClass("axisLines");
        SVGGroup axisGroup2 = new SVGGroup();
        SVGBase[] axisGroup2Children = new SVGBase[2];
        axisGroup2Children[0] = axis;
        axisGroup2.setChildren(axisGroup2Children);
        if (this.axisDef != null) {
            axisGroup2Children[1] = EventTools.generateUserTooltip(axisGroup2, this.axisDef.getTooltip(), this.nls);
            EventTools.generateUserEvents(axisGroup2, this.axisDef.getEventHandler());
            EventTools.generateAccessibility(axisGroup2, this.axisDef.getAccessibility(), this.nls);
        }
        axisParts[0] = axisGroup2;
        SVGGroup tickDefGroup = new SVGGroup();
        tickDefGroup.setIdentifier("tickline");
        SVGBase tickDef = this.drawTickMarks();
        tickDef.setStyleClass("axisTicks");
        tickDef.setIdentifier("verticaltickline");
        SVGBase[] tick = new SVGBase[]{tickDef};
        tickDefGroup.setChildren(tick);
        this.addDefinition(tickDef);
        String tick_y = this.bottom ? "0" : Double.toString(this.getAxisHeight() - 5.0);
        if (this.showMajorTicks) {
            tickGroup = new SVGGroup();
            ticks = new SVGBase[this.majorUnitValues.length];
            axisParts[1] = tickGroup;
            tickGroup.setChildren(ticks);
            i = 0;
            while (i < this.majorUnitValues.length) {
                tick_x = this.isLTR ? this.getXCoordinate(this.majorUnitValues[i], this.offset + this.axisWidth, this.offset, this.max, this.min) : this.getXCoordinate(this.majorUnitValues[i], this.offset, this.offset + this.axisWidth, this.max, this.min);
                tick_x_coordinates[i] = tick_x;
                useTick = new SVGUse();
                useTick.setHref("#verticaltickline");
                useTick.setXCoordinate(Double.toString(tick_x));
                useTick.setYCoordinate(tick_y);
                ticks[i] = useTick;
                ++i;
            }
        } else {
            int i2 = 0;
            while (i2 < this.majorUnitValues.length) {
                double tick_x2 = this.isLTR ? this.getXCoordinate(this.majorUnitValues[i2], this.offset + this.axisWidth, this.offset, this.max, this.min) : this.getXCoordinate(this.majorUnitValues[i2], this.offset, this.offset + this.axisWidth, this.max, this.min);
                tick_x_coordinates[i2] = tick_x2;
                ++i2;
            }
        }
        if (this.showMinorTicks) {
            tickGroup = new SVGGroup();
            ticks = new SVGBase[this.minorUnitValues.length];
            axisParts[2] = tickGroup;
            tickGroup.setChildren(ticks);
            i = 0;
            while (i < this.minorUnitValues.length) {
                tick_x = this.isLTR ? this.getXCoordinate(this.minorUnitValues[i], this.offset + this.axisWidth, this.offset, this.max, this.min) : this.getXCoordinate(this.minorUnitValues[i], this.offset, this.offset + this.axisWidth, this.max, this.min);
                useTick = new SVGUse();
                useTick.setHref("#verticaltickline");
                useTick.setXCoordinate(Double.toString(tick_x));
                useTick.setYCoordinate(tick_y);
                ticks[i] = useTick;
                ++i;
            }
        }
        axisParts[3] = this.labelOrientation == 0 ? this.drawHorizontalLabels(tick_x_coordinates) : this.drawVerticalLabels(tick_x_coordinates);
        if (this.title != null) {
            String title_y = this.bottom ? Double.toString(this.getAxisHeight()) : Double.toString(this.getTitleHeight());
            SVGText svgTitle = new SVGText();
            svgTitle.setText(this.title);
            svgTitle.setXCoordinate(Double.toString(this.offset + this.getAxisLength() / 2.0));
            svgTitle.setYCoordinate(title_y);
            svgTitle.setStyleClass("axisTitles anchorAtMiddle");
            if (this.axisType == 1) {
                svgTitle.setIdentifier("SVGGEN_labelsValues1");
            } else {
                svgTitle.setIdentifier("SVGGEN_labelsValues2");
            }
            axisParts[4] = svgTitle;
        }
    }

    protected double getXCoordinate(double value, double max_coor, double min_coor, double max, double min) {
        return (value - max) / (min - max) * (min_coor - max_coor) + max_coor;
    }

    protected SVGBase drawTickMarks() {
        SVGPolyline tickDef = new SVGPolyline();
        tickDef.setPoints("0 0 0 5");
        return tickDef;
    }

    public double axisExtendedLength() {
        FontHelper fontHelper = new FontHelper();
        fontHelper.setFontSize(8.0f);
        return fontHelper.getHeight(this.topString, this.labelDegrees);
    }
}

