/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import java.util.Vector;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisLabel;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.FontHelper;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class AxisNumberVertical
extends AxisNumber {
    static final long serialVersionUID = 4579202889483253736L;
    protected boolean left = true;

    public AxisNumberVertical(Chart input, boolean isLTR, List datasets, short axisType, boolean cumulative, NLString nls) {
        super(input, datasets, axisType, cumulative, nls, 0.0);
        if (axisType == 2 && isLTR) {
            this.left = false;
        } else if (axisType == 1 && !isLTR) {
            this.left = false;
        }
    }

    public AxisNumberVertical(Chart input, boolean isLTR, Vector datasets, short axisType, boolean cumulative, short labelOrientation, NLString nls) {
        super(input, datasets, axisType, cumulative, labelOrientation, nls, 0.0);
        if (axisType == 2 && isLTR) {
            this.left = false;
        } else if (axisType == 1 && !isLTR) {
            this.left = false;
        }
    }

    public void setAxisLength(double length) {
        this.axisHeight = length;
    }

    public double getAxisLength() {
        return this.axisHeight;
    }

    private double getTitleWidth() {
        if (this.title == null) {
            return 0.0;
        }
        FontHelper fontHelper = new FontHelper();
        fontHelper.setFontSize(9.0f);
        return fontHelper.getHeight() + 5.0;
    }

    public double getAxisWidth() {
        return this.getLabelHeight() + 8.0 + 5.0 + this.getTitleWidth();
    }

    public void setCrossPoint(double x, double y) {
        if (this.left) {
            this.setXCoordinate(Double.toString(x - this.getAxisWidth() + 5.0));
            this.setYCoordinate(Double.toString(y - this.getAxisLength() - 10.0));
        } else {
            this.setXCoordinate(Double.toString(x - 5.0));
            this.setYCoordinate(Double.toString(y - this.getAxisLength() - 10.0));
        }
    }

    protected SVGBase drawHorizontalLabels(double[] positions) {
        SVGGroup labelGroup = new SVGGroup();
        SVGBase[] svglabels = new SVGBase[this.labels.length];
        labelGroup.setChildren(svglabels);
        int i = 0;
        while (i < this.labels.length) {
            if (this.labels[i] != null) {
                SVGGroup label = new SVGGroup();
                SVGBase[] rowText = new SVGBase[1];
                label.setChildren(rowText);
                AxisLabel labelLine = null;
                if (this.left) {
                    labelLine = new AxisLabel(0, 0);
                    labelLine.setDegrees(this.labelDegrees);
                    labelLine.setXCoordinate(Double.toString(this.getTitleWidth() + this.getLabelHeight()));
                    labelLine.setYCoordinate(Double.toString(positions[i]));
                    labelLine.setText(this.labels[i]);
                } else {
                    labelLine = new AxisLabel(0, 1);
                    labelLine.setDegrees(this.labelDegrees);
                    labelLine.setXCoordinate(Double.toString(13.0));
                    labelLine.setYCoordinate(Double.toString(positions[i]));
                    labelLine.setText(this.labels[i]);
                }
                labelLine.setIdentifier("SVGGEN_axisLabel" + EventTools.getUniqueID());
                rowText[0] = labelLine;
                svglabels[i] = label;
            }
            ++i;
        }
        return labelGroup;
    }

    protected SVGBase drawVerticalLabels(double[] positions) {
        return null;
    }

    protected void constructPart() {
        SVGUse useTick;
        double tick_y;
        int i;
        String tick_x;
        SVGBase[] ticks;
        SVGGroup tickGroup;
        double[] tick_y_coordinates = new double[this.majorUnitValues.length];
        this.setYCoordinate("" + (Double.parseDouble(this.getYCoordinate()) - (double)this.marginForMax));
        SVGGroup axisGroup = new SVGGroup();
        axisGroup.setTransformation("translate(0," + this.marginForMax + ")");
        SVGBase[] axisParts = new SVGBase[5];
        axisGroup.setChildren(axisParts);
        SVGBase[] child = new SVGBase[]{axisGroup};
        this.setChildren(child);
        SVGLine axis = new SVGLine();
        String axis_x = this.left ? Double.toString(this.getTitleWidth() + this.getLabelHeight() + 8.0) : Integer.toString(5);
        axis.setX1(axis_x);
        axis.setY1(Integer.toString(10));
        axis.setX2(axis_x);
        axis.setY2(Double.toString(10.0 + this.axisHeight));
        axis.setStyleClass("axisLines");
        SVGGroup axisGroup2 = new SVGGroup();
        SVGBase[] axisGroup2Children = new SVGBase[2];
        axisGroup2Children[0] = axis;
        axisGroup2.setChildren(axisGroup2Children);
        if (this.axisDef != null) {
            axisGroup2Children[1] = EventTools.generateUserTooltip(axisGroup2, this.axisDef.getTooltip(), this.nls);
            EventTools.generateUserEvents(axisGroup2, this.axisDef.getEventHandler());
            EventTools.generateAccessibility(axisGroup2, this.axisDef.getAccessibility(), this.nls);
        }
        axisParts[0] = axisGroup2;
        SVGGroup tickDefGroup = new SVGGroup();
        tickDefGroup.setIdentifier("tickline");
        SVGBase tickDef = this.drawTickMarks();
        tickDef.setStyleClass("axisTicks");
        tickDef.setIdentifier("tickline");
        SVGBase[] tick = new SVGBase[]{tickDef};
        tickDefGroup.setChildren(tick);
        this.addDefinition(tickDef);
        if (this.showMajorTicks) {
            tickGroup = new SVGGroup();
            ticks = new SVGBase[this.majorUnitValues.length];
            axisParts[1] = tickGroup;
            tickGroup.setChildren(ticks);
            tick_x = this.left ? axis_x : "0";
            i = 0;
            while (i < this.majorUnitValues.length) {
                tick_y_coordinates[i] = tick_y = this.getYCoordinate(this.majorUnitValues[i], 10.0, 10.0 + this.axisHeight, this.max, this.min);
                useTick = new SVGUse();
                useTick.setHref("#tickline");
                useTick.setXCoordinate(tick_x);
                useTick.setYCoordinate(Double.toString(tick_y));
                ticks[i] = useTick;
                ++i;
            }
        } else {
            int i2 = 0;
            while (i2 < this.majorUnitValues.length) {
                double tick_y2;
                tick_y_coordinates[i2] = tick_y2 = this.getYCoordinate(this.majorUnitValues[i2], 10.0, 10.0 + this.axisHeight, this.max, this.min);
                ++i2;
            }
        }
        if (this.showMinorTicks) {
            tickGroup = new SVGGroup();
            ticks = new SVGBase[this.minorUnitValues.length];
            axisParts[2] = tickGroup;
            tickGroup.setChildren(ticks);
            tick_x = this.left ? axis_x : "0";
            i = 0;
            while (i < this.minorUnitValues.length) {
                tick_y = this.getYCoordinate(this.minorUnitValues[i], 10.0, 10.0 + this.axisHeight, this.max, this.min);
                useTick = new SVGUse();
                useTick.setHref("#tickline");
                useTick.setXCoordinate(tick_x);
                useTick.setYCoordinate(Double.toString(tick_y));
                ticks[i] = useTick;
                ++i;
            }
        }
        axisParts[3] = this.labelOrientation == 0 ? this.drawHorizontalLabels(tick_y_coordinates) : this.drawVerticalLabels(tick_y_coordinates);
        if (this.title != null) {
            String title_x = this.left ? Double.toString(this.getTitleWidth() - 5.0) : Double.toString(this.getAxisWidth());
            SVGText svgTitle = new SVGText();
            svgTitle.setText(this.title);
            String xanchor = title_x;
            String yanchor = Double.toString(10.0 + this.getAxisLength() / 2.0);
            svgTitle.setXCoordinate(xanchor);
            svgTitle.setYCoordinate(yanchor);
            svgTitle.setStyleClass("axisTitles anchorAtMiddle");
            svgTitle.setTransformation("rotate(270," + xanchor + "," + yanchor + ")");
            if (this.axisType == 1) {
                svgTitle.setIdentifier("SVGGEN_labelsValues1");
            } else {
                svgTitle.setIdentifier("SVGGEN_labelsValues2");
            }
            axisParts[4] = svgTitle;
        }
    }

    private double getYCoordinate(double value, double max_y, double min_y, double max, double min) {
        return (value - max) / (min - max) * (min_y - max_y) + max_y;
    }

    public short getAxisOrientation() {
        return 1;
    }

    public double getAxisHeight() {
        return 0.0;
    }

    protected SVGBase drawTickMarks() {
        SVGPolyline tickDef = new SVGPolyline();
        tickDef.setPoints("0 0 5 0");
        return tickDef;
    }

    public int getMarginForMax() {
        this.marginForMax = super.getMarginForMax();
        if (this.labelDegrees > 90.0 || this.labelDegrees < 0.0) {
            this.marginForMax = 2 * (this.marginForMax + 5) - 5;
        }
        return this.marginForMax;
    }
}

