/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategory;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;

public class DataSetBar
extends DataSet {
    static final long serialVersionUID = 8486538169507992998L;
    protected AxisCategory indepAxis;
    protected AxisNumber depAxis;
    protected org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset;
    protected CategoricalData[] sortedDatapoints;
    protected int colorIndex;
    protected List categoryList;
    protected double[] groupDataPositions;
    protected double depAxisMax;
    protected double depAxisMin;
    protected double axisLenght;
    protected boolean linear;
    protected double barWidth;
    protected double barPosition;
    protected double groupInterval;
    protected boolean isLTR = true;
    protected SVGColorPalettes palettes = null;

    public DataSetBar(Chart input, boolean isLTR, AxisCategory indepAxis, AxisNumber depAxis, org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, int datasetIndex, int colorIndex, double barWidth, double barPosition, double groupInterval, SVGColorPalettes palettes, NLString nls) {
        super(input, nls);
        this.indepAxis = indepAxis;
        this.depAxis = depAxis;
        this.dataset = dataset;
        this.barWidth = barWidth;
        this.datasetIndex = datasetIndex;
        this.colorIndex = colorIndex;
        this.groupInterval = groupInterval;
        this.barPosition = barPosition;
        this.palettes = palettes;
        this.isLTR = isLTR;
        this.sortDataPoints();
        this.groupDataPositions = indepAxis.getGroupDataPositions();
        this.axisLenght = indepAxis.getAxisLength();
        this.depAxisMax = depAxis.getMax();
        this.depAxisMin = depAxis.getMin();
        this.linear = depAxis.isLinear();
    }

    public void setIndepAxis(AxisCategory axis) {
        this.indepAxis = axis;
    }

    public void setDepAxis(AxisNumber axis) {
        this.depAxis = axis;
    }

    public void setDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset) {
        this.dataset = dataset;
    }

    protected void constructPart() {
        double value;
        Utilities.assertion(this.dataset != null);
        Utilities.assertion(this.dataset.getDataPoint() != null);
        SVGBase[] barpart = new SVGBase[1];
        this.setChildren(barpart);
        SVGGroup barset = new SVGGroup();
        int partNum = this.sortedDatapoints.length + 2;
        SVGBase[] barparts = new SVGBase[partNum];
        SVGGroup dataColourGroup = new SVGGroup();
        SVGBase[] dataColourGroupChild = new SVGBase[]{dataColourGroup};
        dataColourGroup.setChildren(barparts);
        dataColourGroup.setIdentifier("SVGGEN_dataColour" + this.datasetIndex);
        String dataSetColor = this.palettes.getDataSetColor(this.dataset.getId());
        if (dataSetColor != null) {
            dataColourGroup.setFill(dataSetColor);
            dataColourGroup.setStroke(dataSetColor);
        }
        barpart[0] = barset;
        barset.setChildren(dataColourGroupChild);
        barset.setIdentifier(this.dataset.getId());
        barset.setStyleClass("bars" + this.colorIndex);
        double min = Math.pow(10.0, this.depAxisMin);
        double d = value = this.linear ? 0.0 : min;
        if (this.indepAxis.getAxisOrientation() == 0) {
            double zero = this.getCoordinate(this.linear, value, 0.0, Double.parseDouble(this.getHeight()), this.depAxisMax, this.depAxisMin);
            int i = 0;
            while (i < this.categoryList.size()) {
                CategoricalData dp = this.isLTR ? this.sortedDatapoints[i] : this.sortedDatapoints[this.categoryList.size() - i - 1];
                if (dp != null && (this.linear || !(dp.getValue() <= 0.0))) {
                    SVGGroup pointGroup = new SVGGroup();
                    pointGroup.setIdentifier(dp.getId());
                    SVGBase[] point = new SVGBase[3];
                    pointGroup.setChildren(point);
                    SVGGroup pointGroupWrapper = new SVGGroup();
                    SVGBase[] pointWrapper = new SVGBase[2];
                    pointWrapper[0] = pointGroup;
                    pointGroupWrapper.setChildren(pointWrapper);
                    pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
                    point[2] = EventTools.generateValueTooltip(pointGroup, this.depAxis.formatValue(dp.getValue()));
                    point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
                    EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
                    EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
                    double curX = this.barPosition + (double)i * this.groupInterval;
                    double curY = this.getCoordinate(this.linear, dp.getValue(), 0.0, Double.parseDouble(this.getHeight()), this.depAxisMax, this.depAxisMin);
                    barparts[i + 1] = pointGroupWrapper;
                    if (i >= 0) {
                        SVGText barTextSegment = new SVGText();
                        String tooltipID = "SVGGEN_datavalue_" + this.dataset.getId() + "_" + EventTools.getUniqueID();
                        barTextSegment.setText(this.depAxis.formatValue(dp.getValue()));
                        barTextSegment.setStyle("font-size:8pt;stroke:none;fill:black");
                        barTextSegment.setStyleClass("anchorAtMiddle");
                        barTextSegment.setVisibility("hidden");
                        barTextSegment.setXCoordinate(Double.toString(curX));
                        if (dp.getValue() < 0.0) {
                            barTextSegment.setYCoordinate(Double.toString(curY + 8.0 + 2.0));
                        } else {
                            barTextSegment.setYCoordinate(Double.toString(curY - 2.0));
                        }
                        barTextSegment.setIdentifier(tooltipID);
                        SVGGroup barGroup = new SVGGroup();
                        barGroup.setIdentifier("SVGGEN_bar_" + this.dataset.getId());
                        SVGLine barSegment = new SVGLine();
                        barSegment.setX1(Double.toString(curX));
                        barSegment.setY1(Double.toString(zero));
                        barSegment.setX2(Double.toString(curX));
                        barSegment.setY2(Double.toString(curY));
                        barSegment.setStrokeWidth(Double.toString(this.barWidth));
                        point[0] = barSegment;
                        pointWrapper[1] = barGroup;
                        SVGBase[] groupChild = new SVGBase[1];
                        barGroup.setChildren(groupChild);
                        groupChild[0] = barTextSegment;
                    }
                }
                ++i;
            }
        } else {
            double zero = this.isLTR ? this.getCoordinate(this.linear, value, Double.parseDouble(this.getWidth()), 0.0, this.depAxisMax, this.depAxisMin) : this.getCoordinate(this.linear, value, 0.0, Double.parseDouble(this.getWidth()), this.depAxisMax, this.depAxisMin);
            int i = 0;
            while (i < this.categoryList.size()) {
                CategoricalData dp = this.sortedDatapoints[i];
                if (dp != null && (this.linear || !(dp.getValue() <= 0.0))) {
                    SVGGroup pointGroup = new SVGGroup();
                    pointGroup.setIdentifier(dp.getId());
                    SVGBase[] point = new SVGBase[3];
                    pointGroup.setChildren(point);
                    SVGGroup pointGroupWrapper = new SVGGroup();
                    SVGBase[] pointWrapper = new SVGBase[2];
                    pointWrapper[0] = pointGroup;
                    pointGroupWrapper.setChildren(pointWrapper);
                    pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
                    point[2] = EventTools.generateValueTooltip(pointGroup, this.depAxis.formatValue(dp.getValue()));
                    point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
                    EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
                    EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
                    double curY = this.indepAxis.getAxisLength() - (this.barPosition + (double)i * this.groupInterval);
                    double curX = this.isLTR ? this.getCoordinate(this.linear, dp.getValue(), this.depAxis.getAxisLength(), 0.0, this.depAxisMax, this.depAxisMin) : this.getCoordinate(this.linear, dp.getValue(), 0.0, this.depAxis.getAxisLength(), this.depAxisMax, this.depAxisMin);
                    barparts[i + 1] = pointGroupWrapper;
                    if (i >= 0) {
                        SVGText barTextSegment = new SVGText();
                        String tooltipID = "SVGGEN_datavalue_" + this.dataset.getId() + "_" + EventTools.getUniqueID();
                        barTextSegment.setText(this.depAxis.formatValue(dp.getValue()));
                        barTextSegment.setStyle("font-size:8pt;stroke:none;fill:black");
                        barTextSegment.setStyleClass("anchorAtStart");
                        barTextSegment.setVisibility("hidden");
                        if (this.isLTR) {
                            if (dp.getValue() < 0.0) {
                                barTextSegment.setXCoordinate(Double.toString(curX - 2.0));
                                barTextSegment.setStyleClass("anchorAtEnd");
                            } else {
                                barTextSegment.setXCoordinate(Double.toString(curX + 2.0));
                                barTextSegment.setStyleClass("anchorAtStart");
                            }
                        } else if (dp.getValue() < 0.0) {
                            barTextSegment.setXCoordinate(Double.toString(curX + 2.0));
                            barTextSegment.setStyleClass("anchorAtStart");
                        } else {
                            barTextSegment.setXCoordinate(Double.toString(curX - 2.0));
                            barTextSegment.setStyleClass("anchorAtEnd");
                        }
                        barTextSegment.setYCoordinate(Double.toString(curY + 4.0));
                        barTextSegment.setIdentifier(tooltipID);
                        SVGGroup barGroup = new SVGGroup();
                        barGroup.setIdentifier("SVGGEN_bar_" + this.dataset.getId());
                        SVGLine barSegment = new SVGLine();
                        barSegment.setX1(Double.toString(zero));
                        barSegment.setY1(Double.toString(curY));
                        barSegment.setX2(Double.toString(curX));
                        barSegment.setY2(Double.toString(curY));
                        barSegment.setStrokeWidth(Double.toString(this.barWidth));
                        point[0] = barSegment;
                        pointWrapper[1] = barGroup;
                        SVGBase[] groupChild = new SVGBase[1];
                        barGroup.setChildren(groupChild);
                        groupChild[0] = barTextSegment;
                    }
                }
                ++i;
            }
        }
    }

    protected void sortDataPoints() {
        Categories categories;
        Data data = this.input.getData();
        List datapoints = this.dataset.getDataPoint();
        if (data != null && (categories = data.getCategories()) != null) {
            this.categoryList = categories.getCategory();
            this.sortedDatapoints = new CategoricalData[this.categoryList.size()];
            for (CategoricalData dp : datapoints) {
                int index = this.categoryList.indexOf(dp.getCategoryId());
                this.sortedDatapoints[index] = dp;
            }
        }
    }
}

