/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeGaussianBlur;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFilter;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolygon;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Coordinates;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Axis;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;

public class DataSetLineContinuum
extends DataSetLine {
    static final long serialVersionUID = -2024074715344317019L;

    public DataSetLineContinuum(Chart input, boolean isLTR, Axis indepAxis, AxisNumber depAxis, DataSet dataset, int datasetIndex, int colorIndex, SVGColorPalettes palettes, String shapeId, double shapeWidth, double shapeHeight, NLString nls) {
        super(input, isLTR, indepAxis, depAxis, dataset, datasetIndex, colorIndex, palettes, shapeId, shapeWidth, shapeHeight, nls);
        this.showArea = input.getType().equals("area");
        this.showShapes = true;
        if (input.getConfiguration() != null && input.getConfiguration().getShapes() != null && input.getConfiguration().getShapes().getVisibility() != null) {
            this.showShapes = input.getConfiguration().getShapes().getVisibility().trim().equals("visible");
        }
        if (input.getType().equals("scatter")) {
            this.showLine = false;
            this.generateShadows = true;
        } else {
            this.showLine = true;
            this.generateShadows = false;
        }
    }

    protected void constructPart() {
        Utilities.assertion(this.dataset != null);
        Utilities.assertion(this.dataset.getDataPoint() != null);
        this.indepAxis.getAxisLength();
        List datapointList = this.dataset.getCoordinates();
        SVGBase[] linepart = new SVGBase[1];
        this.setChildren(linepart);
        SVGGroup line = new SVGGroup();
        int partNum = datapointList.size() + 4;
        SVGBase[] lineparts = new SVGBase[partNum];
        SVGGroup dataColourGroup = new SVGGroup();
        SVGBase[] dataColourGroupChild = new SVGBase[]{dataColourGroup};
        dataColourGroup.setChildren(lineparts);
        dataColourGroup.setIdentifier("SVGGEN_dataColour" + this.datasetIndex);
        String dataSetColor = this.palettes.getDataSetColor(this.dataset.getId());
        if (dataSetColor != null) {
            dataColourGroup.setFill(dataSetColor);
            dataColourGroup.setStroke(dataSetColor);
        }
        linepart[0] = line;
        line.setChildren(dataColourGroupChild);
        line.setIdentifier(this.dataset.getId());
        line.setStyleClass("linestyle strokecolor" + this.colorIndex + " fillcolor" + this.colorIndex);
        line.setTransformation("translate(5.0,5.0)");
        if (this.generateShadows) {
            SVGFilter filter = new SVGFilter();
            filter.setHeight("200%");
            filter.setWidth("200%");
            filter.setX("-50%");
            filter.setY("-50%");
            filter.setIdentifier("drop-shadow");
            SVGBase[] feGaussianBlurPart = new SVGFeGaussianBlur[1];
            SVGFeGaussianBlur feGaussianBlur = new SVGFeGaussianBlur();
            feGaussianBlur.setStdDeviation("3");
            feGaussianBlur.setIn("SourceAlpha");
            feGaussianBlur.setResult("blur");
            feGaussianBlurPart[0] = feGaussianBlur;
            filter.setChildren(feGaussianBlurPart);
            this.addDefinition(filter);
        }
        SVGGroup lineGroup = new SVGGroup();
        SVGBase[] lineSegments = new SVGBase[datapointList.size() - 1];
        if (this.showLine) {
            lineGroup.setChildren(lineSegments);
            lineGroup.setStyle("clip-path: url(#SVGGEN_plotareaBorder)");
        }
        lineparts[1] = lineGroup;
        lineGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
        lineparts[partNum - 1] = EventTools.generateUserTooltip(lineGroup, this.dataset.getTooltip(), this.nls);
        EventTools.generateUserEvents(lineGroup, this.dataset.getEventHandler());
        EventTools.generateAccessibility(lineGroup, this.dataset.getAccessibility(), this.nls);
        SVGGroup shadowGroup = new SVGGroup();
        SVGBase[] shadows = new SVGBase[datapointList.size()];
        if (this.generateShadows) {
            shadowGroup.setChildren(shadows);
            shadowGroup.setVisibility("hidden");
            shadowGroup.setIdentifier("SVGGEN_shadowGroup" + this.dataset.getId());
            lineparts[2] = shadowGroup;
        }
        boolean firstPointDrawn = false;
        double previousX = 0.0;
        double previousY = 0.0;
        double curX = 0.0;
        double curY = 0.0;
        double zero_y = 0.0;
        boolean curPointIsHole = false;
        boolean previousPointIsHole = false;
        int partIndex = 0;
        StringBuffer pointCoordinates = new StringBuffer();
        AxisNumber numberIndepAxis = null;
        if (this.indepAxis instanceof AxisNumber) {
            numberIndepAxis = (AxisNumber)this.indepAxis;
        }
        Utilities.assertion(numberIndepAxis != null);
        for (Coordinates dp : datapointList) {
            if (!(dp == null || !this.indepAxislinear && dp.getValue1() <= 0.0 || !this.depAxislinear && dp.getValue2() <= 0.0)) {
                SVGGroup pointGroup = new SVGGroup();
                SVGBase[] point = new SVGBase[3];
                pointGroup.setChildren(point);
                SVGGroup pointGroupWrapper = new SVGGroup();
                SVGBase[] pointWrapper = new SVGBase[2];
                pointWrapper[0] = pointGroup;
                pointGroupWrapper.setChildren(pointWrapper);
                pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
                point[2] = EventTools.generateValueTooltip(pointGroup, String.valueOf(numberIndepAxis.formatValue(dp.getValue1())) + "," + this.depAxis.formatValue(dp.getValue2()));
                point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
                EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
                EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
                SVGUse useShape = new SVGUse();
                useShape.setIdentifier(dp.getId());
                curX = this.isLTR ? this.getCoordinate(this.indepAxislinear, dp.getValue1(), this.indepAxis.getAxisLength(), 0.0, this.indepAxisMax, this.indepAxisMin) : this.getCoordinate(this.indepAxislinear, dp.getValue1(), 0.0, this.indepAxis.getAxisLength(), this.indepAxisMax, this.indepAxisMin);
                curY = this.getCoordinate(this.depAxislinear, dp.getValue2(), 0.0, this.depAxis.getAxisLength(), this.depAxisMax, this.depAxisMin);
                if (dp.getType().equals("hole")) {
                    useShape.setHref("#SVGGEN_holeshape");
                    useShape.setTransformation("translate(" + (curX - 2.8) + "," + (curY - 2.8) + ")");
                } else {
                    useShape.setHref("#" + this.shapeId);
                    useShape.setTransformation("translate(" + (curX - this.shapeWidth / 2.0) + "," + (curY - this.shapeHeight / 2.0) + ")");
                }
                if (this.showShapes) {
                    useShape.setVisibility("visible");
                } else {
                    useShape.setVisibility("hidden");
                }
                if (dp.getType().equals("hole") || this.shapeId != null && !this.shapeId.trim().equals("")) {
                    point[0] = useShape;
                }
                lineparts[partIndex + 3] = pointGroupWrapper;
                String textLabelStyle = "font-size:8pt;stroke:none;fill:black";
                double labelXCoor = curX < 10.0 ? curX + 5.0 : (curX > this.indepAxis.getAxisLength() - 10.0 ? curX - 30.0 : curX - 5.0);
                double labelYCoor = curY < 10.0 ? curY + 13.0 : (curY > this.depAxis.getAxisLength() - 10.0 ? curY - 5.0 : (curY > previousY ? curY + 13.0 : curY - 5.0));
                SVGText valueText = new SVGText();
                valueText.setText(String.valueOf(numberIndepAxis.formatValue(dp.getValue1())) + "," + this.depAxis.formatValue(dp.getValue2()));
                valueText.setXCoordinate(Double.toString(labelXCoor));
                valueText.setYCoordinate(Double.toString(labelYCoor));
                valueText.setVisibility("hidden");
                valueText.setStyle(textLabelStyle);
                valueText.setIdentifier("SVGGEN_datavalue" + EventTools.getUniqueID());
                pointWrapper[1] = valueText;
                SVGUse shadowShape = new SVGUse();
                shadowShape.setHref("#" + this.shapeId);
                shadowShape.setTransformation("translate(" + (curX - this.shapeWidth / 2.0) + "," + (curY - this.shapeHeight / 2.0) + ")");
                shadowShape.setFilter("url(#drop-shadow)");
                shadowShape.setIdentifier("SVGGEN_shadowShape" + EventTools.getUniqueID());
                if (this.shapeId != null && !this.shapeId.trim().equals("")) {
                    shadows[partIndex] = shadowShape;
                }
                if (firstPointDrawn) {
                    SVGPolyline lineSegment = new SVGPolyline();
                    String points = String.valueOf(previousX) + " " + previousY + "," + curX + " " + curY;
                    lineSegment.setPoints(points);
                    boolean bl = curPointIsHole = dp.getType().equals("hole");
                    if (curPointIsHole || previousPointIsHole) {
                        lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
                    }
                    lineSegments[partIndex - 1] = lineSegment;
                } else {
                    firstPointDrawn = true;
                    if (this.showArea) {
                        double value = this.depAxislinear ? 0.0 : Math.pow(10.0, this.depAxisMin);
                        zero_y = this.getCoordinate(this.depAxislinear, value, 0.0, this.depAxis.getAxisLength(), this.depAxisMax, this.depAxisMin);
                        pointCoordinates.append(String.valueOf(curX) + " " + zero_y);
                    }
                }
                if (this.showArea) {
                    pointCoordinates.append(", " + curX + " " + curY);
                }
                previousX = curX;
                previousY = curY;
                previousPointIsHole = curPointIsHole;
            }
            ++partIndex;
        }
        if (this.showArea) {
            SVGGroup areaGroup = new SVGGroup();
            areaGroup.setIdentifier("SVGGEN_area" + this.datasetIndex);
            if (dataSetColor != null) {
                areaGroup.setFill(dataSetColor);
                areaGroup.setStroke(dataSetColor);
            } else {
                areaGroup.setStyleClass("fillcolor" + this.datasetIndex);
            }
            areaGroup.setStyle("clip-path: url(#SVGGEN_plotareaBorder)");
            lineparts[0] = areaGroup;
            pointCoordinates.append(", " + curX + " " + zero_y);
            SVGPolygon area = new SVGPolygon();
            area.setIdentifier("SVGGEN_poly" + this.datasetIndex);
            area.setStyle("fill-opacity: 0.1; stroke: black; stroke-width: 0;");
            area.setPoints(pointCoordinates.toString());
            SVGBase[] groupChild = new SVGBase[1];
            areaGroup.setChildren(groupChild);
            groupChild[0] = area;
        }
    }
}

