/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Axis;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategory;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public abstract class DataSetStackArea
extends DataSet {
    protected Axis indepAxis;
    protected AxisNumber depAxis;
    protected CategoricalData[] sortedDatapoints;
    protected int colorIndex;
    protected List categoryList;
    protected double[] groupDataPositions;
    protected double indepAxisMax;
    protected double indepAxisMin;
    protected boolean indepAxislinear;
    protected double depAxisMax;
    protected double depAxisMin;
    protected boolean depAxislinear;
    protected boolean useCategories;
    protected boolean showArea;
    protected boolean showLine;
    protected boolean generateShadows;
    protected boolean isLTR = true;
    protected String shapeId;
    protected double shapeWidth;
    protected double shapeHeight;
    protected SVGColorPalettes palettes;

    public DataSetStackArea(Chart input, boolean isLTR, Axis indepAxis, AxisNumber depAxis, org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset, int datasetIndex, int colorIndex, SVGColorPalettes palettes, String shapeId, double shapeWidth, double shapeHeight, NLString nls) {
        super(input, nls);
        this.indepAxis = indepAxis;
        this.depAxis = depAxis;
        this.dataset = dataset;
        this.datasetIndex = datasetIndex;
        this.colorIndex = colorIndex;
        this.palettes = palettes;
        this.shapeId = shapeId;
        this.shapeWidth = shapeWidth;
        this.shapeHeight = shapeHeight;
        this.isLTR = isLTR;
        if (indepAxis instanceof AxisCategory) {
            AxisCategory categoryAxis = (AxisCategory)indepAxis;
            this.sortDataPoints();
            this.groupDataPositions = categoryAxis.getGroupDataPositions();
            this.useCategories = true;
        } else {
            AxisNumber numberAxis = (AxisNumber)indepAxis;
            this.indepAxisMax = numberAxis.getMax();
            this.indepAxisMin = numberAxis.getMin();
            this.indepAxislinear = numberAxis.isLinear();
            this.useCategories = false;
        }
        this.depAxisMax = depAxis.getMax();
        this.depAxisMin = depAxis.getMin();
        this.depAxislinear = depAxis.isLinear();
    }

    public void setIndepAxis(Axis axis) {
        this.indepAxis = axis;
    }

    public void setDepAxis(AxisNumber axis) {
        this.depAxis = axis;
    }

    public void setDataSet(org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset) {
        this.dataset = dataset;
    }

    private void sortDataPoints() {
        Categories categories;
        Data data = this.input.getData();
        List datapoints = this.dataset.getDataPoint();
        if (data != null && (categories = data.getCategories()) != null) {
            this.categoryList = categories.getCategory();
            this.sortedDatapoints = new CategoricalData[this.categoryList.size()];
            for (CategoricalData dp : datapoints) {
                int index = this.categoryList.indexOf(dp.getCategoryId());
                if (index == -1) continue;
                this.sortedDatapoints[index] = dp;
            }
        }
    }
}

