/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeGaussianBlur;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFilter;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolygon;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGScript;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Axis;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetStackArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;

public class DataSetStackAreaCategory
extends DataSetStackArea {
    static final long serialVersionUID = -6828040412250730478L;
    double[] accumulatedHighValues;
    double[] accumulatedLowValues;

    public DataSetStackAreaCategory(Chart input, boolean isLTR, Axis indepAxis, AxisNumber depAxis, DataSet dataset, int datasetIndex, int colorIndex, SVGColorPalettes palettes, String shapeId, double shapeWidth, double shapeHeight, double[] accumulatedHighValues, double[] accumulatedLowValues, NLString nls) {
        super(input, isLTR, indepAxis, depAxis, dataset, datasetIndex, colorIndex, palettes, shapeId, shapeWidth, shapeHeight, nls);
        this.accumulatedHighValues = accumulatedHighValues;
        this.accumulatedLowValues = accumulatedLowValues;
        this.showArea = input.getType().equals("stackedArea");
        this.showLine = true;
        this.generateShadows = false;
    }

    protected void constructPart() {
        double previousSet = 0.0;
        double firstNlast = 0.0;
        double min = Math.pow(10.0, this.depAxisMin);
        Utilities.assertion(this.dataset != null);
        Utilities.assertion(this.dataset.getDataPoint() != null);
        SVGBase[] linepart = new SVGBase[2];
        this.setChildren(linepart);
        SVGGroup line = new SVGGroup();
        int partNum = this.sortedDatapoints.length + 4;
        SVGBase[] lineparts = new SVGBase[partNum];
        SVGGroup dataColourGroup = new SVGGroup();
        SVGBase[] dataColourGroupChild = new SVGBase[]{dataColourGroup};
        dataColourGroup.setChildren(lineparts);
        dataColourGroup.setIdentifier("SVGGEN_dataColour" + this.datasetIndex);
        String dataSetColor = this.palettes.getDataSetColor(this.dataset.getId());
        if (dataSetColor != null) {
            dataColourGroup.setFill(dataSetColor);
            dataColourGroup.setStroke(dataSetColor);
        }
        linepart[0] = line;
        line.setChildren(dataColourGroupChild);
        line.setIdentifier(this.dataset.getId());
        line.setStyleClass("linestyle strokecolor" + this.colorIndex + " fillcolor" + this.colorIndex);
        line.setTransformation("translate(5.0,5.0)");
        SVGGroup lineGroup = new SVGGroup();
        lineGroup.setIdentifier("SVGGEN_lineGroup" + this.datasetIndex);
        SVGBase[] lineSegments = new SVGBase[this.sortedDatapoints.length - 1];
        if (this.showLine) {
            lineGroup.setChildren(lineSegments);
            lineGroup.setStyle("clip-path: url(#SVGGEN_plotareaBorder)");
            lineparts[1] = lineGroup;
        }
        if (this.generateShadows) {
            SVGFilter filter = new SVGFilter();
            filter.setHeight("200%");
            filter.setWidth("200%");
            filter.setX("-50%");
            filter.setY("-50%");
            filter.setIdentifier("drop-shadow");
            SVGBase[] feGaussianBlurPart = new SVGFeGaussianBlur[1];
            SVGFeGaussianBlur feGaussianBlur = new SVGFeGaussianBlur();
            feGaussianBlur.setStdDeviation("3");
            feGaussianBlur.setIn("SourceAlpha");
            feGaussianBlur.setResult("blur");
            feGaussianBlurPart[0] = feGaussianBlur;
            filter.setChildren(feGaussianBlurPart);
            this.addDefinition(filter);
        }
        lineGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
        lineparts[partNum - 1] = EventTools.generateUserTooltip(lineGroup, this.dataset.getTooltip(), this.nls);
        EventTools.generateUserEvents(lineGroup, this.dataset.getEventHandler());
        EventTools.generateAccessibility(lineGroup, this.dataset.getAccessibility(), this.nls);
        SVGGroup shadowGroup = new SVGGroup();
        SVGBase[] shadows = new SVGBase[this.sortedDatapoints.length];
        if (this.generateShadows) {
            shadowGroup.setChildren(shadows);
            shadowGroup.setVisibility("hidden");
            shadowGroup.setIdentifier("SVGGEN_shadowGroup" + this.dataset.getId());
            lineparts[2] = shadowGroup;
        }
        SVGScript scriptEmitter = new SVGScript();
        boolean firstPointDrawn = false;
        double previousX = 0.0;
        double previousY = 0.0;
        double curX = 0.0;
        double curY = 0.0;
        double zero_y = 0.0;
        int index = this.datasetIndex + 1;
        String str = this.depAxislinear ? "true" : "false";
        String stackPointCoordinates = null;
        StringBuffer pointCoordinates = new StringBuffer();
        StringBuffer shapesWidth = new StringBuffer("var width" + index + " =  new Array(");
        StringBuffer shapesHeight = new StringBuffer("var height" + index + " =  new Array(");
        StringBuffer xPoints = this.datasetIndex == 0 ? new StringBuffer("var xpts =  new Array(") : new StringBuffer("xpts =  new Array(");
        StringBuffer yPoints = new StringBuffer("var ypts" + index + " =  new Array(");
        String defaultValues = "var linear = " + str + "; var max_coor = 0.0; var min_coor = " + this.depAxis.getAxisLength() + "; var max = " + this.depAxisMax + "; var min = " + this.depAxisMin + "; ";
        int previousPointIndex = 0;
        double value = this.depAxislinear ? 0.0 : min;
        int i = 0;
        while (i < this.categoryList.size()) {
            double yRValue;
            double yValue;
            double width = this.shapeWidth;
            double height = this.shapeHeight;
            curX = this.groupDataPositions[i];
            CategoricalData dp = this.isLTR ? this.sortedDatapoints[i] : this.sortedDatapoints[this.categoryList.size() - i - 1];
            if (dp == null || !this.depAxislinear && dp.getValue() <= 0.0) {
                if (!this.depAxislinear) {
                    if (this.datasetIndex == 0) {
                        yValue = min;
                        this.accumulatedHighValues[i] = 0.0;
                        yRValue = 0.0;
                    } else {
                        yValue = min;
                        this.accumulatedHighValues[i] = 0.0;
                        yRValue = 0.0;
                    }
                } else if (this.datasetIndex == 0) {
                    this.accumulatedHighValues[i] = yValue = value;
                    yRValue = value;
                } else {
                    this.accumulatedHighValues[i] = yValue = this.sortedDatapoints[previousPointIndex].getValue();
                    yRValue = value;
                }
            } else {
                yValue = dp.getValue() + this.accumulatedHighValues[i];
                yRValue = dp.getValue();
            }
            SVGGroup pointGroup = new SVGGroup();
            SVGBase[] point = new SVGBase[3];
            pointGroup.setChildren(point);
            SVGGroup pointGroupWrapper = new SVGGroup();
            pointGroupWrapper.setIdentifier("SVGGEN_pointGroupWrapper" + (i + 1));
            SVGBase[] pointWrapper = new SVGBase[2];
            pointWrapper[0] = pointGroup;
            pointGroupWrapper.setChildren(pointWrapper);
            pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
            SVGUse useShape = new SVGUse();
            if (dp == null || !this.depAxislinear && dp.getValue() <= 0.0) {
                useShape.setIdentifier(this.sortedDatapoints[previousPointIndex].getId());
            } else {
                point[2] = EventTools.generateValueTooltip(pointGroup, this.depAxis.formatValue(dp.getValue()));
                point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
                EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
                EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
                useShape.setIdentifier(dp.getId());
            }
            double lastYValue = 0.0;
            if (!this.depAxislinear) {
                if (this.accumulatedHighValues[i] != 0.0) {
                    if (dp.getValue() > 0.0) {
                        value = this.accumulatedHighValues[i];
                        this.accumulatedHighValues[i] = yValue;
                    } else {
                        value = min;
                    }
                } else {
                    value = this.sortedDatapoints[previousPointIndex] != null ? min : min;
                    this.accumulatedHighValues[i] = dp != null && dp.getValue() >= 0.0 ? yValue : 0.0;
                }
            } else {
                value = this.accumulatedHighValues[i];
                this.accumulatedHighValues[i] = yValue;
            }
            lastYValue = this.getCoordinate(this.depAxislinear, value, 0.0, this.depAxis.getAxisLength(), this.depAxisMax, this.depAxisMin);
            curY = this.getCoordinate(this.depAxislinear, yValue, 0.0, this.depAxis.getAxisLength(), this.depAxisMax, this.depAxisMin);
            if (this.datasetIndex == 0) {
                firstNlast = this.getCoordinate(this.depAxislinear, value, 0.0, this.depAxis.getAxisLength(), this.depAxisMax, this.depAxisMin);
                previousSet = curY * 2.0;
            } else {
                previousSet = lastYValue;
            }
            if (dp == null || !this.depAxislinear && dp.getValue() <= 0.0) {
                useShape.setHref("#SVGGEN_holeshape");
                useShape.setTransformation("translate(" + (curX - 2.8) + "," + (curY - 2.8) + ")");
                width = 5.6;
                height = 5.6;
            } else if (dp.getType().equals("hole")) {
                useShape.setHref("#SVGGEN_holeshape");
                useShape.setTransformation("translate(" + (curX - 2.8) + "," + (curY - 2.8) + ")");
                width = 5.6;
                height = 5.6;
            } else {
                useShape.setHref("#" + this.shapeId);
                useShape.setTransformation("translate(" + (curX - width / 2.0) + "," + (curY - height / 2.0) + ")");
            }
            point[0] = useShape;
            lineparts[i + 3] = pointGroupWrapper;
            SVGText valueText = new SVGText();
            if (dp == null || !this.depAxislinear && dp.getValue() <= 0.0) {
                valueText.setText("");
            } else {
                valueText.setText(this.depAxis.formatValue(dp.getValue()));
            }
            valueText.setStyle("font-size:8pt;stroke:none;fill:black");
            valueText.setXCoordinate(Double.toString(curX + 5.0));
            valueText.setYCoordinate(Double.toString(curY));
            valueText.setVisibility("hidden");
            valueText.setIdentifier("SVGGEN_datavalue" + EventTools.getUniqueID());
            pointWrapper[1] = valueText;
            SVGUse shadowShape = new SVGUse();
            shadowShape.setHref("#" + this.shapeId);
            shadowShape.setTransformation("translate(" + (curX - width / 2.0) + "," + (curY - height / 2.0) + ")");
            shadowShape.setFilter("url(#drop-shadow)");
            shadowShape.setIdentifier("SVGGEN_shadowShape" + EventTools.getUniqueID());
            shadows[i] = shadowShape;
            if (firstPointDrawn) {
                if (!this.depAxislinear) {
                    yPoints.append("," + yRValue);
                } else {
                    yPoints.append("," + (previousSet - curY));
                }
                xPoints.append("," + curX);
                shapesWidth.append(", " + width / 2.0);
                shapesHeight.append(", " + height / 2.0);
                stackPointCoordinates = String.valueOf(curX) + " " + lastYValue + "," + stackPointCoordinates;
                SVGPolyline lineSegment = new SVGPolyline();
                lineSegment.setIdentifier("SVGGEN_Line" + i);
                String points = String.valueOf(previousX) + " " + previousY + "," + curX + " " + curY;
                lineSegment.setPoints(points);
                if (dp != null) {
                    if (dp.getType().equals("hole")) {
                        lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
                    }
                    if (!this.depAxislinear && dp.getValue() <= 0.0) {
                        lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
                    }
                } else {
                    lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
                }
                if (this.sortedDatapoints[previousPointIndex] != null) {
                    if (this.sortedDatapoints[previousPointIndex].getType().equals("hole")) {
                        lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
                    }
                    if (!this.depAxislinear && this.sortedDatapoints[previousPointIndex].getValue() <= 0.0) {
                        lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
                    }
                } else {
                    lineSegment.setStyle("stroke-dasharray: 9, 5; stroke-width: 1.5;");
                }
                lineSegments[i - 1] = lineSegment;
            } else {
                firstPointDrawn = true;
                if (this.showArea) {
                    if (!this.depAxislinear) {
                        yPoints.append(String.valueOf(value) + "," + yRValue);
                    } else {
                        yPoints.append(String.valueOf(firstNlast) + "," + (previousSet - curY));
                    }
                    xPoints.append(String.valueOf(curX) + "," + curX);
                    shapesWidth.append(width / 2.0);
                    shapesHeight.append(height / 2.0);
                    zero_y = lastYValue;
                    pointCoordinates.append(String.valueOf(curX) + " " + zero_y);
                    stackPointCoordinates = String.valueOf(curX) + " " + lastYValue + ",";
                }
            }
            if (this.showArea) {
                pointCoordinates.append(", " + curX + " " + curY);
            }
            previousX = curX;
            previousY = curY;
            previousPointIndex = i++;
        }
        xPoints.append("," + curX + ");");
        if (!this.depAxislinear) {
            yPoints.append("," + value + ");");
        } else {
            yPoints.append("," + firstNlast + ");");
        }
        shapesWidth.append(");");
        shapesHeight.append(");");
        EventTools.generateStackAreaProcessedData(scriptEmitter, String.valueOf(xPoints.toString()) + yPoints.toString() + defaultValues + shapesWidth.toString() + shapesHeight.toString());
        linepart[1] = scriptEmitter;
        if (this.showArea) {
            SVGGroup areaGroup = new SVGGroup();
            areaGroup.setIdentifier("SVGGEN_area" + this.datasetIndex);
            if (dataSetColor != null) {
                areaGroup.setFill(dataSetColor);
                areaGroup.setStroke(dataSetColor);
            } else {
                areaGroup.setStyleClass("fillcolor" + this.datasetIndex);
            }
            lineparts[0] = areaGroup;
            SVGPolygon area = new SVGPolygon();
            area.setIdentifier("SVGGEN_poly" + this.datasetIndex);
            area.setStyle("fill-opacity: 0.1; stroke: black; stroke-width: 0;");
            area.setPoints(String.valueOf(stackPointCoordinates) + pointCoordinates.toString());
            SVGBase[] groupChild = new SVGBase[1];
            areaGroup.setChildren(groupChild);
            groupChild[0] = area;
            areaGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
        }
    }
}

