/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeComponentTransfer;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFeFunc;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGFilter;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolygon;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Category;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategory;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Line3D;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class DataSetStackBar3D
extends DataSet {
    static final long serialVersionUID = 3424278988980540064L;
    protected double y3Doffset;
    protected double x3Doffset;
    protected Object category;
    protected List dataList;
    protected String[] colors;
    protected AxisCategory indepAxis;
    protected AxisNumber depAxis;
    protected CategoricalData[] sortedDatapoints;
    protected int colorIndex;
    protected int categoryIndex;
    protected List categoryList;
    protected double[] groupDataPositions;
    protected double depAxisMax;
    protected double depAxisMin;
    protected double axisLenght;
    protected boolean linear;
    protected double barWidth;
    protected double[] accumulatedHighValues;
    protected double[] accumulatedLowValues;
    protected int datasetIndex;
    protected boolean isLTR = true;
    protected SVGColorPalettes palettes;

    public DataSetStackBar3D(String[] colors, Chart input, boolean isLTR, AxisCategory indepAxis, AxisNumber depAxis, List dataset, Object category, int categoryIndex, double barWidth, double[] accumulatedLowValues, double[] accumulatedHighValues, double x3Doffset, double y3Doffset, SVGColorPalettes palettes, NLString nls) {
        super(input, nls);
        this.indepAxis = indepAxis;
        this.depAxis = depAxis;
        this.dataList = dataset;
        this.barWidth = barWidth;
        this.accumulatedHighValues = accumulatedHighValues;
        this.accumulatedLowValues = accumulatedLowValues;
        this.isLTR = isLTR;
        this.linear = depAxis.isLinear();
        this.groupDataPositions = indepAxis.getGroupDataPositions();
        this.axisLenght = indepAxis.getAxisLength();
        this.depAxisMax = depAxis.getMax();
        this.categoryIndex = categoryIndex;
        this.depAxisMin = depAxis.getMin();
        this.y3Doffset = y3Doffset;
        this.category = category;
        this.x3Doffset = x3Doffset;
        this.colors = colors;
        this.palettes = palettes;
        this.sortDataPoints();
    }

    protected void constructPart() {
        ArrayList<SVGGroup> lowValues = new ArrayList<SVGGroup>();
        ArrayList<SVGGroup> highValues = new ArrayList<SVGGroup>();
        SVGBase[] barpart = new SVGBase[2];
        this.setChildren(barpart);
        SVGGroup barGroup1 = new SVGGroup();
        SVGBase[] barGroupChild = new SVGBase[1];
        barpart[0] = barGroup1;
        barGroup1.setChildren(barGroupChild);
        barGroup1.setIdentifier(((Category)this.category).getId());
        SVGGroup barset = new SVGGroup();
        int partNum = this.sortedDatapoints.length + 1;
        SVGBase[] barparts = new SVGBase[partNum + 2];
        barGroupChild[0] = barset;
        barset.setChildren(barparts);
        SVGFilter filter = new SVGFilter();
        filter.setIdentifier("right-dimension");
        SVGFeComponentTransfer feComponentTransfer = new SVGFeComponentTransfer();
        SVGBase[] feComponentTransferPart = new SVGFeComponentTransfer[]{feComponentTransfer};
        filter.setChildren(feComponentTransferPart);
        SVGBase[] feFuncPart = new SVGFeFunc[3];
        SVGFeFunc feFunc = new SVGFeFunc("R");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.1");
        feFunc.setType("linear");
        feFuncPart[0] = feFunc;
        feFunc = new SVGFeFunc("G");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.1");
        feFunc.setType("linear");
        feFuncPart[1] = feFunc;
        feFunc = new SVGFeFunc("B");
        feFunc.setSlope("1");
        feFunc.setIntercept("-0.1");
        feFunc.setType("linear");
        feFuncPart[2] = feFunc;
        feComponentTransfer.setChildren(feFuncPart);
        this.addDefinition(filter);
        filter = new SVGFilter();
        filter.setIdentifier("top-dimension");
        feComponentTransferPart = new SVGFeComponentTransfer[1];
        feComponentTransfer = new SVGFeComponentTransfer();
        feComponentTransferPart[0] = feComponentTransfer;
        filter.setChildren(feComponentTransferPart);
        feFuncPart = new SVGFeFunc[3];
        feFunc = new SVGFeFunc("R");
        feFunc.setSlope("1");
        feFunc.setIntercept("0.1");
        feFunc.setType("linear");
        feFuncPart[0] = feFunc;
        feFunc = new SVGFeFunc("G");
        feFunc.setSlope("1");
        feFunc.setIntercept("0.1");
        feFunc.setType("linear");
        feFuncPart[1] = feFunc;
        feFunc = new SVGFeFunc("B");
        feFunc.setSlope("1");
        feFunc.setIntercept("0.1");
        feFunc.setType("linear");
        feFuncPart[2] = feFunc;
        feComponentTransfer.setChildren(feFuncPart);
        this.addDefinition(filter);
        double min = Math.pow(10.0, this.depAxisMin);
        double curX = 0.0;
        double curY = 0.0;
        double[] groupPosition = this.indepAxis.groupDataPositions;
        if (this.indepAxis.getAxisOrientation() == 0) {
            double zero = this.getCoordinate(this.linear, 0.0, 0.0, Double.parseDouble(this.getHeight()) - Math.abs(this.y3Doffset), this.depAxisMax, this.depAxisMin);
            for (org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset : this.dataList) {
                int i = this.dataList.indexOf(dataset);
                int colorIndex = i % this.colors.length;
                CategoricalData dp = this.isLTR ? this.sortedDatapoints[i] : this.sortedDatapoints[this.dataList.size() - i - 1];
                if (dp == null || !this.linear && dp.getValue() <= 0.0 || dp.getValue() == 0.0) continue;
                SVGGroup pointGroup = new SVGGroup();
                SVGBase[] point = new SVGBase[4];
                pointGroup.setChildren(point);
                pointGroup.setStyleClass("bars" + colorIndex);
                pointGroup.setIdentifier(String.valueOf(this.categoryIndex) + "SVGGEN_dataColour" + i);
                pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
                point[2] = EventTools.generateValueTooltip(pointGroup, this.depAxis.formatValue(dp.getValue()));
                point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
                EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
                EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
                double yValue = dp.getValue();
                double lastYValue = 0.0;
                curX = groupPosition[this.categoryIndex];
                if (yValue >= 0.0) {
                    highValues.add(pointGroup);
                    yValue = dp.getValue() + this.accumulatedHighValues[this.categoryIndex];
                    double value = 0.0;
                    value = !this.linear ? (this.accumulatedHighValues[this.categoryIndex] == 0.0 ? min : this.accumulatedHighValues[this.categoryIndex]) : this.accumulatedHighValues[this.categoryIndex];
                    lastYValue = this.getCoordinate(this.linear, value, 0.0, Double.parseDouble(this.getHeight()) - Math.abs(this.y3Doffset), this.depAxisMax, this.depAxisMin);
                    this.accumulatedHighValues[this.categoryIndex] = yValue;
                } else {
                    lowValues.add(pointGroup);
                    yValue = dp.getValue() + this.accumulatedLowValues[this.categoryIndex];
                    lastYValue = this.getCoordinate(this.linear, this.accumulatedLowValues[this.categoryIndex], 0.0, Double.parseDouble(this.getHeight()) - Math.abs(this.y3Doffset), this.depAxisMax, this.depAxisMin);
                    this.accumulatedLowValues[this.categoryIndex] = yValue;
                }
                if (!this.linear && dp.getValue() < min || this.linear && dp.getValue() < this.depAxisMin) continue;
                curY = this.getCoordinate(this.linear, yValue, 0.0, Double.parseDouble(this.getHeight()) - Math.abs(this.y3Doffset), this.depAxisMax, this.depAxisMin);
                barparts[i + 1] = pointGroup;
                if (this.categoryIndex < 0) continue;
                SVGText barTextSegment = new SVGText();
                String tooltipID = "SVGGEN_datavalue_" + dataset.getId() + "_" + EventTools.getUniqueID();
                barTextSegment.setText(this.depAxis.formatValue(dp.getValue()));
                barTextSegment.setStyle("font-size:8pt;stroke:none;fill:black");
                barTextSegment.setStyleClass("anchorAtMiddle");
                barTextSegment.setVisibility("hidden");
                barTextSegment.setXCoordinate(Double.toString(curX));
                if (dp.getValue() < 0.0) {
                    barTextSegment.setYCoordinate(Double.toString(curY + 8.0 + this.y3Doffset));
                } else {
                    barTextSegment.setYCoordinate(Double.toString(curY - 2.0 + this.y3Doffset));
                }
                barTextSegment.setIdentifier(tooltipID);
                Line3D barSegment = new Line3D();
                barSegment.setIsNeg(dp.getValue() < 0.0);
                barSegment.setPlotHieght(Double.parseDouble(this.getHeight()));
                barSegment.setPlotWidth(Double.parseDouble(this.getWidth()));
                barSegment.setIsHorizontal(true);
                barSegment.setIsLTR(this.isLTR);
                barSegment.setLinear(this.linear);
                barSegment.setYMax(Double.parseDouble(this.getHeight()));
                barSegment.setYMin(0.0);
                barSegment.setXMin(0.0);
                barSegment.setXMax(Double.parseDouble(this.getWidth()));
                barSegment.setZeroYCoord(zero);
                barSegment.setY3Doffset(this.y3Doffset);
                barSegment.setX3Doffset(this.x3Doffset);
                barSegment.setX1(Double.toString(curX));
                barSegment.setY1(Double.toString(lastYValue));
                barSegment.setX2(Double.toString(curX));
                barSegment.setY2(Double.toString(curY));
                barSegment.setStrokeWidth(Double.toString(this.barWidth));
                barSegment.setTopDimensionFilter("url(#top-dimension)");
                barSegment.setRightDimensionFilter("url(#right-dimension)");
                barSegment.setStacked(true);
                String dataSetColor = this.palettes.getDataSetColor(dataset.getId());
                if (dataSetColor != null) {
                    barSegment.setStyleClass("linestyle3D");
                    barSegment.setFill(dataSetColor);
                } else {
                    barSegment.setStyleClass("linestyle3D strokecolor" + colorIndex);
                }
                point[0] = barSegment;
                SVGBase[] groupChild = new SVGBase[]{barTextSegment};
            }
            int i = 1;
            Iterator iter = null;
            iter = lowValues.iterator();
            while (iter.hasNext()) {
                barparts[i] = (SVGBase)iter.next();
                ++i;
            }
            iter = highValues.iterator();
            while (iter.hasNext()) {
                barparts[i] = (SVGBase)iter.next();
                ++i;
            }
        } else {
            double zero = 0.0;
            new ArrayList();
            for (org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset : this.dataList) {
                int i = this.dataList.indexOf(dataset);
                int colorIndex = i % this.colors.length;
                CategoricalData dp = this.sortedDatapoints[i];
                if (dp == null || !this.linear && dp.getValue() <= 0.0 || dp.getValue() == 0.0) continue;
                SVGGroup pointGroup = new SVGGroup();
                pointGroup.setStyleClass("bars" + colorIndex);
                pointGroup.setIdentifier(String.valueOf(this.categoryIndex) + "SVGGEN_dataColour" + i);
                SVGBase[] point = new SVGBase[3];
                pointGroup.setChildren(point);
                pointGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDatavalue(evt,'SVGGEN_datasetGroup')");
                point[2] = EventTools.generateValueTooltip(pointGroup, this.depAxis.formatValue(dp.getValue()));
                point[1] = EventTools.generateUserTooltip(pointGroup, dp.getTooltip(), this.nls);
                EventTools.generateUserEvents(pointGroup, dp.getEventHandler());
                EventTools.generateAccessibility(pointGroup, dp.getAccessibility(), this.nls);
                double xValue = dp.getValue();
                double lastXValue = 0.0;
                curY = this.indepAxis.getAxisLength() - groupPosition[this.categoryIndex];
                double value = 0.0;
                value = !this.linear ? (this.accumulatedHighValues[this.categoryIndex] == 0.0 ? min : this.accumulatedHighValues[this.categoryIndex]) : this.accumulatedHighValues[this.categoryIndex];
                if (xValue >= 0.0) {
                    highValues.add(pointGroup);
                    xValue = dp.getValue() + this.accumulatedHighValues[this.categoryIndex];
                    lastXValue = this.isLTR ? this.getCoordinate(this.linear, value, Double.parseDouble(this.getWidth()) - this.x3Doffset, 0.0, this.depAxisMax, this.depAxisMin) : this.getCoordinate(this.linear, value, 0.0, Double.parseDouble(this.getWidth()) - this.x3Doffset, this.depAxisMax, this.depAxisMin);
                    this.accumulatedHighValues[this.categoryIndex] = xValue;
                } else {
                    lowValues.add(pointGroup);
                    xValue = dp.getValue() + this.accumulatedLowValues[this.categoryIndex];
                    lastXValue = this.isLTR ? this.getCoordinate(this.linear, this.accumulatedLowValues[this.categoryIndex], Double.parseDouble(this.getWidth()) - this.x3Doffset, 0.0, this.depAxisMax, this.depAxisMin) : this.getCoordinate(this.linear, this.accumulatedLowValues[this.categoryIndex], 0.0, Double.parseDouble(this.getWidth()) - this.x3Doffset, this.depAxisMax, this.depAxisMin);
                    this.accumulatedLowValues[this.categoryIndex] = xValue;
                }
                if (!this.linear && dp.getValue() < min || this.linear && dp.getValue() < this.depAxisMin) continue;
                if (this.isLTR) {
                    curX = this.getCoordinate(this.linear, xValue, Double.parseDouble(this.getWidth()) - this.x3Doffset, 0.0, this.depAxisMax, this.depAxisMin);
                    zero = this.getCoordinate(this.linear, 0.0, Double.parseDouble(this.getWidth()) - this.x3Doffset, 0.0, this.depAxisMax, this.depAxisMin);
                } else {
                    curX = this.getCoordinate(this.linear, xValue, 0.0, Double.parseDouble(this.getWidth()) - this.x3Doffset, this.depAxisMax, this.depAxisMin);
                    zero = this.getCoordinate(this.linear, 0.0, 0.0, Double.parseDouble(this.getWidth()) - this.x3Doffset, this.depAxisMax, this.depAxisMin);
                }
                barparts[i + 1] = pointGroup;
                if (this.categoryIndex < 0) continue;
                SVGText barTextSegment = new SVGText();
                String tooltipID = "SVGGEN_datavalue_" + dataset.getId() + "_" + EventTools.getUniqueID();
                barTextSegment.setText(this.depAxis.formatValue(dp.getValue()));
                barTextSegment.setStyle("font-size:8pt;stroke:none;fill:black");
                barTextSegment.setVisibility("hidden");
                barTextSegment.setXCoordinate(Double.toString(curX));
                if (dp.getValue() < 0.0) {
                    barTextSegment.setStyleClass("anchorAtEnd");
                } else {
                    barTextSegment.setStyleClass("anchorAtStart");
                }
                barTextSegment.setIdentifier(tooltipID);
                SVGGroup barGroup = new SVGGroup();
                barGroup.setStyleClass("bars" + colorIndex);
                barGroup.setIdentifier("SVGGEN_bar_" + dataset.getId());
                Line3D barSegment = new Line3D();
                barSegment.setIsNeg(dp.getValue() < 0.0);
                barSegment.setPlotHieght(Double.parseDouble(this.getHeight()));
                barSegment.setPlotWidth(Double.parseDouble(this.getWidth()));
                barSegment.setIsHorizontal(false);
                barSegment.setIsLTR(this.isLTR);
                barSegment.setLinear(this.linear);
                barSegment.setYMax(Double.parseDouble(this.getHeight()));
                barSegment.setYMin(0.0);
                barSegment.setXMin(0.0);
                barSegment.setZeroXCoord(zero);
                barSegment.setXMax(Double.parseDouble(this.getWidth()) - this.x3Doffset);
                barSegment.setY3Doffset(this.y3Doffset);
                barSegment.setX3Doffset(this.x3Doffset);
                barSegment.setX1(Double.toString(lastXValue));
                barSegment.setY1(Double.toString(curY));
                barSegment.setX2(Double.toString(curX));
                barSegment.setY2(Double.toString(curY));
                barSegment.setStrokeWidth(Double.toString(this.barWidth));
                barSegment.setTopDimensionFilter("url(#top-dimension)");
                barSegment.setRightDimensionFilter("url(#right-dimension)");
                barSegment.setStacked(true);
                String dataSetColor = this.palettes.getDataSetColor(dataset.getId());
                if (dataSetColor != null) {
                    barSegment.setStyleClass("linestyle3D");
                    barSegment.setFill(dataSetColor);
                } else {
                    barSegment.setStyleClass("linestyle3D strokecolor" + colorIndex);
                }
                point[0] = barSegment;
                SVGBase[] groupChild = new SVGBase[1];
                barGroup.setChildren(groupChild);
                groupChild[0] = barTextSegment;
            }
            int i = 1;
            Iterator iter = null;
            iter = this.isLTR ? lowValues.iterator() : highValues.iterator();
            while (iter.hasNext()) {
                barparts[i] = (SVGBase)iter.next();
                ++i;
            }
            if (this.isLTR) {
                iter = highValues.iterator();
            } else {
                double barInterval = this.indepAxis.getAxisLength() / (double)this.indepAxis.categoryList.size();
                barparts[i] = this.drawVerticalZeroLine(zero, curY, barInterval);
                ++i;
                iter = lowValues.iterator();
            }
            while (iter.hasNext()) {
                barparts[i] = (SVGBase)iter.next();
                ++i;
            }
        }
    }

    protected SVGBase drawVerticalZeroLine(double line_x, double curY, double intervalWidth) {
        this.height = intervalWidth;
        curY = curY - intervalWidth / 2.0 + this.y3Doffset;
        SVGPolygon verticalZeroLineDef = new SVGPolygon();
        verticalZeroLineDef.setPoints(String.valueOf(line_x) + "," + curY + " " + (line_x + this.x3Doffset) + "," + (curY - this.y3Doffset) + " " + (line_x + this.x3Doffset) + "," + (this.height + (curY - this.y3Doffset)) + " " + line_x + "," + (curY + this.height));
        verticalZeroLineDef.setStyleClass("zero3DAxisLines");
        return verticalZeroLineDef;
    }

    protected void sortDataPoints() {
        this.sortedDatapoints = new CategoricalData[this.dataList.size()];
        for (org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet dataset : this.dataList) {
            List datapoints = dataset.getDataPoint();
            int i = this.dataList.indexOf(dataset);
            for (CategoricalData dp : datapoints) {
                if (!((Category)dp.getCategoryId()).getId().equals(((Category)this.category).getId())) continue;
                this.sortedDatapoints[i] = dp;
            }
        }
        int i = 0;
        while (i < this.sortedDatapoints.length) {
            CategoricalData dp = this.sortedDatapoints[i];
            if (dp != null) {
                if (dp.getValue() >= 0.0) {
                    if (Double.isNaN(this.accumulatedHighValues[this.categoryIndex])) {
                        this.accumulatedHighValues[this.categoryIndex] = dp.getValue();
                    } else {
                        int n = this.categoryIndex;
                        this.accumulatedHighValues[n] = this.accumulatedHighValues[n] + dp.getValue();
                    }
                } else if (Double.isNaN(this.accumulatedLowValues[this.categoryIndex])) {
                    this.accumulatedLowValues[this.categoryIndex] = dp.getValue();
                } else {
                    int n = this.categoryIndex;
                    this.accumulatedLowValues[n] = this.accumulatedLowValues[n] + dp.getValue();
                }
            }
            ++i;
        }
    }
}

