/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGScript;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Accessibility;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Ecmascript;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.EventHandler;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Preferences;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Scripts;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Tooltip;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.ECMAScriptGenerator;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.IGraphicDocumentStyle;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.IGraphicTypeConstants;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.IIDGenerator;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;

public class EventTools
implements IGraphicTypeConstants {
    public static int idNumber = 0;
    protected static IIDGenerator IDGenerator;

    public static void registerIDGenerator(IIDGenerator IDGenerator) {
        EventTools.IDGenerator = IDGenerator;
    }

    public static void generateDefaultScripts(Chart input, SVGScript scriptEmitter, SVGColorPalettes palettes, boolean hasLegend, ULocale locale) {
        DataSets datasets;
        ECMAScriptGenerator jscript = new ECMAScriptGenerator();
        StringBuffer functions = new StringBuffer();
        String graphicType = input.getType();
        Data data = input.getData();
        List dataSetList = null;
        if (data != null && (datasets = data.getDataSets()) != null) {
            dataSetList = datasets.getDataSet();
        }
        int numberOfDataSets = dataSetList == null ? 0 : dataSetList.size();
        Preferences preferencesInput = null;
        if (input.getConfiguration() != null) {
            preferencesInput = input.getConfiguration().getPreferences();
        }
        String cookieName = null;
        if (preferencesInput != null && preferencesInput.getBrowserCookieName() != null && (cookieName = preferencesInput.getBrowserCookieName()).length() == 0) {
            cookieName = null;
        }
        String preferencesVariable = null;
        if (preferencesInput != null && preferencesInput.getUpdatedPreferencesVariable() != null && (preferencesVariable = preferencesInput.getUpdatedPreferencesVariable()).length() == 0) {
            preferencesVariable = null;
        }
        String storedUserPreferences = null;
        if (preferencesInput != null && preferencesInput.getStoredPreferences() != null) {
            storedUserPreferences = preferencesInput.getStoredPreferences();
            if (storedUserPreferences.length() == 0) {
                storedUserPreferences = null;
            }
        } else {
            storedUserPreferences = EventTools.getDefaultPreferences(input, palettes, graphicType, IGraphicDocumentStyle.BASIC_FONT);
        }
        String preferencePage = "line.htm";
        String preferencePageHeight = "495";
        String preferencePageHeightNS = "520";
        if (graphicType.equals("area")) {
            preferencePage = "line.htm";
            preferencePageHeight = "495";
            preferencePageHeightNS = "520";
        } else if (graphicType.equals("stackedArea")) {
            preferencePage = "line.htm";
            preferencePageHeight = "495";
            preferencePageHeightNS = "520";
        } else if (graphicType.equals("scatter")) {
            preferencePage = "bar.htm";
            preferencePageHeight = "435";
            preferencePageHeightNS = "520";
        } else if (graphicType.equals("verticalBar") || graphicType.equals("horizontalBar")) {
            preferencePage = "bar.htm";
            preferencePageHeight = "435";
            preferencePageHeightNS = "460";
        } else if (graphicType.equals("verticalStackedBar") || graphicType.equals("horizontalStackedBar")) {
            preferencePage = "bar.htm";
            preferencePageHeight = "435";
            preferencePageHeightNS = "460";
        } else if (graphicType.equals("verticalBar3D") || graphicType.equals("horizontalBar3D")) {
            preferencePage = "bar.htm";
            preferencePageHeight = "435";
            preferencePageHeightNS = "460";
        } else if (graphicType.equals("verticalStackedBar3D") || graphicType.equals("horizontalStackedBar3D")) {
            preferencePage = "bar.htm";
            preferencePageHeight = "435";
            preferencePageHeightNS = "460";
        } else if (graphicType.equals("pie")) {
            preferencePage = "pie.htm";
            preferencePageHeight = "460";
            preferencePageHeightNS = "480";
        } else if (graphicType.equals("pie3D")) {
            preferencePage = "pie.htm";
            preferencePageHeight = "460";
            preferencePageHeightNS = "480";
        } else if (graphicType.equals("meter")) {
            preferencePage = "meter.htm";
            preferencePageHeight = "350";
            preferencePageHeightNS = "320";
        }
        String url = null;
        if (preferencesInput != null) {
            Utilities.assertion(preferencesInput.getUrl() != null);
            url = preferencesInput.getUrl();
            if (url.endsWith("/") || url.endsWith("\\")) {
                url = url.substring(0, url.length() - 1);
            }
            url = url.replace('\\', '/');
            url = String.valueOf(url) + "/";
            if (locale.getLanguage().equals(new ULocale("de", "", "").getLanguage()) || locale.getLanguage().equals(new ULocale("es", "", "").getLanguage()) || locale.getLanguage().equals(new ULocale("fr", "", "").getLanguage()) || locale.getLanguage().equals(new ULocale("it", "", "").getLanguage()) || locale.getLanguage().equals(new ULocale("ja", "", "").getLanguage()) || locale.getLanguage().equals(new ULocale("ko", "", "").getLanguage())) {
                url = String.valueOf(url) + locale.getLanguage();
                url = String.valueOf(url) + "/";
            } else {
                url = locale.getLanguage().equals(new ULocale("pt", "", "").getLanguage()) ? String.valueOf(url) + "pt/BR/" : (locale.getLanguage().equals(new ULocale("zh", "", "").getLanguage()) ? (locale.getCountry().equals(new ULocale("zh", "CN", "").getCountry()) ? String.valueOf(url) + "zh/CN/" : (locale.getCountry().equals(new ULocale("zh", "TW", "").getCountry()) ? String.valueOf(url) + "zh/TW/" : String.valueOf(url) + "zh/CN/")) : String.valueOf(url) + "en/");
            }
        }
        Scripts scriptsInput = null;
        if (input.getConfiguration() != null) {
            scriptsInput = input.getConfiguration().getScripts();
        }
        String svgDocumentVariable = null;
        String svgWindowVariable = null;
        if (scriptsInput != null) {
            svgDocumentVariable = scriptsInput.getSvgDocumentVariable();
            if (svgDocumentVariable != null && svgDocumentVariable.length() == 0) {
                svgDocumentVariable = null;
            }
            if ((svgWindowVariable = scriptsInput.getSvgWindowVariable()) != null && svgWindowVariable.length() == 0) {
                svgWindowVariable = null;
            }
        }
        int numOfCategories = 0;
        if (data != null && data.getCategories() != null && data.getCategories().getCategory() != null) {
            numOfCategories = data.getCategories().getCategory().size();
        }
        if (preferencesInput != null) {
            functions.append(jscript.generateClientSnifferVariables());
            functions.append(jscript.generateGetPreferencesFunction(cookieName));
            functions.append(jscript.generateStorePreferencesFunction(cookieName));
            functions.append(jscript.generateGetUserPreferencesFunction());
            functions.append(jscript.generateOpenPreferencePageFunction(url, preferencePage, graphicType, "430", preferencePageHeight));
            functions.append(jscript.generateUseNetscapePreferencePage(url, "indexs.html", graphicType, "360", preferencePageHeightNS));
        }
        boolean show_Shapes = EventTools.showShapes(input);
        boolean showUserPref = EventTools.showUserPref(preferencesInput);
        functions.append(jscript.generateGlobalVariables());
        functions.append(jscript.generateInitFunction(storedUserPreferences, palettes, IGraphicDocumentStyle.BASIC_FONT, cookieName, graphicType, dataSetList, numOfCategories, numberOfDataSets, preferencesVariable, svgDocumentVariable, svgWindowVariable, show_Shapes));
        functions.append(jscript.generateGetCurrentValuesFunction());
        functions.append(jscript.generateGetPalettesFunction());
        functions.append(jscript.generateCookieFunctions());
        functions.append(jscript.generateResetStylesFunction());
        functions.append(jscript.generateUpdateLegendStylesFunction(numberOfDataSets, graphicType));
        functions.append(jscript.generateUpdateStylesFunction(numberOfDataSets, cookieName, graphicType, hasLegend, preferencesVariable, numOfCategories, showUserPref));
        functions.append(jscript.generateToggleVisibilityFunction(numberOfDataSets, graphicType, show_Shapes));
        functions.append(jscript.generateBuildHelper());
        functions.append(jscript.generateTooltipScripts());
        functions.append(jscript.generateToggleVisibilityDatavalue());
        if (input.getType().equals("area") || input.getType().equals("stackedArea")) {
            functions.append(jscript.generateMoveNode());
            functions.append(jscript.generateChangeOpacity());
        }
        if (input.getType().equals("stackedArea")) {
            functions.append(jscript.generateTakeOut());
            functions.append(jscript.generatePutIn());
            functions.append(jscript.generateToggle());
            functions.append(jscript.generateRegen());
            functions.append(jscript.generateGetCoordinateFunction());
        }
        if (input.getType().equals("pie") || input.getType().equals("pie3D")) {
            functions.append(jscript.generatePieScripts());
        }
        if (input.getType().equals("scatter")) {
            functions.append(jscript.generateToggleVisibilityShadow(show_Shapes));
        }
        if (input.getType().equals("verticalBar") || input.getType().equals("horizontalBar") || input.getType().equals("horizontalStackedBar") || input.getType().equals("horizontalBar3D") || input.getType().equals("horizontalStackedBar3D") || input.getType().equals("verticalBar3D") || input.getType().equals("horizontalStackedBar3D") || input.getType().equals("verticalStackedBar") || input.getType().equals("verticalStackedBar3D")) {
            functions.append(jscript.generateMoveNode());
        }
        if (input.getType().equals("verticalBar") || input.getType().equals("horizontalBar") || input.getType().equals("verticalBar3D") || input.getType().equals("horizontalBar3D")) {
            functions.append(jscript.generateToggleVisibilityDatasetBar());
        } else if (input.getType().equals("scatter")) {
            functions.append(jscript.generateToggleVisibilityDatasetScatter());
        } else {
            functions.append(jscript.generateToggleVisibilityDataset());
        }
        EventTools.inlineScripts(input, functions);
        scriptEmitter.setDefaultScripts(functions.toString());
    }

    protected static void inlineScripts(Chart input, StringBuffer functions) {
        Scripts scripts;
        if (input.getConfiguration() != null && (scripts = input.getConfiguration().getScripts()) != null) {
            int x = 0;
            while (x < scripts.getEcmascript().size()) {
                String scriptContent = ((Ecmascript)scripts.getEcmascript().get(x)).getValue();
                if (scriptContent != null) {
                    functions.append(scriptContent);
                }
                ++x;
            }
        }
    }

    protected static boolean showShapes(Chart input) {
        boolean showShapes = true;
        if (input.getConfiguration() != null && input.getConfiguration().getShapes() != null) {
            if (input.getConfiguration().getShapes().getVisibility() == null) {
                input.getConfiguration().getShapes().setVisibility("visible");
            }
            showShapes = input.getConfiguration().getShapes().getVisibility().trim().equals("visible");
        }
        return showShapes;
    }

    protected static boolean showUserPref(Preferences pref) {
        return pref != null && pref.isSetShow() && pref.isShow();
    }

    protected static String getDefaultPreferences(Chart input, SVGColorPalettes palettes, String type, String currentFont) {
        StringBuffer preference = new StringBuffer();
        String defaultFont = "font-weight:normal; font-style:normal; font-family:Arial; fill:#000000;";
        String newDefaultFont = String.valueOf(defaultFont.substring(0, defaultFont.indexOf("font-family") + "font-family".length() + 1)) + currentFont + defaultFont.substring(defaultFont.indexOf("; fill"), defaultFont.length());
        preference.append(palettes.getPaletteDisplayName());
        preference.append(",");
        preference.append(8);
        preference.append(",");
        preference.append(newDefaultFont);
        preference.append(",");
        String showShapes = "1";
        if (input.getConfiguration() != null && input.getConfiguration().getShapes() != null) {
            if (input.getConfiguration().getShapes().getVisibility() == null) {
                input.getConfiguration().getShapes().setVisibility("visible");
            }
            showShapes = input.getConfiguration().getShapes().getVisibility().trim().equals("visible") ? "1" : "0";
        }
        preference.append(showShapes);
        preference.append(",");
        String showValues = "0";
        String showPercentage = "0";
        if (type.equals("pie") || type.equals("pie3D")) {
            showValues = "1";
            showPercentage = "1";
        }
        if (input.getConfiguration() != null && input.getConfiguration().getDataValue() != null) {
            DataValue dataValue;
            Configuration config;
            if (input.getConfiguration().getDataValue().getValueVisibility() == null) {
                if (type.equals("pie") || type.equals("pie3D")) {
                    input.getConfiguration().getDataValue().setPercentageVisibility("visible");
                } else {
                    input.getConfiguration().getDataValue().setPercentageVisibility("hidden");
                }
            }
            if (input.getConfiguration().getDataValue().getPercentageVisibility() == null) {
                if (type.equals("pie") || type.equals("pie3D")) {
                    input.getConfiguration().getDataValue().setPercentageVisibility("visible");
                } else {
                    input.getConfiguration().getDataValue().setPercentageVisibility("hidden");
                }
            }
            if ((config = input.getConfiguration()) != null && (dataValue = config.getDataValue()) != null) {
                String percentageVisibility;
                String valueVisibility = dataValue.getValueVisibility();
                if (valueVisibility != null) {
                    String string = showValues = valueVisibility.trim().equals("visible") ? "1" : "0";
                }
                if ((percentageVisibility = dataValue.getPercentageVisibility()) != null) {
                    showPercentage = percentageVisibility.trim().equals("visible") ? "1" : "0";
                }
            }
        }
        preference.append(showValues);
        preference.append(",");
        preference.append(showPercentage);
        return preference.toString();
    }

    public static void generateUserEvents(SVGGroup group, List eventHandlerList) {
        int i = 0;
        while (i < eventHandlerList.size()) {
            EventHandler eventHandler = (EventHandler)eventHandlerList.get(i);
            group.addEvent(eventHandler.getType(), eventHandler.getValue());
            ++i;
        }
    }

    public static void generateStackAreaProcessedData(SVGScript scriptEmitter, String data) {
        new ECMAScriptGenerator();
        StringBuffer functions = new StringBuffer();
        functions.append(data);
        scriptEmitter.setDefaultScripts(functions.toString());
    }

    public static void generateStackAreaJSFunction(SVGScript scriptEmitter, String data) {
        new ECMAScriptGenerator();
        StringBuffer functions = new StringBuffer();
        functions.append(data);
        scriptEmitter.setDefaultScripts(functions.toString());
    }

    public static SVGBase generateUserTooltip(SVGGroup group, Tooltip tooltip, NLString nls) {
        SVGGroup result = null;
        if (tooltip != null) {
            String tooltipID = tooltip.getId() != null ? tooltip.getId() : "SVGGEN_tooltip" + EventTools.getUniqueID();
            SVGGroup toolTipGroup = new SVGGroup();
            SVGBase[] toolTips = new SVGBase[2];
            toolTipGroup.setChildren(toolTips);
            toolTipGroup.setVisibility("hidden");
            SVGText tooltipText = new SVGText();
            tooltipText.setText(nls.getString(tooltip.getLabel()));
            tooltipText.setIdentifier(String.valueOf(tooltipID) + "text");
            toolTips[0] = tooltipText;
            SVGRectangle tooltipRect = new SVGRectangle();
            tooltipRect.setIdentifier(String.valueOf(tooltipID) + "rect");
            tooltipRect.setXCoordinate("0");
            tooltipRect.setYCoordinate("0");
            tooltipRect.setWidth("0");
            tooltipRect.setHeight("0");
            toolTips[1] = tooltipRect;
            result = toolTipGroup;
            group.addEvent("onmouseover", "SVGGEN_showTooltip(evt,'" + tooltipID + "')");
            group.addEvent("onmouseout", "SVGGEN_hideTooltip(evt,'" + tooltipID + "')");
        }
        return result;
    }

    public static SVGBase generateValueTooltip(SVGGroup group, String value) {
        SVGGroup result = null;
        String tooltipID = "SVGGEN_tooltip" + EventTools.getUniqueID();
        SVGGroup toolTipGroup = new SVGGroup();
        SVGBase[] toolTips = new SVGBase[2];
        toolTipGroup.setChildren(toolTips);
        toolTipGroup.setVisibility("hidden");
        SVGText tooltipText = new SVGText();
        tooltipText.setText(value);
        tooltipText.setIdentifier(String.valueOf(tooltipID) + "text");
        toolTips[0] = tooltipText;
        SVGRectangle tooltipRect = new SVGRectangle();
        tooltipRect.setIdentifier(String.valueOf(tooltipID) + "rect");
        tooltipRect.setXCoordinate("0");
        tooltipRect.setYCoordinate("0");
        tooltipRect.setWidth("0");
        tooltipRect.setHeight("0");
        toolTips[1] = tooltipRect;
        result = toolTipGroup;
        group.addEvent("onmouseover", "SVGGEN_showTooltip(evt,'" + tooltipID + "')");
        group.addEvent("onmouseout", "SVGGEN_hideTooltip(evt,'" + tooltipID + "')");
        return result;
    }

    public static void generateAccessibility(SVGGroup group, Accessibility accessibility, NLString nls) {
        if (accessibility != null) {
            String desc;
            String title = nls.getString(accessibility.getTitle());
            if (title != null && title.length() != 0) {
                group.setTitle(title);
            }
            if ((desc = nls.getString(accessibility.getDescription())) != null && desc.length() != 0) {
                group.setDesc(desc);
            }
        }
    }

    public static synchronized String getUniqueID() {
        if (IDGenerator != null) {
            return IDGenerator.getUniqueID();
        }
        String result = Integer.toString(idNumber);
        int zeros = 9 - result.length();
        int i = 0;
        while (i < zeros) {
            result = String.valueOf('0') + result;
            ++i;
        }
        if (++idNumber == 999999999) {
            idNumber = 0;
        }
        return result;
    }

    public static synchronized int getHashCode(Object obj) {
        if (IDGenerator != null) {
            return IDGenerator.getUniqueHashcode(obj);
        }
        return obj.hashCode();
    }
}

