/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGCircle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPath;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Axes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Coordinates;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataValue;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Internationalization;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.MarkerLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.UnitDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphArea;

public class GraphAreaMeter
extends GraphArea {
    static final long serialVersionUID = 2017681070254741260L;
    private ULocale locale = null;
    private double min;
    private double max;
    private double pointerValue = 0.0;
    private double majorUnit;
    private double minorUnit;
    private String label;
    private boolean pointerValueKnown = false;
    private NumberFormat numberFormatter = null;
    private DataSet dataset = null;
    private CategoricalData datumCat = null;
    private Coordinates datumCoor = null;
    private boolean useDatumCat = false;
    private String pointerId = null;
    private TreeSet sortedMarkers;

    public GraphAreaMeter(Chart input, double x, double y, double width, double height) {
        super(input, x, y, width, height);
        this.analyzeData();
    }

    private void analyzeData() {
        this.getPointerValue();
        boolean maxKnown = false;
        boolean minKnown = false;
        boolean majorUnitKnown = false;
        boolean minorUnitKnown = false;
        Configuration config = this.input.getConfiguration();
        if (config != null) {
            Internationalization i18n = config.getInternationalization();
            if (i18n != null) {
                String country;
                String language = i18n.getLanguage() == null ? "" : i18n.getLanguage();
                String string = country = i18n.getCountry() == null ? "" : i18n.getCountry();
                if (language != "" && country != "") {
                    this.locale = new ULocale(language, country);
                } else if (language != "") {
                    this.locale = new ULocale(language);
                }
            }
            Axes axes = config.getAxes();
            DataValue dataValueDef = config.getDataValue();
            if (axes != null) {
                AxisDefinition axisDef = axes.getIndependentAxis();
                this.initDataFormatter(axisDef, dataValueDef);
                if (axisDef != null) {
                    List markerList;
                    UnitDefinition minorUnitDef;
                    UnitDefinition majorUnitDef;
                    if (axisDef.isSetMax()) {
                        this.max = axisDef.getMax();
                        maxKnown = true;
                    }
                    if (axisDef.isSetMin()) {
                        this.min = axisDef.getMin();
                        minKnown = true;
                    }
                    if ((majorUnitDef = axisDef.getMajorUnit()) != null && majorUnitDef.isSetValue()) {
                        this.majorUnit = Math.abs(majorUnitDef.getValue());
                        if (this.majorUnit != 0.0) {
                            majorUnitKnown = true;
                        }
                    }
                    if ((minorUnitDef = axisDef.getMinorUnit()) != null && minorUnitDef.isSetValue()) {
                        this.minorUnit = Math.abs(minorUnitDef.getValue());
                        if (this.minorUnit != 0.0) {
                            minorUnitKnown = true;
                        }
                    }
                    if ((markerList = axisDef.getMarkerLine()) != null && markerList.size() > 0) {
                        this.sortedMarkers = new TreeSet(new Comparator(){

                            public int compare(Object o1, Object o2) {
                                double d2;
                                MarkerLine m1 = (MarkerLine)o1;
                                MarkerLine m2 = (MarkerLine)o2;
                                double d1 = m1.getValue();
                                return d1 == (d2 = m2.getValue()) ? 0 : (d1 < d2 ? -1 : 1);
                            }
                        });
                        this.sortedMarkers.addAll(markerList);
                    }
                }
            }
            if (!(maxKnown && minKnown && majorUnitKnown)) {
                double orderOfMag = maxKnown ? this.getOrderOfMagnitude(this.pointerValue, this.max) : this.getOrderOfMagnitude(this.pointerValue);
                if (!majorUnitKnown) {
                    this.majorUnit = orderOfMag;
                }
                if (!minorUnitKnown) {
                    this.minorUnit = this.majorUnit / 2.0;
                }
                double maxMarkerValue = 0.0;
                boolean maxMarkerValueSet = false;
                if (this.sortedMarkers != null && this.sortedMarkers.size() > 0) {
                    for (MarkerLine marker : this.sortedMarkers) {
                        if (!maxMarkerValueSet) {
                            maxMarkerValue = marker.getValue();
                            maxMarkerValueSet = true;
                            continue;
                        }
                        if (!(marker.getValue() > maxMarkerValue)) continue;
                        maxMarkerValue = marker.getValue();
                    }
                }
                if (!maxKnown) {
                    if (this.pointerValue < 0.0) {
                        this.max = 0.0;
                    } else {
                        this.max = Math.floor(this.pointerValue / this.majorUnit) * this.majorUnit + this.majorUnit;
                        if (maxMarkerValueSet && maxMarkerValue > this.max) {
                            this.max = maxMarkerValue;
                        }
                    }
                }
                if (!minKnown) {
                    this.min = this.min >= 0.0 ? 0.0 : (Math.floor(Math.abs(this.pointerValue) / this.majorUnit) * this.majorUnit + this.majorUnit) * -1.0;
                }
            }
        }
    }

    private void initDataFormatter(AxisDefinition axisDef, DataValue dataValueDef) {
        if (axisDef != null) {
            org.eclipse.tptp.platform.report.chart.svg.internal.input.NumberFormat numFormat = axisDef.getNumberFormat();
            if (numFormat == null && dataValueDef != null) {
                numFormat = dataValueDef.getNumberFormat();
            }
            if (numFormat != null) {
                this.numberFormatter = this.locale != null ? NumberFormat.getInstance((ULocale)this.locale) : NumberFormat.getInstance();
                if (this.numberFormatter instanceof DecimalFormat) {
                    ((DecimalFormat)this.numberFormatter).applyPattern(numFormat.getPattern());
                }
            }
        }
    }

    private String formatValue(double value) {
        String labelText = this.numberFormatter != null ? this.numberFormatter.format(value) : Double.toString(value);
        return labelText;
    }

    private void getPointerValue() {
        List datasetList;
        DataSets datasets;
        Data data = this.input.getData();
        if (data != null && (datasets = data.getDataSets()) != null && (datasetList = datasets.getDataSet()).size() != 0) {
            this.dataset = (DataSet)datasetList.get(0);
            this.label = this.dataset.getLabel();
            List dataList = this.dataset.getDataPoint();
            if (dataList.size() != 0) {
                this.datumCat = (CategoricalData)dataList.get(0);
                if (this.datumCat.isSetValue()) {
                    this.pointerValue = this.datumCat.getValue();
                    this.pointerId = this.datumCat.getId();
                    this.pointerValueKnown = true;
                    this.useDatumCat = true;
                    return;
                }
            }
            if ((dataList = this.dataset.getCoordinates()).size() != 0) {
                this.datumCoor = (Coordinates)dataList.get(0);
                if (this.datumCoor.isSetValue1()) {
                    this.pointerValue = this.datumCoor.getValue1();
                    this.pointerId = this.datumCoor.getId();
                    this.pointerValueKnown = true;
                }
            }
        }
    }

    protected void constructPart() {
        SVGPolyline newTick;
        double gWidth = this.width;
        double gHeight = this.height;
        double cx = gWidth / 2.0;
        double cy = gHeight / 2.0 + 5.0;
        double baseLength = gHeight >= gWidth ? gWidth : gHeight;
        SVGBase[] meterParts = new SVGBase[11];
        this.setChildren(meterParts);
        SVGCircle outerRim = new SVGCircle();
        outerRim.setStyleClass("outerRim");
        outerRim.setCx(Double.toString(cx));
        outerRim.setCy(Double.toString(cy));
        outerRim.setRadius(Double.toString(baseLength * 0.36));
        meterParts[0] = outerRim;
        SVGCircle innerRim = new SVGCircle();
        innerRim.setStyleClass("innerRim");
        innerRim.setCx(Double.toString(cx));
        innerRim.setCy(Double.toString(cy));
        innerRim.setRadius(Double.toString(baseLength * 0.352));
        meterParts[1] = innerRim;
        SVGCircle bkground = new SVGCircle();
        bkground.setStyleClass("speedometerBg");
        bkground.setCx(Double.toString(cx));
        bkground.setCy(Double.toString(cy));
        bkground.setRadius(Double.toString(baseLength * 0.344));
        meterParts[2] = bkground;
        double boxWidth = baseLength * 0.262;
        double boxYOffset = baseLength * 0.1;
        short boxHeight = 14;
        if (this.label != null) {
            SVGGroup labelTextGroup = new SVGGroup();
            labelTextGroup.setIdentifier("rateDefinition");
            labelTextGroup.setStyleClass("rateDef anchorAtMiddle");
            meterParts[5] = labelTextGroup;
            SVGBase[] groupChildren = new SVGBase[1];
            labelTextGroup.setChildren(groupChildren);
            SVGText labelText = new SVGText();
            labelText.setXCoordinate(Double.toString(cx));
            labelText.setYCoordinate(Double.toString(cy + boxYOffset / 2.0));
            labelText.setText(this.nls.getString(this.label));
            groupChildren[0] = labelText;
        }
        double radius = baseLength * 0.25;
        String path = "M " + (cx - radius) + " " + cy + " A " + radius + " " + radius + " 0 1 1 " + (cx + radius) + " " + cy + " Z";
        SVGPath rangeBackground = new SVGPath();
        rangeBackground.setStyleClass("safeRange");
        rangeBackground.setPathData(path);
        meterParts[6] = rangeBackground;
        if (this.sortedMarkers != null && this.sortedMarkers.size() > 0) {
            SVGGroup sectorGroup = new SVGGroup();
            SVGBase[] sectors = new SVGBase[this.sortedMarkers.size()];
            meterParts[7] = sectorGroup;
            sectorGroup.setChildren(sectors);
            int sectorIndex = 0;
            double angleSum = 0.0;
            for (MarkerLine marker : this.sortedMarkers) {
                double value = marker.getValue();
                if (value > this.max) {
                    value = this.max;
                } else if (value <= this.min) continue;
                String color = marker.getColor();
                String markerlabel = this.nls.getString(marker.getLabel());
                double angle = 180.0 / (this.max - this.min) * (value - this.min) - angleSum;
                double arcx = cx + radius * Math.cos(Math.toRadians(180.0 - angle));
                double arcy = cy - radius * Math.sin(Math.toRadians(180.0 - angle));
                String sectorPath = "M " + cx + " " + cy + " L " + (cx - radius) + " " + cy + " A " + radius + " " + radius + " 0 0 1 " + arcx + " " + arcy + " L " + cx + " " + cy + " Z";
                SVGGroup pathGroup = new SVGGroup();
                SVGBase[] thePath = new SVGBase[2];
                pathGroup.setChildren(thePath);
                sectors[sectorIndex++] = pathGroup;
                thePath[1] = EventTools.generateValueTooltip(pathGroup, markerlabel);
                SVGPath sector = new SVGPath();
                sector.setStyle("fill:" + color);
                sector.setPathData(sectorPath);
                sector.setTransformation("rotate(" + angleSum + "," + cx + "," + cy + ")");
                thePath[0] = sector;
                angleSum += angle;
            }
        }
        SVGPolyline tickDef = new SVGPolyline();
        tickDef.setPoints("0 0 5 0");
        tickDef.setStyleClass("ticks");
        tickDef.setIdentifier("tick");
        this.addDefinition(tickDef);
        int numOfTicks = (int)((this.max - this.min) / this.majorUnit);
        if ((this.max - this.min) % this.majorUnit == 0.0) {
            ++numOfTicks;
        }
        SVGGroup tickGroup = new SVGGroup();
        SVGBase[] ticks = new SVGBase[numOfTicks * 2];
        meterParts[8] = tickGroup;
        tickGroup.setChildren(ticks);
        String tickPoints = new String(String.valueOf(cx - radius) + " " + cy + " " + (cx - radius + 5.0) + " " + cy);
        int i = 0;
        while (i < numOfTicks) {
            double angle = 180.0 / (this.max - this.min) * this.majorUnit * (double)i;
            newTick = new SVGPolyline();
            newTick.setPoints(tickPoints);
            newTick.setStyleClass("ticks");
            newTick.setTransformation("rotate(" + angle + "," + cx + "," + cy + ")");
            ticks[i * 2] = newTick;
            SVGText label = new SVGText();
            label.setText(this.formatValue(this.min + this.majorUnit * (double)i));
            double labelx = cx + (radius + 5.0) * Math.cos(Math.toRadians(180.0 - angle));
            double labely = cy - (radius + 5.0) * Math.sin(Math.toRadians(180.0 - angle));
            if (labelx < cx) {
                label.setStyleClass("anchorAtEnd");
            } else if (labelx > cx) {
                label.setStyleClass("anchorAtStart");
            } else {
                label.setStyleClass("anchorAtMiddle");
            }
            label.setXCoordinate(Double.toString(labelx));
            label.setYCoordinate(Double.toString(labely));
            ticks[i * 2 + 1] = label;
            ++i;
        }
        numOfTicks = (int)((this.max - this.min) / this.minorUnit);
        if ((this.max - this.min) % this.minorUnit == 0.0) {
            ++numOfTicks;
        }
        tickGroup = new SVGGroup();
        ticks = new SVGBase[numOfTicks];
        meterParts[9] = tickGroup;
        tickGroup.setChildren(ticks);
        i = 0;
        while (i < numOfTicks) {
            double angle = 180.0 / (this.max - this.min) * this.minorUnit * (double)i;
            newTick = new SVGPolyline();
            newTick.setPoints(tickPoints);
            newTick.setStyleClass("ticks");
            newTick.setTransformation("rotate(" + angle + "," + cx + "," + cy + ")");
            ticks[i] = newTick;
            ++i;
        }
        if (this.pointerValueKnown && this.pointerValue >= this.min && this.pointerValue <= this.max) {
            String actualRate;
            SVGGroup pointerGroup = new SVGGroup();
            meterParts[10] = pointerGroup;
            SVGBase[] pointerParts = new SVGBase[8];
            pointerGroup.setChildren(pointerParts);
            pointerParts[4] = EventTools.generateUserTooltip(pointerGroup, this.dataset.getTooltip(), this.nls);
            EventTools.generateUserEvents(pointerGroup, this.dataset.getEventHandler());
            EventTools.generateAccessibility(pointerGroup, this.dataset.getAccessibility(), this.nls);
            if (this.useDatumCat) {
                pointerParts[5] = EventTools.generateUserTooltip(pointerGroup, this.datumCat.getTooltip(), this.nls);
                EventTools.generateUserEvents(pointerGroup, this.datumCat.getEventHandler());
                EventTools.generateAccessibility(pointerGroup, this.datumCat.getAccessibility(), this.nls);
            } else {
                pointerParts[5] = EventTools.generateUserTooltip(pointerGroup, this.datumCoor.getTooltip(), this.nls);
                EventTools.generateUserEvents(pointerGroup, this.datumCoor.getEventHandler());
                EventTools.generateAccessibility(pointerGroup, this.datumCoor.getAccessibility(), this.nls);
            }
            SVGRectangle rateBox = new SVGRectangle();
            rateBox.setStyleClass("actualRate");
            rateBox.setWidth(Double.toString(boxWidth));
            rateBox.setHeight(Short.toString(boxHeight));
            rateBox.setXCoordinate(Double.toString(cx - boxWidth / 2.0));
            rateBox.setYCoordinate(Double.toString(cy + boxYOffset));
            pointerParts[6] = rateBox;
            if (this.pointerValueKnown && (actualRate = this.formatValue(this.pointerValue)) != null) {
                SVGGroup rateTextGroup = new SVGGroup();
                rateTextGroup.setIdentifier("minmaxRate");
                rateTextGroup.setStyleClass("minmaxRate anchorAtMiddle");
                pointerParts[7] = rateTextGroup;
                SVGBase[] groupChildren = new SVGBase[1];
                rateTextGroup.setChildren(groupChildren);
                SVGText rateText = new SVGText();
                rateText.setXCoordinate(Double.toString(cx));
                rateText.setYCoordinate(Double.toString(cy + boxYOffset + (double)boxHeight - 3.0));
                rateText.setText(actualRate);
                groupChildren[0] = rateText;
            }
            double pointerLength = radius * 0.95;
            double angle = (this.pointerValue - this.min) / (this.max - this.min) * 180.0;
            SVGLine pointer = new SVGLine();
            pointer.setX1(Double.toString(cx - pointerLength));
            pointer.setY1(Double.toString(cy));
            pointer.setX2(Double.toString(cx));
            pointer.setY2(Double.toString(cy));
            pointer.setIdentifier(this.pointerId);
            pointer.setStyleClass("needle");
            pointer.setTransformation("rotate(" + angle + "," + cx + "," + cy + ")");
            pointerParts[0] = pointer;
            SVGCircle outerCircle = new SVGCircle();
            outerCircle.setCx(Double.toString(cx));
            outerCircle.setCy(Double.toString(cy));
            outerCircle.setRadius(Double.toString(3.0));
            outerCircle.setStyleClass("outerCircle");
            pointerParts[1] = outerCircle;
            SVGCircle innerCircle = new SVGCircle();
            innerCircle.setCx(Double.toString(cx));
            innerCircle.setCy(Double.toString(cy));
            innerCircle.setRadius(Double.toString(2.0));
            innerCircle.setStyleClass("innerCircle");
            pointerParts[2] = innerCircle;
            SVGCircle center = new SVGCircle();
            center.setCx(Double.toString(cx));
            center.setCy(Double.toString(cy));
            center.setRadius(Double.toString(0.5));
            center.setStyleClass("center");
            pointerParts[3] = center;
        }
    }

    private double getOrderOfMagnitude(double num, double max) {
        double numMagnitude = this.getOrderOfMagnitude(num);
        double magnitude = 1.0;
        double number = Math.abs(max) / 10.0;
        if (number >= 1.0) {
            while (number >= 10.0) {
                number /= 10.0;
                magnitude *= 10.0;
            }
        } else if (number != 0.0) {
            while (number < 1.0) {
                number *= 10.0;
                magnitude *= 10.0;
            }
            magnitude = 1.0 / magnitude;
        }
        if (numMagnitude > magnitude) {
            magnitude = numMagnitude;
        }
        return magnitude;
    }

    private double getOrderOfMagnitude(double num) {
        double magnitude = 1.0;
        double number = Math.abs(num);
        if (number >= 1.0) {
            while (number >= 10.0) {
                number /= 10.0;
                magnitude *= 10.0;
            }
        } else if (number != 0.0) {
            while (number < 1.0) {
                number *= 10.0;
                magnitude *= 10.0;
            }
            magnitude = 1.0 / magnitude;
        }
        return magnitude;
    }
}

