/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import java.util.Vector;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Axes;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSetAssociations;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DependentAxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Axis;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategoryHorizontal;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategoryVertical;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumberHorizontal;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumberVertical;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.GraphArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Grid;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.MarkerLines;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.MarkerRegions;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.PlotArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;

public abstract class GraphAreaXY
extends GraphArea {
    protected boolean useCategories;
    protected boolean useSecondaryAxis = false;
    protected String indepAxisPosition = "S";
    protected List datasetList = null;
    protected List primaryDataSets = null;
    protected List secondaryDataSets = null;
    protected AxisNumber primaryDepAxis = null;
    protected AxisNumber secondaryDepAxis = null;
    protected Axis indepAxis = null;
    protected boolean cumulative = false;
    protected AxisDefinition indepAxisDef = null;
    protected AxisDefinition primaryDepAxisDef = null;
    protected DependentAxisDefinition secondaryDepAxisDef = null;
    protected boolean isLTR = true;

    public GraphAreaXY(Chart input, boolean isLTR, double x, double y, double width, double height) {
        super(input, x, y, width, height);
        this.isLTR = isLTR;
        this.analyzeData();
    }

    private void analyzeData() {
        Data data;
        Axes axes;
        DataSetAssociations assoc = null;
        String chartType = this.input.getType();
        Configuration config = this.input.getConfiguration();
        if (config != null && (axes = config.getAxes()) != null) {
            this.indepAxisDef = axes.getIndependentAxis();
            this.primaryDepAxisDef = axes.getPrimaryDependentAxis();
            this.secondaryDepAxisDef = axes.getSecondaryDependentAxis();
            this.useSecondaryAxis = this.secondaryDepAxisDef == null || chartType.equals("verticalBar") || chartType.equals("horizontalBar") || chartType.equals("horizontalStackedBar") || chartType.equals("verticalBar3D") || chartType.equals("horizontalBar3D") || chartType.equals("horizontalStackedBar3D") || chartType.equals("verticalStackedBar3D") || chartType.equals("verticalStackedBar") ? false : (assoc = this.secondaryDepAxisDef.getDataSetAssociations()) != null;
        }
        if ((data = this.input.getData()) != null) {
            DataSets datasets = data.getDataSets();
            this.useCategories = data.getCategories() != null;
            if (datasets != null) {
                this.datasetList = datasets.getDataSet();
                this.primaryDataSets = new Vector(this.datasetList);
                if (!this.datasetList.isEmpty()) {
                    DataSet cfr_ignored_0 = (DataSet)this.datasetList.get(0);
                }
            }
        }
        if (this.useSecondaryAxis && assoc != null) {
            this.secondaryDataSets = assoc.getDataSetIds();
            this.primaryDataSets.removeAll(this.secondaryDataSets);
        }
    }

    protected void constructPart() {
        SVGBase[] parts = new SVGBase[8];
        this.setChildren(parts);
        if (this.indepAxisPosition.equals("S")) {
            double rightVertAxisWidth;
            double leftVertAxisWidth;
            this.indepAxis = this.useCategories ? new AxisCategoryHorizontal(this.input, this.isLTR, this.nls) : new AxisNumberHorizontal(this.input, this.isLTR, this.datasetList, 0, this.cumulative, this.nls);
            this.primaryDepAxis = new AxisNumberVertical(this.input, this.isLTR, this.primaryDataSets, 1, this.cumulative, this.nls);
            double marginHeight = this.primaryDepAxis.getMarginForMax();
            if (this.useSecondaryAxis) {
                this.secondaryDepAxis = new AxisNumberVertical(this.input, this.isLTR, this.secondaryDataSets, 2, this.cumulative, this.nls);
                if (marginHeight < (double)this.secondaryDepAxis.getMarginForMax()) {
                    marginHeight = this.secondaryDepAxis.getMarginForMax();
                }
            }
            boolean primaryDepAxisOnLeft = this.isLTR;
            double graphAreaWidth = new Double(this.getWidth());
            double graphAreaHeight = new Double(this.getHeight());
            int margin = 0;
            if (this.indepAxis instanceof AxisNumber) {
                margin = ((AxisNumber)this.indepAxis).getMarginForMax();
            }
            if (primaryDepAxisOnLeft) {
                leftVertAxisWidth = this.primaryDepAxis == null ? 0.0 : this.primaryDepAxis.getAxisWidth();
                rightVertAxisWidth = this.secondaryDepAxis == null ? (double)margin : this.secondaryDepAxis.getAxisWidth();
            } else {
                leftVertAxisWidth = this.secondaryDepAxis == null ? (double)margin : this.secondaryDepAxis.getAxisWidth();
                rightVertAxisWidth = this.primaryDepAxis == null ? 0.0 : this.primaryDepAxis.getAxisWidth();
            }
            double horAxisHeight = this.indepAxis.getAxisHeight();
            double indepAxisLength = graphAreaWidth - leftVertAxisWidth - rightVertAxisWidth - 20.0;
            double depAxisLength = graphAreaHeight - horAxisHeight - 20.0 - marginHeight - 10.0;
            if (indepAxisLength <= 0.0) {
                indepAxisLength = 1.0;
            }
            if (depAxisLength <= 0.0) {
                depAxisLength = 1.0;
            }
            this.indepAxis.setAxisLength(indepAxisLength);
            this.indepAxis.setCrossPoint(leftVertAxisWidth + 10.0, 20.0 + depAxisLength + marginHeight);
            parts[3] = this.indepAxis;
            this.primaryDepAxis.setAxisLength(depAxisLength);
            if (primaryDepAxisOnLeft) {
                this.primaryDepAxis.setCrossPoint(leftVertAxisWidth + 10.0, 20.0 + depAxisLength + marginHeight);
            } else {
                this.primaryDepAxis.setCrossPoint(graphAreaWidth - rightVertAxisWidth - 10.0, 20.0 + depAxisLength + marginHeight);
            }
            parts[4] = this.primaryDepAxis;
            if (this.secondaryDepAxis != null) {
                this.secondaryDepAxis.setAxisLength(depAxisLength);
                if (primaryDepAxisOnLeft) {
                    this.secondaryDepAxis.setCrossPoint(graphAreaWidth - rightVertAxisWidth - 10.0, 20.0 + depAxisLength + marginHeight);
                } else {
                    this.secondaryDepAxis.setCrossPoint(leftVertAxisWidth + 10.0, 20.0 + depAxisLength + marginHeight);
                }
                parts[5] = this.secondaryDepAxis;
            }
            Grid grid = new Grid(this.input, this.isLTR, leftVertAxisWidth + 10.0, 20.0 + marginHeight, indepAxisLength, depAxisLength);
            grid.setPrimaryDepAxis(this.primaryDepAxis);
            grid.setSecondaryDepAxis(this.secondaryDepAxis);
            grid.setIndepAxis(this.indepAxis);
            parts[0] = grid;
            PlotArea plotarea = this.getPlotArea(leftVertAxisWidth + 10.0, 20.0 + marginHeight, indepAxisLength, depAxisLength);
            if (this.input.getType().equals("verticalBar") || this.input.getType().equals("horizontalBar") || this.input.getType().equals("horizontalStackedBar") || this.input.getType().equals("verticalStackedBar")) {
                parts[2] = plotarea;
            } else {
                parts[6] = plotarea;
            }
            MarkerLines markerLines = new MarkerLines(this.input, this.isLTR, leftVertAxisWidth + 10.0, 20.0 + marginHeight, indepAxisLength, depAxisLength, this.indepAxisPosition, this.nls);
            markerLines.setIndepAxis(this.indepAxis);
            markerLines.setIndepAxisDef(this.indepAxisDef);
            markerLines.setPrimaryDepAxis(this.primaryDepAxis);
            markerLines.setPrimaryDepAxisDef(this.primaryDepAxisDef);
            markerLines.setSecondaryDepAxis(this.secondaryDepAxis);
            markerLines.setSecondaryDepAxisDef(this.secondaryDepAxisDef);
            parts[7] = markerLines;
            MarkerRegions markerRegions = new MarkerRegions(this.input, this.isLTR, leftVertAxisWidth + 10.0, 20.0 + marginHeight, indepAxisLength, depAxisLength, this.indepAxisPosition, this.nls);
            markerRegions.setIndepAxis(this.indepAxis);
            markerRegions.setIndepAxisDef(this.indepAxisDef);
            markerRegions.setPrimaryDepAxis(this.primaryDepAxis);
            markerRegions.setPrimaryDepAxisDef(this.primaryDepAxisDef);
            markerRegions.setSecondaryDepAxis(this.secondaryDepAxis);
            markerRegions.setSecondaryDepAxisDef(this.secondaryDepAxisDef);
            parts[1] = markerRegions;
        } else if (this.indepAxisPosition.equals("W")) {
            double rightVertAxisWidth;
            double leftVertAxisWidth;
            this.indepAxis = new AxisCategoryVertical(this.input, this.isLTR, this.nls);
            this.primaryDepAxis = new AxisNumberHorizontal(this.input, this.isLTR, this.primaryDataSets, 1, this.cumulative, this.nls);
            double marginHeight = this.indepAxis.getMarginForMax();
            if (this.useSecondaryAxis) {
                this.secondaryDepAxis = new AxisNumberHorizontal(this.input, this.isLTR, this.secondaryDataSets, 2, this.cumulative, this.nls);
            }
            boolean indepAxisOnLeft = this.isLTR;
            double graphAreaWidth = new Double(this.getWidth());
            double graphAreaHeight = new Double(this.getHeight());
            double bottomAxisHeight = this.primaryDepAxis == null ? 0.0 : this.primaryDepAxis.getAxisHeight();
            double topAxisHeight = this.secondaryDepAxis == null ? 0.0 : this.secondaryDepAxis.getAxisHeight();
            int margin = 0;
            if (this.primaryDepAxis instanceof AxisNumber) {
                margin = this.primaryDepAxis.getMarginForMax();
            }
            if (indepAxisOnLeft) {
                leftVertAxisWidth = this.indepAxis.getAxisWidth();
                rightVertAxisWidth = margin;
            } else {
                leftVertAxisWidth = margin;
                rightVertAxisWidth = this.indepAxis.getAxisWidth();
            }
            double indepAxisLength = graphAreaHeight - bottomAxisHeight - topAxisHeight - marginHeight - 20.0;
            double depAxisLength = graphAreaWidth - leftVertAxisWidth - rightVertAxisWidth - 20.0;
            if (indepAxisLength <= 0.0) {
                indepAxisLength = 1.0;
            }
            if (depAxisLength <= 0.0) {
                depAxisLength = 1.0;
            }
            this.indepAxis.setAxisLength(indepAxisLength);
            if (indepAxisOnLeft) {
                this.indepAxis.setCrossPoint(leftVertAxisWidth + 10.0, 10.0 + indepAxisLength + marginHeight + topAxisHeight);
            } else {
                this.indepAxis.setCrossPoint(graphAreaWidth - rightVertAxisWidth - 10.0, 10.0 + indepAxisLength + marginHeight + topAxisHeight);
            }
            parts[3] = this.indepAxis;
            this.primaryDepAxis.setAxisLength(depAxisLength);
            this.primaryDepAxis.setCrossPoint(leftVertAxisWidth + 10.0, 10.0 + indepAxisLength + marginHeight + topAxisHeight);
            parts[4] = this.primaryDepAxis;
            if (this.secondaryDepAxis != null) {
                this.secondaryDepAxis.setAxisLength(depAxisLength);
                this.secondaryDepAxis.setCrossPoint(leftVertAxisWidth + 10.0, 10.0 + topAxisHeight);
                parts[5] = this.secondaryDepAxis;
            }
            Grid grid = new Grid(this.input, this.isLTR, leftVertAxisWidth + 10.0, 10.0 + topAxisHeight + marginHeight, depAxisLength, indepAxisLength);
            grid.setPrimaryDepAxis(this.primaryDepAxis);
            grid.setSecondaryDepAxis(this.secondaryDepAxis);
            grid.setIndepAxis(this.indepAxis);
            parts[0] = grid;
            PlotArea plotarea = this.getPlotArea(leftVertAxisWidth + 10.0, 10.0 + topAxisHeight + marginHeight, depAxisLength, indepAxisLength);
            if (this.input.getType().equals("verticalBar") || this.input.getType().equals("horizontalBar") || this.input.getType().equals("horizontalStackedBar") || this.input.getType().equals("verticalStackedBar")) {
                parts[2] = plotarea;
            } else {
                parts[6] = plotarea;
            }
            MarkerLines markerLines = new MarkerLines(this.input, this.isLTR, leftVertAxisWidth + 10.0, 10.0 + topAxisHeight + marginHeight, depAxisLength, indepAxisLength, this.indepAxisPosition, this.nls);
            markerLines.setIndepAxis(this.indepAxis);
            markerLines.setIndepAxisDef(this.indepAxisDef);
            markerLines.setPrimaryDepAxis(this.primaryDepAxis);
            markerLines.setPrimaryDepAxisDef(this.primaryDepAxisDef);
            markerLines.setSecondaryDepAxis(this.secondaryDepAxis);
            markerLines.setSecondaryDepAxisDef(this.secondaryDepAxisDef);
            parts[7] = markerLines;
            MarkerRegions markerRegions = new MarkerRegions(this.input, this.isLTR, leftVertAxisWidth + 10.0, 20.0 + marginHeight, indepAxisLength, depAxisLength, this.indepAxisPosition, this.nls);
            markerRegions.setIndepAxis(this.indepAxis);
            markerRegions.setIndepAxisDef(this.indepAxisDef);
            markerRegions.setPrimaryDepAxis(this.primaryDepAxis);
            markerRegions.setPrimaryDepAxisDef(this.primaryDepAxisDef);
            markerRegions.setSecondaryDepAxis(this.secondaryDepAxis);
            markerRegions.setSecondaryDepAxisDef(this.secondaryDepAxisDef);
            parts[1] = markerRegions;
        } else {
            Utilities.assertion(false);
        }
    }

    protected abstract PlotArea getPlotArea(double var1, double var3, double var5, double var7);
}

