/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.Iterator;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLine;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGUse;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Configuration;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.LegendHorizontalLTR;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.LegendHorizontalRTL;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.LegendVerticalLTR;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.LegendVerticalRTL;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Part;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGShapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.FontHelper;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public abstract class Legend
extends Part {
    protected String legendId = null;
    protected String legendTitle = null;
    protected String[] legendLabels = null;
    protected DataSet[] datasetArray = null;
    protected String location = "E";
    protected boolean useShapes = true;
    protected SVGShapes shapes;
    protected SVGColorPalettes palettes;
    protected int numOfDataSets = 0;
    protected String backgroundColor;
    protected boolean isLTR = true;
    protected NLString nls;
    protected FontHelper fontHelper;
    protected double chartWidth;
    protected double margin;
    protected double chartHeight;
    protected double customHeight;
    protected boolean isSetCustomHeight;
    protected double customWidth;
    protected boolean isSetCustomWidth;

    public Legend(Chart input, double x, double y, double width, double height, double chartWidth, double chartHeight, int margin, SVGColorPalettes palettes, SVGShapes shapes, NLString nls) {
        super(input, x, y, width, height);
        this.shapes = shapes;
        this.palettes = palettes;
        this.chartWidth = chartWidth;
        this.chartHeight = chartHeight;
        this.margin = margin;
        this.nls = nls;
        if (input.getType().endsWith("Bar") || input.getType().endsWith("Bar3D") || input.getType().equals("pie") || input.getType().equals("pie3D")) {
            this.useShapes = false;
        }
        this.getDataFromInput();
        this.fontHelper = new FontHelper();
    }

    private void getDataFromInput() {
        DataSets dataSets;
        Data data;
        org.eclipse.tptp.platform.report.chart.svg.internal.input.Legend legendInput;
        Configuration config = this.input.getConfiguration();
        if (config != null && (legendInput = config.getLegend()) != null) {
            this.legendTitle = legendInput.getTitle();
            if (legendInput.isSetLocation()) {
                this.location = legendInput.getLocation();
            }
            this.backgroundColor = legendInput.getBackgroundColor();
            this.legendId = legendInput.getId();
            this.customHeight = legendInput.getHeight();
            this.isSetCustomHeight = legendInput.isSetHeight();
            this.customWidth = legendInput.getWidth();
            this.isSetCustomWidth = legendInput.isSetWidth();
        }
        if ((data = this.input.getData()) != null && (dataSets = data.getDataSets()) != null) {
            List dataSetList = dataSets.getDataSet();
            this.numOfDataSets = dataSetList.size();
            this.legendLabels = new String[this.numOfDataSets];
            this.datasetArray = new DataSet[this.numOfDataSets];
            int count = 0;
            Iterator i = dataSetList.iterator();
            while (i.hasNext()) {
                this.datasetArray[count] = (DataSet)i.next();
                this.legendLabels[count] = this.datasetArray[count].getLabel();
                ++count;
            }
        }
    }

    protected SVGText drawTitle(double x, double y) {
        SVGText title = new SVGText();
        title.setText(this.nls.getString(this.legendTitle));
        if (this.isLTR) {
            title.setXCoordinate(Double.toString(x));
            title.setYCoordinate(Double.toString(y));
            title.setStyleClass("legendTitle");
            title.setIdentifier("SVGGEN_legendTitle");
        } else {
            title.setXCoordinate(Double.toString(x));
            title.setYCoordinate(Double.toString(y));
            title.setStyleClass("legendTitle anchorAtEnd");
            title.setIdentifier("SVGGEN_legendTitle");
        }
        return title;
    }

    protected SVGBase drawLegendItem(double x, double y, int itemNum) {
        String dataSetColor = this.palettes.getDataSetColor(this.datasetArray[itemNum].getId());
        SVGGroup group = new SVGGroup();
        SVGBase[] children = new SVGBase[2];
        group.setChildren(children);
        SVGGroup shapeGroup = new SVGGroup();
        SVGBase[] shapeGroupChildren = new SVGBase[1];
        shapeGroup.setChildren(shapeGroupChildren);
        children[0] = shapeGroup;
        shapeGroup.setIdentifier("SVGGEN_legendShape" + itemNum);
        shapeGroup.setStyleClass("shape" + itemNum);
        int index = itemNum + 1;
        if (this.input.getType().equals("area") || this.input.getType().equals("stackedArea")) {
            shapeGroup.addEvent("onmouseover", "SVGGEN_ChangeOpacity('SVGGEN_poly" + itemNum + "','0.6')");
            shapeGroup.addEvent("onmouseout", "SVGGEN_ChangeOpacity('SVGGEN_poly" + itemNum + "','0.1')");
        } else if (this.input.getType().equals("scatter")) {
            shapeGroup.addEvent("onmouseover", "SVGGEN_toggleVisibilityShadow(evt,'SVGGEN_shadowGroup" + this.datasetArray[itemNum].getId() + "','visible')");
            shapeGroup.addEvent("onmouseout", "SVGGEN_toggleVisibilityShadow(evt,'SVGGEN_shadowGroup" + this.datasetArray[itemNum].getId() + "','hidden')");
        }
        if (!(this.input.getType().equals("horizontalStackedBar3D") || this.input.getType().equals("verticalStackedBar3D") || this.input.getType().equals("verticalStackedBar") || this.input.getType().equals("horizontalStackedBar") || this.input.getType().equals("pie") || this.input.getType().equals("pie3D"))) {
            if (this.input.getType().equals("area")) {
                shapeGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDataset(evt,'" + this.datasetArray[itemNum].getId() + "');" + "SVGGEN_toggleVisibilityDataset(evt,'SVGGEN_area" + itemNum + "');");
            } else if (this.input.getType().equals("scatter")) {
                shapeGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDataset(evt,'" + this.datasetArray[itemNum].getId() + "','SVGGEN_shadowGroup" + this.datasetArray[itemNum].getId() + "')");
            } else if (this.input.getType().equals("stackedArea")) {
                shapeGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDataset(evt,'" + this.datasetArray[itemNum].getId() + "');" + "SVGGEN_toggleVisibilityDataset(evt,'SVGGEN_area" + itemNum + "');SVGGEN_toggle(" + index + ");");
            } else {
                shapeGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDataset(evt,'" + this.datasetArray[itemNum].getId() + "')");
            }
        }
        EventTools.generateUserEvents(shapeGroup, this.datasetArray[itemNum].getEventHandler());
        SVGGroup legendLabelGroup = new SVGGroup();
        SVGBase[] legendLabelGroupChildren = new SVGBase[2];
        legendLabelGroup.setChildren(legendLabelGroupChildren);
        legendLabelGroupChildren[1] = EventTools.generateUserTooltip(legendLabelGroup, this.datasetArray[itemNum].getTooltip(), this.nls);
        EventTools.generateAccessibility(legendLabelGroup, this.datasetArray[itemNum].getAccessibility(), this.nls);
        children[1] = legendLabelGroup;
        if (this.isLTR) {
            SVGRectangle square = new SVGRectangle();
            square.setXCoordinate(Double.toString(x));
            square.setYCoordinate(Double.toString(y));
            square.setHeight(Integer.toString(8));
            square.setWidth(Integer.toString(8));
            if (dataSetColor != null) {
                square.setFill(dataSetColor);
            }
            shapeGroupChildren[0] = square;
            SVGText legendLabel = new SVGText();
            legendLabel.setText(this.nls.getString(this.legendLabels[itemNum]));
            legendLabel.setXCoordinate(Double.toString(x + 8.0 + 5.0));
            legendLabel.setYCoordinate(Double.toString(y + 8.0));
            legendLabel.setStyleClass("legendData");
            legendLabel.setIdentifier("SVGGEN_legendData" + itemNum);
            legendLabelGroupChildren[0] = legendLabel;
        } else {
            SVGRectangle square = new SVGRectangle();
            square.setXCoordinate(Double.toString(x - 8.0));
            square.setYCoordinate(Double.toString(y));
            square.setHeight(Integer.toString(8));
            square.setWidth(Integer.toString(8));
            if (dataSetColor != null) {
                square.setFill(dataSetColor);
            }
            shapeGroupChildren[0] = square;
            SVGText legendLabel = new SVGText();
            legendLabel.setText(this.nls.getString(this.legendLabels[itemNum]));
            legendLabel.setXCoordinate(Double.toString(x - 8.0 - 5.0));
            legendLabel.setYCoordinate(Double.toString(y + 8.0));
            legendLabel.setStyleClass("legendData anchorAtEnd");
            legendLabel.setIdentifier("SVGGEN_legendData" + itemNum);
            legendLabelGroupChildren[0] = legendLabel;
        }
        return group;
    }

    protected SVGBase drawLegendItem(String shapeId, double shapeWidth, double shapeHeight, double x, double y, int itemNum) {
        String dataSetColor = this.palettes.getDataSetColor(this.datasetArray[itemNum].getId());
        SVGGroup group = new SVGGroup();
        SVGBase[] children = new SVGBase[2];
        group.setChildren(children);
        SVGGroup shapeGroup = new SVGGroup();
        children[0] = shapeGroup;
        SVGBase[] shapeGroupChildren = new SVGBase[2];
        shapeGroup.setChildren(shapeGroupChildren);
        shapeGroup.setStyleClass("fillcolor" + itemNum + " strokecolor" + itemNum);
        int index = itemNum + 1;
        if (this.input.getType().equals("area") || this.input.getType().equals("stackedArea")) {
            shapeGroup.addEvent("onmouseover", "SVGGEN_ChangeOpacity('SVGGEN_poly" + itemNum + "','0.6')");
            shapeGroup.addEvent("onmouseout", "SVGGEN_ChangeOpacity('SVGGEN_poly" + itemNum + "','0.1')");
        } else if (this.input.getType().equals("scatter")) {
            shapeGroup.addEvent("onmouseover", "SVGGEN_toggleVisibilityShadow(evt,'SVGGEN_shadowGroup" + this.datasetArray[itemNum].getId() + "','visible')");
            shapeGroup.addEvent("onmouseout", "SVGGEN_toggleVisibilityShadow(evt,'SVGGEN_shadowGroup" + this.datasetArray[itemNum].getId() + "','hidden')");
        }
        if (!(this.input.getType().equals("verticalStackedBar3D") || this.input.getType().equals("horizontalStackedBar3D") || this.input.getType().equals("verticalStackedBar") || this.input.getType().equals("horizontalStackedBar") || this.input.getType().equals("pie") || this.input.getType().equals("pie3D"))) {
            if (this.input.getType().equals("area")) {
                shapeGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDataset(evt,'" + this.datasetArray[itemNum].getId() + "');" + "SVGGEN_toggleVisibilityDataset(evt,'SVGGEN_area" + itemNum + "');");
            } else if (this.input.getType().equals("scatter")) {
                shapeGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDataset(evt,'" + this.datasetArray[itemNum].getId() + "','SVGGEN_shadowGroup" + this.datasetArray[itemNum].getId() + "')");
            } else if (this.input.getType().equals("stackedArea")) {
                shapeGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDataset(evt,'" + this.datasetArray[itemNum].getId() + "');" + "SVGGEN_toggleVisibilityDataset(evt,'SVGGEN_area" + itemNum + "');SVGGEN_toggle(" + index + ");");
            } else {
                shapeGroup.addEvent("onclick", "SVGGEN_toggleVisibilityDataset(evt,'" + this.datasetArray[itemNum].getId() + "')");
            }
        }
        EventTools.generateUserEvents(shapeGroup, this.datasetArray[itemNum].getEventHandler());
        SVGGroup legendLabelGroup = new SVGGroup();
        children[1] = legendLabelGroup;
        SVGBase[] legendLabelGroupChildren = new SVGBase[2];
        legendLabelGroup.setChildren(legendLabelGroupChildren);
        legendLabelGroupChildren[1] = EventTools.generateUserTooltip(legendLabelGroup, this.datasetArray[itemNum].getTooltip(), this.nls);
        EventTools.generateAccessibility(legendLabelGroup, this.datasetArray[itemNum].getAccessibility(), this.nls);
        if (this.isLTR) {
            SVGGroup shapeWithLineGroup = new SVGGroup();
            SVGBase[] shapeAndLine = new SVGBase[2];
            shapeWithLineGroup.setChildren(shapeAndLine);
            shapeWithLineGroup.setIdentifier("SVGGEN_legendShape" + itemNum);
            shapeGroupChildren[0] = shapeWithLineGroup;
            if (dataSetColor != null) {
                shapeWithLineGroup.setFill(dataSetColor);
                shapeWithLineGroup.setStroke(dataSetColor);
            }
            if (!this.input.getType().equals("scatter")) {
                SVGLine line = new SVGLine();
                line.setX1(Double.toString(x));
                line.setY1(Double.toString(y + shapeHeight / 2.0));
                line.setX2(Double.toString(x + 16.0));
                line.setY2(Double.toString(y + shapeHeight / 2.0));
                shapeAndLine[0] = line;
            }
            if (shapeId != null && !shapeId.trim().equals("")) {
                SVGUse useShape = new SVGUse();
                useShape.setHref("#" + shapeId);
                double shapeX = x + (16.0 - shapeWidth) / 2.0;
                useShape.setTransformation("translate(" + shapeX + "," + y + ")");
                shapeAndLine[1] = useShape;
            }
            SVGGroup squareGroup = new SVGGroup();
            SVGBase[] squareMember = new SVGBase[1];
            squareGroup.setChildren(squareMember);
            shapeGroupChildren[1] = squareGroup;
            if (dataSetColor != null) {
                squareGroup.setFill(dataSetColor);
                squareGroup.setStroke(dataSetColor);
            }
            SVGRectangle square = new SVGRectangle();
            square.setXCoordinate(Double.toString(x + 5.0));
            square.setYCoordinate(Double.toString(y));
            square.setHeight(Integer.toString(8));
            square.setWidth(Integer.toString(8));
            square.setIdentifier("SVGGEN_legendsquareshapeWithoutLine" + itemNum);
            square.setVisibility("hidden");
            squareMember[0] = square;
            SVGText legendLabel = new SVGText();
            legendLabel.setText(this.nls.getString(this.legendLabels[itemNum]));
            legendLabel.setXCoordinate(Double.toString(x + 16.0 + 5.0));
            legendLabel.setYCoordinate(Double.toString(y + 8.0));
            legendLabel.setStyleClass("legendData");
            legendLabel.setIdentifier("SVGGEN_legendData" + itemNum);
            legendLabelGroupChildren[0] = legendLabel;
        } else {
            SVGGroup shapeWithLineGroup = new SVGGroup();
            SVGBase[] shapeAndLine = new SVGBase[2];
            shapeWithLineGroup.setChildren(shapeAndLine);
            shapeWithLineGroup.setIdentifier("SVGGEN_legendShape" + itemNum);
            shapeGroupChildren[0] = shapeWithLineGroup;
            if (!this.input.getType().equals("scatter")) {
                SVGLine line = new SVGLine();
                line.setX1(Double.toString(x - 16.0));
                line.setY1(Double.toString(y + shapeHeight / 2.0));
                line.setX2(Double.toString(x));
                line.setY2(Double.toString(y + shapeHeight / 2.0));
                shapeAndLine[0] = line;
            }
            if (shapeId != null && !shapeId.trim().equals("")) {
                SVGUse useShape = new SVGUse();
                useShape.setHref("#" + shapeId);
                double shapeX = x - 16.0 + (16.0 - shapeWidth) / 2.0;
                useShape.setTransformation("translate(" + shapeX + "," + y + ")");
                shapeAndLine[1] = useShape;
            }
            SVGGroup squareGroup = new SVGGroup();
            SVGBase[] squareMember = new SVGBase[1];
            squareGroup.setChildren(squareMember);
            shapeGroupChildren[1] = squareGroup;
            SVGRectangle square = new SVGRectangle();
            square.setXCoordinate(Double.toString(x - 8.0 - 5.0));
            square.setYCoordinate(Double.toString(y));
            square.setHeight(Integer.toString(8));
            square.setWidth(Integer.toString(8));
            square.setIdentifier("SVGGEN_legendsquareshapeWithoutLine" + itemNum);
            square.setVisibility("hidden");
            squareMember[0] = square;
            SVGText legendLabel = new SVGText();
            legendLabel.setText(this.nls.getString(this.legendLabels[itemNum]));
            legendLabel.setXCoordinate(Double.toString(x - 16.0 - 5.0));
            legendLabel.setYCoordinate(Double.toString(y + 8.0));
            legendLabel.setStyleClass("legendData anchorAtEnd");
            legendLabel.setIdentifier("SVGGEN_legendData" + itemNum);
            legendLabelGroupChildren[0] = legendLabel;
        }
        return group;
    }

    public static Legend getInstance(String legendPosition, boolean isLTR, Chart input, double x, double y, double width, double height, double chartWidth, double chartHeight, int margin, SVGColorPalettes palettes, SVGShapes shapes, NLString nls) {
        if (isLTR) {
            if (legendPosition.equals("E") || legendPosition.equals("W") || legendPosition.equals("LEADING") || legendPosition.equals("TRAILING")) {
                return new LegendVerticalLTR(input, x, y, width, height, chartWidth, chartHeight, margin, palettes, shapes, legendPosition, nls);
            }
            return new LegendHorizontalLTR(input, x, y, width, height, chartWidth, chartHeight, margin, palettes, shapes, nls);
        }
        if (legendPosition.equals("E") || legendPosition.equals("W") || legendPosition.equals("LEADING") || legendPosition.equals("TRAILING")) {
            return new LegendVerticalRTL(input, x, y, width, height, chartWidth, chartHeight, margin, palettes, shapes, legendPosition, nls);
        }
        return new LegendHorizontalRTL(input, x, y, width, height, chartWidth, chartHeight, margin, palettes, shapes, nls);
    }

    public void setNLString(NLString nls) {
        this.nls = nls;
    }

    public double getLegendHeight() {
        return this.height;
    }

    public double getLegendWidth() {
        return this.width;
    }
}

