/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Legend;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGShapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.SVGShapeIterator;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;

public class LegendVerticalRTL
extends Legend {
    static final long serialVersionUID = 2615871776779352920L;
    private String legendPosition;
    protected double scalingFactor = 1.0;

    public LegendVerticalRTL(Chart input, double x, double y, double width, double height, double chartWidth, double chartHeight, int margin, SVGColorPalettes palettes, SVGShapes shapes, String legendPosition, NLString nls) {
        super(input, x, y, width, height, chartWidth, chartHeight, margin, palettes, shapes, nls);
        this.legendPosition = legendPosition;
        this.isLTR = false;
        this.analyzeData();
    }

    protected void analyzeData() {
        double maxX = 0.0;
        double currentY = 20.0;
        double verticalScalingFactor = 1.0;
        double horizontalScalingFactor = 1.0;
        if (this.legendTitle != null) {
            this.fontHelper.setFontSize(10.0f);
            double titleWidth = this.fontHelper.getStringWidth(this.nls.getString(this.legendTitle));
            if (titleWidth > maxX) {
                maxX = titleWidth;
            }
            currentY += this.fontHelper.getHeight() + 15.0;
        }
        this.fontHelper.setFontSize(8.0f);
        double itemLineHeight = 18.0;
        if (this.useShapes && this.legendLabels != null) {
            Utilities.assertion(this.shapes != null);
            int i = 0;
            while (i < this.legendLabels.length) {
                double itemWidth = 21.0 + this.fontHelper.getStringWidth(this.nls.getString(this.legendLabels[i])) + 10.0;
                if (itemWidth > maxX) {
                    maxX = itemWidth;
                }
                currentY += itemLineHeight;
                ++i;
            }
        } else if (!this.useShapes && this.legendLabels != null) {
            int i = 0;
            while (i < this.legendLabels.length) {
                double itemWidth = 13.0 + this.fontHelper.getStringWidth(this.nls.getString(this.legendLabels[i])) + 10.0;
                if (itemWidth > maxX) {
                    maxX = itemWidth;
                }
                currentY += itemLineHeight;
                ++i;
            }
        }
        double naturalLegendHeight = currentY + 10.0;
        double naturalLegendWidth = maxX += this.getLeftMargin() + this.getRightMargin();
        if (!this.isSetCustomWidth) {
            if (maxX < this.chartWidth * 0.5) {
                this.width = maxX;
            } else {
                this.width = this.chartWidth * 0.5;
                horizontalScalingFactor = this.width / naturalLegendWidth;
            }
        } else {
            this.width = this.customWidth;
            horizontalScalingFactor = this.width / naturalLegendWidth;
        }
        if (naturalLegendHeight > this.chartHeight) {
            verticalScalingFactor = this.chartHeight / naturalLegendHeight;
        }
        double d = this.scalingFactor = horizontalScalingFactor < verticalScalingFactor ? horizontalScalingFactor : verticalScalingFactor;
        if (this.scalingFactor < 1.0) {
            this.width *= this.scalingFactor;
        }
    }

    protected void constructPart() {
        SVGBase[] subElements = new SVGBase[2];
        this.setChildren(subElements);
        this.setIdentifier(this.legendId);
        SVGGroup legendGroup = new SVGGroup();
        SVGBase[] legendMembers = new SVGBase[this.numOfDataSets + 1];
        legendGroup.setChildren(legendMembers);
        SVGGroup translateGroup = new SVGGroup();
        SVGBase[] translateGroupMember = new SVGBase[1];
        translateGroup.setChildren(translateGroupMember);
        translateGroupMember[0] = legendGroup;
        subElements[1] = translateGroup;
        double currentY = 20.0;
        double sideMargin = this.legendPosition.equals("E") || this.legendPosition.equals("LEADING") ? 10.0 : 5.0;
        if (this.legendTitle != null) {
            legendMembers[0] = this.drawTitle(this.width - sideMargin, 30.0);
            currentY += 25.0;
        }
        if (this.useShapes && this.legendLabels != null) {
            Utilities.assertion(this.shapes != null);
            SVGShapeIterator shapeIterator = this.shapes.getShapeIterator();
            int i = 0;
            while (i < this.legendLabels.length) {
                legendMembers[i + 1] = this.drawLegendItem(shapeIterator.getNextShapeId(this.datasetArray[i].getId()), shapeIterator.getShapeWidth(), shapeIterator.getShapeHeight(), this.width - sideMargin, currentY, i);
                currentY += 18.0;
                ++i;
            }
        } else if (!this.useShapes && this.legendLabels != null) {
            int i = 0;
            while (i < this.legendLabels.length) {
                legendMembers[i + 1] = this.drawLegendItem(this.width - sideMargin, currentY, i);
                currentY += 18.0;
                ++i;
            }
        }
        if (this.scalingFactor < 1.0) {
            legendGroup.setTransformation("scale(" + this.scalingFactor + ")");
            double xOffset = this.width * (1.0 - this.scalingFactor);
            translateGroup.setTransformation("translate(" + xOffset + ",0)");
        }
        this.setWidth(Double.toString(this.width));
        if (this.backgroundColor != null && !this.backgroundColor.equals("")) {
            SVGRectangle bkground = new SVGRectangle();
            bkground.setXCoordinate("0");
            bkground.setYCoordinate("0");
            bkground.setWidth(this.getWidth());
            bkground.setHeight(this.getHeight());
            bkground.setFill(this.backgroundColor);
            subElements[0] = bkground;
        }
    }

    private double getLeftMargin() {
        double sideMargin = this.legendPosition.equals("W") || this.legendPosition.equals("LEADING") ? 10.0 : 5.0;
        return sideMargin;
    }

    private double getRightMargin() {
        double rightMargin = this.legendPosition.equals("E") || this.legendPosition.equals("LEADING") ? 10.0 : 5.0;
        return rightMargin;
    }
}

