/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import java.util.Vector;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGRectangle;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.AxisDefinition;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.MarkerRegion;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Axis;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.Part;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class MarkerRegions
extends Part {
    static final long serialVersionUID = 7019534245475563145L;
    private Axis indepAxis = null;
    private AxisNumber primaryDepAxis = null;
    private AxisNumber secondaryDepAxis = null;
    private AxisDefinition indepAxisDef = null;
    private AxisDefinition primaryDepAxisDef = null;
    private AxisDefinition secondaryDepAxisDef = null;
    private String indepAxisPosition = null;
    private boolean isLTR = true;
    protected NLString nls;

    public MarkerRegions(Chart input, boolean isLTR, double x, double y, double width, double height, String indepAxisPosition, NLString nls) {
        super(input, x, y, width, height);
        this.indepAxisPosition = indepAxisPosition;
        this.isLTR = isLTR;
        this.nls = nls;
    }

    public void setIndepAxis(Axis axis) {
        this.indepAxis = axis;
    }

    public void setPrimaryDepAxis(AxisNumber axis) {
        this.primaryDepAxis = axis;
    }

    public void setSecondaryDepAxis(AxisNumber axis) {
        this.secondaryDepAxis = axis;
    }

    public void setIndepAxisDef(AxisDefinition axisDef) {
        this.indepAxisDef = axisDef;
    }

    public void setPrimaryDepAxisDef(AxisDefinition axisDef) {
        this.primaryDepAxisDef = axisDef;
    }

    public void setSecondaryDepAxisDef(AxisDefinition axisDef) {
        this.secondaryDepAxisDef = axisDef;
    }

    protected void constructPart() {
        List markerRegions;
        Vector<SVGBase> lineVector = new Vector<SVGBase>();
        if (this.primaryDepAxisDef != null) {
            markerRegions = this.primaryDepAxisDef.getMarkerRegion();
            for (MarkerRegion markerRegion : markerRegions) {
                if (this.indepAxisPosition.equals("S") || this.indepAxisPosition.equals("N")) {
                    lineVector.add(this.drawHorizontalMarkerRegion(this.primaryDepAxis, markerRegion));
                    continue;
                }
                lineVector.add(this.drawVerticalMarkerRegion(this.primaryDepAxis, markerRegion));
            }
        }
        if (this.secondaryDepAxisDef != null) {
            markerRegions = this.secondaryDepAxisDef.getMarkerRegion();
            for (MarkerRegion markerRegion : markerRegions) {
                if (this.indepAxisPosition.equals("S") || this.indepAxisPosition.equals("N")) {
                    lineVector.add(this.drawHorizontalMarkerRegion(this.secondaryDepAxis, markerRegion));
                    continue;
                }
                lineVector.add(this.drawVerticalMarkerRegion(this.secondaryDepAxis, markerRegion));
            }
        }
        if (this.indepAxisDef != null && this.indepAxis instanceof AxisNumber) {
            markerRegions = this.indepAxisDef.getMarkerRegion();
            for (MarkerRegion markerRegion : markerRegions) {
                if (this.indepAxisPosition.equals("S") || this.indepAxisPosition.equals("N")) {
                    lineVector.add(this.drawVerticalMarkerRegion((AxisNumber)this.indepAxis, markerRegion));
                    continue;
                }
                lineVector.add(this.drawHorizontalMarkerRegion((AxisNumber)this.indepAxis, markerRegion));
            }
        }
        SVGBase[] children = new SVGBase[lineVector.size()];
        int i = 0;
        while (i < lineVector.size()) {
            children[i] = (SVGBase)lineVector.elementAt(i);
            ++i;
        }
        this.setChildren(children);
    }

    private SVGBase drawHorizontalMarkerRegion(AxisNumber axis, MarkerRegion markerRegion) {
        double toValue;
        double fromValue;
        SVGGroup regionGroup = new SVGGroup();
        SVGBase[] groupMembers = new SVGBase[2];
        regionGroup.setChildren(groupMembers);
        SVGRectangle horizontalMarkerRegion = new SVGRectangle();
        groupMembers[0] = horizontalMarkerRegion;
        double max_y = 0.0;
        double min_y = Double.parseDouble(this.getHeight());
        double max = axis.getMax();
        double min = axis.getMin();
        if (axis.isLinear) {
            fromValue = markerRegion.getFromValue();
            toValue = markerRegion.getToValue();
        } else if (markerRegion.getFromValue() > 0.0 && markerRegion.getToValue() > 0.0) {
            fromValue = Math.log(markerRegion.getFromValue()) / Math.log(10.0);
            toValue = Math.log(markerRegion.getToValue()) / Math.log(10.0);
        } else {
            return regionGroup;
        }
        double from_y_coor = this.getCoordinate(fromValue, max_y, min_y, max, min);
        double to_y_coor = this.getCoordinate(toValue, max_y, min_y, max, min);
        if (to_y_coor < from_y_coor) {
            double tmp = to_y_coor;
            to_y_coor = from_y_coor;
            from_y_coor = tmp;
        }
        horizontalMarkerRegion.setXCoordinate("0");
        horizontalMarkerRegion.setYCoordinate(Double.toString(from_y_coor));
        horizontalMarkerRegion.setWidth(this.getWidth());
        horizontalMarkerRegion.setHeight(Double.toString(to_y_coor - from_y_coor));
        if (markerRegion.getColor() != null) {
            horizontalMarkerRegion.setStroke("none");
            horizontalMarkerRegion.setFill(markerRegion.getColor());
            horizontalMarkerRegion.setStyle("fill-opacity:0.3");
        } else {
            horizontalMarkerRegion.setStroke("none");
            horizontalMarkerRegion.setFill("red");
            horizontalMarkerRegion.setStyle("fill-opacity:0.3");
        }
        String labelText = this.nls.getString(markerRegion.getLabel());
        if (labelText != null && labelText.length() != 0) {
            SVGText label = new SVGText();
            label.setText(labelText);
            if (this.isLTR) {
                label.setXCoordinate("5");
                label.setYCoordinate(Double.toString(from_y_coor + 5.0 + 8.0));
            } else {
                label.setXCoordinate(Double.toString(this.width - 5.0));
                label.setYCoordinate(Double.toString(from_y_coor + 5.0 + 8.0));
                label.setStyleClass("anchorAtEnd");
            }
            groupMembers[1] = label;
        }
        return regionGroup;
    }

    private SVGBase drawVerticalMarkerRegion(AxisNumber axis, MarkerRegion markerRegion) {
        double to_x_coor;
        double from_x_coor;
        double toValue;
        double fromValue;
        SVGGroup regionGroup = new SVGGroup();
        SVGBase[] groupMembers = new SVGBase[2];
        regionGroup.setChildren(groupMembers);
        SVGRectangle verticalMarkerRegion = new SVGRectangle();
        groupMembers[0] = verticalMarkerRegion;
        double max_x = Double.parseDouble(this.getWidth());
        double min_x = 0.0;
        double max = axis.getMax();
        double min = axis.getMin();
        if (axis.isLinear) {
            fromValue = markerRegion.getFromValue();
            toValue = markerRegion.getToValue();
        } else if (markerRegion.getFromValue() > 0.0 && markerRegion.getToValue() > 0.0) {
            fromValue = Math.log(markerRegion.getFromValue()) / Math.log(10.0);
            toValue = Math.log(markerRegion.getToValue()) / Math.log(10.0);
        } else {
            return regionGroup;
        }
        if (this.isLTR) {
            from_x_coor = this.getCoordinate(fromValue, max_x, min_x, max, min);
            to_x_coor = this.getCoordinate(toValue, max_x, min_x, max, min);
        } else {
            from_x_coor = this.getCoordinate(fromValue, min_x, max_x, max, min);
            to_x_coor = this.getCoordinate(toValue, min_x, max_x, max, min);
        }
        if (to_x_coor < from_x_coor) {
            double tmp = to_x_coor;
            to_x_coor = from_x_coor;
            from_x_coor = tmp;
        }
        verticalMarkerRegion.setXCoordinate(Double.toString(from_x_coor));
        verticalMarkerRegion.setYCoordinate("0");
        verticalMarkerRegion.setWidth(Double.toString(to_x_coor - from_x_coor));
        verticalMarkerRegion.setHeight(this.getHeight());
        if (markerRegion.getColor() != null) {
            verticalMarkerRegion.setStroke("none");
            verticalMarkerRegion.setFill(markerRegion.getColor());
            verticalMarkerRegion.setStyle("fill-opacity:0.3");
        } else {
            verticalMarkerRegion.setStroke("none");
            verticalMarkerRegion.setFill("red");
            verticalMarkerRegion.setStyle("fill-opacity:0.3");
        }
        String labelText = this.nls.getString(markerRegion.getLabel());
        if (labelText != null && labelText.length() != 0) {
            SVGText label = new SVGText();
            label.setText(labelText);
            if (this.isLTR) {
                label.setXCoordinate(Double.toString(from_x_coor + 5.0));
                label.setYCoordinate(Double.toString(13.0));
            } else {
                label.setXCoordinate(Double.toString(to_x_coor - 5.0));
                label.setYCoordinate(Double.toString(13.0));
                label.setStyleClass("anchorAtEnd");
            }
            groupMembers[1] = label;
        }
        return regionGroup;
    }

    private double getCoordinate(double value, double max_coor, double min_coor, double max, double min) {
        return (value - max) / (min - max) * (min_coor - max_coor) + max_coor;
    }
}

