/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetPie;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.PlotArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.FontHelper;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class PlotAreaPie
extends PlotArea {
    static final long serialVersionUID = -7674772589477380374L;
    protected CategoricalData[] sortedDatapoints;
    protected List categoryList;
    protected ULocale locale = null;

    public PlotAreaPie() {
        super(null, 0.0, 0.0, 0.0, 0.0, null);
    }

    public PlotAreaPie(Chart input, double x, double y, double width, double height, SVGColorPalettes palettes, ULocale locale, NLString nls) {
        super(input, x, y, width, height, nls);
        this.palettes = palettes;
        this.locale = locale;
    }

    protected void constructPart() {
        double gWidth = this.width;
        double gHeight = this.height;
        double cx = gWidth / 2.0;
        double cy = gHeight / 2.0;
        double radius = gHeight >= gWidth ? gWidth * 0.3 : gHeight * 0.3;
        double pieValue = 0.0;
        double previousDegree = 0.0;
        int numOfSets = 0;
        if (this.primaryDataSets != null) {
            numOfSets += this.primaryDataSets.size();
        }
        Data data = this.input.getData();
        List dataSetList = null;
        if (data != null) {
            DataSets datasets = data.getDataSets();
            Categories categories = data.getCategories();
            if (categories != null) {
                categories.getCategory();
            }
            if (datasets != null) {
                dataSetList = datasets.getDataSet();
            }
        }
        SVGBase[] parts = new SVGBase[numOfSets];
        this.setChildren(parts);
        SVGGroup group = new SVGGroup();
        group.setIdentifier("SVGGEN_datasetGroup");
        group.setChildren(parts);
        SVGBase[] groupChildren = new SVGBase[]{group};
        this.setChildren(groupChildren);
        int curSetNum = 0;
        SVGGroup tickDefGroup = new SVGGroup();
        tickDefGroup.setIdentifier("tickline");
        SVGPolyline tickDef = new SVGPolyline();
        tickDef.setPoints("0 0 5 0");
        tickDef.setStyleClass("axisTicks");
        tickDef.setIdentifier("tickline");
        this.addDefinition(tickDef);
        if (this.primaryDataSets != null) {
            for (DataSet dataset : this.primaryDataSets) {
                this.sortDataPoints(dataset);
                if (this.sortedDatapoints[0] == null || !(this.sortedDatapoints[0].getValue() > 0.0)) continue;
                pieValue += this.sortedDatapoints[0].getValue();
            }
            double runningDeg = 0.0;
            double oldRadius = radius;
            FontHelper fontHelper = new FontHelper();
            fontHelper.setFontSize(8.0f);
            for (DataSet dataset : this.primaryDataSets) {
                this.sortDataPoints(dataset);
                if (this.sortedDatapoints[0] == null || !(this.sortedDatapoints[0].getValue() > 0.0)) continue;
                double degrees = 360.0 * this.sortedDatapoints[0].getValue() / pieValue / 2.0;
                double percentage = this.sortedDatapoints[0].getValue() / pieValue * 100.0;
                Math.cos(Math.PI / 180 * (degrees + runningDeg));
                String label = DataSetPie.formatValue(this.locale, this.input, percentage, this.sortedDatapoints[0].getValue());
                double fontWidth = fontHelper.getStringWidth(label) + 5.0;
                double newRad = (this.width / 2.0 - (fontWidth -= 10.0)) / Math.cos(Math.PI / 180 * (degrees + runningDeg));
                if (Math.abs(newRad) < oldRadius) {
                    oldRadius = Math.abs(newRad);
                }
                runningDeg += degrees * 2.0;
            }
            radius = oldRadius;
            String[] colors = this.palettes.getPalette();
            for (DataSet dataset : this.primaryDataSets) {
                this.sortDataPoints(dataset);
                if (this.sortedDatapoints[0] == null) continue;
                int datasetIndex = dataSetList.indexOf(dataset);
                int colorIndex = datasetIndex % colors.length;
                DataSetPie pie = this.getDatasetPie(this.input, cx, cy, radius, dataset, datasetIndex, colorIndex, this.sortedDatapoints, pieValue, previousDegree, this.locale, this.nls);
                pie.setWidth(this.getWidth());
                pie.setHeight(this.getHeight());
                parts[curSetNum++] = pie;
                previousDegree += (pieValue > 0.0 ? this.sortedDatapoints[0].getValue() / pieValue : 0.0) * 360.0;
            }
        }
    }

    protected DataSetPie getDatasetPie(Chart input, double cx, double cy, double radius, DataSet dataset, int datasetIndex, int colorIndex, CategoricalData[] sortedDatapoints, double pieValue, double previousDegree, ULocale locale, NLString nls) {
        return new DataSetPie(input, cx, cy, radius, dataset, datasetIndex, colorIndex, sortedDatapoints, pieValue, previousDegree, locale, this.palettes, nls);
    }

    protected void sortDataPoints(DataSet dataset) {
        Categories categories;
        Data data = this.input.getData();
        List datapoints = dataset.getDataPoint();
        if (data != null && (categories = data.getCategories()) != null) {
            this.categoryList = categories.getCategory();
            this.sortedDatapoints = new CategoricalData[this.categoryList.size()];
            for (CategoricalData dp : datapoints) {
                this.categoryList.indexOf(dp.getCategoryId());
                this.sortedDatapoints[0] = dp;
            }
        }
    }
}

