/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGLinearGradient;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPath;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGPolyline;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGStop;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.CategoricalData;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetPie;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetPie3D;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.PlotAreaPie;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.FontHelper;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class PlotAreaPie3D
extends PlotAreaPie {
    static final long serialVersionUID = -5473648900946305318L;

    public PlotAreaPie3D(Chart input, double x, double y, double width, double height, SVGColorPalettes palettes, ULocale locale, NLString nls) {
        super(input, x, y, width, height, palettes, locale, nls);
    }

    protected DataSetPie getDatasetPie(Chart input, double cx, double cy, double radius, DataSet dataset, int datasetIndex, int colorIndex, CategoricalData[] sortedDatapoints, double pieValue, double previousDegree, ULocale locale, NLString nls) {
        return new DataSetPie3D(input, cx, cy, radius, dataset, datasetIndex, colorIndex, sortedDatapoints, pieValue, previousDegree, locale, this.palettes, nls);
    }

    protected void constructPart() {
        double gWidth = this.width;
        double gHeight = this.height;
        double cx = gWidth / 2.0;
        double cy = gHeight / 2.0;
        double radius = gHeight >= gWidth ? gWidth * 0.3 : gHeight * 0.3;
        double pieValue = 0.0;
        double previousDegree = 0.0;
        int numOfSets = 0;
        if (this.primaryDataSets != null) {
            numOfSets += this.primaryDataSets.size();
        }
        Data data = this.input.getData();
        List dataSetList = null;
        if (data != null) {
            DataSets datasets = data.getDataSets();
            Categories categories = data.getCategories();
            if (categories != null) {
                categories.getCategory();
            }
            if (datasets != null) {
                dataSetList = datasets.getDataSet();
            }
        }
        SVGBase[] parts = new SVGBase[numOfSets + 1];
        this.setChildren(parts);
        SVGGroup group = new SVGGroup();
        group.setIdentifier("SVGGEN_datasetGroup");
        group.setChildren(parts);
        SVGBase[] groupChildren = new SVGBase[]{group};
        this.setChildren(groupChildren);
        int curSetNum = 0;
        SVGGroup tickDefGroup = new SVGGroup();
        tickDefGroup.setIdentifier("tickline");
        SVGPolyline tickDef = new SVGPolyline();
        tickDef.setPoints("0 0 5 0");
        tickDef.setStyleClass("axisTicks");
        tickDef.setIdentifier("tickline");
        this.addDefinition(tickDef);
        SVGLinearGradient linearGradient = new SVGLinearGradient();
        linearGradient.setIdentifier("pie-gradient");
        linearGradient.setX1("" + -radius);
        linearGradient.setX2("" + radius);
        linearGradient.setY1("0");
        linearGradient.setY2("0");
        linearGradient.setGradientUnits("userSpaceOnUse");
        SVGBase[] stopPart = new SVGStop[3];
        SVGStop stop = new SVGStop();
        stop.setOffset("0");
        stop.setStyle("stop-color:#000000");
        stopPart[0] = stop;
        stop = new SVGStop();
        stop.setOffset(".25");
        stop.setStyle("stop-color:#FFFFFF");
        stopPart[1] = stop;
        stop = new SVGStop();
        stop.setOffset("1");
        stop.setStyle("stop-color:#000000");
        stopPart[2] = stop;
        linearGradient.setChildren(stopPart);
        this.addDefinition(linearGradient);
        if (this.primaryDataSets != null) {
            for (DataSet dataset : this.primaryDataSets) {
                this.sortDataPoints(dataset);
                if (this.sortedDatapoints[0] == null || !(this.sortedDatapoints[0].getValue() > 0.0)) continue;
                pieValue += this.sortedDatapoints[0].getValue();
            }
            double runningDeg = 0.0;
            double oldRadius = radius;
            FontHelper fontHelper = new FontHelper();
            fontHelper.setFontSize(8.0f);
            for (DataSet dataset : this.primaryDataSets) {
                this.sortDataPoints(dataset);
                if (this.sortedDatapoints[0] == null || !(this.sortedDatapoints[0].getValue() > 0.0)) continue;
                double degrees = 360.0 * this.sortedDatapoints[0].getValue() / pieValue / 2.0;
                double percentage = this.sortedDatapoints[0].getValue() / pieValue * 100.0;
                Math.cos(Math.PI / 180 * (degrees + runningDeg));
                String label = DataSetPie.formatValue(this.locale, this.input, percentage, this.sortedDatapoints[0].getValue());
                double fontWidth = fontHelper.getStringWidth(label) + 5.0;
                double newRad = (this.width / 2.0 - (fontWidth -= 10.0)) / Math.cos(Math.PI / 180 * (degrees + runningDeg));
                if (Math.abs(newRad) < oldRadius) {
                    oldRadius = Math.abs(newRad);
                }
                runningDeg += degrees * 2.0;
            }
            radius = oldRadius;
            if (pieValue > 0.0) {
                double depth = radius * 0.3;
                String transformation = "translate(" + cx + "," + cy + ")";
                double degree = 360.0;
                String depthPath = "M " + -radius + " " + depth + " ";
                depthPath = "M " + -radius + " " + depth + " ";
                depthPath = String.valueOf(depthPath) + " A " + radius + " " + radius / 2.0 + " 0 " + (degree < 180.0 ? 0 : 1) + " 0 " + radius + " " + depth;
                depthPath = String.valueOf(depthPath) + " L " + radius + " 0" + " A " + radius + " " + radius / 2.0 + " 0 " + (degree < 180.0 ? 0 : 1) + " 1 " + -radius + " " + "0 Z";
                SVGPath shadeSegment = new SVGPath();
                shadeSegment.setPathData(depthPath);
                shadeSegment.setTransform(transformation);
                shadeSegment.setStyle("fill: url(#pie-gradient)");
                parts[curSetNum++] = shadeSegment;
            }
            String[] colors = this.palettes.getPalette();
            for (DataSet dataset : this.primaryDataSets) {
                this.sortDataPoints(dataset);
                if (this.sortedDatapoints[0] == null) continue;
                int datasetIndex = dataSetList.indexOf(dataset);
                int colorIndex = datasetIndex % colors.length;
                DataSetPie pie = this.getDatasetPie(this.input, cx, cy, radius, dataset, datasetIndex, colorIndex, this.sortedDatapoints, pieValue, previousDegree, this.locale, this.nls);
                pie.setWidth(this.getWidth());
                pie.setHeight(this.getHeight());
                parts[curSetNum++] = pie;
                previousDegree += (pieValue > 0.0 ? this.sortedDatapoints[0].getValue() / pieValue : 0.0) * 360.0;
            }
        }
    }
}

