/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisCategory;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.AxisNumber;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetStackBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.PlotArea;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class PlotAreaStackBar
extends PlotArea {
    static final long serialVersionUID = 6518663084918465127L;
    protected AxisNumber primaryDepAxis = null;
    protected AxisCategory indepAxis = null;
    protected double barWidth = 0.0;
    protected double offset = 1.0;
    protected double groupOffset = 1.0;
    protected double barInterval;
    protected double[] accumulatedHighValues;
    protected double[] accumulatedLowValues;
    protected boolean useCategories;
    protected boolean isLTR = true;

    public PlotAreaStackBar(Chart input, boolean isLTR, double x, double y, double width, double height, SVGColorPalettes palettes, boolean useCategories, NLString nls) {
        super(input, x, y, width, height, nls);
        this.palettes = palettes;
        this.useCategories = useCategories;
        this.isLTR = isLTR;
    }

    protected void constructPart() {
        List categoryList;
        int numOfSets = 0;
        if (this.primaryDataSets != null) {
            numOfSets += this.primaryDataSets.size();
        }
        if (this.secondaryDataSets != null) {
            numOfSets += this.secondaryDataSets.size();
        }
        Data data = this.input.getData();
        List dataSetList = null;
        if (data != null) {
            DataSets datasets = data.getDataSets();
            Categories categories = data.getCategories();
            if (categories != null) {
                categoryList = categories.getCategory();
                this.accumulatedHighValues = new double[categoryList.size()];
                this.accumulatedLowValues = new double[categoryList.size()];
                int i = 0;
                while (i < categoryList.size()) {
                    this.accumulatedHighValues[i] = Double.NaN;
                    this.accumulatedLowValues[i] = Double.NaN;
                    ++i;
                }
            }
            if (datasets != null) {
                dataSetList = datasets.getDataSet();
            }
        }
        int curSetNum = 0;
        if (this.accumulatedHighValues != null) {
            curSetNum = this.accumulatedHighValues.length;
        }
        SVGBase[] parts = new SVGBase[numOfSets + curSetNum + 1];
        SVGGroup group = new SVGGroup();
        group.setIdentifier("SVGGEN_datasetGroup");
        group.setChildren(parts);
        SVGBase[] groupChildren = new SVGBase[]{group};
        this.setChildren(groupChildren);
        SVGGroup foreground = new SVGGroup();
        foreground.setIdentifier("SVGGEN_plotBarsForeground");
        parts[numOfSets + curSetNum] = foreground;
        String[] colors = this.palettes.getPalette();
        this.setBarWidth(numOfSets);
        if (this.primaryDataSets != null) {
            for (DataSet dataset : this.primaryDataSets) {
                int datasetIndex = dataSetList.indexOf(dataset);
                int colorIndex = datasetIndex % colors.length;
                DataSetStackBar bar = this.getDataSet(this.input, this.isLTR, this.indepAxis, this.primaryDepAxis, dataset, datasetIndex, colorIndex, this.barWidth, this.accumulatedLowValues, this.accumulatedHighValues);
                bar.setWidth(this.getWidth());
                bar.setHeight(this.getHeight());
                parts[curSetNum++] = bar;
            }
        }
        if (this.useCategories) {
            Categories categories;
            double[] groupPosition = this.indepAxis.getGroupDataPositions();
            int i = 0;
            while (i < this.accumulatedHighValues.length) {
                double total = 0.0;
                if (!Double.isNaN(this.accumulatedHighValues[i]) || !Double.isNaN(this.accumulatedLowValues[i])) {
                    double y;
                    double x;
                    total = Double.isNaN(this.accumulatedLowValues[i]) ? this.accumulatedHighValues[i] : (Double.isNaN(this.accumulatedHighValues[i]) ? this.accumulatedLowValues[i] : this.accumulatedHighValues[i] + this.accumulatedLowValues[i]);
                    SVGText result = null;
                    String tooltipID = "SVGGEN_datavalue" + EventTools.getUniqueID();
                    SVGText tooltipText = new SVGText();
                    tooltipText.setText(this.primaryDepAxis.formatValue(total));
                    tooltipText.setStyle("font-size:8pt;stroke:none;fill:black");
                    tooltipText.setIdentifier(tooltipID);
                    tooltipText.setVisibility("hidden");
                    if (this.indepAxis.getAxisOrientation() == 0) {
                        tooltipText.setStyleClass("anchorAtMiddle");
                        x = groupPosition[i];
                        y = total >= 0.0 ? this.getCoordinate(this.primaryDepAxis.isLinear, this.accumulatedHighValues[i], 0.0, Double.parseDouble(this.getHeight()), this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin()) - 2.0 : this.getCoordinate(this.primaryDepAxis.isLinear, this.accumulatedLowValues[i], 0.0, Double.parseDouble(this.getHeight()), this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin()) + 10.0;
                    } else {
                        if (this.isLTR) {
                            if (total >= 0.0) {
                                tooltipText.setStyleClass("anchorAtStart");
                                x = this.getCoordinate(this.primaryDepAxis.isLinear, this.accumulatedHighValues[i], Double.parseDouble(this.getWidth()), 0.0, this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin()) + 2.0;
                            } else {
                                tooltipText.setStyleClass("anchorAtEnd");
                                x = this.getCoordinate(this.primaryDepAxis.isLinear, this.accumulatedLowValues[i], Double.parseDouble(this.getWidth()), 0.0, this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin()) - 2.0;
                            }
                        } else if (total >= 0.0) {
                            tooltipText.setStyleClass("anchorAtEnd");
                            x = this.getCoordinate(this.primaryDepAxis.isLinear, this.accumulatedHighValues[i], 0.0, Double.parseDouble(this.getWidth()), this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin()) - 2.0;
                        } else {
                            tooltipText.setStyleClass("anchorAtStart");
                            x = this.getCoordinate(this.primaryDepAxis.isLinear, this.accumulatedLowValues[i], 0.0, Double.parseDouble(this.getWidth()), this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin()) + 2.0;
                        }
                        y = this.indepAxis.getAxisLength() - groupPosition[i];
                    }
                    tooltipText.setXCoordinate(Double.toString(x));
                    tooltipText.setYCoordinate(Double.toString(y));
                    result = tooltipText;
                    parts[i] = result;
                }
                ++i;
            }
            if (data != null && (categories = data.getCategories()) != null) {
                categoryList = categories.getCategory();
                int i2 = 0;
                while (i2 < categoryList.size()) {
                    this.accumulatedHighValues[i2] = 0.0;
                    this.accumulatedLowValues[i2] = 0.0;
                    ++i2;
                }
            }
        }
    }

    public void setPrimaryDepAxis(AxisNumber axis) {
        this.primaryDepAxis = axis;
    }

    public void setIndepAxis(AxisCategory axis) {
        this.indepAxis = axis;
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    public void setBarWidth(int numOfSets) {
        if (this.useCategories) {
            this.barInterval = this.indepAxis.getAxisLength() / (double)this.indepAxis.categoryList.size();
            this.barWidth = this.barInterval - 2.0 * this.offset;
            if (this.barWidth < 1.0) {
                this.offset = 0.1;
                this.barWidth = this.barInterval - this.offset;
            }
            this.barWidth *= 0.8;
        }
    }

    protected DataSetStackBar getDataSet(Chart input, boolean isLTR, AxisCategory indepAxis, AxisNumber depAxis, DataSet dataset, int datasetIndex, int colorIndex, double barWidth, double[] accumulatedLowValues, double[] accumulatedHighValues) {
        return new DataSetStackBar(input, isLTR, indepAxis, this.primaryDepAxis, dataset, datasetIndex, colorIndex, barWidth, accumulatedLowValues, accumulatedHighValues, this.palettes, this.nls);
    }
}

