/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.util.List;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGBase;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGGroup;
import org.eclipse.tptp.platform.report.chart.svg.internal.generator.SVGText;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Categories;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Chart;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Data;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSets;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DataSetStackBar3D;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.EventTools;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.PlotAreaStackBar;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.SVGColorPalettes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.NLString;

public class PlotAreaStackBar3D
extends PlotAreaStackBar {
    protected double y3Doffset;
    protected double x3Doffset;
    static final long serialVersionUID = -8285701343338422123L;

    public PlotAreaStackBar3D(Chart input, boolean isLTR, double x, double y, double width, double height, SVGColorPalettes palettes, boolean useCategories, double x3Doffset, double y3Doffset, NLString nls) {
        super(input, isLTR, x, y, width, height, palettes, useCategories, nls);
        this.y3Doffset = y3Doffset;
        this.x3Doffset = x3Doffset;
    }

    protected void constructPart() {
        int numOfSets = 0;
        if (this.primaryDataSets != null) {
            numOfSets += this.primaryDataSets.size();
        }
        if (this.secondaryDataSets != null) {
            numOfSets += this.secondaryDataSets.size();
        }
        Data data = this.input.getData();
        List categoryList = null;
        if (data != null) {
            DataSets datasets = data.getDataSets();
            Categories categories = data.getCategories();
            if (categories != null) {
                categoryList = categories.getCategory();
                this.accumulatedHighValues = new double[categoryList.size()];
                this.accumulatedLowValues = new double[categoryList.size()];
                int i = 0;
                while (i < categoryList.size()) {
                    this.accumulatedHighValues[i] = Double.NaN;
                    this.accumulatedLowValues[i] = Double.NaN;
                    ++i;
                }
            }
            if (datasets != null) {
                datasets.getDataSet();
            }
        }
        int curSetNum = 0;
        if (this.accumulatedHighValues != null) {
            curSetNum = this.accumulatedHighValues.length;
        }
        int categorySize = 0;
        if (categoryList != null) {
            categorySize = categoryList.size();
        }
        SVGBase[] parts = new SVGBase[categorySize + curSetNum + 1];
        SVGGroup group = new SVGGroup();
        group.setIdentifier("SVGGEN_datasetGroup");
        group.setChildren(parts);
        SVGBase[] groupChildren = new SVGBase[]{group};
        this.setChildren(groupChildren);
        SVGGroup foreground = new SVGGroup();
        foreground.setIdentifier("SVGGEN_plotBarsForeground");
        parts[categorySize + curSetNum] = foreground;
        String[] colors = this.palettes.getPalette();
        this.setBarWidth(numOfSets);
        if (this.primaryDataSets != null) {
            int i = 0;
            while (i < categorySize) {
                DataSetStackBar3D bar = new DataSetStackBar3D(colors, this.input, this.isLTR, this.indepAxis, this.primaryDepAxis, this.primaryDataSets, categoryList.get(i), i, this.barWidth, this.accumulatedLowValues, this.accumulatedHighValues, this.x3Doffset, this.y3Doffset, this.palettes, this.nls);
                bar.setWidth(this.getWidth());
                bar.setHeight(this.getHeight());
                parts[i] = bar;
                ++i;
            }
        }
        if (this.useCategories) {
            Categories categories;
            double[] groupPosition = this.indepAxis.getGroupDataPositions();
            int i = 0;
            while (i < this.accumulatedHighValues.length) {
                double total = 0.0;
                if (!Double.isNaN(this.accumulatedHighValues[i]) || !Double.isNaN(this.accumulatedLowValues[i])) {
                    double y;
                    double x;
                    total = Double.isNaN(this.accumulatedLowValues[i]) ? this.accumulatedHighValues[i] : (Double.isNaN(this.accumulatedHighValues[i]) ? this.accumulatedLowValues[i] : this.accumulatedHighValues[i] + this.accumulatedLowValues[i]);
                    SVGText result = null;
                    String tooltipID = "SVGGEN_datavalue" + EventTools.getUniqueID();
                    SVGText tooltipText = new SVGText();
                    tooltipText.setText(this.primaryDepAxis.formatValue(total));
                    tooltipText.setStyle("font-size:8pt;stroke:none;fill:black");
                    tooltipText.setIdentifier(tooltipID);
                    tooltipText.setVisibility("hidden");
                    if (this.indepAxis.getAxisOrientation() == 0) {
                        tooltipText.setStyleClass("anchorAtMiddle");
                        x = groupPosition[i];
                        y = total >= 0.0 ? this.getCoordinate(this.primaryDepAxis.isLinear, this.accumulatedHighValues[i], 0.0, Double.parseDouble(this.getHeight()) - this.y3Doffset, this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin()) - 2.0 : this.getCoordinate(this.primaryDepAxis.isLinear, this.accumulatedLowValues[i], 0.0, Double.parseDouble(this.getHeight()) - this.y3Doffset, this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin()) + 10.0 + this.y3Doffset;
                    } else {
                        if (this.isLTR) {
                            if (total >= 0.0) {
                                tooltipText.setStyleClass("anchorAtStart");
                                x = this.getCoordinate(this.primaryDepAxis.isLinear, this.accumulatedHighValues[i], Double.parseDouble(this.getWidth()) - this.x3Doffset, 0.0, this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin()) + 2.0 + this.x3Doffset;
                            } else {
                                tooltipText.setStyleClass("anchorAtEnd");
                                x = this.getCoordinate(this.primaryDepAxis.isLinear, this.accumulatedLowValues[i], Double.parseDouble(this.getWidth()) - this.x3Doffset, 0.0, this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin()) - 2.0;
                            }
                        } else if (total >= 0.0) {
                            tooltipText.setStyleClass("anchorAtEnd");
                            x = this.getCoordinate(this.primaryDepAxis.isLinear, this.accumulatedHighValues[i], 0.0, Double.parseDouble(this.getWidth()) - this.x3Doffset, this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin()) - 2.0;
                        } else {
                            tooltipText.setStyleClass("anchorAtStart");
                            x = this.getCoordinate(this.primaryDepAxis.isLinear, this.accumulatedLowValues[i], 0.0, Double.parseDouble(this.getWidth()) - this.x3Doffset, this.primaryDepAxis.getMax(), this.primaryDepAxis.getMin()) + 2.0 + this.x3Doffset;
                        }
                        y = this.indepAxis.getAxisLength() - groupPosition[i] + this.y3Doffset;
                    }
                    tooltipText.setXCoordinate(Double.toString(x));
                    tooltipText.setYCoordinate(Double.toString(y));
                    result = tooltipText;
                    parts[i + curSetNum] = result;
                }
                ++i;
            }
            if (data != null && (categories = data.getCategories()) != null) {
                categoryList = categories.getCategory();
                int i2 = 0;
                while (i2 < categorySize) {
                    this.accumulatedHighValues[i2] = 0.0;
                    this.accumulatedLowValues[i2] = 0.0;
                    ++i2;
                }
            }
        }
    }
}

