/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.part;

import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.DataSet;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.Shape;
import org.eclipse.tptp.platform.report.chart.svg.internal.part.DefaultResources;
import org.eclipse.tptp.platform.report.chart.svg.internal.shapes.ShapeType;
import org.eclipse.tptp.platform.report.chart.svg.internal.shapes.Shapes;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.SVGShapeIterator;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.ShapesDOMDocument;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.Utilities;
import org.eclipse.tptp.platform.report.chart.svg.internal.util.XMLLoader;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SVGShapes
implements Serializable {
    static final long serialVersionUID = 7766275120609290096L;
    private DefaultResources defaultResources;
    private String[] shapeIds;
    private double[] shapeWidths;
    private double[] shapeHeights;
    private Element[] shapeDefinitions;
    private boolean useDefault = true;
    private HashMap dataSetShapes;

    public SVGShapes(DefaultResources resources) {
        this.defaultResources = resources;
        this.dataSetShapes = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initShapes() {
        DefaultResources defaultResources = this.defaultResources;
        synchronized (defaultResources) {
            String shapeXMLFile;
            if (this.defaultResources.isDefaultShapesInitialized()) {
                return;
            }
            Shapes shapes = null;
            boolean initialized = false;
            if (this.defaultResources.getResourceDir() != null && (shapes = this.getShapesFromShapeXMLFile(shapeXMLFile = String.valueOf(this.defaultResources.getResourceDir()) + "/shapes.xml")) != null) {
                initialized = this.parseShapes(shapes);
            }
            if (!initialized && (shapes = this.getShapesFromDefaultLocation()) != null) {
                initialized = this.parseShapes(shapes);
            }
            if (initialized) {
                this.defaultResources.setDefaultShapesInitialized(true);
            } else {
                Utilities.assertion(false);
            }
        }
    }

    private boolean parseShapes(Shapes shapes) {
        Utilities.assertion(shapes != null);
        boolean parseFailed = false;
        List shapeList = shapes.getShape();
        String[] defaultShapeIds = new String[shapeList.size()];
        double[] defaultShapeWidths = new double[shapeList.size()];
        double[] defaultShapeHeights = new double[shapeList.size()];
        Element[] defaultShapeDefinitions = new Element[shapeList.size()];
        int shapeIndex = 0;
        for (ShapeType shape : shapeList) {
            String shapeDef = shape.getValue();
            Element shapeElem = this.getSymbolElementFromShapeDef(shapeDef);
            if (shapeElem == null) {
                parseFailed = true;
                defaultShapeIds = null;
                defaultShapeWidths = null;
                defaultShapeHeights = null;
                defaultShapeDefinitions = null;
                break;
            }
            shapeElem.setAttribute("id", shape.getId());
            defaultShapeWidths[shapeIndex] = shape.getWidth();
            defaultShapeHeights[shapeIndex] = shape.getHeight();
            defaultShapeIds[shapeIndex] = shape.getId();
            defaultShapeDefinitions[shapeIndex] = shapeElem;
            ++shapeIndex;
        }
        if (!parseFailed) {
            this.defaultResources.setDefaultShapeIds(defaultShapeIds);
            this.defaultResources.setDefaultShapeWidths(defaultShapeWidths);
            this.defaultResources.setDefaultShapeHeights(defaultShapeHeights);
            this.defaultResources.setDefaultShapeDefinitions(defaultShapeDefinitions);
            return true;
        }
        return false;
    }

    private Document createShapeDefDoc() {
        Document shapeDefDoc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            DOMImplementation domImpl = builder.getDOMImplementation();
            DocumentType dType = domImpl.createDocumentType("svg", "-//W3C//DTD SVG 1.0//EN", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
            shapeDefDoc = domImpl.createDocument("http://www.w3.org/2000/svg", "g", dType);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Utilities.assertion(false);
        }
        return shapeDefDoc;
    }

    private Shapes getShapesFromShapeXMLFile(String shapeXMLFile) {
        XMLLoader xmlLoader = new XMLLoader();
        InputSource inputSource = new InputSource(shapeXMLFile);
        if (!xmlLoader.load(inputSource)) {
            return null;
        }
        ShapesDOMDocument shapesInput = new ShapesDOMDocument(xmlLoader.getDOM());
        return shapesInput.getShapes();
    }

    private Shapes getShapesFromDefaultLocation() {
        XMLLoader xmlLoader = new XMLLoader();
        InputStream defaultShapes = Utilities.getResourceAsStream("org/eclipse/tptp/platform/report/chart/svg/internal/resources/shapes.xml");
        InputSource inputSource = new InputSource(defaultShapes);
        if (!xmlLoader.load(inputSource)) {
            return null;
        }
        ShapesDOMDocument shapesInput = new ShapesDOMDocument(xmlLoader.getDOM());
        return shapesInput.getShapes();
    }

    private Element getSymbolElementFromShapeDef(String xmlFragments) {
        XMLLoader xmlLoader = new XMLLoader();
        StringBuffer xml = new StringBuffer("<symbol>" + xmlFragments + "</symbol>");
        StringReader reader = new StringReader(xml.toString());
        InputSource inputSource = new InputSource(reader);
        if (!xmlLoader.load(inputSource)) {
            return null;
        }
        return xmlLoader.getDOM().getDocumentElement();
    }

    public void setCustomShapes(String shapesLocation) {
        boolean configInvalid = false;
        Document shapeDefDoc = this.createShapeDefDoc();
        Utilities.assertion(shapeDefDoc != null);
        Shapes shapes = this.getShapesFromShapeXMLFile(shapesLocation);
        if (shapes == null) {
            return;
        }
        List shapeList = shapes.getShape();
        this.shapeIds = new String[shapeList.size()];
        this.shapeWidths = new double[shapeList.size()];
        this.shapeHeights = new double[shapeList.size()];
        this.shapeDefinitions = new Element[shapeList.size()];
        int shapeIndex = 0;
        for (ShapeType shape : shapeList) {
            String shapeDef = shape.getValue();
            Element shapeElem = this.getSymbolElementFromShapeDef(shapeDef);
            if (shapeElem == null) {
                configInvalid = true;
                break;
            }
            shapeElem.setAttribute("id", shape.getId());
            this.shapeWidths[shapeIndex] = shape.getWidth();
            this.shapeHeights[shapeIndex] = shape.getHeight();
            this.shapeIds[shapeIndex] = shape.getId();
            this.shapeDefinitions[shapeIndex] = shapeElem;
            ++shapeIndex;
        }
        if (!configInvalid) {
            this.useDefault = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getShapeDefinition(int numOfShapes) {
        String[] shapeIdArray;
        Element[] shapeElementArray;
        Document shapeDefDoc = this.createShapeDefDoc();
        Utilities.assertion(shapeDefDoc != null);
        Element shapeGroup = shapeDefDoc.getDocumentElement();
        shapeGroup.setAttribute("id", "symbols");
        if (this.useDefault) {
            if (!this.defaultResources.isDefaultShapesInitialized()) {
                this.initShapes();
            }
            shapeElementArray = this.defaultResources.getDefaultShapeDefinitions();
            shapeIdArray = this.defaultResources.getDefaultShapeIds();
        } else {
            shapeElementArray = this.shapeDefinitions;
            shapeIdArray = this.shapeIds;
        }
        int numberOfShapeElementsAdded = 0;
        int i = 0;
        while (i < shapeElementArray.length) {
            if (this.dataSetShapes.containsValue(shapeIdArray[i])) {
                DefaultResources defaultResources = this.defaultResources;
                synchronized (defaultResources) {
                    shapeGroup.appendChild(shapeDefDoc.importNode(shapeElementArray[i], true));
                }
                ++numberOfShapeElementsAdded;
            }
            ++i;
        }
        int numOfShapesNeeded = numOfShapes - numberOfShapeElementsAdded;
        int numOfShapesLeft = shapeElementArray.length - numberOfShapeElementsAdded;
        int numOfDefs = numOfShapesNeeded < numOfShapesLeft ? numOfShapesNeeded : numOfShapesLeft;
        int shapeIndex = 0;
        numberOfShapeElementsAdded = 0;
        while (numberOfShapeElementsAdded < numOfDefs) {
            if (!this.dataSetShapes.containsValue(shapeIdArray[shapeIndex])) {
                if (this.useDefault) {
                    DefaultResources defaultResources = this.defaultResources;
                    synchronized (defaultResources) {
                        shapeGroup.appendChild(shapeDefDoc.importNode(shapeElementArray[shapeIndex], true));
                    }
                } else {
                    shapeGroup.appendChild(shapeDefDoc.importNode(shapeElementArray[shapeIndex], true));
                }
                ++numberOfShapeElementsAdded;
            }
            ++shapeIndex;
        }
        return shapeGroup;
    }

    public void setDataSetShapes(List shapeList) {
        for (Shape dataSetShape : shapeList) {
            try {
                DataSet dataSet = (DataSet)dataSetShape.getDataSetId();
                String dataSetId = dataSet.getId();
                String shapeId = dataSetShape.getShapeId();
                this.dataSetShapes.put(dataSetId, shapeId);
            }
            catch (ClassCastException classCastException) {}
        }
    }

    public SVGShapeIterator getShapeIterator() {
        return new ShapeIterator();
    }

    public class ShapeIterator
    implements SVGShapeIterator {
        private int nextShapeIndex = 0;
        private double currentShapeWidth = 0.0;
        private double currentShapeHeight = 0.0;
        private String currentShapeId;

        public String getNextShapeId(String dataSetId) {
            double[] heights;
            double[] widths;
            String[] shapeIdArray;
            if (SVGShapes.this.useDefault) {
                if (!SVGShapes.this.defaultResources.isDefaultShapesInitialized()) {
                    SVGShapes.this.initShapes();
                }
                shapeIdArray = SVGShapes.this.defaultResources.getDefaultShapeIds();
                widths = SVGShapes.this.defaultResources.getDefaultShapeWidths();
                heights = SVGShapes.this.defaultResources.getDefaultShapeHeights();
            } else {
                shapeIdArray = SVGShapes.this.shapeIds;
                widths = SVGShapes.this.shapeWidths;
                heights = SVGShapes.this.shapeHeights;
            }
            String shapeId = (String)SVGShapes.this.dataSetShapes.get(dataSetId);
            if (shapeId == null) {
                int startIndex = this.nextShapeIndex;
                Utilities.assertion(shapeIdArray.length > 0);
                do {
                    this.nextShapeIndex %= shapeIdArray.length;
                    shapeId = shapeIdArray[this.nextShapeIndex];
                    if (!SVGShapes.this.dataSetShapes.containsValue(shapeId)) {
                        this.currentShapeId = shapeId;
                        this.currentShapeWidth = widths[this.nextShapeIndex % widths.length];
                        this.currentShapeHeight = heights[this.nextShapeIndex % heights.length];
                        ++this.nextShapeIndex;
                        break;
                    }
                    ++this.nextShapeIndex;
                } while (this.nextShapeIndex != startIndex);
            } else {
                this.currentShapeId = shapeId;
                int shapeIndex = 0;
                int i = 0;
                while (i < shapeIdArray.length) {
                    if (shapeIdArray[i].equals(shapeId)) {
                        shapeIndex = i;
                        break;
                    }
                    ++i;
                }
                this.currentShapeWidth = widths[shapeIndex];
                this.currentShapeHeight = heights[shapeIndex];
            }
            return shapeId;
        }

        public double getShapeWidth() {
            return this.currentShapeWidth;
        }

        public double getShapeHeight() {
            return this.currentShapeHeight;
        }
    }
}

