/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.DefaultErrorHandler;
import org.apache.batik.transcoder.ErrorHandler;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.svg2svg.SVGTranscoder;
import org.apache.batik.util.XMLResourceDescriptor;
import org.apache.fop.svg.PDFTranscoder;
import org.w3c.dom.Document;

public class SVGTranscode {
    public static void transcode2JPEG(File svgFile, OutputStream ostream) throws IOException, TranscoderException {
        FileReader r = new FileReader(svgFile);
        SVGTranscode.transcode2JPEG(r, ostream);
    }

    public static void transcode2JPEG(String svg, OutputStream ostream) throws IOException, TranscoderException {
        StringReader r = new StringReader(svg);
        SVGTranscode.transcode2JPEG(r, ostream);
    }

    public static void transcode2JPEG(Document document, OutputStream ostream) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(document);
        TranscoderOutput tcout = new TranscoderOutput(ostream);
        SVGTranscode.transcode2JPEG(tcin, tcout);
        try {
            ostream.flush();
        }
        catch (IOException iOException) {}
    }

    public static void transcode2JPEG(InputStream istream, OutputStream ostream) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(istream);
        TranscoderOutput tcout = new TranscoderOutput(ostream);
        SVGTranscode.transcode2JPEG(tcin, tcout);
        try {
            ostream.flush();
        }
        catch (IOException iOException) {}
    }

    public static void transcode2JPEG(Reader reader, OutputStream ostream) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(reader);
        TranscoderOutput tcout = new TranscoderOutput(ostream);
        SVGTranscode.transcode2JPEG(tcin, tcout);
        try {
            ostream.flush();
        }
        catch (IOException iOException) {}
    }

    public static void transcode2JPEG(TranscoderInput tcin, TranscoderOutput tcout) throws TranscoderException {
        JPEGTranscoder t = new JPEGTranscoder();
        t.addTranscodingHint(JPEGTranscoder.KEY_QUALITY, (Object)new Float(0.8));
        t.setErrorHandler((ErrorHandler)new DefaultErrorHandler(){

            public void error(TranscoderException te) {
            }

            public void warning(TranscoderException te) {
            }
        });
        t.transcode(tcin, tcout);
    }

    public static void transcode2PNG(File svgFile, OutputStream ostream) throws IOException, TranscoderException {
        FileReader r = new FileReader(svgFile);
        SVGTranscode.transcode2PNG(r, ostream);
    }

    public static void transcode2PNG(String svg, OutputStream ostream) throws IOException, TranscoderException {
        StringReader r = new StringReader(svg);
        SVGTranscode.transcode2PNG(r, ostream);
    }

    public static void transcode2PNG(Document document, OutputStream ostream) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(document);
        TranscoderOutput tcout = new TranscoderOutput(ostream);
        SVGTranscode.transcode2PNG(tcin, tcout);
        try {
            ostream.flush();
        }
        catch (IOException iOException) {}
    }

    public static void transcode2PNG(InputStream istream, OutputStream ostream) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(istream);
        TranscoderOutput tcout = new TranscoderOutput(ostream);
        SVGTranscode.transcode2PNG(tcin, tcout);
        try {
            ostream.flush();
        }
        catch (IOException iOException) {}
    }

    public static void transcode2PNG(Reader reader, OutputStream ostream) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(reader);
        TranscoderOutput tcout = new TranscoderOutput(ostream);
        SVGTranscode.transcode2PNG(tcin, tcout);
        try {
            ostream.flush();
        }
        catch (IOException iOException) {}
    }

    public static void transcode2PNG(TranscoderInput tcin, TranscoderOutput tcout) throws TranscoderException {
        PNGTranscoder t = new PNGTranscoder();
        t.setErrorHandler((ErrorHandler)new DefaultErrorHandler(){

            public void error(TranscoderException te) {
            }

            public void warning(TranscoderException te) {
            }
        });
        t.transcode(tcin, tcout);
    }

    public static void transcode2PDF(String svg, OutputStream ostream) throws IOException, TranscoderException {
        StringReader r = new StringReader(svg);
        SVGTranscode.transcode2PDF(r, ostream);
    }

    public static void transcode2PDF(Document document, OutputStream ostream) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(document);
        TranscoderOutput tcout = new TranscoderOutput(ostream);
        SVGTranscode.transcode2PDF(tcin, tcout);
        try {
            ostream.flush();
        }
        catch (IOException iOException) {}
    }

    public static void transcode2PDF(InputStream istream, OutputStream ostream) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(istream);
        TranscoderOutput tcout = new TranscoderOutput(ostream);
        SVGTranscode.transcode2PDF(tcin, tcout);
        try {
            ostream.flush();
        }
        catch (IOException iOException) {}
    }

    public static void transcode2PDF(Reader reader, OutputStream ostream) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(reader);
        TranscoderOutput tcout = new TranscoderOutput(ostream);
        SVGTranscode.transcode2PDF(tcin, tcout);
        try {
            ostream.flush();
        }
        catch (IOException iOException) {}
    }

    public static void transcode2PDF(TranscoderInput tcin, TranscoderOutput tcout) throws TranscoderException {
        PDFTranscoder t = new PDFTranscoder();
        t.setErrorHandler((ErrorHandler)new DefaultErrorHandler(){

            public void error(TranscoderException te) {
                te.printStackTrace();
            }

            public void warning(TranscoderException te) {
                te.printStackTrace();
            }
        });
        t.transcode(tcin, tcout);
    }

    public static void prettyPrintSVG(InputStream istream, OutputStream ostream) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(istream);
        TranscoderOutput tcout = new TranscoderOutput(ostream);
        SVGTranscode.prettyPrintSVG(tcin, tcout);
        try {
            ostream.flush();
        }
        catch (IOException iOException) {}
    }

    public static void prettyPrintSVG(Reader rdr, Writer writer) throws TranscoderException {
        TranscoderInput tcin = new TranscoderInput(rdr);
        TranscoderOutput tcout = new TranscoderOutput(writer);
        SVGTranscode.prettyPrintSVG(tcin, tcout);
        try {
            writer.flush();
        }
        catch (IOException iOException) {}
    }

    public static void prettyPrintSVG(TranscoderInput tcin, TranscoderOutput tcout) throws TranscoderException {
        SVGTranscoder t = new SVGTranscoder();
        TranscodingHints hints = new TranscodingHints();
        hints.put((Object)SVGTranscoder.KEY_FORMAT, (Object)SVGTranscoder.VALUE_FORMAT_ON);
        t.setTranscodingHints(hints);
        t.setErrorHandler((ErrorHandler)new DefaultErrorHandler(){

            public void error(TranscoderException te) {
            }

            public void warning(TranscoderException te) {
            }
        });
        t.transcode(tcin, tcout);
    }

    public static String prettyPrintSVG(String svgInput) throws TranscoderException {
        StringReader rdr = new StringReader(svgInput);
        StringWriter writer = new StringWriter();
        SVGTranscode.prettyPrintSVG(rdr, writer);
        writer.flush();
        return writer.toString();
    }

    public static Document createSVGDocument(String uri) throws IOException {
        String parser = XMLResourceDescriptor.getXMLParserClassName();
        SAXSVGDocumentFactory df = new SAXSVGDocumentFactory(parser);
        Document doc = df.createDocument(uri);
        return doc;
    }
}

