/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.chart.svg.internal.util;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLoader {
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private Document dom = null;
    private Exception exception = null;
    protected boolean validate = false;
    protected String schemaLocation;

    public XMLLoader() {
    }

    public XMLLoader(String schemaLocation) {
        this.schemaLocation = schemaLocation;
    }

    public void setValidating(boolean validating) {
        this.validate = validating;
    }

    public boolean load(InputSource inputSource) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        if (this.validate) {
            factory.setAttribute(JAXP_SCHEMA_SOURCE, new File(this.schemaLocation));
        }
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.dom = builder.parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return false;
        }
        catch (SAXException sAXException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public Document getDOM() {
        return this.dom;
    }

    public Exception getException() {
        return this.exception;
    }

    class InputErrorHandler
    implements ErrorHandler {
        InputErrorHandler() {
        }

        public void warning(SAXParseException e) throws SAXException {
            XMLLoader.this.exception = e;
        }

        public void error(SAXParseException e) throws SAXException {
            XMLLoader.this.exception = e;
            throw e;
        }

        public void fatalError(SAXParseException e) throws SAXException {
            XMLLoader.this.exception = e;
            throw e;
        }
    }
}

