/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.internal;

import org.eclipse.tptp.platform.report.core.internal.DAbstractParagraph;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.IDItem;

public class DCell
extends DAbstractParagraph {
    public static final int DEFAULT_COLSPAN = 0;
    public static final int DEFAULT_ROWSPAN = 0;
    private int colSpan = 0;
    private int rowSpan = 0;

    public DCell(int cspan, int rspan, int align) {
        super(align);
        this.colSpan = cspan;
        this.rowSpan = rspan;
    }

    public DCell(int align) {
        super(align);
    }

    public DCell(int cspan, int rspan) {
        this.colSpan = cspan;
        this.rowSpan = rspan;
    }

    public DCell() {
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public void setColSpan(int aColSpan) {
        this.colSpan = aColSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public void setRowSpan(int aRowSpan) {
        this.rowSpan = aRowSpan;
    }

    public int getLineNumber() {
        DRow r = (DRow)this.getParent();
        if (r == null) {
            return -1;
        }
        DTable t = (DTable)r.getParent();
        if (t == null) {
            return -1;
        }
        int nbrow = 0;
        IDItem i = t.getFirstChild();
        while (i != r) {
            if (i instanceof DRow) {
                ++nbrow;
            }
            i = i.getNext();
        }
        return nbrow;
    }

    public int getColumnNumber() {
        IDItem p = this.getParent();
        if (p == null) {
            return -1;
        }
        if (p.getFirstChild() == null) {
            return -1;
        }
        int nbcell = 0;
        int nbcolspan = 0;
        IDItem i = p.getFirstChild();
        while (i != this) {
            if (i instanceof DCell) {
                DCell c = (DCell)i;
                ++nbcell;
                nbcolspan += c.getColSpan();
            }
            i = i.getNext();
        }
        return nbcell + nbcolspan;
    }
}

