/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.internal;

import org.eclipse.tptp.platform.report.core.internal.IDFont;

public class DFont
implements IDFont {
    private String family = null;
    private String script = null;
    private int size = -1;
    private int style = 0;

    public static boolean IsStyle(int _style, int _mask) {
        return (_style & _mask) == _mask;
    }

    public static boolean HaveStyle(int _style, int _mask) {
        return (_style & _mask) != 0;
    }

    public DFont(String family, String script, int size, int style) {
        this.family = family;
        this.script = script;
        this.size = size;
        this.style = style;
    }

    public DFont() {
    }

    public DFont(IDFont font) {
        if (font != null) {
            this.family = font.getFamily();
            this.script = font.getScript();
            this.size = font.getSize();
            this.style = font.getStyle();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IDFont)) {
            return false;
        }
        IDFont ft = (IDFont)o;
        return ft.getStyle() == this.style && ft.getFamily() == this.family && ft.getScript() == this.script && ft.getSize() == this.size;
    }

    public boolean isStyle(int _style_mask) {
        return (this.style & _style_mask) == _style_mask;
    }

    public boolean haveStyle(int _style_mask) {
        return (this.style & _style_mask) != 0;
    }

    public String getFamily() {
        return this.family;
    }

    public String getScript() {
        return this.script;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public void addStyle(int _style_mask) {
        this.style |= _style_mask;
    }

    public void removeStyle(int _style_mask) {
        this.style &= ~_style_mask;
    }

    public void setStyle(int _style_mask) {
        this.style = _style_mask;
    }

    public void setFamily(String f) {
        this.family = f;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setStyle(String s) {
        int style = 0;
        String[] list = s.split("\\|");
        int i = 0;
        while (i < list.length) {
            String st = list[i];
            if (st.compareTo("BOLD") == 0) {
                style |= 1;
            }
            if (st.compareTo("DASHED") == 0) {
                style |= 0x10;
            }
            if (st.compareTo("ITALIC") == 0) {
                style |= 2;
            }
            if (st.compareTo("UNDERLINE") == 0) {
                style |= 4;
            }
            if (st.compareTo("OVERLINE") == 0) {
                style |= 8;
            }
            if (st.compareTo("STRIKE") == 0) {
                style |= 0x20;
            }
            ++i;
        }
        this.setStyle(style);
    }

    public String getStringStyle() {
        return DFont.GetStringStyle(this.style);
    }

    public static String GetStringStyle(int style) {
        int val = style;
        String s = "";
        if (DFont.HaveStyle(style, 1)) {
            s = String.valueOf(s) + "BOLD";
            if ((val ^= 1) != 0) {
                s = String.valueOf(s) + "|";
            }
        }
        if (DFont.HaveStyle(style, 2)) {
            s = String.valueOf(s) + "ITALIC";
            if ((val ^= 2) != 0) {
                s = String.valueOf(s) + "|";
            }
        }
        if (DFont.HaveStyle(style, 4)) {
            s = String.valueOf(s) + "UNDERLINE";
            if ((val ^= 4) != 0) {
                s = String.valueOf(s) + "|";
            }
        }
        if (DFont.HaveStyle(style, 8)) {
            s = String.valueOf(s) + "OVERLINE";
            if ((val ^= 8) != 0) {
                s = String.valueOf(s) + "|";
            }
        }
        if (DFont.HaveStyle(style, 16)) {
            s = String.valueOf(s) + "DASHED";
            if ((val ^= 0x10) != 0) {
                s = String.valueOf(s) + "|";
            }
        }
        if (DFont.HaveStyle(style, 32)) {
            s = String.valueOf(s) + "STRIKE";
            if ((val ^= 0x20) != 0) {
                s = String.valueOf(s) + "|";
            }
        }
        if (s == "") {
            s = String.valueOf(s) + "NORMAL";
        }
        return s;
    }

    public String getID() {
        return Integer.toString(this.hashCode(), 16);
    }
}

