/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.internal;

import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.core.internal.IDWallpaper;

public class DStyle
implements IDStyle {
    private String name = null;
    public static final int NUMBER = 1;
    public static final int ROMAN_NUMBER = 2;
    public static final String T_ROMAN_NUMBER = "T_LETTER.DStyle.core.jscrib";
    public static final int LETTER = 3;
    public static final String T_LETTER = "T_LETTER.DStyle.core.jscrib";
    public static final int NOTHING = 4;
    public static final String T_NOTHING = "T_NOTHING.DStyle.core.jscrib";
    public static final int GLYPH = 5;
    public static final String T_GLYPH = "T_GLYPH.DStyle.core.jscrib";
    private int numberingFormat = 0;
    private IDFont font;
    private IDColor foreColor;
    private IDColor backColor;
    private IDWallpaper wallpaper;

    public DStyle(String n, IDStyle s) {
        String string = this.name = n == null ? "unamed" : n;
        if (s != null) {
            this.font = s.getFont();
            this.foreColor = s.getForeColor();
            this.backColor = s.getBackColor();
            this.numberingFormat = s.getNumberingFormat();
        }
    }

    public DStyle(String n, IDFont f, IDColor fore, IDColor back) {
        this.name = n;
        this.font = f;
        this.foreColor = fore;
        this.backColor = back;
    }

    public DStyle() {
        this.name = "unamed";
    }

    public DStyle(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName == null ? "unamed" : aName;
    }

    public int getNumberingFormat() {
        return this.numberingFormat;
    }

    public void setNumberingFormat(int aNumberingFormat) {
        this.numberingFormat = aNumberingFormat;
    }

    public void setFont(IDFont f) {
        this.font = f;
    }

    public IDFont getFont() {
        return this.font;
    }

    public void setForeColor(IDColor c) {
        this.foreColor = c;
    }

    public void setBackColor(IDColor c) {
        this.backColor = c;
    }

    public IDColor getBackColor() {
        return this.backColor;
    }

    public boolean isValidNumberingFormat(int f) {
        return f == 5 || f == 3 || f == 4 || f == 1 || f == 2;
    }

    public IDColor getForeColor() {
        return this.foreColor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IDStyle)) {
            return false;
        }
        IDStyle s = (IDStyle)o;
        IDFont sfn = s.getFont();
        IDColor sfr = s.getForeColor();
        IDColor sbk = s.getBackColor();
        return (this.font == sfn || this.font != null && this.font.equals(sfn)) && (this.foreColor == sfr || this.foreColor != null && this.foreColor.equals(sfr)) && (this.backColor == sbk || this.backColor != null && this.backColor.equals(sbk)) && s.getNumberingFormat() == this.getNumberingFormat();
    }

    public String numberingFormatToString(int i) {
        switch (i) {
            case 5: {
                return "GLYPH";
            }
            case 3: {
                return "LETTER";
            }
            case 1: {
                return "NUMBER";
            }
            case 2: {
                return "ROMAN_NUMBER";
            }
        }
        return "NOTHING";
    }

    public int stringToNumberingFormat(String s) {
        if (s == null) {
            return 4;
        }
        if (s.equalsIgnoreCase("GLYPH")) {
            return 5;
        }
        if (s.equalsIgnoreCase("LETTER")) {
            return 3;
        }
        if (s.equalsIgnoreCase("NUMBER")) {
            return 1;
        }
        if (s.equalsIgnoreCase("ROMAN_NUMBER")) {
            return 2;
        }
        return 4;
    }

    public IDWallpaper getWallpaper() {
        return this.wallpaper;
    }

    public void setWallpaper(IDWallpaper wallpaper) {
        this.wallpaper = wallpaper;
    }

    public String getID() {
        return Integer.toString(this.hashCode(), 16);
    }
}

