/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDItemIterator;
import org.eclipse.tptp.platform.report.core.internal.IDRegistry;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;

public class DStyleRegistry
implements IDRegistry {
    private ArrayList styles = new ArrayList();

    public void clear() {
        this.styles.clear();
    }

    public IDStyle putStyle(IDStyle style) {
        if (style == null) {
            return null;
        }
        if (this.contains(style)) {
            return style;
        }
        if (this.styles.add(style)) {
            return style;
        }
        return null;
    }

    public void merge(DStyleRegistry r) {
        if (r == null) {
            return;
        }
        Iterator i = r.iterator();
        while (i.hasNext()) {
            Object s = i.next();
            if (!(s instanceof IDStyle)) continue;
            this.putStyle((IDStyle)s);
        }
    }

    public boolean contains(IDStyle style) {
        Iterator it = this.styles.iterator();
        while (it.hasNext()) {
            if (it.next() != style) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        return this.styles.listIterator();
    }

    public List getStyles(String _name) {
        ArrayList<IDStyle> list = new ArrayList<IDStyle>();
        for (IDStyle sty : this.styles) {
            if (sty.getName() != _name && (_name == null || !_name.equals(sty.getName()))) continue;
            list.add(sty);
        }
        return list;
    }

    public IDStyle getFirstStyle(String _name) {
        for (IDStyle sty : this.styles) {
            if (sty.getName() != _name && (_name == null || !_name.equals(sty.getName()))) continue;
            return sty;
        }
        return null;
    }

    public void merge(IDItem root) {
        IDItemIterator iter = root.getIterator();
        IDItem item = iter.getFirst();
        while (item != null) {
            IDStyle idstyle = item.getStyle();
            if (idstyle != null) {
                this.putStyle(idstyle);
            }
            item = iter.getNext();
        }
    }

    public boolean isEmpty() {
        return this.styles.isEmpty();
    }
}

