/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.internal;

import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.internal.IDWallpaper;

public class DWallpaper
implements IDWallpaper,
IDObject {
    public static int HCENTER = 1;
    public static int VCENTER = 2;
    public static int LEFT = 4;
    public static int RIGHT = 8;
    public static int HSCALE = 16;
    public static int TOP = 32;
    public static int BOTTOM = 64;
    public static int VSCALE = 128;
    public static int HREPEAT = 256;
    public static int VREPEAT = 512;
    public static int BORDER;
    public static int LAST;
    public static int CENTER;
    public static int SCALE;
    public static int REPEAT;
    public static int DEFAULT;
    private String image_name;
    private int effect;
    private static String[] name;

    static {
        LAST = BORDER = 1024;
        CENTER = HCENTER | VCENTER;
        SCALE = HSCALE | VSCALE;
        REPEAT = HREPEAT | VREPEAT;
        DEFAULT = CENTER;
        name = new String[]{"HCENTER", "VCENTER", "LEFT", "RIGHT", "HSCALE", "TOP", "BOTTOM", "VSCALE", "HREPEAT", "VREPEAT", "BORDER"};
    }

    public DWallpaper(String name) {
        this.image_name = name;
        this.effect = CENTER;
    }

    public DWallpaper(String name, int effect) {
        this.image_name = name;
        this.effect = effect;
    }

    public String getName() {
        return this.image_name;
    }

    public void setName(String name) {
        this.image_name = name;
    }

    public int getEffect() {
        return this.effect;
    }

    public void setEffect(int effect) {
        this.effect = effect;
    }

    public boolean isEffect(int mask) {
        return (this.effect & mask) == mask;
    }

    public boolean haveEffect(int mask) {
        return (this.effect & mask) != 0;
    }

    public static boolean IsEffect(int effect, int mask) {
        return (effect & mask) == mask;
    }

    public static boolean HaveEffect(int effect, int mask) {
        return (effect & mask) != 0;
    }

    public static String ToString(int effect) {
        String s = null;
        int e = 1;
        int bit = 0;
        while (e <= LAST) {
            if (DWallpaper.HaveEffect(effect, e)) {
                s = s != null ? String.valueOf(s) + "|" + name[bit] : name[bit];
            }
            e <<= 1;
            ++bit;
        }
        return s;
    }

    public static int ToEffect(String str) {
        if (str == null) {
            return DEFAULT;
        }
        String[] s = str.split("\\|");
        if (s == null || s.length == 0) {
            return DEFAULT;
        }
        int effect = 0;
        int i = 0;
        while (i < s.length) {
            String n = s[i];
            int bit = 0;
            while (bit < name.length) {
                if (n.equals(name[i])) {
                    effect |= 1 << bit;
                    break;
                }
                ++bit;
            }
            ++i;
        }
        return effect;
    }

    public String serializeToString() {
        String s = String.valueOf(Integer.toString(this.effect, 16)) + ":" + this.image_name;
        return s;
    }

    public void serializeFromString(String str) {
        this.effect = DEFAULT;
        this.image_name = null;
        if (str == null) {
            return;
        }
        int idx = str.indexOf(58);
        if (idx < 0) {
            return;
        }
        try {
            this.effect = Integer.parseInt(str.substring(0, idx), 16);
        }
        catch (NumberFormatException numberFormatException) {}
        this.image_name = str.substring(idx + 1);
    }
}

