/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.core.provisional;

import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.core.provisional.IBounds;
import org.eclipse.tptp.platform.report.core.provisional.IChart;
import org.eclipse.tptp.platform.report.core.provisional.IRenderer;
import org.eclipse.tptp.platform.report.core.provisional.IRuntimeContext;
import org.eclipse.tptp.platform.report.core.provisional.RendererException;

public final class Generator {
    private static Generator g = null;

    private Generator() {
    }

    public static final synchronized Generator instance() {
        if (g == null) {
            g = new Generator();
        }
        return g;
    }

    public final void run(IRenderer renderer, IChart model) throws RendererException {
        renderer.render(model);
    }

    public final void run(IRenderer renderer, IChart model, IRuntimeContext context) throws RendererException {
        this.run(renderer, model, context, null);
    }

    public final void run(IRenderer renderer, IChart model, IBounds bounds) throws RendererException {
        this.run(renderer, model, null, bounds);
    }

    public final void run(IRenderer renderer, IChart model, IRuntimeContext context, IBounds bounds) throws RendererException {
        DGraphic chart = null;
        if (model instanceof DDocument) {
            chart = (DGraphic)((DDocument)model).getChildOfClass(DGraphic.class);
        } else if (model instanceof DGraphic) {
            chart = (DGraphic)model;
        } else {
            throw new RendererException("The model object is not supported");
        }
        if (chart != null) {
            if (context != null) {
                DI18N i18N = null;
                i18N = (DI18N)chart.getChildOfClass(DI18N.class);
                if (i18N == null) {
                    i18N = new DI18N();
                    chart.addChild(i18N);
                }
                if (context.getLocale() != null) {
                    i18N.setCountry(context.getLocale().getCountry());
                    i18N.setLanguage(context.getLocale().getLanguage());
                }
                if (context.getTimeZone() != null) {
                    i18N.setTimeZone(context.getTimeZone().getID());
                }
                if (context.getResourceBundle() != null) {
                    i18N.setResourceBundle(context.getResourceBundle());
                }
            }
            if (bounds != null) {
                chart.getProperties().store("P_MAX_WIDTH.DGraphic.core.jscrib", bounds.getWidth());
                chart.getProperties().store("P_MAX_HEIGHT.DGraphic.core.jscrib", bounds.getHeight());
            }
        }
        renderer.render(model);
    }
}

