/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DWallpaper;
import org.eclipse.tptp.platform.report.drawutil.internal.Rect;
import org.eclipse.tptp.platform.report.igc.internal.IRect;

public class DrawUtil {
    public static final int MASK = 448;
    private static final int DistMax = 4;

    public static boolean isEmpty(String _s) {
        if (_s == null) {
            return true;
        }
        return _s.length() == 0;
    }

    public static Color lighter(Device _dev, Color _clr, float _k) {
        if (_k < 0.0f) {
            _k = 0.0f;
        } else if (_k > 1.0f) {
            _k = 1.0f;
        }
        int r = _clr.getRed();
        int g = _clr.getGreen();
        int b = _clr.getBlue();
        r = (int)((float)r + _k * (float)(255 - r));
        g = (int)((float)g + _k * (float)(255 - g));
        b = (int)((float)b + _k * (float)(255 - b));
        return new Color(_dev, r, g, b);
    }

    public static Color darker(Device _dev, Color _clr, float _k) {
        if (_k < 0.0f) {
            _k = 0.0f;
        } else if (_k > 1.0f) {
            _k = 1.0f;
        }
        int r = _clr.getRed();
        int g = _clr.getGreen();
        int b = _clr.getBlue();
        r = (int)((float)r - _k * (float)r);
        g = (int)((float)g - _k * (float)g);
        b = (int)((float)b - _k * (float)b);
        return new Color(_dev, r, g, b);
    }

    public static String truncateText(GC _gc, String _text, int _available_width, int _available_height, int _alignment) {
        if (DrawUtil.HaveAlignment(_alignment, 64)) {
            return DrawUtil.truncateTextV(_gc, _text, _available_height);
        }
        if (DrawUtil.HaveAlignment(_alignment, 128) || DrawUtil.HaveAlignment(_alignment, 256)) {
            return DrawUtil.truncateTextH(_gc, _text, _available_height);
        }
        return DrawUtil.truncateTextH(_gc, _text, _available_width);
    }

    public static String truncateTextH(GC _gc, String _text, int _available_width) {
        String txt = _text;
        if (_text == null) {
            return null;
        }
        if (_available_width <= 0) {
            return null;
        }
        Point ext = _gc.textExtent(_text);
        if (ext.x > _available_width) {
            while (ext.x > _available_width) {
                if (txt.length() == 0) {
                    return null;
                }
                txt = txt.substring(0, txt.length() - 1);
                ext = _gc.textExtent(String.valueOf(txt) + "...");
            }
            txt = String.valueOf(txt) + "...";
        }
        return txt;
    }

    public static String truncateTextV(GC _gc, String _text, int _available_height) {
        if (DrawUtil.isEmpty(_text)) {
            return null;
        }
        if (_available_height <= 0) {
            return null;
        }
        String txt = _text;
        Point ext = DrawUtil.verticalTextExtent(_gc, _text);
        if (ext.y > _available_height) {
            while (ext.y > _available_height) {
                if (txt.length() == 0) {
                    return null;
                }
                txt = txt.substring(0, txt.length() - 1);
                ext = DrawUtil.verticalTextExtent(_gc, txt);
            }
        }
        return txt;
    }

    public static Point verticalTextExtent(GC _gc, String _s) {
        Point ext = new Point(0, 0);
        if (DrawUtil.isEmpty(_s)) {
            return ext;
        }
        int hc = _gc.getFontMetrics().getHeight();
        int i = 0;
        while (i < _s.length()) {
            int w = _gc.textExtent((String)_s.substring((int)i, (int)(i + 1))).x;
            if (w > ext.x) {
                ext.x = w;
            }
            ext.y += hc;
            ++i;
        }
        return ext;
    }

    public static Point textExtent(GC _gc, String _s, int _style) {
        if (_s == null) {
            return new Point(0, 0);
        }
        if (DrawUtil.HaveAlignment(_style, 64)) {
            return DrawUtil.verticalTextExtent(_gc, _s);
        }
        if (DrawUtil.HaveAlignment(_style, 256)) {
            return DrawUtil.rotCW90TextExtent(_gc, _s);
        }
        if (DrawUtil.HaveAlignment(_style, 128)) {
            return DrawUtil.rotCCW90TextExtent(_gc, _s);
        }
        return _gc.textExtent(_s);
    }

    public static Point rotCW90TextExtent(GC _gc, String _s) {
        Point ext = _gc.textExtent(_s);
        int v = ext.x;
        ext.x = ext.y;
        ext.y = v;
        return ext;
    }

    public static Point rotCCW90TextExtent(GC _gc, String _s) {
        Point ext = _gc.textExtent(_s);
        int v = ext.x;
        ext.x = ext.y;
        ext.y = v;
        return ext;
    }

    public static final void drawText(GC _gc, Device _dev, IRect _r, int _align, String _txt, boolean _is_transparent, int _font_style) {
        DrawUtil.drawText(_gc, _dev, _r.getX(), _r.getY(), _r.getW(), _r.getH(), _align, _txt, _is_transparent, _font_style);
    }

    public static final void drawText(GC _gc, Device _dev, Rect _r, int _align, String _txt, int _font_style) {
        DrawUtil.drawText(_gc, _dev, _r.x(), _r.y(), _r.w(), _r.h(), _align, _txt, true, _font_style);
    }

    public static final void drawText(GC _gc, Device _dev, Rect _r, int _align, String _txt, boolean _is_transparent, int _font_style) {
        DrawUtil.drawText(_gc, _dev, _r.x(), _r.y(), _r.w(), _r.h(), _align, _txt, _is_transparent, _font_style);
    }

    public static boolean HaveAlignment(int _alignment, int _mask) {
        return (_alignment & _mask) == _mask;
    }

    public static final void drawText(GC _gc, Device _dev, int _x, int _y, int _w, int _h, int _align, String _txt, int _font_style) {
        DrawUtil.drawText(_gc, _dev, _x, _y, _w, _h, _align, _txt, true, _font_style);
    }

    public static void drawText(GC _gc, Device _dev, int _x, int _y, int _w, int _h, int _align, String _txt, boolean _is_transparent, int _font_style) {
        if (_txt == null) {
            return;
        }
        Point ext = DrawUtil.textExtent(_gc, _txt, _align);
        int x = _x;
        int y = _y;
        x = DrawUtil.HaveAlignment(_align, 1) ? _x : (DrawUtil.HaveAlignment(_align, 2) ? _x + _w - ext.x : _x + (_w - ext.x) / 2);
        y = DrawUtil.HaveAlignment(_align, 8) ? _y : (DrawUtil.HaveAlignment(_align, 16) ? _y + _h - ext.y : _y + (_h - ext.y) / 2);
        if (DrawUtil.HaveAlignment(_align, 64)) {
            int hc = _gc.getFontMetrics().getHeight();
            int xctr = _x + _w / 2;
            int i = 0;
            while (i < _txt.length()) {
                String c = _txt.substring(i, i + 1);
                int wc = _gc.textExtent((String)c).x;
                int cx = x;
                cx = DrawUtil.HaveAlignment(_align, 1) ? x : (DrawUtil.HaveAlignment(_align, 2) ? x + ext.x - wc : xctr - (wc >> 1));
                DrawUtil.drawText(_gc, _dev, cx, y, wc, hc, c, _is_transparent, _font_style);
                y += hc;
                ++i;
            }
        } else if (DrawUtil.HaveAlignment(_align, 128) || DrawUtil.HaveAlignment(_align, 256)) {
            Color back = _gc.getBackground();
            Color fore = _gc.getForeground();
            PaletteData pal = new PaletteData(0xFF0000, 65280, 255);
            ImageData data = new ImageData(ext.y, ext.x, 8, pal);
            Image img = new Image(_dev, data);
            GC imgc = new GC((Drawable)img);
            imgc.setFont(_gc.getFont());
            imgc.setForeground(fore);
            imgc.setBackground(back);
            imgc.fillRectangle(0, 0, ext.y, ext.x);
            DrawUtil.drawText(imgc, _dev, 0, 0, ext.y, ext.x, _txt, false, _font_style);
            ImageData sdata = img.getImageData();
            int h = sdata.height;
            int w = sdata.width;
            PaletteData spal = sdata.palette;
            ImageData ndata = new ImageData(h, w, sdata.depth, spal);
            PaletteData npal = ndata.palette;
            if (_is_transparent) {
                try {
                    ndata.transparentPixel = npal.getPixel(back.getRGB());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("[JScrib-DrawUtil] !!! TRANSP PIXEL NOT FOUND, CHOOSE 0");
                    ndata.transparentPixel = 0;
                }
            }
            if (DrawUtil.HaveAlignment(_align, 256)) {
                int nx = h - 1;
                int dy = 0;
                while (dy < h) {
                    int dx = 0;
                    while (dx < w) {
                        int pix = sdata.getPixel(dx, dy);
                        ndata.setPixel(nx, dx, pix);
                        ++dx;
                    }
                    --nx;
                    ++dy;
                }
            } else {
                int dy = 0;
                while (dy < h) {
                    int ny = w - 1;
                    int dx = 0;
                    while (dx < w) {
                        int pix = sdata.getPixel(dx, dy);
                        ndata.setPixel(dy, ny--, pix);
                        ++dx;
                    }
                    ++dy;
                }
            }
            Image rot = new Image(_dev, ndata);
            _gc.drawImage(rot, x, y);
            rot.dispose();
            imgc.dispose();
            img.dispose();
        } else {
            DrawUtil.drawText(_gc, _dev, x, y, ext.x, ext.y, _txt, _is_transparent, _font_style);
        }
    }

    private static void dumpPalette(PaletteData pal) {
        System.out.println("PaletteData isdirect=" + pal.isDirect);
        if (!pal.isDirect) {
            RGB[] c = pal.colors;
            int i = 0;
            while (i < c.length) {
                System.out.print(" c[" + i + "]=" + c[i]);
                ++i;
            }
            System.out.println("");
        }
    }

    private static void drawText(GC _gc, Device _dev, int _x, int _y, int _txtw, int _txth, String _txt, boolean _is_transparent, int _font_style) {
        _gc.drawText(_txt, _x, _y, _is_transparent);
        boolean bold = DFont.HaveStyle(_font_style, 1);
        if (DFont.HaveStyle(_font_style, 60)) {
            FontMetrics fm = _gc.getFontMetrics();
            int descent = fm.getDescent();
            int psize = fm.getHeight();
            int linesize = psize / 10;
            if (linesize == 0) {
                linesize = 1;
            }
            int linesize2 = linesize / 2;
            if (bold && (linesize += linesize2) == 1) {
                linesize = 2;
                linesize2 = 1;
            }
            int space = linesize2 + 2;
            int olw = _gc.getLineWidth();
            _gc.setLineWidth(linesize);
            int ly = _y + _txth - descent + space;
            if (DFont.HaveStyle(_font_style, 4)) {
                _gc.drawLine(_x, ly, _x + _txtw, ly);
            } else if (DFont.HaveStyle(_font_style, 16)) {
                int size = DrawUtil.convertDPIX(5, (Device)Display.getDefault(), _dev);
                int size2 = 2 * size;
                int xx = size * ((_x + _txtw) / size);
                int x = size * (int)Math.ceil(_x / size);
                if (x < _x) {
                    x += size2;
                }
                while (x < xx) {
                    _gc.drawLine(x, ly, x + size, ly);
                    x += size2;
                }
            }
            if (DFont.HaveStyle(_font_style, 8)) {
                ly = _y + linesize / 2;
                _gc.drawLine(_x, ly, _x + _txtw, ly);
            }
            if (DFont.HaveStyle(_font_style, 32)) {
                ly = _y + fm.getLeading() + fm.getAscent() / 2 + linesize2;
                _gc.drawLine(_x, ly, _x + _txtw, ly);
            }
            _gc.setLineWidth(olw);
        }
    }

    public static Image rotate90_NOT_TESTED(Image _source, boolean _clockwise) {
        ImageData src_data = _source.getImageData();
        int h = src_data.height;
        int w = src_data.width;
        ImageData ndata = new ImageData(h, w, src_data.depth, src_data.palette);
        ndata.transparentPixel = src_data.transparentPixel;
        System.out.println("ROT depth=" + src_data.depth + " pal=" + ndata.palette + " src_pal=" + src_data.palette);
        if (_clockwise) {
            int nx = h - 1;
            int dy = 0;
            while (dy < h) {
                int dx = 0;
                while (dx < w) {
                    int pix = src_data.getPixel(dx, dy);
                    ndata.setPixel(nx, dx, pix);
                    ++dx;
                }
                --nx;
                ++dy;
            }
        } else {
            int dy = 0;
            while (dy < h) {
                int ny = w - 1;
                int dx = 0;
                while (dx < w) {
                    int pix = src_data.getPixel(dx, dy);
                    ndata.setPixel(dy, ny--, pix);
                    ++dx;
                }
                ++dy;
            }
        }
        Image dst = new Image(null, ndata);
        return dst;
    }

    public static final Rect boundingRect(GC _gc, Rect _r, int _align, String _txt) {
        return DrawUtil.boundingRect(_gc, _r.x(), _r.y(), _r.w(), _r.h(), _align, _txt);
    }

    public static Rect boundingRect(GC _gc, int _x, int _y, int _w, int _h, int _align, String _txt) {
        Point ext = DrawUtil.textExtent(_gc, _txt, _align);
        int x = _x;
        int y = _y;
        x = DrawUtil.HaveAlignment(_align, 1) ? _x : (DrawUtil.HaveAlignment(_align, 2) ? _x + _w - ext.x : _x + (_w - ext.x) / 2);
        y = DrawUtil.HaveAlignment(_align, 8) ? _y : (DrawUtil.HaveAlignment(_align, 16) ? _y + _h - ext.y : _y + (_h - ext.y) / 2);
        return new Rect(x, y, ext.x, ext.y);
    }

    public static boolean segmentContains(int _ax, int _ay, int _bx, int _by, int _px, int _py) {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        if (_ax == _bx) {
            return DrawUtil.near_segment_uv(_ay, _by, _ax, _py, _px, 4);
        }
        if (_ay == _by) {
            return DrawUtil.near_segment_uv(_ax, _bx, _ay, _px, _py, 4);
        }
        if (_ax < _bx) {
            xmin = _ax;
            xmax = _bx;
        } else {
            xmin = _bx;
            xmax = _ax;
        }
        if (_ay < _by) {
            ymin = _ay;
            ymax = _by;
        } else {
            ymin = _by;
            ymax = _ay;
        }
        if (_px < xmin - 4) {
            return false;
        }
        if (_px > xmax + 4) {
            return false;
        }
        if (_py < ymin - 4) {
            return false;
        }
        if (_py > ymax + 4) {
            return false;
        }
        int _bax = _bx - _ax;
        int _bay = _by - _ay;
        float n_ab = (float)Math.sqrt(_bax * _bax + _bay * _bay);
        float _1_n_ab = 1.0f / n_ab;
        float u_ab_x = (float)_bax * _1_n_ab;
        float u_ab_y = (float)_bay * _1_n_ab;
        float v_ab_x = -u_ab_y;
        float v_ab_y = u_ab_x;
        float kx = _bax;
        float lx = v_ab_x;
        float cx = _ax - _px;
        float ky = _bay;
        float ly = v_ab_y;
        float cy = _ay - _py;
        float a = ly * kx + ky * lx;
        float b = cx * ly + cy * lx;
        float k = -b / a;
        float x = k * (float)_bax + (float)_ax;
        float y = k * (float)_bay + (float)_ay;
        if (k < 0.0f) {
            return false;
        }
        if (k > 1.0f) {
            return false;
        }
        float v1 = (float)_px - x;
        float v2 = (float)_py - y;
        float dist = (float)Math.sqrt(v1 * v1 + v2 * v2);
        return dist <= 4.0f && k >= 0.0f && k <= 1.0f;
    }

    protected static boolean near_segment_uv(int _su1, int _su2, int _sv, int _pu, int _pv, int _DistMax) {
        int umax;
        int umin;
        if (_su1 < _su2) {
            umin = _su1;
            umax = _su2;
        } else {
            umin = _su2;
            umax = _su1;
        }
        if (_pu < umin) {
            if (_pu < umin - _DistMax) {
                return false;
            }
            if (_pv < _sv - _DistMax) {
                return false;
            }
            if (_pv > _sv + _DistMax) {
                return false;
            }
            int v1 = _pu - umin;
            int v2 = _pv - _sv;
            float dist = (float)Math.sqrt(v1 * v1 + v2 * v2);
            return dist <= (float)_DistMax;
        }
        if (_pu > umax) {
            if (_pu > umax + _DistMax) {
                return false;
            }
            if (_pv < _sv - _DistMax) {
                return false;
            }
            if (_pv > _sv + _DistMax) {
                return false;
            }
            int v1 = _pu - umax;
            int v2 = _pv - _sv;
            float dist = (float)Math.sqrt(v1 * v1 + v2 * v2);
            return dist <= (float)_DistMax;
        }
        int dist = _pv - _sv;
        if (dist < 0) {
            dist = -dist;
        }
        return dist <= _DistMax;
    }

    public static boolean polygonContains(int[] poly, int px, int py) {
        if (poly == null) {
            return false;
        }
        if (poly.length < 6) {
            return false;
        }
        int length = poly.length;
        if ((length & 1) != 0) {
            --length;
        }
        int last_ip = length - 2;
        int lx = poly[last_ip];
        int ly = poly[last_ip + 1];
        int segment_count = 0;
        int i = 0;
        while (i < length) {
            int yxx;
            int xx;
            int yxn;
            int xn;
            int x = poly[i++];
            int y = poly[i++];
            if (lx < x) {
                xn = lx;
                yxn = ly;
                xx = x;
                yxx = y;
            } else {
                xn = x;
                yxn = y;
                xx = lx;
                yxx = ly;
            }
            if (px >= xn && px <= xx && py >= (y < ly ? y : ly)) {
                if (xn == xx) {
                    return py <= (y < ly ? ly : y);
                }
                float sy = yxn + (px - xn) * (yxx - yxn) / (xx - xn);
                if (sy == (float)py) {
                    return true;
                }
                if (sy < (float)py) {
                    ++segment_count;
                }
            }
            lx = x;
            ly = y;
        }
        return segment_count & true;
    }

    public static boolean ovalContains(int _x, int _y, int _w, int _h, int px, int py) {
        float ya;
        int ry;
        if (!Rect.Contains(_x, _y, _w, _h, px, py)) {
            return false;
        }
        int cx = _x + _w / 2;
        int cy = _y + _h / 2;
        int dx = px - cx;
        int dy = py - cy;
        float rp = (float)Math.sqrt(dx * dx + dy * dy);
        int rx = Math.abs(_w / 2);
        if (rx == (ry = Math.abs(_h / 2))) {
            return rp <= (float)rx;
        }
        if (dy == 0) {
            return Math.abs(dx) <= rx;
        }
        if (dx == 0) {
            return Math.abs(dy) <= ry;
        }
        float a = (float)Math.atan2(dy, dx);
        float xa = (float)((double)rx * Math.cos(a));
        float ra = (float)Math.sqrt(xa * xa + (ya = (float)((double)ry * Math.sin(a))) * ya);
        return rp <= ra;
    }

    public static boolean ovalUnder(int _x, int _y, int _w, int _h, int px, int py) {
        float ya;
        int ry;
        if (!Rect.Contains(_x, _y, _w, _h, px, py)) {
            return false;
        }
        int cx = _x + _w / 2;
        int cy = _y + _h / 2;
        int dx = px - cx;
        int dy = py - cy;
        float rp = (float)Math.sqrt(dx * dx + dy * dy);
        int rx = Math.abs(_w / 2);
        if (rx == (ry = Math.abs(_h / 2))) {
            boolean r = (float)(rx - 2) <= rp && rp <= (float)(rx + 2);
            return r;
        }
        if (dy == 0) {
            return Math.abs(dx) <= rx;
        }
        if (dx == 0) {
            return Math.abs(dy) <= ry;
        }
        float a = (float)Math.atan2(dy, dx);
        float xa = (float)((double)rx * Math.cos(a));
        float ra = (float)Math.sqrt(xa * xa + (ya = (float)((double)ry * Math.sin(a))) * ya);
        return ra - 2.0f <= rp && rp <= ra + 2.0f;
    }

    public static void convertDPISizeToDPISize(Point p, Device from, Device to) {
        if (from == to) {
            return;
        }
        p.x = p.x * to.getDPI().x / from.getDPI().x;
        p.y = p.y * to.getDPI().y / from.getDPI().y;
    }

    public static int convertDPIX(int x, Device from, Device to) {
        if (from == to) {
            return x;
        }
        return x * to.getDPI().x / from.getDPI().x;
    }

    public static int convertDPIY(int y, Device from, Device to) {
        if (from == to) {
            return y;
        }
        return y * to.getDPI().y / from.getDPI().y;
    }

    public static final void drawImage(GC gc, Device dev, Image image, Rect rect, float _scale, int effect) {
        DrawUtil.drawImage(gc, dev, image, rect.x(), rect.y(), rect.w(), rect.h(), _scale, effect);
    }

    public static void drawImage(GC _gc, Device _dev, Image _image, int _x, int _y, int _w, int _h, float _scale, int _effect) {
        int iy;
        int div;
        int ix;
        int add;
        if (_effect == 0 || _w <= 0 || _h <= 0) {
            return;
        }
        ImageData data = _image.getImageData();
        if (data == null) {
            return;
        }
        int devimgw = (int)((float)data.width * _scale);
        int devimgh = (int)((float)data.height * _scale);
        if (devimgw == 0 || devimgh == 0) {
            return;
        }
        Display disp = Display.getDefault();
        if (disp != _dev) {
            Point ddpi = _dev.getDPI();
            Point cdpi = disp.getDPI();
            devimgw = devimgw * ddpi.x / cdpi.x;
            devimgh = devimgh * ddpi.y / cdpi.y;
        }
        int iw = devimgw;
        int ih = devimgh;
        int icx = 1;
        int icy = 1;
        if (DWallpaper.HaveEffect(_effect, DWallpaper.BORDER)) {
            int ix2 = _x;
            icx = _w / devimgw;
            ix2 = _x;
            iw = _w / (icx == 0 ? 1 : icx);
            int iy2 = _y;
            icy = _h / devimgh;
            iy2 = _y;
            ih = _h / (icy == 0 ? 1 : icy);
            if (icx == 0 || icy == 0) {
                return;
            }
            Rectangle save = _gc.getClipping();
            _gc.setClipping(_x, _y, _w, _h);
            try {
                int iix = ix2;
                int ry = 0;
                while (ry < icy) {
                    ix2 = iix;
                    int rx = 0;
                    while (rx < icx) {
                        boolean border;
                        boolean bl = ry != 0 && !(rx == 0 | ry == icy - 1) && rx != icx - 1 ? false : (border = true);
                        if (border) {
                            _gc.drawImage(_image, 0, 0, data.width, data.height, ix2, iy2, iw, ih);
                        }
                        ix2 += iw;
                        ++rx;
                    }
                    iy2 += ih;
                    ++ry;
                }
            }
            finally {
                _gc.setClipping(save);
            }
            return;
        }
        if (DWallpaper.HaveEffect(_effect, DWallpaper.HREPEAT)) {
            add = _w % devimgw == 0 ? 0 : 1;
            icx = _w / devimgw + add;
            int tw = icx * devimgw;
            if (DWallpaper.HaveEffect(_effect, DWallpaper.LEFT)) {
                ix = _x;
            } else if (DWallpaper.HaveEffect(_effect, DWallpaper.RIGHT)) {
                ix = _x + _w - tw;
            } else if (DWallpaper.HaveEffect(_effect, DWallpaper.HSCALE)) {
                ix = _x;
                div = icx - add;
                iw = _w / (div == 0 ? 1 : div);
                icx -= add;
            } else {
                ix = _x + (_w - tw) / 2;
            }
        } else if (DWallpaper.HaveEffect(_effect, DWallpaper.HSCALE)) {
            ix = _x;
            iw = _w;
        } else {
            ix = DWallpaper.HaveEffect(_effect, DWallpaper.LEFT) ? _x : (DWallpaper.HaveEffect(_effect, DWallpaper.RIGHT) ? _x + _w - devimgw : _x + (_w - devimgw) / 2);
        }
        if (DWallpaper.HaveEffect(_effect, DWallpaper.VREPEAT)) {
            add = _h % devimgh == 0 ? 0 : 1;
            icy = _h / devimgh + add;
            int th = icy * devimgh;
            if (DWallpaper.HaveEffect(_effect, DWallpaper.TOP)) {
                iy = _y;
            } else if (DWallpaper.HaveEffect(_effect, DWallpaper.BOTTOM)) {
                iy = _y + _h - th;
            } else if (DWallpaper.HaveEffect(_effect, DWallpaper.VSCALE)) {
                iy = _y;
                div = icy - add;
                ih = _h / (div == 0 ? 1 : div);
                icy -= add;
            } else {
                iy = _y + (_h - th) / 2;
            }
        } else if (DWallpaper.HaveEffect(_effect, DWallpaper.VSCALE)) {
            iy = _y;
            ih = _h;
        } else {
            iy = DWallpaper.HaveEffect(_effect, DWallpaper.TOP) ? _y : (DWallpaper.HaveEffect(_effect, DWallpaper.BOTTOM) ? _y + _h - devimgh : _y + (_h - devimgh) / 2);
        }
        if (iw < 0 || ih < 0) {
            return;
        }
        Rectangle save = _gc.getClipping();
        _gc.setClipping(_x, _y, _w, _h);
        try {
            int iix = ix;
            int ry = 0;
            while (ry < icy) {
                ix = iix;
                int rx = 0;
                while (rx < icx) {
                    _gc.drawImage(_image, 0, 0, data.width, data.height, ix, iy, iw, ih);
                    ix += iw;
                    ++rx;
                }
                iy += ih;
                ++ry;
            }
        }
        finally {
            _gc.setClipping(save);
        }
    }
}

