/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

import com.ibm.icu.util.ULocale;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.DrawUtilIGC;
import org.eclipse.tptp.platform.report.igc.internal.IFont;
import org.eclipse.tptp.platform.report.igc.util.internal.Font;
import org.eclipse.tptp.platform.report.igc.util.internal.RGBA;

public class IGCDStyle {
    protected IFont font_;
    protected int fore_;
    protected int back_;

    public IGCDStyle() {
        this.styleOf(null, 1.0f);
    }

    public IGCDStyle(float font_scale) {
        this.styleOf(null, font_scale);
    }

    public IGCDStyle(IDItem _item) {
        this.styleOf(_item, 1.0f);
    }

    public IGCDStyle(IDItem _item, float font_scale) {
        this.styleOf(_item, font_scale);
    }

    public IFont getFont() {
        return this.font_;
    }

    public int getFore() {
        return this.fore_;
    }

    public int getBack() {
        return this.back_;
    }

    public static int GetDefaultFore() {
        return 255;
    }

    public static int GetDefaultBack() {
        return -1;
    }

    public static Font GetDefaultFont(float font_scale) {
        return new Font("", "", (int)(8.0f * font_scale), 0);
    }

    public void styleOf(IDItem _item, float font_scale) {
        IDStyle jscrib_style = null;
        IDFont jscrib_font = null;
        IDColor jscrib_color = null;
        int all = 0;
        this.font_ = null;
        this.fore_ = 0;
        this.back_ = 0;
        boolean have_fore = false;
        boolean have_back = false;
        boolean have_font = false;
        IDItem item = _item;
        while (item != null) {
            jscrib_style = item.getStyle();
            if (jscrib_style != null) {
                if (!have_font && (jscrib_font = jscrib_style.getFont()) != null) {
                    this.font_ = IGCDStyle.GetFont(jscrib_font, font_scale, null);
                    have_font = this.font_ != null;
                    ++all;
                }
                if (!have_fore && (jscrib_color = jscrib_style.getForeColor()) != null) {
                    this.fore_ = IGCDStyle.GetRGBA(jscrib_color);
                    have_fore = true;
                    ++all;
                }
                if (!have_back && (jscrib_color = jscrib_style.getBackColor()) != null) {
                    this.back_ = IGCDStyle.GetRGBA(jscrib_color);
                    have_back = true;
                    ++all;
                }
                if (have_font && have_back && have_fore) {
                    return;
                }
            }
            item = item.getParent();
        }
        if (!have_font) {
            this.font_ = IGCDStyle.GetDefaultFont(font_scale);
        }
        if (!have_fore) {
            this.fore_ = IGCDStyle.GetDefaultFore();
        }
        if (!have_back) {
            this.back_ = IGCDStyle.GetDefaultBack();
        }
    }

    public static Font GetFont(IDFont _jscrib_font, float _font_scale, Font _font) {
        if (_jscrib_font == null) {
            return _font;
        }
        int fstyle = 0;
        if (_jscrib_font.haveStyle(1)) {
            fstyle |= 1;
        }
        if (_jscrib_font.haveStyle(2)) {
            fstyle |= 2;
        }
        if (_jscrib_font.haveStyle(4)) {
            fstyle |= 0x10;
        }
        if (_jscrib_font.haveStyle(8)) {
            fstyle |= 0x20;
        }
        if (_jscrib_font.haveStyle(32)) {
            fstyle |= 0x80;
        }
        if (_jscrib_font.haveStyle(16)) {
            fstyle |= 0x40;
        }
        String ffamily = _jscrib_font.getFamily();
        String fscript = _jscrib_font.getScript();
        int fsize = _jscrib_font.getSize();
        if (DrawUtilIGC.isEmpty(ffamily)) {
            ffamily = "arial";
        }
        if (DrawUtilIGC.isEmpty(fscript)) {
            fscript = ULocale.getDefault().toString();
        }
        if (_font_scale != 1.0f) {
            fsize = (int)((float)fsize * _font_scale);
        }
        if (fsize <= 5) {
            fsize = 6;
        }
        if (_font != null) {
            _font.setFont(fscript, ffamily, fsize, fstyle);
        } else {
            _font = new Font(fscript, ffamily, fsize, fstyle);
        }
        return _font;
    }

    public static int getColorComponent(int jscrib_color_component) {
        if (jscrib_color_component > 255) {
            return 255;
        }
        if (jscrib_color_component < 0) {
            return 0;
        }
        return jscrib_color_component;
    }

    public static int GetRGBA(IDColor _jscrib_color) {
        if (_jscrib_color == null) {
            return 0;
        }
        return RGBA.Get(_jscrib_color.getRed(), _jscrib_color.getGreen(), _jscrib_color.getBlue());
    }

    public static int GetForeColor(IDItem _item) {
        IDStyle jscrib_style = null;
        IDColor jscrib_color = null;
        IDItem item = _item;
        while (item != null) {
            jscrib_style = item.getStyle();
            if (jscrib_style != null && (jscrib_color = jscrib_style.getForeColor()) != null) {
                return IGCDStyle.GetRGBA(jscrib_color);
            }
            item = item.getParent();
        }
        return IGCDStyle.GetDefaultFore();
    }

    public static int GetBackColor(IDItem _item) {
        IDStyle jscrib_style = null;
        IDColor jscrib_color = null;
        IDItem item = _item;
        while (item != null) {
            jscrib_style = item.getStyle();
            if (jscrib_style != null && (jscrib_color = jscrib_style.getBackColor()) != null) {
                return IGCDStyle.GetRGBA(jscrib_color);
            }
            item = item.getParent();
        }
        return IGCDStyle.GetDefaultBack();
    }

    public static Font GetFont(IDItem _item, float font_scale) {
        IDFont f = IGCDStyle.GetIDFont(_item);
        if (f != null) {
            return IGCDStyle.GetFont(f, font_scale, null);
        }
        return IGCDStyle.GetDefaultFont(font_scale);
    }

    public static IDFont GetIDFont(IDItem _item) {
        IDStyle jscrib_style = null;
        IDFont jscrib_font = null;
        IDItem item = _item;
        while (item != null) {
            jscrib_style = item.getStyle();
            if (jscrib_style != null && (jscrib_font = jscrib_style.getFont()) != null) {
                return jscrib_font;
            }
            item = item.getParent();
        }
        return null;
    }
}

