/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drawutil.internal;

public class Vector3D {
    protected double x_;
    protected double y_;
    protected double z_;
    protected double n_;

    public Vector3D() {
        this.n_ = 0.0;
        this.z_ = 0.0;
        this.y_ = 0.0;
        this.x_ = 0.0;
    }

    public Vector3D(double _x, double _y, double _z) {
        this.setVector(_x, _y, _z);
    }

    public Vector3D(Vector3D _v) {
        this.setVector(_v);
    }

    public double getX() {
        return this.x_;
    }

    public double getY() {
        return this.y_;
    }

    public double getZ() {
        return this.z_;
    }

    public double getNorm() {
        if (this.n_ < 0.0) {
            this.n_ = Math.sqrt(this.x_ * this.x_ + this.y_ * this.y_ + this.z_ * this.z_);
        }
        return this.n_;
    }

    public void setX(double _x) {
        this.x_ = _x;
        this.n_ = -1.0;
    }

    public void setY(double _y) {
        this.y_ = _y;
        this.n_ = -1.0;
    }

    public void setZ(double _z) {
        this.z_ = _z;
        this.n_ = -1.0;
    }

    public void setVector(double _x, double _y, double _z) {
        this.x_ = _x;
        this.y_ = _y;
        this.z_ = _z;
        this.n_ = -1.0;
    }

    public void setVector(Vector3D _v) {
        this.x_ = _v.x_;
        this.y_ = _v.y_;
        this.z_ = _v.z_;
        this.n_ = _v.n_;
    }

    public String toString() {
        String s = String.valueOf(super.toString()) + "[" + this.x_ + "," + this.y_ + "," + this.z_ + "]";
        return s;
    }

    public void normalize() {
        if (this.n_ < 0.0) {
            this.getNorm();
        }
        if (this.n_ != 1.0) {
            if (this.n_ != 0.0) {
                this.x_ /= this.n_;
                this.y_ /= this.n_;
                this.z_ /= this.n_;
            }
            this.n_ = 1.0;
        }
    }

    public static double Scalar(Vector3D v1, Vector3D v2) {
        return v1.x_ * v2.x_ + v1.y_ * v2.y_ + v1.z_ * v2.z_;
    }

    public void vectorialProduct(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.x_ = y1 * z2 - z1 * y2;
        this.y_ = -x1 * z2 + z1 * x2;
        this.z_ = x1 * y2 - y1 * x2;
        this.n_ = -1.0;
    }

    public void negative() {
        this.x_ = -this.x_;
        this.y_ = -this.y_;
        this.z_ = -this.z_;
    }
}

