/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.html;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.IDDocument;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.drivers.html.ConfParser;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriter;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriterException;
import org.eclipse.tptp.platform.report.drivers.html.IDGenerationPolicy;
import org.eclipse.tptp.platform.report.drivers.internal.HtmlFile;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.awt.internal.AWTGC;
import org.eclipse.tptp.platform.report.igc.awt.internal.AWTImage;
import org.eclipse.tptp.platform.report.igc.internal.IImage;
import org.eclipse.tptp.platform.report.igc.swt.internal.SWTImage;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;

public abstract class DAbstractDocumentPolicy
implements IDGenerationPolicy {
    private DHtmlWriter writer;
    private ConfParser confparser;
    private String fileExtension = "html";
    private String baseDirectory;
    private String imageDirectoryName = "images";
    private IDIImageProvider imageProvider;
    private IDDocument indexDocument;
    private HashMap _generatedImage = new HashMap();

    public DAbstractDocumentPolicy(DHtmlWriter wh, String basePath, IDIImageProvider imgp) {
        this.writer = wh;
        this.baseDirectory = basePath;
        this.imageProvider = imgp;
    }

    public DHtmlWriter getWriter() {
        return this.writer;
    }

    protected String writeInFile(IImage img) throws DHtmlWriterException {
        String image_name = "img" + img.hashCode() + ".jpeg";
        String image_filename = String.valueOf(this.getImageDirectoryPath()) + File.separatorChar + image_name;
        if (this._generatedImage.containsKey(img)) {
            return (String)this._generatedImage.get(img);
        }
        if (img instanceof SWTImage) {
            Image swtimg = ((SWTImage)img).getImage();
            ImageLoader loader = new ImageLoader();
            if (loader.data == null) {
                loader.data = new ImageData[1];
            }
            loader.data[0] = swtimg.getImageData();
            try {
                loader.save(image_filename, 4);
            }
            catch (SWTException _e) {
                throw new DHtmlWriterException("Error saving image:" + image_filename + ": " + (Object)((Object)_e));
            }
            catch (SWTError _r) {
                throw new DHtmlWriterException("Error saving image:" + image_filename + ": " + (Object)((Object)_r));
            }
            this._generatedImage.put(img, String.valueOf(this.getImageDirectoryName()) + File.separatorChar + image_name);
            return String.valueOf(this.getImageDirectoryName()) + File.separatorChar + image_name;
        }
        if (img instanceof AWTImage) {
            ((AWTImage)img).getImage();
            int w = img.getWidth();
            int h = img.getHeight();
            BufferedImage offscreen = new BufferedImage(w, h, 1);
            AWTGC awtgc = new AWTGC(offscreen.getGraphics());
            awtgc.drawImage(img, 0, 0);
            File file = new File(image_filename);
            try {
                ImageIO.write((RenderedImage)offscreen, "jpeg", file);
            }
            catch (IOException e) {
                throw new DHtmlWriterException("Error saving image:" + image_filename + ": " + e);
            }
            this._generatedImage.put(img, String.valueOf(this.getImageDirectoryName()) + File.separatorChar + image_name);
            return String.valueOf(this.getImageDirectoryName()) + File.separatorChar + image_name;
        }
        return null;
    }

    protected String copyImageFile(String img) throws DHtmlWriterException {
        File src = new File(img);
        String image_filename = String.valueOf(this.getImageDirectoryPath()) + File.separatorChar + src.getName();
        try {
            FileOutputStream fout = new FileOutputStream(image_filename);
            FileInputStream fin = new FileInputStream(img);
            byte[] b = new byte[1024];
            int nbread = 0;
            while ((nbread = fin.read(b)) != -1) {
                fout.write(b, 0, nbread);
            }
            fout.close();
            fin.close();
        }
        catch (IOException e) {
            throw new DHtmlWriterException("Error when copy image file:" + img + " to " + image_filename + ": " + e);
        }
        return String.valueOf(this.getImageDirectoryName()) + File.separatorChar + src.getName();
    }

    public String getImageUrl(DImage image) throws DHtmlWriterException {
        IImage img;
        if (this.getImageProvider() != null && (img = this.getImageProvider().getImage(image.getName())) != null) {
            return this.writeInFile(img);
        }
        if (image.getName().matches("http:")) {
            return image.getName();
        }
        File f = new File(image.getName());
        if (f.exists()) {
            return this.copyImageFile(image.getName());
        }
        if (this.getImageProvider() != null) {
            IImage img2 = this.getImageProvider().getBrokenImage();
            return this.writeInFile(img2);
        }
        return image.getName();
    }

    protected void writeInFile(DHtmlWriter writer, String docTitle, IDItem item, DExtensible ext, Object arg) throws DHtmlWriterException {
        writer.getConfparser().setVariableValue("DOCUMENT_TITLE", docTitle, item);
        writer.getConfparser().setVariableValue("HTML_BGCOLOR", "=\"#ffffff\"", item);
        writer.getTitleLevel().setMax(writer.getConfparser().getHtmlFile().getMaxTitleLevel() - 1);
        HtmlFile hf = writer.getConfparser().getHtmlFile();
        writer.htmlDump(hf.getBegin());
        writer.doChildrenItem(item, ext, arg);
        writer.htmlDump(hf.getEnd());
    }

    public void doMethod(DPopup item, DExtensible ext, Object arg) throws DHtmlWriterException {
        DHtmlWriter writer = (DHtmlWriter)ext;
        String filepath = String.valueOf(this.getBaseDirectoryPath()) + File.separatorChar + item.getTag() + "." + this.getFileExtension();
        OutputStream out = writer.getOutputStream();
        try {
            writer.setOutputStream(new FileOutputStream(filepath));
            this.writeInFile(writer, item.getTag(), item, ext, arg);
            writer.getOutputStream().close();
            writer.setOutputStream(out);
        }
        catch (FileNotFoundException e) {
            throw new DHtmlWriterException("Document Generation Error: unable to generate the file '" + filepath + "' (" + e.getMessage() + ")");
        }
        catch (IOException e) {
            throw new DHtmlWriterException(e.getMessage());
        }
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public void setBaseDirectoryPath(String dirname) {
        this.baseDirectory = dirname;
    }

    public String getBaseDirectoryPath() {
        return this.baseDirectory;
    }

    public String getImageDirectoryPath() {
        return String.valueOf(this.getBaseDirectoryPath()) + File.separatorChar + this.getImageDirectoryName();
    }

    public void start() {
        File f = new File(this.getBaseDirectoryPath());
        if (!f.exists()) {
            f.mkdir();
        }
        if (!(f = new File(this.getImageDirectoryPath())).exists()) {
            f.mkdir();
        }
    }

    public String getImageDirectoryName() {
        return this.imageDirectoryName;
    }

    public void setImageDirectoryName(String imageDirectoryName) {
        this.imageDirectoryName = imageDirectoryName;
    }

    public IDIImageProvider getImageProvider() {
        return this.imageProvider;
    }
}

