/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.html;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.drivers.html.ConfParser;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriter;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriterException;
import org.eclipse.tptp.platform.report.drivers.internal.Item;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.awt.internal.AWTGC;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.render.internal.DRenderRegistry;
import org.eclipse.tptp.platform.report.render.internal.IRender;
import org.eclipse.tptp.platform.report.render.internal.NullRenderMonitor;

public class DHtmlGraphicImageAWT {
    private void graphicDump(DGraphic graphic, float scale, DHtmlWriter driver) {
        int w;
        if (driver.getGenerationPolicy() == null) {
            return;
        }
        String path = String.valueOf(driver.getGenerationPolicy().getImageDirectoryPath()) + File.separatorChar;
        String image_filename = String.valueOf(path) + driver.getConfparser().getVariableValue("HTML_GRAPHIC_FILE_NAME");
        int h = w = 500;
        w = (int)((float)w * graphic.getWidthScale());
        h = (int)((float)h * graphic.getHeightScale());
        Rect rect = new Rect(0, 0, w, h);
        BufferedImage offscreen = new BufferedImage(w, h, 1);
        AWTGC awtgc = new AWTGC(offscreen.getGraphics());
        IRender render = DRenderRegistry.GetRender(graphic);
        render.draw(awtgc, rect, graphic, scale, driver.getGenerationPolicy().getImageProvider(), new NullRenderMonitor(), null);
        File file = new File(image_filename);
        try {
            ImageIO.write((RenderedImage)offscreen, "png", file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void doMethod(DGraphic item, DExtensible ext, Object arg) throws DHtmlWriterException {
        DHtmlWriter driver = (DHtmlWriter)ext;
        Item hitem = driver.getItem(item);
        driver.updateStyleVariables(item);
        ConfParser confparser = driver.getConfparser();
        String title = DefaultChartRenderData.getResourceString(item.getTitle(), (DI18N)item.getChildOfClass(DI18N.class));
        confparser.setVariableValue("GRAPHIC_TITLE", title, item);
        confparser.setVariableValue("GRAPHIC_WIDTH", Float.toString(item.getWidthScale()), item);
        confparser.setVariableValue("HTML_GRAPHIC_WIDTH", Integer.toString((int)(item.getWidthScale() * 100.0f)), item);
        confparser.setVariableValue("GRAPHIC_HEIGHT", Float.toString(item.getHeightScale()), item);
        confparser.setVariableValue("HTML_GRAPHIC_FILE_NAME", "img" + Integer.toHexString(item.hashCode()) + ".png", item);
        driver.htmlDump(hitem.getBegin());
        this.graphicDump(item, 1.0f, driver);
        driver.htmlDump(hitem.getEnd());
        confparser.unsetVariables(item);
    }
}

