/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.html;

import java.io.File;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.drivers.html.ConfParser;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriter;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriterException;
import org.eclipse.tptp.platform.report.drivers.internal.Item;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.render.internal.RenderableSnapShot;

public class DHtmlGraphicImageSWT {
    private void graphicDump(Device dev, DGraphic graphic, float scale, DHtmlWriter driver) {
        int w;
        if (driver.getGenerationPolicy() == null) {
            return;
        }
        String path = String.valueOf(driver.getGenerationPolicy().getImageDirectoryPath()) + File.separatorChar;
        String image_filename = String.valueOf(path) + driver.getConfparser().getVariableValue("HTML_GRAPHIC_FILE_NAME");
        int h = w = 500;
        w = (int)((float)w * graphic.getWidthScale());
        h = (int)((float)h * graphic.getHeightScale());
        Rect r = new Rect(0, 0, w, h);
        Image img = RenderableSnapShot.Process(dev, r, graphic, scale, driver.getGenerationPolicy().getImageProvider());
        ImageLoader loader = new ImageLoader();
        if (loader.data == null) {
            loader.data = new ImageData[1];
        }
        loader.data[0] = img.getImageData();
        try {
            loader.save(image_filename, 4);
        }
        catch (SWTException _e) {
            System.err.println("Error saving image:" + image_filename + ": " + (Object)((Object)_e));
        }
        catch (SWTError _r) {
            System.err.println("Error saving image:" + image_filename + ": " + (Object)((Object)_r));
        }
        img.dispose();
    }

    public void doMethod(DGraphic item, DExtensible ext, Object arg) throws DHtmlWriterException {
        DHtmlWriter driver = (DHtmlWriter)ext;
        Item hitem = driver.getItem(item);
        driver.updateStyleVariables(item);
        ConfParser confparser = driver.getConfparser();
        String title = DefaultChartRenderData.getResourceString(item.getTitle(), (DI18N)item.getChildOfClass(DI18N.class));
        confparser.setVariableValue("GRAPHIC_TITLE", title, item);
        confparser.setVariableValue("GRAPHIC_WIDTH", Float.toString(item.getWidthScale()), item);
        confparser.setVariableValue("HTML_GRAPHIC_WIDTH", Integer.toString((int)(item.getWidthScale() * 100.0f)), item);
        confparser.setVariableValue("GRAPHIC_HEIGHT", Float.toString(item.getHeightScale()), item);
        confparser.setVariableValue("HTML_GRAPHIC_FILE_NAME", "img" + Integer.toHexString(item.hashCode()) + ".jpeg", item);
        driver.htmlDump(hitem.getBegin());
        this.graphicDump((Device)Display.getDefault(), item, 1.0f, driver);
        driver.htmlDump(hitem.getEnd());
        confparser.unsetVariables(item);
    }
}

