/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.html;

import java.io.File;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.chart.svg.internal.SVGGenerator;
import org.eclipse.tptp.platform.report.chart.svg.internal.input.cim.SVGChartImpl;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.drivers.html.ConfParser;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriter;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriterException;
import org.eclipse.tptp.platform.report.drivers.internal.ConfSemanticException;
import org.eclipse.tptp.platform.report.drivers.internal.Item;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DHtmlGraphicSVG {
    private DHtmlWriter driver;
    private ConfParser confparser;
    private boolean initialized;

    public ConfParser getConfParser() {
        return this.confparser;
    }

    private void initConfParser(ConfParser parent) {
        if (this.initialized) {
            this.confparser.setParentConfParser(parent);
            return;
        }
        this.confparser = new ConfParser("dhtmlgraphicsvg.xml", parent){

            protected void checkItemChild(Item item, Node n) throws ConfSemanticException {
            }

            private void checkPropertyData(String value) throws ConfSemanticException {
            }

            private void checkPropertyCopyJarFile(String value) throws ConfSemanticException {
            }

            private void checkPropertyEncode(String value) throws ConfSemanticException {
            }
        };
        this.confparser.initVariable("HTML_APPLET_PARAM_NAME");
        this.confparser.initVariable("HTML_APPLET_PARAM_VALUE");
        if (!this.confparser.parse()) {
            System.err.println("Graphic Applet Html Configuration parsing failed");
            this.confparser = null;
            this.initialized = false;
            return;
        }
        this.initialized = true;
    }

    public void doMethod(DGraphic graphic, DExtensible ext, Object arg) throws DHtmlWriterException {
        this.driver = (DHtmlWriter)ext;
        DGraphic oldf = null;
        if (graphic.getFirstChild() instanceof DGraphic) {
            oldf = (DGraphic)graphic.getFirstChild();
            graphic.removeChild(oldf);
        }
        ConfParser parent_parser = this.driver.getConfparser();
        this.initConfParser(parent_parser);
        if (this.confparser == null) {
            return;
        }
        this.driver.setConfparser(this.confparser);
        Item hitem = this.driver.getItem(graphic);
        this.driver.updateStyleVariables(graphic);
        int width = (int)(500.0f * graphic.getWidthScale());
        int height = (int)(500.0f * graphic.getHeightScale());
        graphic.getProperties().get("P_MAX_WIDTH.DGraphic.core.jscrib", width);
        int min_w = graphic.getProperties().get("P_MIN_WIDTH.DGraphic.core.jscrib", width);
        graphic.getProperties().get("P_MAX_HEIGHT.DGraphic.core.jscrib", height);
        int min_h = graphic.getProperties().get("P_MIN_HEIGHT.DGraphic.core.jscrib", height);
        File f = new File(this.driver.getGenerationPolicy().getImageDirectoryPath());
        String name = "gph" + Integer.toHexString(graphic.hashCode()) + ".svg";
        this.confparser.setVariableValue("HTML_GRAPHIC_FILE_NAME", String.valueOf(f.getName()) + "/" + name, graphic);
        String filename = String.valueOf(this.driver.getGenerationPolicy().getImageDirectoryPath()) + "/" + name;
        String title = DefaultChartRenderData.getResourceString(graphic.getTitle(), (DI18N)graphic.getChildOfClass(DI18N.class));
        this.confparser.setVariableValue("GRAPHIC_TITLE", title, graphic);
        this.confparser.setVariableValue("GRAPHIC_WIDTH", Float.toString(graphic.getWidthScale()), graphic);
        this.confparser.setVariableValue("GRAPHIC_HEIGHT", Float.toString(graphic.getHeightScale()), graphic);
        this.confparser.setVariableValue("HTML_GRAPHIC_WIDTH", Integer.toString(min_w), graphic);
        this.confparser.setVariableValue("HTML_GRAPHIC_HEIGHT", Integer.toString(min_h), graphic);
        try {
            this.driver.htmlDump(hitem.getBegin());
            try {
                SVGGenerator generator = new SVGGenerator();
                SVGChartImpl input = new SVGChartImpl(graphic);
                input.getConfiguration().getSize().setHeight(min_h);
                input.getConfiguration().getSize().setWidth(min_w);
                Document svgoutput = generator.generateGraphicDocument(input);
                generator.serializeGeneratedDocumentToFile(svgoutput, filename);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Error reading: " + e);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.confparser.setParentConfParser(null);
        this.driver.setConfparser(parent_parser);
        if (oldf != null) {
            graphic.insertChild(oldf, null);
        }
    }
}

