/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.html;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DBorder;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DCurveLink;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DFolder;
import org.eclipse.tptp.platform.report.core.internal.DFolderModel;
import org.eclipse.tptp.platform.report.core.internal.DFooter;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DHeader;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.DIndex;
import org.eclipse.tptp.platform.report.core.internal.DIndexEntry;
import org.eclipse.tptp.platform.report.core.internal.DLine;
import org.eclipse.tptp.platform.report.core.internal.DLink;
import org.eclipse.tptp.platform.report.core.internal.DLinkUtil;
import org.eclipse.tptp.platform.report.core.internal.DList;
import org.eclipse.tptp.platform.report.core.internal.DPageBreak;
import org.eclipse.tptp.platform.report.core.internal.DPageCounter;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPointLink;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.DSummary;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.DTag;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.DTitle;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.IGCDStyle;
import org.eclipse.tptp.platform.report.drivers.html.ConfParser;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriterException;
import org.eclipse.tptp.platform.report.drivers.html.DOneDocumentPolicy;
import org.eclipse.tptp.platform.report.drivers.html.IDGenerationPolicy;
import org.eclipse.tptp.platform.report.drivers.internal.HtmlFile;
import org.eclipse.tptp.platform.report.drivers.internal.HtmlVariable;
import org.eclipse.tptp.platform.report.drivers.internal.IWriter;
import org.eclipse.tptp.platform.report.drivers.internal.Item;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.tools.internal.DParser;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;
import org.eclipse.tptp.platform.report.tools.internal.IDProgressMonitor;

public class DHtmlWriter
extends DParser
implements IWriter {
    public static final String GRAPHIC_APPLET = "org.eclipse.tptp.platform.report.drivers.html.DHtmlGraphicApplet";
    public static final String GRAPHIC_IMAGE_AWT = "org.eclipse.tptp.platform.report.drivers.html.DHtmlGraphicImageAWT";
    public static final String GRAPHIC_IMAGE_SWT = "org.eclipse.tptp.platform.report.drivers.html.DHtmlGraphicImageSWT";
    public static final String GRAPHIC_SVG = "org.eclipse.tptp.platform.report.drivers.html.DHtmlGraphicSVG";
    private ConfParser confparser;
    private PrintStream out;
    private String graphic_extension_classname_;
    private Object graphic_extension_instance_;
    private IDGenerationPolicy generationPolicy;
    private String title = "";
    private boolean verbose;
    private boolean html_header_generated;
    private LinkedList foot = new LinkedList();
    private IDProgressMonitor progressMonitor;
    private String basePath;
    private IDIImageProvider imageProvider;
    private static Item default_hitem = new Item();

    public DHtmlWriter() throws DHtmlWriterException {
        this.setConfparser(new ConfParser());
        if (!this.getConfparser().parse()) {
            this.setConfparser(null);
            throw new DHtmlWriterException("Html Configuration parsing failed");
        }
        this.setGraphicExtensionClass(GRAPHIC_APPLET);
        this.html_header_generated = true;
    }

    public boolean isHtmlHeaderGenerated() {
        return this.html_header_generated;
    }

    public void setHtmlHeaderGenerated(boolean b) {
        this.html_header_generated = b;
    }

    public String getGraphicExtensionClass() {
        return this.graphic_extension_classname_;
    }

    public IDGenerationPolicy getGenerationPolicy() {
        return this.generationPolicy;
    }

    public void setGraphicExtensionClass(String graphic_type) throws DHtmlWriterException {
        if (this.graphic_extension_classname_ != null && this.graphic_extension_classname_.equals(graphic_type)) {
            return;
        }
        if (this.graphic_extension_instance_ != null) {
            this.removeDoMethods(this.graphic_extension_instance_);
            this.graphic_extension_instance_ = null;
            this.graphic_extension_classname_ = null;
        }
        this.graphic_extension_classname_ = graphic_type;
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(this.graphic_extension_classname_);
            this.graphic_extension_instance_ = clazz.newInstance();
            this.installDoMethods(this.graphic_extension_instance_);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.isVerbose()) {
                throw new DHtmlWriterException("No Graphic to Html Translator loaded: Class not found '" + this.graphic_extension_classname_ + "'");
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    protected void setGenerationPolicy(IDGenerationPolicy policy) throws DHtmlWriterException {
        if (this.generationPolicy == policy) {
            return;
        }
        if (this.generationPolicy != null) {
            this.removeDoMethods(this.generationPolicy);
            this.generationPolicy = null;
        }
        this.generationPolicy = policy;
        this.installDoMethods(this.generationPolicy);
    }

    public void setConfparser(ConfParser confparser) {
        this.confparser = confparser;
    }

    public ConfParser getConfparser() {
        return this.confparser;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setOutputStream(OutputStream output) {
        this.out = new PrintStream(output);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void htmlConvertDump(String string) {
        if (string == null) {
            return;
        }
        int space_count = 0;
        try {
            int i = 0;
            while (i < string.length()) {
                char c = string.charAt(i);
                if (c == ' ') {
                    if (++space_count == 1) {
                        this.out.write(this.getConfparser().getConvertText().getFirstSpace().getBytes("UTF-8"));
                    } else {
                        this.out.write(this.getConfparser().getConvertText().getExtraSpace().getBytes("UTF-8"));
                    }
                } else if (c == '\n') {
                    this.out.println("<BR>");
                } else {
                    space_count = 0;
                    Character ch = new Character(c);
                    String repl = this.getConfparser().getConvertText().getReplace(ch);
                    String cstr = repl != null ? repl : ch.toString();
                    this.out.write(cstr.getBytes("UTF-8"));
                }
                ++i;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public void htmlDump(String string) {
        try {
            byte[] b = string.getBytes("UTF-8");
            int i = 0;
            while (i < b.length) {
                char c = (char)b[i];
                if (c == '\n') {
                    this.out.println();
                } else {
                    this.out.write(b[i]);
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void htmlDump(int value) {
        this.htmlDump(Integer.toString(value));
    }

    public void htmlDump(List list) {
        if (list == null) {
            return;
        }
        for (Object obj : list) {
            if (obj instanceof String) {
                this.htmlDump((String)obj);
                continue;
            }
            HtmlVariable var = (HtmlVariable)obj;
            String value = this.getConfparser().getVariableValue(var.getName());
            if ("#".equals(value)) {
                this.htmlDump("${" + var.getName() + "}");
                continue;
            }
            this.htmlDump(value != null ? value : var.getName());
        }
    }

    private void setTagVariable(String name, String tag, IDItem item) {
        this.getConfparser().setVariableValue(name, tag != null ? tag : "_" + item.hashCode(), item);
    }

    private String to2DigitsHexa(int color) {
        return String.valueOf(Integer.toHexString(color % 256 / 16)) + Integer.toHexString(color % 16);
    }

    private String getColorHexa(IDColor color, String default_value) {
        if (color == null) {
            return default_value;
        }
        String result = "#";
        result = String.valueOf(result) + this.to2DigitsHexa(color.getRed());
        result = String.valueOf(result) + this.to2DigitsHexa(color.getGreen());
        result = String.valueOf(result) + this.to2DigitsHexa(color.getBlue());
        return result;
    }

    private String getFontAttrsBegin(IDStyle style) {
        IDFont font = style.getFont();
        IDColor color = style.getForeColor();
        if (font == null && color == null) {
            return "";
        }
        String result = "";
        if (font != null) {
            if (font.haveStyle(1)) {
                result = String.valueOf(result) + "<B>";
            }
            if (font.haveStyle(20)) {
                result = String.valueOf(result) + "<U>";
            }
            if (font.haveStyle(2)) {
                result = String.valueOf(result) + "<I>";
            }
        }
        result = String.valueOf(result) + "<FONT COLOR=" + this.getColorHexa(color, "#000000");
        if (font != null) {
            if (font.getFamily() != null) {
                result = String.valueOf(result) + " FACE=\"" + font.getFamily() + "\"";
            }
            if (font.getSize() != -1) {
                int s = font.getSize() / 3;
                if (s < 1) {
                    s = 1;
                }
                if (s > 7) {
                    s = 7;
                }
                result = String.valueOf(result) + " SIZE=\"" + Integer.toString(s) + "\"";
            }
        }
        result = String.valueOf(result) + ">";
        if (font != null && this.getConfparser().isTTFont(font.getFamily())) {
            result = String.valueOf(result) + "<TT>";
        }
        return result;
    }

    private String getFontAttrsEnd(IDStyle style) {
        IDFont font = style.getFont();
        IDColor color = style.getForeColor();
        if (font == null && color == null) {
            return "";
        }
        String result = "";
        if (font != null && this.getConfparser().isTTFont(font.getFamily())) {
            result = String.valueOf(result) + "</TT>";
        }
        result = String.valueOf(result) + "</FONT>";
        if (font != null) {
            if (font.haveStyle(2)) {
                result = String.valueOf(result) + "</I>";
            }
            if (font.haveStyle(20)) {
                result = String.valueOf(result) + "</U>";
            }
            if (font.haveStyle(1)) {
                result = String.valueOf(result) + "</B>";
            }
        }
        return result;
    }

    public void updateStyleVariables(IDItem item) {
        if (item.getStyle() != null) {
            this.getConfparser().setVariableValue("HTML_FONT_ATTRS_BEGIN", this.getFontAttrsBegin(item.getStyle()), item);
            this.getConfparser().setVariableValue("HTML_FONT_ATTRS_END", this.getFontAttrsEnd(item.getStyle()), item);
            String fore_color = this.getColorHexa(item.getStyle().getForeColor(), "#000000");
            this.getConfparser().setVariableValue("HTML_COLOR", "=\"" + fore_color + "\"", item);
            this.getConfparser().setVariableValue("HTML_FORE_COLOR", fore_color, item);
            String back_color = this.getColorHexa(item.getStyle().getBackColor(), "#ffffff");
            this.getConfparser().setVariableValue("HTML_BGCOLOR", "=\"" + back_color + "\"", item);
            this.getConfparser().setVariableValue("HTML_BACK_COLOR", back_color, item);
        }
    }

    public Item getItem(IDItem item) throws DHtmlWriterException {
        Item hitem = this.getConfparser().getItem(item.getClass());
        if (hitem == null) {
            hitem = default_hitem;
            throw new DHtmlWriterException("No html parser found for " + item.getClass());
        }
        return hitem;
    }

    public void doChildrenItem(IDItem item, Item hitem, DExtensible ext, Object arg) {
        IDItem i = item.getFirstChild();
        while (i != null) {
            this.htmlDump(hitem.getBeginChild());
            this.invokeDoMethod(i, ext, arg);
            this.htmlDump(hitem.getEndChild());
            i = i.getNext();
        }
    }

    public void doMethod(DDocument item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        this.setTagVariable("DOCUMENT_TAG", item.getTag(), item);
        this.htmlDump(hitem.getBegin());
        this.doChildrenItem(item, hitem, ext, arg);
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DSection item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        this.setTagVariable("SECTION_TAG", item.getTag(), item);
        this.htmlDump(hitem.getBegin());
        this.doChildrenItem(item, hitem, ext, arg);
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DHeader item, DExtensible ext, Object arg) {
    }

    public void doMethod(DFooter item, DExtensible ext, Object arg) {
    }

    public void doMethod(DParagraph item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        if (item.getParent() instanceof DFolder || item.getParent() instanceof DList) {
            this.doChildrenItem(item, hitem, ext, arg);
        } else {
            this.updateStyleVariables(item);
            String sa = "LEFT";
            if (item.haveAlignment(4)) {
                sa = "CENTER";
            } else if (item.haveAlignment(2)) {
                sa = "RIGHT";
            }
            this.getConfparser().setVariableValue("PARAGRAPH_ALIGN", sa, item);
            this.htmlDump(hitem.getBegin());
            this.doChildrenItem(item, hitem, ext, arg);
            this.htmlDump(hitem.getEnd());
            this.getConfparser().unsetVariables(item);
        }
    }

    public void doMethod(DTag item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        this.setTagVariable("TAG_NAME", item.getTag(), item);
        this.htmlDump(hitem.getBegin());
        this.doChildrenItem(item, hitem, ext, arg);
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DText item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        this.htmlDump(hitem.getBegin());
        this.htmlConvertDump(item.getText());
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DImage item, DExtensible ext, Object arg) throws DHtmlWriterException {
        String urlimg = this.generationPolicy.getImageUrl(item);
        if (urlimg != null) {
            Item hitem = this.getItem(item);
            this.updateStyleVariables(item);
            this.getConfparser().setVariableValue("IMAGE_NAME", this.generationPolicy.getImageUrl(item), item);
            this.htmlDump(hitem.getBegin());
            this.htmlDump(hitem.getEnd());
            this.getConfparser().unsetVariables(item);
        }
    }

    public void doMethod(DList item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        if (item.getFormat() == 5) {
            this.getConfparser().setVariableValue("LIST_TYPE", "BULLETED", item);
            this.getConfparser().setVariableValue("HTML_LIST_TYPE", "UL", item);
        } else if (item.getFormat() == 1) {
            this.getConfparser().setVariableValue("LIST_TYPE", "NUMBERED", item);
            this.getConfparser().setVariableValue("HTML_LIST_TYPE", "OL", item);
        } else {
            this.getConfparser().setVariableValue("LIST_TYPE", "", item);
            this.getConfparser().setVariableValue("HTML_LIST_TYPE", "UL", item);
        }
        this.htmlDump(hitem.getBegin());
        this.doChildrenItem(item, hitem, ext, arg);
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DTable item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        float w = 0.0f;
        float[] wc = item.getColumnWidth();
        if (wc == null || wc.length < item.getColumnCount()) {
            w = item.getWidthScale();
        } else {
            int i = 0;
            while (i < wc.length) {
                w += wc[i];
                ++i;
            }
        }
        this.getConfparser().setVariableValue("TABLE_WIDTH", Float.toString(w), item);
        this.getConfparser().setVariableValue("HTML_TABLE_WIDTH", Integer.toString((int)(w * 100.0f)), item);
        this.getConfparser().setVariableValue("TABLE_BORDER", Integer.toString(item.getBorder()), item);
        this.getConfparser().setVariableValue("TABLE_COLUMNS", Integer.toString(item.getColumnCount()), item);
        this.getConfparser().setVariableValue("TABLE_ROWS", Integer.toString(item.getRowCount()), item);
        this.htmlDump(hitem.getBegin());
        this.doChildrenItem(item, hitem, ext, arg);
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DRow item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        this.getConfparser().setVariableValue("ROW_CELLS", Integer.toString(item.getCellCount()), item);
        this.htmlDump(hitem.getBegin());
        this.doChildrenItem(item, hitem, ext, arg);
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    private void setCellVariables(DCell item) {
        this.updateStyleVariables(item);
        this.getConfparser().setVariableValue("CELL_COLSPAN", Integer.toString(item.getColSpan()), item);
        this.getConfparser().setVariableValue("HTML_CELL_COLSPAN", Integer.toString(item.getColSpan() + 1), item);
        this.getConfparser().setVariableValue("CELL_ROWSPAN", Integer.toString(item.getRowSpan()), item);
        this.getConfparser().setVariableValue("HTML_CELL_ROWSPAN", Integer.toString(item.getRowSpan() + 1), item);
        this.getConfparser().setVariableValue("CELL_COL", Integer.toString(item.getColumnNumber()), item);
        this.getConfparser().setVariableValue("CELL_ROW", Integer.toString(item.getLineNumber()), item);
        DRow row = (DRow)item.getParent();
        if (row == null) {
            return;
        }
        DTable table = (DTable)row.getParent();
        if (table.getColumnWidth() != null && table.getColumnCount() > item.getColumnNumber()) {
            float w = table.getColumnWidth()[item.getColumnNumber()];
            this.getConfparser().setVariableValue("CELL_WIDTH", Float.toString(w), item);
            this.getConfparser().setVariableValue("HTML_CELL_WIDTH", Integer.toString((int)(w * 100.0f)), item);
        } else {
            this.getConfparser().setVariableValue("CELL_WIDTH", Float.toString(100 / table.getColumnCount()), item);
            this.getConfparser().setVariableValue("HTML_CELL_WIDTH", Integer.toString(100 / table.getColumnCount()), item);
        }
        String ha = "LEFT";
        if (item.haveAlignment(4)) {
            ha = "CENTER";
        } else if (item.haveAlignment(2)) {
            ha = "RIGHT";
        }
        this.getConfparser().setVariableValue("CELL_ALIGN", ha, item);
        String va = "MIDDLE";
        if (item.haveAlignment(8)) {
            va = "TOP";
        } else if (item.haveAlignment(16)) {
            va = "BOTTOM";
        }
        this.getConfparser().setVariableValue("CELL_VALIGN", va, item);
    }

    public void doMethod(DCell item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.setCellVariables(item);
        this.htmlDump(hitem.getBegin());
        this.doChildrenItem(item, hitem, ext, arg);
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DCellText item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.setCellVariables(item);
        this.htmlDump(hitem.getBegin());
        String text = item.getText();
        if (text.length() == 0 || text.equals(" ")) {
            text = "  ";
        }
        this.htmlConvertDump(text);
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DPopup item, DExtensible ext, Object arg) throws DHtmlWriterException {
        if (arg == null) {
            this.foot.add(item);
        } else {
            Item hitem = this.getItem(item);
            this.updateStyleVariables(item);
            this.setTagVariable("POPUP_TAG", item.getTag(), item);
            this.htmlDump(hitem.getBegin());
            this.doChildrenItem(item, hitem, ext, arg);
            this.htmlDump(hitem.getEnd());
            this.getConfparser().unsetVariables(item);
        }
    }

    public void doMethod(DLink item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        String url = this.generationPolicy.getLinkUrl(item);
        this.getConfparser().setVariableValue("HTML_LINK", url, item);
        this.getConfparser().setVariableValue("POPUP_LINK_METHOD", DLinkUtil.getMethod(item), item);
        String action = "";
        if (DLinkUtil.isPopupLink(item)) {
            action = "onclick=\"return popup(this,'')\"";
        }
        this.getConfparser().setVariableValue("LINK_ACTION", action, item);
        this.htmlDump(hitem.getBegin());
        this.doChildrenItem(item, hitem, ext, arg);
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DLine item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        this.getConfparser().setVariableValue("HTML_LINE_SIZE", Integer.toString(item.getSize()), item);
        this.htmlDump(hitem.getBegin());
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DPageBreak item, DExtensible ext, Object arg) {
    }

    public void doMethod(DPageCounter item, DExtensible ext, Object arg) {
    }

    public void doMethod(DSummary item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        this.htmlDump(hitem.getBegin());
        this.doChildrenItem(item, hitem, ext, arg);
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DTitle item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        this.setTagVariable("TITLE_TAG", item.getTag(), item);
        this.getTitleLevel().increase(item.getLevel());
        this.getConfparser().setVariableValue("TITLE_LEVEL", Integer.toString(this.getTitleLevel().getLevel()), item);
        this.getConfparser().setVariableValue("HTML_TITLE_LEVEL", Integer.toString(this.getTitleLevel().getLevel()), item);
        this.getConfparser().setVariableValue("TITLE_FULL_NUMBER", this.getTitleLevel().toFormatString(0), item);
        this.getConfparser().setVariableValue("TITLE_NUMBER", Integer.toString(this.getTitleLevel().getCurrentEntryNumber()), item);
        this.htmlDump(hitem.getBegin());
        this.doChildrenItem(item, hitem, ext, arg);
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DIndex item) {
    }

    public void doMethod(DIndexEntry item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        this.htmlDump(hitem.getBegin());
        this.doChildrenItem(item, hitem, ext, arg);
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DGraphic item, DExtensible ext, Object arg) throws DHtmlWriterException {
        Item hitem = this.getItem(item);
        this.updateStyleVariables(item);
        String title = DefaultChartRenderData.getResourceString(item.getTitle(), (DI18N)item.getChildOfClass(DI18N.class));
        this.getConfparser().setVariableValue("GRAPHIC_TITLE", title, item);
        this.getConfparser().setVariableValue("GRAPHIC_WIDTH", Float.toString(item.getWidthScale()), item);
        this.getConfparser().setVariableValue("HTML_GRAPHIC_WIDTH", Integer.toString((int)(item.getWidthScale() * 100.0f)), item);
        this.getConfparser().setVariableValue("GRAPHIC_HEIGHT", Float.toString(item.getHeightScale()), item);
        this.getConfparser().setVariableValue("HTML_GRAPHIC_FILE_NAME", "img" + Integer.toHexString(item.hashCode()), item);
        this.htmlDump(hitem.getBegin());
        this.htmlDump(hitem.getEnd());
        this.getConfparser().unsetVariables(item);
    }

    public void doMethod(DAxis item, DExtensible ext, Object arg) {
    }

    public void doMethod(DCurve item, DExtensible ext, Object arg) {
    }

    public void doMethod(DCurveLink item, DExtensible ext, Object arg) {
    }

    public void doMethod(DPoint item, DExtensible ext, Object arg) {
    }

    public void doMethod(DPointLink item, DExtensible ext, Object arg) {
    }

    public void write(OutputStream output, IDObject[] objects) throws DHtmlWriterException {
        if (this.getConfparser() == null) {
            throw new DHtmlWriterException("Html Configuration parsing failed");
        }
        this.out = new PrintStream(output);
        this.setGenerationPolicy(new DOneDocumentPolicy(this, this.getDirname(), this.getImageProvider()));
        this.generationPolicy.start();
        this.getConfparser().setVariableValue("DOCUMENT_TITLE", this.getTitle(), objects[0]);
        this.getConfparser().setVariableValue("HTML_BGCOLOR", "=\"#ffffff\"", objects[0]);
        this.getTitleLevel().setMax(this.getConfparser().getHtmlFile().getMaxTitleLevel() - 1);
        HtmlFile hf = this.getConfparser().getHtmlFile();
        if (this.html_header_generated) {
            this.htmlDump(hf.getBegin());
        }
        int i = 0;
        while (i < objects.length) {
            this.invokeDoMethod(objects[i], this, null);
            ++i;
        }
        Iterator it = this.foot.iterator();
        while (it.hasNext()) {
            this.htmlDump("<HR>");
            Object o = it.next();
            this.invokeDoMethod(o, this, o);
        }
        if (this.html_header_generated) {
            this.htmlDump(hf.getEnd());
        }
        this.out.close();
    }

    public void write(OutputStream output, IDObject object) throws DHtmlWriterException {
        if (this.getConfparser() == null) {
            throw new DHtmlWriterException("Html Configuration parsing failed");
        }
        this.out = new PrintStream(output);
        this.setGenerationPolicy(new DOneDocumentPolicy(this, this.getDirname(), this.getImageProvider()));
        this.generationPolicy.start();
        this.getConfparser().setVariableValue("DOCUMENT_TITLE", this.getTitle(), object);
        this.getConfparser().setVariableValue("HTML_BGCOLOR", "=\"#ffffff\"", object);
        this.getTitleLevel().setMax(this.getConfparser().getHtmlFile().getMaxTitleLevel() - 1);
        HtmlFile hf = this.getConfparser().getHtmlFile();
        if (this.html_header_generated) {
            this.htmlDump(hf.getBegin());
        }
        this.invokeDoMethod(object, this, null);
        Iterator it = this.foot.iterator();
        while (it.hasNext()) {
            this.htmlDump("<HR>");
            Object o = it.next();
            this.invokeDoMethod(o, this, o);
        }
        if (this.html_header_generated) {
            this.htmlDump(hf.getEnd());
        }
        this.out.close();
    }

    public void write(IDGenerationPolicy policy, IDObject[] objects) throws DHtmlWriterException {
        if (this.getConfparser() == null) {
            throw new DHtmlWriterException("Html Configuration parsing failed");
        }
        this.setGenerationPolicy(policy);
        policy.start();
        int i = 0;
        while (i < objects.length) {
            this.invokeDoMethod(objects[i], this, null);
            ++i;
        }
    }

    public void write(IDGenerationPolicy policy, IDObject object) throws DHtmlWriterException {
        if (this.getConfparser() == null) {
            throw new DHtmlWriterException("Html Configuration parsing failed");
        }
        this.setGenerationPolicy(policy);
        policy.start();
        this.invokeDoMethod(object, this, null);
    }

    public void clear() {
        super.clear();
    }

    public void doMethod(DFolder folder, DExtensible ext, Object arg) {
        DHtmlWriter w = (DHtmlWriter)ext;
        DFolderModel model = folder.getFolderModel();
        if (model == null) {
            model = DFolderModel.GetDefault();
        }
        if (model.isIndented()) {
            w.htmlDump("<UL>");
        }
        w.htmlDump("<LI>");
        IDItem item = folder.getFirstChild();
        if (item != null) {
            ext.invokeDoMethod(item, ext, arg);
            w.htmlDump("<BR>\n");
            item = item.getNext();
            while (item != null) {
                ext.invokeDoMethod(item, ext, arg);
                item = item.getNext();
            }
        }
        w.htmlDump("</LI>\n");
        if (model.isIndented()) {
            w.htmlDump("</UL>");
        }
    }

    public void doMethod(DBorder border, DExtensible ext, Object arg) {
        DHtmlWriter w = (DHtmlWriter)ext;
        if (border.getLineType() == 0) {
            ((DHtmlWriter)ext).doChildrenItem(border, ext, arg);
            return;
        }
        String sid = Integer.toString(border.hashCode(), 16);
        boolean border_contains_only_text_and_image = true;
        IDItem item = border.getFirstChild();
        while (item != null) {
            if (!(item instanceof DText) && !(item instanceof DImage)) {
                border_contains_only_text_and_image = false;
                break;
            }
            item = item.getNext();
        }
        int bc = IGCDStyle.GetForeColor(border);
        String sc = Integer.toString(bc >> 8, 16);
        while (sc.length() < 6) {
            sc = "0" + sc;
        }
        if (border_contains_only_text_and_image) {
            w.htmlDump("\n<STYLE type=\"text/css\"><!--");
            w.htmlDump(".styDBorder");
            w.htmlDump(sid);
            w.htmlDump(" {border: ");
            switch (border.getLineType()) {
                default: {
                    w.htmlDump(" solid 1px ");
                    break;
                }
                case 3: {
                    w.htmlDump(" solid 2px ");
                    break;
                }
                case 7: {
                    w.htmlDump(" solid 3px ");
                    break;
                }
                case 5: {
                    w.htmlDump(" double 3px ");
                    break;
                }
                case 11: 
                case 13: {
                    w.htmlDump(" double 5px ");
                    break;
                }
                case 21: {
                    w.htmlDump(" ridge 3px ");
                }
            }
            w.htmlDump("#");
            w.htmlDump(sc);
            w.htmlDump("}--></STYLE>\n");
            w.htmlDump("<FONT class=\"styDBorder");
            w.htmlDump(sid);
            w.htmlDump("\">");
            ((DHtmlWriter)ext).doChildrenItem(border, ext, arg);
            w.htmlDump("</FONT>");
        } else {
            int table_border = 0;
            int cell_padding = 0;
            switch (border.getLineType()) {
                default: {
                    table_border = 1;
                    break;
                }
                case 3: {
                    table_border = 2;
                    break;
                }
                case 7: {
                    table_border = 3;
                    break;
                }
                case 5: {
                    table_border = 1;
                    cell_padding = 1;
                    break;
                }
                case 11: 
                case 13: {
                    table_border = 2;
                    cell_padding = 1;
                    break;
                }
                case 21: {
                    table_border = 2;
                    cell_padding = 3;
                }
            }
            w.htmlDump("<TABLE BORDER=\"" + table_border + "\" cellpadding=\"" + cell_padding + "\" FGCOLOR=\"#");
            w.htmlDump(sc);
            w.htmlDump("\"><TR><TD>");
            ((DHtmlWriter)ext).doChildrenItem(border, ext, arg);
            w.htmlDump("</TD></TD></TABLE>");
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public IDProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public void setProgressMonitor(IDProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    public String getDirname() {
        return this.basePath;
    }

    public void setDirname(String basePath) {
        this.basePath = basePath;
    }

    public IDIImageProvider getImageProvider() {
        return this.imageProvider;
    }

    public void setImageProvider(IDIImageProvider imageProvider) {
        this.imageProvider = imageProvider;
    }

    public static void write(String html_filepath, IDObject[] docs, String graphic_extension, IDIImageProvider imgp) throws DHtmlWriterException {
        try {
            DHtmlWriter writer = new DHtmlWriter();
            writer.setGraphicExtensionClass(graphic_extension);
            File f = new File(html_filepath);
            DOneDocumentPolicy policy = new DOneDocumentPolicy(writer, f.getParent(), imgp);
            policy.setImageDirectoryName(String.valueOf(f.getName()) + "_files");
            writer.setOutputStream(new FileOutputStream(html_filepath));
            writer.write((IDGenerationPolicy)policy, docs);
        }
        catch (DHtmlWriterException e) {
            throw new DHtmlWriterException(String.valueOf(html_filepath) + "\n\nError When Generating HTML file:" + e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new DHtmlWriterException(String.valueOf(html_filepath) + "\n\nError When Generating HTML file:\n" + e.getMessage());
        }
    }
}

