/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.html;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DLinkUtil;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.IDDocument;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDLink;
import org.eclipse.tptp.platform.report.drivers.html.DAbstractDocumentPolicy;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriter;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriterException;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.tools.internal.DLinkResolver;
import org.eclipse.tptp.platform.report.tools.internal.IDIImageProvider;

public class DMultiDocumentPolicy
extends DAbstractDocumentPolicy {
    private IDDocument indexDocument;
    private IDDocument currentDoc;

    public DMultiDocumentPolicy(DHtmlWriter wh, String basePath, IDIImageProvider imgp) {
        super(wh, basePath, imgp);
    }

    public void doMethod(DDocument item, DExtensible ext, Object arg) throws DHtmlWriterException {
        DHtmlWriter writer = (DHtmlWriter)ext;
        if (this.getIndexDocument() == null) {
            this.setIndexDocument(item);
        }
        String filepath = String.valueOf(this.getBaseDirectoryPath()) + File.separatorChar + item.getTag() + "." + this.getFileExtension();
        try {
            this.currentDoc = item;
            writer.setOutputStream(new FileOutputStream(filepath));
            this.writeInFile(writer, item.getTitle(), item, ext, arg);
            writer.getOutputStream().close();
        }
        catch (FileNotFoundException e) {
            throw new DHtmlWriterException("Document Generation Error: unable to generate the file '" + filepath + "' (" + e.getMessage() + ")");
        }
        catch (IOException e) {
            throw new DHtmlWriterException(e.getMessage());
        }
    }

    public String getIndexFilePath() {
        return String.valueOf(this.getBaseDirectoryPath()) + File.separatorChar + this.getIndexDocument().getTag() + "." + this.getFileExtension();
    }

    public IDDocument getIndexDocument() {
        return this.indexDocument;
    }

    public void setIndexDocument(IDDocument indexDocument) {
        this.indexDocument = indexDocument;
    }

    public String getLinkUrl(IDLink link) throws DHtmlWriterException {
        if (DLinkUtil.isInternalLink(link)) {
            DLinkResolver r = new DLinkResolver(link);
            r.resolve(this.getWriter().getProgressMonitor());
            if (r.getTaggedItem() != null) {
                if (r.getTaggedItem() instanceof DPopup) {
                    return String.valueOf(r.getTaggedItem().getTag()) + "." + this.getFileExtension();
                }
                IDItem doc = r.getTaggedItem().getRoot();
                if (doc instanceof IDDocument) {
                    if (r.getTaggedItem().getRoot() == this.currentDoc) {
                        return "#" + r.getTaggedItem().getTag();
                    }
                    return String.valueOf(((IDDocument)doc).getTag()) + "." + this.getFileExtension() + "#" + r.getTaggedItem().getTag();
                }
            }
            System.err.println("Unable to resolve link for target '" + link.getTarget() + "'");
            return "";
        }
        File f = new File(link.getTarget());
        if (f.exists()) {
            return this.copyImageFile(link.getTarget());
        }
        return link.getTarget();
    }
}

