/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.internal;

import java.io.File;
import java.io.FileOutputStream;
import org.eclipse.tptp.platform.report.chart.internal.DefaultChartRenderData;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DI18N;
import org.eclipse.tptp.platform.report.drivers.html.ConfParser;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriter;
import org.eclipse.tptp.platform.report.drivers.html.DHtmlWriterException;
import org.eclipse.tptp.platform.report.drivers.internal.ConfSemanticException;
import org.eclipse.tptp.platform.report.drivers.internal.Item;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.igc.svg.internal.SVGGC;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.render.internal.DRenderRegistry;
import org.eclipse.tptp.platform.report.render.internal.IRender;
import org.eclipse.tptp.platform.report.render.internal.NullRenderMonitor;
import org.w3c.dom.Node;

public class DHtmlGraphicIGCSVG {
    private DHtmlWriter driver;
    private ConfParser confparser;
    private boolean initialized;

    public ConfParser getConfParser() {
        return this.confparser;
    }

    private void initConfParser(ConfParser parent) {
        if (this.initialized) {
            this.confparser.setParentConfParser(parent);
            return;
        }
        this.confparser = new ConfParser("dhtmlgraphicsvg.xml", parent){

            protected void checkItemChild(Item item, Node n) throws ConfSemanticException {
            }

            private void checkPropertyData(String value) throws ConfSemanticException {
            }

            private void checkPropertyCopyJarFile(String value) throws ConfSemanticException {
            }

            private void checkPropertyEncode(String value) throws ConfSemanticException {
            }
        };
        this.confparser.initVariable("HTML_APPLET_PARAM_NAME");
        this.confparser.initVariable("HTML_APPLET_PARAM_VALUE");
        if (!this.confparser.parse()) {
            System.err.println("Graphic Applet Html Configuration parsing failed");
            this.confparser = null;
            this.initialized = false;
            return;
        }
        this.initialized = true;
    }

    public void doMethod(DGraphic graphic, DExtensible ext, Object arg) throws DHtmlWriterException {
        this.driver = (DHtmlWriter)ext;
        ConfParser parent_parser = this.driver.getConfparser();
        this.initConfParser(parent_parser);
        if (this.confparser == null) {
            return;
        }
        this.driver.setConfparser(this.confparser);
        Item hitem = this.driver.getItem(graphic);
        this.driver.updateStyleVariables(graphic);
        int width = (int)(500.0f * graphic.getWidthScale());
        int height = (int)(500.0f * graphic.getHeightScale());
        File f = new File(this.driver.getGenerationPolicy().getImageDirectoryPath());
        String name = "gph" + Integer.toHexString(graphic.hashCode()) + ".svg";
        this.confparser.setVariableValue("HTML_GRAPHIC_FILE_NAME", String.valueOf(f.getName()) + "/" + name, graphic);
        String filename = String.valueOf(this.driver.getGenerationPolicy().getImageDirectoryPath()) + "/" + name;
        String title = DefaultChartRenderData.getResourceString(graphic.getTitle(), (DI18N)graphic.getChildOfClass(DI18N.class));
        this.confparser.setVariableValue("GRAPHIC_TITLE", title, graphic);
        this.confparser.setVariableValue("GRAPHIC_WIDTH", Float.toString(graphic.getWidthScale()), graphic);
        this.confparser.setVariableValue("GRAPHIC_HEIGHT", Float.toString(graphic.getHeightScale()), graphic);
        this.confparser.setVariableValue("HTML_GRAPHIC_WIDTH", Integer.toString(width), graphic);
        this.confparser.setVariableValue("HTML_GRAPHIC_HEIGHT", Integer.toString(height), graphic);
        try {
            this.driver.htmlDump(hitem.getBegin());
            FileOutputStream os = new FileOutputStream(filename);
            SVGGC gc = new SVGGC(os, width, height);
            IRender render = DRenderRegistry.GetRender(graphic);
            gc.begin();
            render.draw(gc, new Rect(0, 0, width, height), graphic, 1.0f, this.driver.getImageProvider(), new NullRenderMonitor(), null);
            gc.end();
            this.driver.htmlDump(hitem.getEnd());
            this.confparser.unsetVariables(graphic);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.confparser.setParentConfParser(null);
        this.driver.setConfparser(parent_parser);
    }
}

