/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.internal;

import java.util.List;
import org.eclipse.tptp.platform.report.drivers.html.ConfParser;
import org.eclipse.tptp.platform.report.drivers.internal.ConfSemanticException;

public class Item {
    private Class item_class;
    private List begin;
    private List end;
    private List begin_child;
    private List end_child;

    public Item() {
    }

    public Item(String sclass, List s_begin, List s_end, List s_begin_child, List s_end_child) throws ConfSemanticException {
        try {
            this.item_class = this.getClass().getClassLoader().loadClass(sclass);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfSemanticException("cannot load class \"" + sclass + "\" declared as 'class' attribute of 'item' tag");
        }
        this.begin = s_begin;
        this.end = s_end;
        this.begin_child = s_begin_child;
        this.end_child = s_end_child;
    }

    public Class getItemClass() {
        return this.item_class;
    }

    public List getBegin() {
        return this.begin;
    }

    public List getEnd() {
        return this.end;
    }

    public List getBeginChild() {
        return this.begin_child;
    }

    public List getEndChild() {
        return this.end_child;
    }

    public void dump() {
        System.out.println("item associated to " + this.item_class.toString() + ":");
        ConfParser.dump("  ", "begin", this.begin);
        ConfParser.dump("  ", "end", this.end);
        if (this.begin_child != null) {
            ConfParser.dump("  ", "begin_child", this.begin_child);
        }
        if (this.end_child != null) {
            ConfParser.dump("  ", "end_child", this.end_child);
        }
    }
}

