/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.xml.internal;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DBorder;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DColorRegistry;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DCurveLink;
import org.eclipse.tptp.platform.report.core.internal.DData;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DFolder;
import org.eclipse.tptp.platform.report.core.internal.DFolderModel;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DFontRegistry;
import org.eclipse.tptp.platform.report.core.internal.DFooter;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DHeader;
import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.DIndex;
import org.eclipse.tptp.platform.report.core.internal.DIndexEntry;
import org.eclipse.tptp.platform.report.core.internal.DItem;
import org.eclipse.tptp.platform.report.core.internal.DItemContainer;
import org.eclipse.tptp.platform.report.core.internal.DLine;
import org.eclipse.tptp.platform.report.core.internal.DLink;
import org.eclipse.tptp.platform.report.core.internal.DList;
import org.eclipse.tptp.platform.report.core.internal.DPageBreak;
import org.eclipse.tptp.platform.report.core.internal.DPageCounter;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPointLink;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.DPropertyStore;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.DSummary;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.DTag;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.DTitle;
import org.eclipse.tptp.platform.report.core.internal.DWallpaper;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.internal.IDStringSerializable;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drawutil.internal.DSymbolRegistry;
import org.eclipse.tptp.platform.report.drawutil.internal.ISymbol;
import org.eclipse.tptp.platform.report.drivers.internal.IReader;
import org.eclipse.tptp.platform.report.drivers.xml.internal.DXmlError;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IDXmlSerializable;
import org.eclipse.tptp.platform.report.drivers.xml.internal.IXmlParser;
import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.extension.internal.DExtensionRegistry;
import org.eclipse.tptp.platform.report.extension.internal.IDExtension;
import org.eclipse.tptp.platform.report.tools.internal.DAlignment;
import org.eclipse.tptp.platform.report.tools.internal.DParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DXmlReader
extends DParser
implements IReader {
    private List iditem_factories;
    private DStyleRegistry styles;
    private DColorRegistry colors;
    private DFontRegistry fonts;
    private HashMap fontsId;
    private HashMap colorsId;
    private HashMap stylesId;
    private HashMap axis;
    private IXmlParser parser_;
    private static String[] filter_HEADER_FOOTER = new String[]{"HEADER", "FOOTER"};
    private static String[] filter_PROPERTIES = new String[]{"PROPERTIES"};
    private static String[] filter_for_DGraphic = new String[]{"PROPERTIES", "AXIS"};
    private HashMap folder_model_read_ = new HashMap();

    public DXmlReader(IXmlParser parser) {
        this.parser_ = parser;
        this.fontsId = new HashMap();
        this.colorsId = new HashMap();
        this.stylesId = new HashMap();
        this.axis = new HashMap();
        DExtensionRegistry.sgn_addExtension.connect(this, "updateExtension(org.eclipse.tptp.platform.report.extension.internal.IDExtension, Class)");
        DExtensionRegistry.sgn_removeExtension.connect(this, "updateExtension(org.eclipse.tptp.platform.report.extension.internal.IDExtension, Class)");
    }

    public DColorRegistry getColorRegistry() {
        return this.colors;
    }

    public DFontRegistry getFontRegistry() {
        return this.fonts;
    }

    public DStyleRegistry getStyleRegistry() {
        return this.styles;
    }

    public void setColorRegistry(DColorRegistry r) {
        this.colors = r;
    }

    public void setFontRegistry(DFontRegistry r) {
        this.fonts = r;
    }

    public void setStyleRegistry(DStyleRegistry r) {
        this.styles = r;
    }

    public void addIDItemFactory(IDItemFactory f) {
        if (this.iditem_factories == null) {
            this.iditem_factories = new ArrayList();
        }
        this.iditem_factories.add(f);
    }

    public void removeIDItemFactory(IDItemFactory f) {
        if (this.iditem_factories == null) {
            return;
        }
        this.iditem_factories.remove(f);
    }

    public void clear() {
        this.fontsId.clear();
        this.colorsId.clear();
        this.stylesId.clear();
        this.axis.clear();
        this.folder_model_read_ = null;
    }

    public String getRootElementName() {
        return "JSCRIB";
    }

    public IDObject[] read(InputStream in) throws Exception {
        this.clear();
        this.parser_.parse(new InputSource(in));
        Document dom_doc = this.parser_.getDocument();
        if (dom_doc == null) {
            throw new DXmlError("no document to read");
        }
        Element root = dom_doc.getDocumentElement();
        String root_name = this.getRootElementName();
        if (root == null || !root.getNodeName().equals(root_name)) {
            throw new DXmlError("no '" + root_name + "' root element found in document");
        }
        this.parseStyles(dom_doc);
        ArrayList<DItemContainer> docs = new ArrayList<DItemContainer>();
        NodeList l = root.getChildNodes();
        Arg arg = new Arg(null);
        int i = 0;
        while (i < l.getLength()) {
            Node n = l.item(i);
            if (n != null && n.getNodeType() == 1) {
                if ("DOCUMENT".equals(n.getNodeName())) {
                    DDocument doc = new DDocument();
                    arg.node = n;
                    this.invokeDoMethod(doc, this, arg);
                    docs.add(doc);
                } else if ("GRAPHIC".equals(n.getNodeName())) {
                    DGraphic gph = new DGraphic();
                    arg.node = n;
                    this.invokeDoMethod(gph, this, arg);
                    docs.add(gph);
                }
            }
            ++i;
        }
        if (docs.size() == 0) {
            return null;
        }
        IDObject[] a = new IDObject[docs.size()];
        int i2 = 0;
        while (i2 < docs.size()) {
            a[i2] = (IDObject)docs.get(i2);
            ++i2;
        }
        return a;
    }

    public void doMethod(DColor color, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        Node att_id = this.getRequiredAttribut(attr, "ID", "COLOR");
        int r = 0;
        int g = 0;
        int b = 0;
        Node n = attr.getNamedItem("R");
        if (n != null) {
            r = Integer.parseInt(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("G")) != null) {
            g = Integer.parseInt(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("B")) != null) {
            b = Integer.parseInt(n.getNodeValue());
        }
        color.setRGB(r, g, b);
        ((Arg)arg).ret_id = att_id.getNodeValue();
    }

    public void doMethod(DFont font, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        Node att_id = this.getRequiredAttribut(attr, "ID", "FONT");
        Node n = attr.getNamedItem("SIZE");
        if (n != null) {
            font.setSize(Integer.parseInt(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("FAMILY")) != null) {
            font.setFamily(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("SCRIPT")) != null) {
            font.setScript(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("STYLE")) != null) {
            font.setStyle(n.getNodeValue());
        }
        ((Arg)arg).ret_id = att_id.getNodeValue();
    }

    public void doMethod(DStyle style, DExtensible ext, Object a_arg) {
        Arg arg = (Arg)a_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        arg.ret_id = this.getRequiredAttribut(attr, "ID", "STYLE").getNodeValue();
        Node n = attr.getNamedItem("NAME");
        if (n != null) {
            style.setName(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("FONT")) != null) {
            DFont font = (DFont)this.fontsId.get(n.getNodeValue());
            if (font == null) {
                throw new DXmlError("Undeclared FONT ID (" + n.getNodeValue() + ") while parsing STYLE tag");
            }
            style.setFont(font);
        }
        if ((n = attr.getNamedItem("FORECOLOR")) != null) {
            DColor fore = (DColor)this.colorsId.get(n.getNodeValue());
            if (fore == null) {
                throw new DXmlError("Undeclared FORECOLOR ID (" + n.getNodeValue() + ") while parsing STYLE tag");
            }
            style.setForeColor(fore);
        }
        if ((n = attr.getNamedItem("BACKCOLOR")) != null) {
            DColor back = (DColor)this.colorsId.get(n.getNodeValue());
            if (back == null) {
                throw new DXmlError("Undeclared BACKCOLOR ID (" + n.getNodeValue() + ") while parsing STYLE tag");
            }
            style.setBackColor(back);
        }
        if ((n = attr.getNamedItem("WALLPAPER")) != null) {
            DWallpaper wp = new DWallpaper(null);
            wp.serializeFromString(n.getNodeValue());
            style.setWallpaper(wp);
        }
    }

    private void parseStyles(Document dom_doc) {
        Arg arg;
        int j;
        this.colorsId.clear();
        this.fontsId.clear();
        this.stylesId.clear();
        if (this.styles != null) {
            this.styles.clear();
        }
        if (this.colors != null) {
            this.colors.clear();
        }
        if (this.fonts != null) {
            this.fonts.clear();
        }
        NodeList List2 = dom_doc.getDocumentElement().getElementsByTagName("COLORS");
        int i = 0;
        while (i < List2.getLength()) {
            NodeList colorList = List2.item(i).getChildNodes();
            j = 0;
            while (j < colorList.getLength()) {
                if ("COLOR".equals(colorList.item(j).getNodeName())) {
                    DColor c = new DColor();
                    arg = new Arg(colorList.item(j));
                    this.invokeDoMethod(c, this, arg);
                    if (arg.ret_id != null) {
                        this.colorsId.put(arg.ret_id, c);
                        if (this.colors == null) {
                            this.colors = new DColorRegistry();
                        }
                        this.colors.putColor(c);
                    }
                }
                ++j;
            }
            ++i;
        }
        List2 = dom_doc.getDocumentElement().getElementsByTagName("FONTS");
        i = 0;
        while (i < List2.getLength()) {
            NodeList fontList = List2.item(i).getChildNodes();
            j = 0;
            while (j < fontList.getLength()) {
                if ("FONT".equals(fontList.item(j).getNodeName())) {
                    DFont f = new DFont();
                    arg = new Arg(fontList.item(j));
                    this.invokeDoMethod(f, this, arg);
                    if (arg.ret_id != null) {
                        this.fontsId.put(arg.ret_id, f);
                        if (this.fonts == null) {
                            this.fonts = new DFontRegistry();
                        }
                        this.fonts.putFont(f);
                    }
                }
                ++j;
            }
            ++i;
        }
        List2 = dom_doc.getDocumentElement().getElementsByTagName("STYLES");
        i = 0;
        while (i < List2.getLength()) {
            NodeList styleList = List2.item(i).getChildNodes();
            j = 0;
            while (j < styleList.getLength()) {
                if ("STYLE".equals(styleList.item(j).getNodeName())) {
                    DStyle s = new DStyle();
                    arg = new Arg(styleList.item(j));
                    this.invokeDoMethod(s, this, arg);
                    if (arg.ret_id != null) {
                        this.stylesId.put(arg.ret_id, s);
                        if (this.styles == null) {
                            this.styles = new DStyleRegistry();
                        }
                        this.styles.putStyle(s);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static String decode(String s) {
        if (s == null) {
            return s;
        }
        s = s.replaceAll("&apos;", "'");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&gt;", ">");
        s = s.replaceAll("&quot;", "\"");
        s = s.replaceAll("&amp;", "&");
        return s;
    }

    protected Node getRequiredAttribut(NamedNodeMap attr, String attr_tag, String elt_tag) {
        Node n = attr.getNamedItem(attr_tag);
        if (n == null) {
            throw new DXmlError(String.valueOf(attr_tag) + " attribute not defined while parsing " + elt_tag + " tag");
        }
        return n;
    }

    public void setNodeStyle(NamedNodeMap attr, IDItem item) {
        Node n = attr.getNamedItem("STYLE");
        if (n != null) {
            item.setStyle((IDStyle)this.stylesId.get(n.getNodeValue()));
        }
    }

    public static String getNodeText(Node node) {
        String s = "";
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                String sc = child.getNodeValue();
                s = String.valueOf(s) + DXmlReader.decode(sc);
            }
            child = child.getNextSibling();
        }
        return s;
    }

    protected IDItem createIDItemForNode(Node node) {
        String name;
        if (this.iditem_factories != null) {
            int i = 0;
            while (i < this.iditem_factories.size()) {
                IDItemFactory f = (IDItemFactory)this.iditem_factories.get(i);
                IDItem item = f.createIDItem(node);
                if (item instanceof DDummy) {
                    return null;
                }
                if (item != null) {
                    return item;
                }
                ++i;
            }
        }
        if ((name = node.getNodeName()) == null) {
            return null;
        }
        switch (name.length()) {
            case 3: {
                if (name.equals("TAG")) {
                    return new DTag();
                }
                if (!name.equals("ROW")) break;
                return new DRow();
            }
            case 4: {
                if (name.equals("TEXT")) {
                    return new DText();
                }
                if (name.equals("CELL")) {
                    return new DCell();
                }
                if (name.equals("LIST")) {
                    return new DList();
                }
                if (name.equals("LINK")) {
                    return new DLink();
                }
                if (name.equals("DATA")) {
                    return new DData();
                }
                if (name.equals("AXIS")) {
                    return new DAxis("unnamed");
                }
                if (!name.equals("LINE")) break;
                return new DLine();
            }
            case 5: {
                if (name.equals("COORD")) {
                    return new DCoord(null, 0.0);
                }
                if (name.equals("POINT")) {
                    return new DPoint();
                }
                if (name.equals("IMAGE")) {
                    return new DImage();
                }
                if (name.equals("CURVE")) {
                    return new DCurve();
                }
                if (name.equals("TITLE")) {
                    return new DTitle();
                }
                if (name.equals("TABLE")) {
                    return new DTable();
                }
                if (name.equals("POPUP")) {
                    return new DPopup();
                }
                if (!name.equals("INDEX")) break;
                return new DIndex();
            }
            case 6: {
                if (name.equals("HEADER")) {
                    return new DHeader();
                }
                if (name.equals("FOOTER")) {
                    return new DFooter();
                }
                if (name.equals("FOLDER")) {
                    return new DFolder();
                }
                if (name.equals("BORDER")) {
                    return new DBorder();
                }
                if (!name.equals("IDITEM")) break;
                NamedNodeMap attr = node.getAttributes();
                Node a_class = this.getRequiredAttribut(attr, "CLASS", "IDITEM");
                String class_name = a_class.getNodeValue();
                return this.createFromClass(class_name);
            }
            case 7: {
                if (name.equals("GRAPHIC")) {
                    return new DGraphic();
                }
                if (name.equals("SECTION")) {
                    return new DSection();
                }
                if (!name.equals("SUMMARY")) break;
                return new DSummary();
            }
            case 8: {
                if (!name.equals("DOCUMENT")) break;
                return new DDocument();
            }
            case 9: {
                if (name.equals("PARAGRAPH")) {
                    return new DParagraph();
                }
                if (name.equals("CELL_TEXT")) {
                    return new DCellText();
                }
                if (!name.equals("COORD_OBJ")) break;
                return new DCoordObject();
            }
            case 10: {
                if (name.equals("PAGE_BREAK")) {
                    return new DPageBreak();
                }
                if (name.equals("POINT_LINK")) {
                    return new DPointLink();
                }
                if (!name.equals("CURVE_LINK")) break;
                return new DCurveLink();
            }
            default: {
                if (name.equals("INDEX_ENTRY")) {
                    return new DIndexEntry();
                }
                if (name.equals("PAGE_COUNTER")) {
                    return new DPageCounter();
                }
                if (!name.equals("JSML_EXTENSION")) break;
                NamedNodeMap attr = node.getAttributes();
                Node a_class = this.getRequiredAttribut(attr, "CLASS", "JSML_EXTENSION");
                String class_name = a_class.getNodeValue();
                this.createFromClass(class_name);
                return null;
            }
        }
        throw new DXmlError(String.valueOf(name) + " is unknown node.");
    }

    protected IDItem createFromClass(String class_name) {
        try {
            Class<?> clazz = Class.forName(class_name);
            Object inst = clazz.newInstance();
            return (IDItem)inst;
        }
        catch (Exception e) {
            if (e instanceof InstantiationException) {
                System.out.println("Can't instanciate class '" + class_name + "',  haven't a public empty constructor ?");
                return null;
            }
            if (e instanceof ClassNotFoundException) {
                System.out.println("Can't found class = " + class_name);
            }
            return null;
        }
    }

    public void doChildrenItem(IDItem parent, DExtensible ext, Object a_arg) {
        Arg arg = (Arg)a_arg;
        Node n = arg.node;
        if (!n.hasChildNodes()) {
            return;
        }
        Node e = null;
        if (n.getNodeType() == 3) {
            return;
        }
        if (n.getNodeType() == 1) {
            e = (Element)n;
        }
        NodeList list = e.getChildNodes();
        IDItem previous = null;
        int i = 0;
        while (i < list.getLength()) {
            IDItem child = null;
            Node node = list.item(i);
            if (node.getNodeType() == 1 && !arg.filterChildren(node.getNodeName()) && (child = this.createIDItemForNode(node)) != null) {
                this.invokeDoMethod(child, this, new Arg(node));
                if (parent == child) {
                    throw new DXmlError("Parent = " + parent.getClass());
                }
                if (parent != null) {
                    parent.insertChild(child, previous);
                    previous = child;
                }
            }
            ++i;
        }
    }

    public void doMethod(DDocument doc, DExtensible ext, Object arg) {
        Node node = ((Arg)arg).node;
        NamedNodeMap attr = node.getAttributes();
        Node n = attr.getNamedItem("TITLE");
        if (n != null) {
            doc.setTitle(n.getNodeValue());
        }
        doc.setTag(this.getRequiredAttribut(attr, "TAG", node.getNodeName()).getNodeValue());
        this.setNodeStyle(attr, doc);
        this.doChildrenItem(doc, ext, arg);
    }

    public void doMethod(DSection sec, DExtensible ext, Object arg) {
        Node node = ((Arg)arg).node;
        NamedNodeMap attr = node.getAttributes();
        sec.setTag(this.getRequiredAttribut(attr, "TAG", node.getNodeName()).getNodeValue());
        this.setNodeStyle(attr, sec);
        Node c = node.getFirstChild();
        while (c != null) {
            String name = c.getNodeName();
            if ("HEADER".equals(name)) {
                if (sec.getHeader() != null) {
                    throw new DXmlError("more than one HEADER defined in section");
                }
                DHeader header = new DHeader();
                this.invokeDoMethod(header, ext, new Arg(c));
                sec.setHeader(header);
            } else if ("FOOTER".equals(name)) {
                if (sec.getFooter() != null) {
                    throw new DXmlError("more than one FOOTER defined in section");
                }
                DFooter footer = new DFooter();
                this.invokeDoMethod(footer, ext, new Arg(c));
                sec.setFooter(footer);
            }
            c = c.getNextSibling();
        }
        Arg aarg = (Arg)arg;
        String[] save = aarg.filter_children;
        aarg.filter_children = filter_HEADER_FOOTER;
        this.doChildrenItem(sec, ext, arg);
        aarg.filter_children = save;
    }

    public void doMethod(DFooter foot, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        this.setNodeStyle(attr, foot);
        this.doChildrenItem(foot, ext, arg);
    }

    public void doMethod(DHeader head, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        this.setNodeStyle(attr, head);
        this.doChildrenItem(head, ext, arg);
    }

    public void doMethod(DParagraph para, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        Node n = attr.getNamedItem("ALIGNMENT");
        if (n != null) {
            para.setAlignment(DAlignment.StringToAlignment(n.getNodeValue()));
        }
        this.setNodeStyle(attr, para);
        this.doChildrenItem(para, ext, arg);
    }

    public void doMethod(DItem it, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        this.setNodeStyle(attr, it);
    }

    public void doMethod(DItemContainer ic, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        this.setNodeStyle(attr, ic);
        this.doChildrenItem(ic, ext, arg);
    }

    public void doMethod(DText text, DExtensible ext, Object arg) {
        Node node = ((Arg)arg).node;
        NamedNodeMap attr = node.getAttributes();
        this.setNodeStyle(attr, text);
        text.setText(DXmlReader.getNodeText(node));
    }

    public void doMethod(DImage img, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        img.setName(this.getRequiredAttribut(attr, "NAME", "IMAGE").getNodeValue());
        Node n = attr.getNamedItem("SCALEW");
        if (n != null) {
            img.setWidthScale(Float.parseFloat(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("SCALEH")) != null) {
            img.setHeightScale(Float.parseFloat(n.getNodeValue()));
        }
        this.setNodeStyle(attr, img);
    }

    public void doMethod(DList list, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        list.setFormat(Integer.parseInt(this.getRequiredAttribut(attr, "TYPE", "LIST").getNodeValue()));
        this.setNodeStyle(attr, list);
        this.doChildrenItem(list, ext, arg);
    }

    public void doMethod(DTable tab, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        Node n = attr.getNamedItem("SCALEW");
        if (n != null) {
            tab.setWidthScale(Float.parseFloat(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("SCALEH")) != null) {
            tab.setHeightScale(Float.parseFloat(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("BORDER")) != null) {
            tab.setBorder(Integer.parseInt(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("WIDTH")) != null) {
            String s = n.getNodeValue();
            String[] split = s.split("/");
            float[] cw = new float[split.length];
            try {
                int i = 0;
                while (i < split.length) {
                    String sp = split[i];
                    cw[i] = Float.parseFloat(sp);
                    ++i;
                }
                tab.setColumnWidth(cw);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DXmlError("Invalid table's width attribute, valid format is: WIDTH=\"(float ('/' float)*)\"");
            }
        }
        this.setNodeStyle(attr, tab);
        this.doChildrenItem(tab, ext, arg);
    }

    public void doMethod(DRow row, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        this.setNodeStyle(attr, row);
        this.doChildrenItem(row, ext, arg);
    }

    public void doMethod(DCell cell, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        Node n = attr.getNamedItem("COLSPAN");
        if (n != null) {
            cell.setColSpan(Integer.parseInt(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("ROWSPAN")) != null) {
            cell.setRowSpan(Integer.parseInt(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("ALIGNMENT")) != null) {
            cell.setAlignment(DAlignment.StringToAlignment(n.getNodeValue()));
        }
        this.setNodeStyle(attr, cell);
        this.doChildrenItem(cell, ext, arg);
    }

    public void doMethod(DCellText ct, DExtensible ext, Object arg) {
        Node node = ((Arg)arg).node;
        NamedNodeMap attr = node.getAttributes();
        Node n = attr.getNamedItem("COLSPAN");
        if (n != null) {
            ct.setColSpan(Integer.parseInt(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("ROWSPAN")) != null) {
            ct.setRowSpan(Integer.parseInt(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("ALIGNMENT")) != null) {
            ct.setAlignment(DAlignment.StringToAlignment(n.getNodeValue()));
        }
        this.setNodeStyle(attr, ct);
        ct.setText(DXmlReader.getNodeText(node));
        this.doChildrenItem(ct, ext, arg);
    }

    public void doMethod(DLink ln, DExtensible ext, Object arg) {
        Node node = ((Arg)arg).node;
        NamedNodeMap attr = node.getAttributes();
        ln.setTarget(this.getRequiredAttribut(attr, "TARGET", node.getNodeName()).getNodeValue());
        this.setNodeStyle(attr, ln);
        this.doChildrenItem(ln, ext, arg);
    }

    public void doMethod(DTag tag, DExtensible ext, Object arg) {
        Node node = ((Arg)arg).node;
        NamedNodeMap attr = node.getAttributes();
        tag.setTag(this.getRequiredAttribut(attr, "NAME", node.getNodeName()).getNodeValue());
        this.setNodeStyle(attr, tag);
    }

    public void doMethod(DLine line, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        Node n = attr.getNamedItem("SIZE");
        if (n != null) {
            line.setSize(Integer.parseInt(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("TYPE")) != null) {
            line.setType(n.getNodeValue());
        }
        this.setNodeStyle(attr, line);
        this.doChildrenItem(line, ext, arg);
    }

    public void doMethod(DPageBreak pb, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        this.setNodeStyle(attr, pb);
    }

    public void doMethod(DPageCounter pc, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        this.setNodeStyle(attr, pc);
    }

    public void doMethod(DPopup ppp, DExtensible ext, Object arg) {
        Node node = ((Arg)arg).node;
        NamedNodeMap attr = node.getAttributes();
        ppp.setTag(this.getRequiredAttribut(attr, "TAG", node.getNodeName()).getNodeValue());
        this.setNodeStyle(attr, ppp);
        this.doChildrenItem(ppp, ext, arg);
    }

    public void doMethod(DSummary sum, DExtensible ext, Object arg) {
        Node node = ((Arg)arg).node;
        NamedNodeMap attr = node.getAttributes();
        sum.setTitleLevel(Integer.parseInt(this.getRequiredAttribut(attr, "LEVEL", node.getNodeName()).getNodeValue()));
        Node n = attr.getNamedItem("TAG");
        if (n != null) {
            sum.setTag(n.getNodeValue());
        }
        this.setNodeStyle(attr, sum);
    }

    public void doMethod(DTitle ttl, DExtensible ext, Object arg) {
        Node node = ((Arg)arg).node;
        NamedNodeMap attr = node.getAttributes();
        ttl.setLevel(Integer.parseInt(this.getRequiredAttribut(attr, "LEVEL", node.getNodeName()).getNodeValue()));
        Node n = attr.getNamedItem("TAG");
        if (n != null) {
            ttl.setTag(n.getNodeValue());
        }
        this.setNodeStyle(attr, ttl);
        this.doChildrenItem(ttl, ext, arg);
    }

    public void doMethod(DIndex ndx, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        this.setNodeStyle(attr, ndx);
        Node n = attr.getNamedItem("PROPERTY");
        if (n != null) {
            String prop = n.getNodeValue();
            ndx.setProperty(prop);
            n = attr.getNamedItem("CLASS");
            if (n != null) {
                String clname = n.getNodeValue();
                Object o = this.createObjectForClassName(clname, n);
                ndx.setValue(o);
            }
        }
    }

    public void doMethod(DIndexEntry ie, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        this.setNodeStyle(attr, ie);
        this.doChildrenItem(ie, ext, arg);
    }

    public void doMethod(DGraphic graf, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        graf.setRenderableId(this.getRequiredAttribut(attr, "TYPE", "GRAPHIC").getNodeValue());
        Node n = attr.getNamedItem("TITLE");
        if (n != null) {
            graf.setTitle(n.getNodeValue());
        }
        this.setNodeStyle(attr, graf);
        this.axis.clear();
        Node c = arg.node.getFirstChild();
        while (c != null) {
            if ("PROPERTIES".equals(c.getNodeName())) {
                DPropertyStore ps = graf.getProperties();
                if (ps == null) {
                    ps = new DPropertyStore();
                }
                this.invokeDoMethod(ps, ext, new Arg(c));
                graf.setProperties(ps);
            } else if ("AXIS".equals(c.getNodeName())) {
                DAxis the_axis = new DAxis(null);
                this.invokeDoMethod(the_axis, ext, new Arg(c));
                graf.addChild(the_axis);
            }
            c = c.getNextSibling();
        }
        String[] save = arg.filter_children;
        arg.filter_children = filter_for_DGraphic;
        this.doChildrenItem(graf, ext, arg);
        arg.filter_children = save;
        this.axis.clear();
    }

    public void doMethod(DAxis ax, DExtensible ext, Object the_arg) {
        Arg arg = (Arg)the_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        ax.setName(this.getRequiredAttribut(attr, "NAME", "AXIS").getNodeValue());
        Node n = attr.getNamedItem("UNIT");
        if (n != null) {
            ax.setUnit(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("TITLE")) != null) {
            ax.setTitle(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("TYPE")) != null) {
            ax.setScaleType(n.getNodeValue());
        }
        this.setNodeStyle(attr, ax);
        this.axis.put(ax.getName(), ax);
        Node c = arg.node.getFirstChild();
        while (c != null) {
            if ("PROPERTIES".equals(c.getNodeName())) {
                DPropertyStore ps = ax.getProperties();
                if (ps == null) {
                    ps = new DPropertyStore();
                }
                this.invokeDoMethod(ps, ext, new Arg(c));
                ax.setProperties(ps);
                break;
            }
            c = c.getNextSibling();
        }
        String[] save = arg.filter_children;
        arg.filter_children = filter_PROPERTIES;
        this.doChildrenItem(ax, ext, arg);
        arg.filter_children = save;
    }

    public void doMethod(DCurve curv, DExtensible ext, Object a_arg) {
        Arg arg = (Arg)a_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        this.setNodeStyle(attr, curv);
        Node n = attr.getNamedItem("NAME");
        if (n != null) {
            curv.setName(n.getNodeValue());
        }
        if ((n = attr.getNamedItem("TYPE")) != null) {
            curv.setType(n.getNodeValue());
        }
        Node c = arg.node.getFirstChild();
        while (c != null) {
            if ("PROPERTIES".equals(c.getNodeName())) {
                DPropertyStore ps = curv.getProperties();
                if (ps == null) {
                    ps = new DPropertyStore();
                }
                this.invokeDoMethod(ps, ext, new Arg(c));
                curv.setProperties(ps);
                break;
            }
            c = c.getNextSibling();
        }
        String[] save = arg.filter_children;
        arg.filter_children = filter_PROPERTIES;
        this.doChildrenItem(curv, ext, arg);
        arg.filter_children = save;
    }

    public void doMethod(DCurveLink cl, DExtensible ext, Object a_arg) {
        Arg arg = (Arg)a_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        cl.setTarget(this.getRequiredAttribut(attr, "TARGET", "CURVE_LINK").getNodeValue());
        this.doMethod((DCurve)cl, ext, a_arg);
    }

    public void doMethod(DPoint pnt, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        this.setNodeStyle(attr, pnt);
        this.doChildrenItem(pnt, ext, arg);
    }

    public void doMethod(DPointLink pl, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        pl.setTarget(this.getRequiredAttribut(attr, "TARGET", "POINT_LINK").getNodeValue());
        this.setNodeStyle(attr, pl);
        this.doChildrenItem(pl, ext, arg);
    }

    public void doMethod(DCoord coord, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        DAxis ax = (DAxis)this.axis.get(this.getRequiredAttribut(attr, "AXIS", "COORD").getNodeValue());
        coord.setAxis(ax);
        coord.setValue(Float.parseFloat(this.getRequiredAttribut(attr, "VALUE", "COORD").getNodeValue()));
    }

    public void doMethod(DCoordObject coord, DExtensible ext, Object arg) {
        NamedNodeMap attr = ((Arg)arg).node.getAttributes();
        DAxis ax = (DAxis)this.axis.get(this.getRequiredAttribut(attr, "AXIS", "COORD_OBJ").getNodeValue());
        coord.setAxis(ax);
        String cl_name = this.getRequiredAttribut(attr, "CLASS", "COORD_OBJ").getNodeValue();
        if (Object.class.getName().equals(cl_name)) {
            coord.setValue(null);
        } else {
            try {
                Class<?> c = Class.forName(cl_name);
                Object val = c.newInstance();
                this.invokeDoMethod(val, ext, arg);
                coord.setValue(val);
            }
            catch (Exception e) {
                throw new DXmlError(e.getMessage());
            }
        }
    }

    public void doMethod(Date date, DExtensible ext, Object arg) {
        String s = DXmlReader.getNodeText(((Arg)arg).node);
        try {
            date.setTime(Long.parseLong(s));
        }
        catch (NumberFormatException e) {
            throw new DXmlError(e.getMessage());
        }
    }

    public void doMethod(DPropertyStore ps, DExtensible ext, Object arg) {
        Node node = ((Arg)arg).node;
        Node c = node.getFirstChild();
        while (c != null) {
            if ("PROPERTY".equals(c.getNodeName())) {
                NamedNodeMap attr = c.getAttributes();
                String name = this.getRequiredAttribut(attr, "NAME", c.getNodeName()).getNodeValue();
                String clazz = this.getRequiredAttribut(attr, "CLASS", c.getNodeName()).getNodeValue();
                Object o = this.createObjectForClassName(clazz, c);
                ps.store(name, o);
            }
            c = c.getNextSibling();
        }
    }

    protected Object createObjectForClassName(String class_name, Node node) {
        block28: {
            Class<?> c;
            block27: {
                block26: {
                    c = Class.forName(class_name);
                    if (c == String.class) {
                        return DXmlReader.getNodeText(node);
                    }
                    if (c == Byte.class) {
                        return Byte.decode(DXmlReader.getNodeText(node));
                    }
                    if (c == Short.class) {
                        return Short.decode(DXmlReader.getNodeText(node));
                    }
                    if (c == Integer.class) {
                        return Integer.decode(DXmlReader.getNodeText(node));
                    }
                    if (c == Long.class) {
                        return Long.decode(DXmlReader.getNodeText(node));
                    }
                    if (c == Float.class) {
                        return Float.valueOf(DXmlReader.getNodeText(node));
                    }
                    if (c == Double.class) {
                        return Double.valueOf(DXmlReader.getNodeText(node));
                    }
                    if (c == Boolean.class) {
                        return Boolean.valueOf(DXmlReader.getNodeText(node));
                    }
                    if (IDColor.class.isAssignableFrom(c)) {
                        return this.colorsId.get(DXmlReader.getNodeText(node));
                    }
                    if (IDFont.class.isAssignableFrom(c)) {
                        return this.fontsId.get(DXmlReader.getNodeText(node));
                    }
                    if (IDFont.class.isAssignableFrom(c)) {
                        return this.stylesId.get(DXmlReader.getNodeText(node));
                    }
                    if (!IDStringSerializable.class.isAssignableFrom(c)) break block26;
                    try {
                        IDStringSerializable v = (IDStringSerializable)c.newInstance();
                        Arg arg = new Arg(node);
                        this.invokeDoMethod(v, this, arg);
                        return v;
                    }
                    catch (Exception e) {
                        if (!(e instanceof InstantiationException)) break block26;
                        System.out.println("IDStringSerializable class should have an empty public constructor");
                        return null;
                    }
                }
                if (!IDXmlSerializable.class.isAssignableFrom(c)) break block27;
                try {
                    IDXmlSerializable v = (IDXmlSerializable)c.newInstance();
                    Arg arg = new Arg(node);
                    this.invokeDoMethod(v, this, arg);
                    return v;
                }
                catch (Exception e) {
                    if (e instanceof InstantiationException) {
                        System.out.println("IDXmlSerializable class should have an empty public constructor");
                        return null;
                    }
                }
            }
            try {
                if (c == Class.class) {
                    return Class.forName(DXmlReader.getNodeText(node));
                }
                if (c == DecimalFormat.class) {
                    return new DecimalFormat(DXmlReader.getNodeText(node));
                }
                if (c == SimpleDateFormat.class) {
                    return new SimpleDateFormat(DXmlReader.getNodeText(node));
                }
                if (c == Date.class) {
                    try {
                        return new Date(Long.parseLong(DXmlReader.getNodeText(node)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new DXmlError("Failed to parse Date");
                    }
                }
                System.err.println("(W) don't know how to handle property class '" + c.getName() + "'");
            }
            catch (Exception e) {
                if (!(e instanceof ClassNotFoundException)) break block28;
                System.out.println("(W) Unable to instanciate class = " + class_name);
            }
        }
        return null;
    }

    public void doMethod(IDXmlSerializable v, DExtensible ext, Object arg) {
        v.readXml(((Arg)arg).node);
    }

    public void doMethod(IDStringSerializable v, DExtensible ext, Object arg) {
        Node node = ((Arg)arg).node;
        v.serializeFromString(DXmlReader.getNodeText(node));
    }

    public void updateExtension(IDExtension ext, Class for_extension) {
        if (this.getClass().equals(for_extension)) {
            DExtensionRegistry.updateExtensible(this);
        }
    }

    public static IDColor DecodeColor(String s) {
        try {
            int rgb = Integer.parseInt(s, 16);
            return new DColor(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void doMethod(DFolder folder, DExtensible ext, Object a_arg) {
        DXmlReader r = (DXmlReader)ext;
        Arg arg = (Arg)a_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        if (this.folder_model_read_ == null) {
            this.folder_model_read_ = new HashMap();
        }
        Node n = arg.node;
        while (n.getParentNode() != null) {
            n = n.getParentNode();
        }
        r.setNodeStyle(attr, folder);
        n = attr.getNamedItem("OPEN");
        if (n != null) {
            folder.setOpen("true".equals(n.getNodeValue()));
        }
        if ((n = attr.getNamedItem("MODELDEF")) != null) {
            ISymbol symbol;
            int id = -1;
            try {
                id = Integer.parseInt(n.getNodeValue(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DXmlError("Folder model id must be a number");
            }
            DFolderModel model = new DFolderModel();
            folder.setFolderModel(model);
            this.folder_model_read_.put(new Integer(id), model);
            n = attr.getNamedItem("INDENTED");
            if (n != null) {
                model.setIndented("true".equals(n.getNodeValue()));
            }
            if ((n = attr.getNamedItem("OPENED")) != null) {
                symbol = DSymbolRegistry.GetCoreSymbol(n.getNodeValue());
                model.setOpenedSymbol(true, symbol);
                model.setOpenedSymbol(false, symbol);
            } else {
                n = attr.getNamedItem("OPENEDL2R");
                if (n != null) {
                    model.setOpenedSymbol(true, DSymbolRegistry.GetCoreSymbol(n.getNodeValue()));
                }
                if ((n = attr.getNamedItem("OPENEDR2L")) != null) {
                    model.setOpenedSymbol(false, DSymbolRegistry.GetCoreSymbol(n.getNodeValue()));
                }
            }
            n = attr.getNamedItem("CLOSED");
            if (n != null) {
                symbol = DSymbolRegistry.GetCoreSymbol(n.getNodeValue());
                model.setClosedSymbol(true, symbol);
                model.setClosedSymbol(false, symbol);
            } else {
                n = attr.getNamedItem("CLOSEDL2R");
                if (n != null) {
                    model.setClosedSymbol(true, DSymbolRegistry.GetCoreSymbol(n.getNodeValue()));
                }
                if ((n = attr.getNamedItem("CLOSEDR2L")) != null) {
                    model.setClosedSymbol(false, DSymbolRegistry.GetCoreSymbol(n.getNodeValue()));
                }
            }
            n = attr.getNamedItem("OPENEDFORE");
            if (n != null) {
                model.setOpenedForeColor(DXmlReader.DecodeColor(n.getNodeValue()));
            }
            if ((n = attr.getNamedItem("OPENEDBACK")) != null) {
                model.setOpenedBackColor(DXmlReader.DecodeColor(n.getNodeValue()));
            }
            if ((n = attr.getNamedItem("CLOSEDFORE")) != null) {
                model.setClosedForeColor(DXmlReader.DecodeColor(n.getNodeValue()));
            }
            if ((n = attr.getNamedItem("CLOSEDBACK")) != null) {
                model.setClosedBackColor(DXmlReader.DecodeColor(n.getNodeValue()));
            }
        } else {
            n = attr.getNamedItem("MODEL");
            if (n != null) {
                int id = -1;
                try {
                    id = Integer.parseInt(n.getNodeValue(), 16);
                    DFolderModel model = (DFolderModel)this.folder_model_read_.get(new Integer(id));
                    if (model == null) {
                        throw new DXmlError("Can't retrieve folder model id=" + n.getNodeValue());
                    }
                    folder.setFolderModel(model);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new DXmlError("Folder model id must be a number");
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new DXmlError("Folder model id=" + id + " isn't a known model.");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new DXmlError("Folder model id=" + id + " isn't a known model.");
                }
            }
        }
        r.doChildrenItem(folder, ext, arg);
    }

    private int parseInt(String s, int _default) {
        try {
            int v = Integer.parseInt(s);
            return v;
        }
        catch (Throwable throwable) {
            return _default;
        }
    }

    public void doMethod(DBorder border, DExtensible ext, Object a_arg) {
        DXmlReader r = (DXmlReader)ext;
        Arg arg = (Arg)a_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        Node n = arg.node;
        r.setNodeStyle(attr, border);
        n = attr.getNamedItem("SHADOW_TYPE");
        if (n != null) {
            border.setShadowType(DBorder.ToShadowType(n.getNodeValue()));
        } else {
            border.setShadowType(0);
        }
        n = attr.getNamedItem("SHADOW_DEPTH");
        if (n != null) {
            border.setShadowDepth(this.parseInt(n.getNodeValue(), 0));
        } else {
            border.setShadowDepth(8);
        }
        n = attr.getNamedItem("LINE_TYPE");
        if (n != null) {
            border.setLineType(DBorder.ToLineType(n.getNodeValue()));
        } else {
            border.setLineType(1);
        }
        n = attr.getNamedItem("MARGIN");
        if (n != null) {
            border.setMargin(this.parseInt(n.getNodeValue(), 0));
        } else {
            border.setMargin(3);
        }
        n = attr.getNamedItem("SHADOW_COLOR");
        if (n != null) {
            border.setShadowColor(DXmlReader.DecodeColor(n.getNodeValue()));
        }
        r.doChildrenItem(border, ext, arg);
    }

    public static class Arg {
        public Node node;
        public String[] filter_children;
        public String ret_id;

        public Arg(Node n) {
            this.node = n;
            this.ret_id = null;
        }

        public boolean filterChildren(String node_name) {
            if (this.filter_children == null) {
                return false;
            }
            int i = 0;
            while (i < this.filter_children.length) {
                String s = this.filter_children[i];
                if (s != null && s.equals(node_name)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static class DDummy
    extends DItem {
    }

    public static interface IDItemFactory {
        public IDItem createIDItem(Node var1);
    }
}

