/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.drivers.xsd.internal;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.tptp.platform.report.core.internal.DAxis;
import org.eclipse.tptp.platform.report.core.internal.DCell;
import org.eclipse.tptp.platform.report.core.internal.DCellText;
import org.eclipse.tptp.platform.report.core.internal.DColor;
import org.eclipse.tptp.platform.report.core.internal.DColorRegistry;
import org.eclipse.tptp.platform.report.core.internal.DCoord;
import org.eclipse.tptp.platform.report.core.internal.DCoordObject;
import org.eclipse.tptp.platform.report.core.internal.DCurve;
import org.eclipse.tptp.platform.report.core.internal.DCurveLink;
import org.eclipse.tptp.platform.report.core.internal.DData;
import org.eclipse.tptp.platform.report.core.internal.DDocument;
import org.eclipse.tptp.platform.report.core.internal.DFont;
import org.eclipse.tptp.platform.report.core.internal.DFontRegistry;
import org.eclipse.tptp.platform.report.core.internal.DFooter;
import org.eclipse.tptp.platform.report.core.internal.DGraphic;
import org.eclipse.tptp.platform.report.core.internal.DHeader;
import org.eclipse.tptp.platform.report.core.internal.DImage;
import org.eclipse.tptp.platform.report.core.internal.DIndex;
import org.eclipse.tptp.platform.report.core.internal.DIndexEntry;
import org.eclipse.tptp.platform.report.core.internal.DLine;
import org.eclipse.tptp.platform.report.core.internal.DLink;
import org.eclipse.tptp.platform.report.core.internal.DList;
import org.eclipse.tptp.platform.report.core.internal.DPageBreak;
import org.eclipse.tptp.platform.report.core.internal.DPageCounter;
import org.eclipse.tptp.platform.report.core.internal.DParagraph;
import org.eclipse.tptp.platform.report.core.internal.DPoint;
import org.eclipse.tptp.platform.report.core.internal.DPointLink;
import org.eclipse.tptp.platform.report.core.internal.DPopup;
import org.eclipse.tptp.platform.report.core.internal.DRow;
import org.eclipse.tptp.platform.report.core.internal.DSection;
import org.eclipse.tptp.platform.report.core.internal.DStyle;
import org.eclipse.tptp.platform.report.core.internal.DStyleRegistry;
import org.eclipse.tptp.platform.report.core.internal.DSummary;
import org.eclipse.tptp.platform.report.core.internal.DTable;
import org.eclipse.tptp.platform.report.core.internal.DTag;
import org.eclipse.tptp.platform.report.core.internal.DText;
import org.eclipse.tptp.platform.report.core.internal.DTitle;
import org.eclipse.tptp.platform.report.core.internal.IDColor;
import org.eclipse.tptp.platform.report.core.internal.IDFont;
import org.eclipse.tptp.platform.report.core.internal.IDItem;
import org.eclipse.tptp.platform.report.core.internal.IDObject;
import org.eclipse.tptp.platform.report.core.internal.IDStringSerializable;
import org.eclipse.tptp.platform.report.core.internal.IDStyle;
import org.eclipse.tptp.platform.report.drivers.internal.IReader;
import org.eclipse.tptp.platform.report.drivers.xsd.internal.DXsdError;
import org.eclipse.tptp.platform.report.drivers.xsd.internal.IDXsdSerializable;
import org.eclipse.tptp.platform.report.tools.internal.DParser;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DXsdReader
extends DParser
implements IReader {
    public String _inputXsdChartType;
    public String _titleBar;
    public boolean _showTitleBar = true;
    public boolean _showLegend = true;
    public boolean _chart3D = false;
    public String _chartType = "Unknown";
    public boolean _axis1Found = false;
    public String _labelAxis1;
    public String _minAxis1;
    public String _maxAxis1;
    public boolean _showGridLineMajorUnitAxis1 = false;
    public boolean _showGridLineMinorUnitAxis1 = false;
    public boolean _showTickMajorUnitAxis1 = false;
    public boolean _showTickMinorUnitAxis1 = false;
    public String _valueMajorUnitAxis1;
    public String _valueMinorUnitAxis1;
    public String _markerLineValueAxis1;
    public String _markerLineLabelAxis1;
    public String _markerLineColorAxis1;
    public String _numberFormatAxis1;
    public String _dataFormatAxis1;
    public String _dataSetIdsAxis1;
    DAxis _axis1;
    public boolean _axis2Found = false;
    public String _labelAxis2;
    public String _minAxis2;
    public String _maxAxis2;
    public boolean _showGridLineMajorUnitAxis2 = false;
    public boolean _showGridLineMinorUnitAxis2 = false;
    public boolean _showTickMajorUnitAxis2 = false;
    public boolean _showTickMinorUnitAxis2 = false;
    public String _valueMajorUnitAxis2;
    public String _valueMinorUnitAxis2;
    public String _markerLineValueAxis2;
    public String _markerLineLabelAxis2;
    public String _markerLineColorAxis2;
    public String _numberFormatAxis2;
    public String _dataFormatAxis2;
    public String _dataSetIdsAxis2;
    DAxis _axis2;
    public boolean _axis3Found = false;
    public String _labelAxis3;
    public String _minAxis3;
    public String _maxAxis3;
    public boolean _showGridLineMajorUnitAxis3 = false;
    public boolean _showGridLineMinorUnitAxis3 = false;
    public boolean _showTickMajorUnitAxis3 = false;
    public boolean _showTickMinorUnitAxis3 = false;
    public String _valueMajorUnitAxis3;
    public String _valueMinorUnitAxis3;
    public String _markerLineValueAxis3;
    public String _markerLineLabelAxis3;
    public String _markerLineColorAxis3;
    public String _numberFormatAxis3;
    public String _dataFormatAxis3;
    public String _dataSetIdsAxis3;
    DAxis _axis3;
    public boolean _trace = true;
    public boolean _traceLevel1 = false;
    public boolean _traceLevel2 = false;
    public boolean _traceLevel3 = false;
    public boolean _traceLevel4 = false;
    public boolean _traceLevel5 = false;
    public boolean _traceLevel4_5 = false;
    public static boolean _traceLevel6 = false;
    public boolean _traceChilds = true;
    public boolean _traceAttributes = true;
    public int _lastRValue = 0;
    public int _lastGValue = 0;
    public int _lastBValue = 255;
    public boolean _categoriesFound = false;
    private List iditem_factories;
    private DStyleRegistry styles;
    private DColorRegistry colors;
    private DFontRegistry fonts;
    private HashMap fontsId = new HashMap();
    private HashMap colorsId = new HashMap();
    private HashMap stylesId = new HashMap();
    private HashMap axis = new HashMap();

    public void _m(String s) {
        if (this._trace) {
            System.out.println(s);
        }
    }

    public void _displayContent(Element node) {
        if (this._traceAttributes) {
            System.out.println("node : " + node.getNodeName());
            System.out.println("\t Attributes : ");
            NamedNodeMap an = node.getAttributes();
            int k = 0;
            while (k < an.getLength()) {
                Node n3 = an.item(k);
                System.out.println("\t    " + n3.getNodeName() + " = " + n3.getNodeValue());
                ++k;
            }
        }
        if (this._traceChilds) {
            NodeList l = node.getChildNodes();
            System.out.println("\t Childs : ");
            int i = 0;
            while (i < l.getLength()) {
                Node n = l.item(i);
                if (n.getNodeName() != "#text") {
                    System.out.println("\t     => " + n.getNodeName());
                }
                ++i;
            }
        }
    }

    public DColorRegistry getColorRegistry() {
        return this.colors;
    }

    public DFontRegistry getFontRegistry() {
        return this.fonts;
    }

    public DStyleRegistry getStyleRegistry() {
        return this.styles;
    }

    public void setColorRegistry(DColorRegistry r) {
        this.colors = r;
    }

    public void setFontRegistry(DFontRegistry r) {
        this.fonts = r;
    }

    public void setStyleRegistry(DStyleRegistry r) {
        this.styles = r;
    }

    public void addIDItemFactory(IDItemFactory f) {
        if (this.iditem_factories == null) {
            this.iditem_factories = new ArrayList();
        }
        this.iditem_factories.add(f);
    }

    public void removeIDItemFactory(IDItemFactory f) {
        if (this.iditem_factories == null) {
            return;
        }
        this.iditem_factories.remove(f);
    }

    public void clear() {
        this.fontsId.clear();
        this.colorsId.clear();
        this.stylesId.clear();
        this.axis.clear();
    }

    public String _getXsdRootElementName() {
        return "chart";
    }

    public String getRootElementName() {
        return "JSCRIB";
    }

    public IDObject[] read(InputStream in) throws Exception {
        this.clear();
        XSDParser parser = new XSDParser();
        parser.parse(new InputSource(in));
        Document _input_dom_doc = parser.getDocument();
        if (_input_dom_doc == null) {
            throw new DXsdError("no document to read");
        }
        Element root = _input_dom_doc.getDocumentElement();
        String _Xsd_root_name = this._getXsdRootElementName();
        if (root == null) {
            throw new DXsdError("no '" + _Xsd_root_name + "' root element found in document");
        }
        ArrayList<DDocument> docs = new ArrayList<DDocument>();
        if (root.getNodeName().equals(_Xsd_root_name)) {
            this._m("XSD root detected");
            this.parseStyles(_input_dom_doc);
            Arg arg = new Arg(null);
            Element n = root;
            DDocument doc = new DDocument();
            arg.node = n;
            this._doMethodXsd(doc, (Object)arg);
            docs.add(doc);
        }
        if (docs.size() == 0) {
            return null;
        }
        IDObject[] a = new IDObject[docs.size()];
        int i = 0;
        while (i < docs.size()) {
            a[i] = (IDObject)docs.get(i);
            ++i;
        }
        return a;
    }

    private void parseStyles(Document dom_doc) {
        Arg arg;
        int j;
        this.colorsId.clear();
        this.fontsId.clear();
        this.stylesId.clear();
        if (this.styles != null) {
            this.styles.clear();
        }
        if (this.colors != null) {
            this.colors.clear();
        }
        if (this.fonts != null) {
            this.fonts.clear();
        }
        NodeList List2 = dom_doc.getElementsByTagName("COLORS");
        int i = 0;
        while (i < List2.getLength()) {
            NodeList colorList = List2.item(i).getChildNodes();
            j = 0;
            while (j < colorList.getLength()) {
                if (colorList.item(j).getNodeName() == "COLOR") {
                    DColor c = new DColor();
                    arg = new Arg(colorList.item(j));
                    this.invokeDoMethod(c, this, arg);
                    if (arg.ret_id != null) {
                        this.colorsId.put(arg.ret_id, c);
                        if (this.colors == null) {
                            this.colors = new DColorRegistry();
                        }
                        this.colors.putColor(c);
                    }
                }
                ++j;
            }
            ++i;
        }
        List2 = dom_doc.getElementsByTagName("FONTS");
        i = 0;
        while (i < List2.getLength()) {
            NodeList fontList = List2.item(i).getChildNodes();
            j = 0;
            while (j < fontList.getLength()) {
                if (fontList.item(j).getNodeName() == "FONT") {
                    DFont f = new DFont();
                    arg = new Arg(fontList.item(j));
                    this.invokeDoMethod(f, this, arg);
                    if (arg.ret_id != null) {
                        this.fontsId.put(arg.ret_id, f);
                        if (this.fonts == null) {
                            this.fonts = new DFontRegistry();
                        }
                        this.fonts.putFont(f);
                    }
                }
                ++j;
            }
            ++i;
        }
        List2 = dom_doc.getElementsByTagName("STYLES");
        i = 0;
        while (i < List2.getLength()) {
            NodeList styleList = List2.item(i).getChildNodes();
            j = 0;
            while (j < styleList.getLength()) {
                if (styleList.item(j).getNodeName() == "STYLE") {
                    DStyle s = new DStyle();
                    arg = new Arg(styleList.item(j));
                    this.invokeDoMethod(s, this, arg);
                    if (arg.ret_id != null) {
                        this.stylesId.put(arg.ret_id, s);
                        if (this.styles == null) {
                            this.styles = new DStyleRegistry();
                        }
                        this.styles.putStyle(s);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static String decode(String s) {
        if (s == null) {
            return s;
        }
        s = s.replaceAll("&apos;", "'");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&gt;", ">");
        s = s.replaceAll("&quot;", "\"");
        s = s.replaceAll("&amp;", "&");
        return s;
    }

    protected Node getRequiredAttribut(NamedNodeMap attr, String attr_tag, String elt_tag) {
        Node n = attr.getNamedItem(attr_tag);
        if (n == null) {
            throw new DXsdError(String.valueOf(attr_tag) + " attribute not defined while parsing " + elt_tag + " tag");
        }
        return n;
    }

    public void setNodeStyle(NamedNodeMap attr, IDItem item) {
        Node n = attr.getNamedItem("STYLE");
        if (n != null) {
            item.setStyle((IDStyle)this.stylesId.get(n.getNodeValue()));
        }
    }

    public static String getNodeText(Node node) {
        String s = "";
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                String sc = child.getNodeValue();
                s = String.valueOf(s) + DXsdReader.decode(sc);
            }
            child = child.getNextSibling();
        }
        return s;
    }

    protected IDItem createIDItemForNode(Node node) {
        String name;
        if (this.iditem_factories != null) {
            int i = 0;
            while (i < this.iditem_factories.size()) {
                IDItemFactory f = (IDItemFactory)this.iditem_factories.get(i);
                IDItem item = f.createIDItem(node);
                if (item != null) {
                    return item;
                }
                ++i;
            }
        }
        if ((name = node.getNodeName()) == null) {
            return null;
        }
        switch (name.length()) {
            case 3: {
                if (name.equals("TAG")) {
                    return new DTag();
                }
                if (!name.equals("ROW")) break;
                return new DRow();
            }
            case 4: {
                if (name.equals("TEXT")) {
                    return new DText();
                }
                if (name.equals("CELL")) {
                    return new DCell();
                }
                if (name.equals("LIST")) {
                    return new DList();
                }
                if (name.equals("LINK")) {
                    return new DLink();
                }
                if (name.equals("DATA")) {
                    return new DData();
                }
                if (name.equals("AXIS")) {
                    return new DAxis("unnamed");
                }
                if (!name.equals("LINE")) break;
                return new DLine();
            }
            case 5: {
                if (name.equals("COORD")) {
                    return new DCoord(null, 0.0);
                }
                if (name.equals("POINT")) {
                    return new DPoint();
                }
                if (name.equals("IMAGE")) {
                    return new DImage();
                }
                if (name.equals("CURVE")) {
                    return new DCurve();
                }
                if (name.equals("TITLE")) {
                    return new DTitle();
                }
                if (name.equals("TABLE")) {
                    return new DTable();
                }
                if (name.equals("POPUP")) {
                    return new DPopup();
                }
                if (!name.equals("INDEX")) break;
                return new DIndex();
            }
            case 6: {
                if (name.equals("HEADER")) {
                    return new DHeader();
                }
                if (name.equals("FOOTER")) {
                    return new DFooter();
                }
                if (!name.equals("IDITEM")) break;
                NamedNodeMap attr = node.getAttributes();
                Node a_class = this.getRequiredAttribut(attr, "CLASS", "IDITEM");
                String class_name = a_class.getNodeValue();
                try {
                    Class<?> clazz = Class.forName(class_name);
                    Object inst = clazz.newInstance();
                    return (IDItem)inst;
                }
                catch (Exception e) {
                    if (e instanceof InstantiationException) {
                        System.out.println("Can't instanciate class '" + class_name + "',  haven't a public empty constructor ?");
                        return null;
                    }
                    if (!(e instanceof ClassNotFoundException)) break;
                    System.out.println("(W) Unable to instanciate class = " + class_name);
                    break;
                }
            }
            case 7: {
                if (name.equals("GRAPHIC")) {
                    return new DGraphic();
                }
                if (name.equals("SECTION")) {
                    return new DSection();
                }
                if (!name.equals("SUMMARY")) break;
                return new DSummary();
            }
            case 8: {
                if (!name.equals("DOCUMENT")) break;
                return new DDocument();
            }
            case 9: {
                if (name.equals("PARAGRAPH")) {
                    return new DParagraph();
                }
                if (name.equals("CELL_TEXT")) {
                    return new DCellText();
                }
                if (!name.equals("COORD_OBJ")) break;
                return new DCoordObject();
            }
            case 10: {
                if (name.equals("PAGE_BREAK")) {
                    return new DPageBreak();
                }
                if (name.equals("POINT_LINK")) {
                    return new DPointLink();
                }
                if (!name.equals("CURVE_LINK")) break;
                return new DCurveLink();
            }
            default: {
                if (name.equals("INDEX_ENTRY")) {
                    return new DIndexEntry();
                }
                if (!name.equals("PAGE_COUNTER")) break;
                return new DPageCounter();
            }
        }
        System.err.println(String.valueOf(name) + " is unknown in node " + node.getParentNode().getNodeName());
        return null;
    }

    public void _doMethodXsd(DDocument doc, Object arg) {
        this._m("in  _doMethodXsd DDocument");
        Node node = ((Arg)arg).node;
        NamedNodeMap attr = node.getAttributes();
        Node n = attr.getNamedItem("TITLE");
        if (n != null) {
            doc.setTitle(n.getNodeValue());
        } else {
            doc.setTitle("SVG Generator Chart");
        }
        doc.setTag("SVG doc");
        this.setNodeStyle(attr, doc);
        DGraphic chart = new DGraphic();
        this._doMethodXsd(chart, arg);
        doc.addChild(chart);
    }

    public void _axisElementAnalysis(Node confElt) {
        if (this._traceLevel3) {
            this._displayContent((Element)confElt);
        }
        Node axisSet = confElt.getFirstChild();
        while (axisSet != null) {
            if (axisSet.getNodeType() != 3) {
                if ("independentAxis".equals(axisSet.getNodeName())) {
                    this._independentAxisElementAnalysis(axisSet);
                } else if ("primaryDependentAxis".equals(axisSet.getNodeName())) {
                    this._primaryDependentAxisElementAnalysis(axisSet);
                } else if ("secondaryDependentAxis".equals(axisSet.getNodeName())) {
                    this._secondaryDependentAxisElementAnalysis(axisSet);
                } else {
                    System.out.println("Unknown element in Axis" + axisSet.getNodeName());
                }
            }
            axisSet = axisSet.getNextSibling();
        }
    }

    public void _tooltipElementAnalysis(Node n) {
        if (_traceLevel6) {
            this._displayContent((Element)n);
        }
    }

    public void _coordinatesElementAnalysis(Node dataSetElt, DPoint point) {
        this._m("in _coordinatesElementAnalysis");
        if (this._traceLevel5) {
            this._displayContent((Element)dataSetElt);
        }
        Element node = (Element)dataSetElt;
        NamedNodeMap an = node.getAttributes();
        DCoord _storedCoordX = new DCoord();
        DCoord _storedCoordY = new DCoord();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if ("value1".equals(n3.getNodeName())) {
                double _coord1 = Double.parseDouble(n3.getNodeValue());
                DCoord coordX = new DCoord();
                if (n3.getNodeValue() != null) {
                    coordX.setAxis(this._axis1);
                    coordX.setValue(_coord1);
                    this._axis1.getProperties().store("P_MAX.DAxis.core.jscrib", Math.max(_coord1, (double)this._axis1.getProperties().get("P_MAX.DAxis.core.jscrib", 10000)));
                    _storedCoordX = coordX;
                    point.addChild(coordX);
                }
            } else if ("value2".equals(n3.getNodeName())) {
                double _coord2 = Double.parseDouble(n3.getNodeValue());
                DCoord coordY = new DCoord();
                if (n3.getNodeValue() != null) {
                    coordY.setAxis(this._axis2);
                    coordY.setValue(_coord2);
                    _storedCoordY = coordY;
                    this._axis2.getProperties().store("P_MAX.DAxis.core.jscrib", Math.max(_coord2, (double)this._axis2.getProperties().get("P_MAX.DAxis.core.jscrib", 1000)));
                    point.insertChild(coordY, _storedCoordX);
                }
            } else if ("value3".equals(n3.getNodeName())) {
                double _coord3 = Double.parseDouble(n3.getNodeValue());
                DCoord coordZ = new DCoord();
                if (n3.getNodeValue() != null) {
                    coordZ.setAxis(this._axis3);
                    coordZ.setValue(_coord3);
                    this._axis3.getProperties().store("P_MAX.DAxis.core.jscrib", Math.max(_coord3, (double)this._axis3.getProperties().get("P_MAX.DAxis.core.jscrib", 0)));
                    point.insertChild(coordZ, _storedCoordY);
                }
            }
            ++k;
        }
        Node coordinates = dataSetElt.getFirstChild();
        while (coordinates != null) {
            if (!(coordinates.getNodeType() == 3 || "accessibiliy".equals(coordinates.getNodeName()) || "eventHandler".equals(coordinates.getNodeName()) || "tooltip".equals(coordinates.getNodeName()))) {
                System.out.println("unknow Element in coordinates" + coordinates.getNodeName());
            }
            coordinates = coordinates.getNextSibling();
        }
        this._m("exit _coordinatesElementAnalysis");
    }

    public void _dataPointElementAnalysis(Node dataSetElt, HashMap curveMap) {
        if (this._traceLevel5) {
            this._displayContent((Element)dataSetElt);
        }
        String categoryId = "";
        double _coord1 = 0.0;
        DPoint point = new DPoint();
        Element node = (Element)dataSetElt;
        NamedNodeMap an = node.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if ("categoryId".equals(n3.getNodeName())) {
                categoryId = n3.getNodeValue();
            } else if ("value".equals(n3.getNodeName())) {
                _coord1 = Double.parseDouble(n3.getNodeValue());
            } else {
                System.out.println("Unknown attribute in dataPoint => " + n3.getNodeName());
            }
            ++k;
        }
        DCoord coordX = new DCoord();
        coordX.setAxis(this._axis1);
        coordX.setValue(_coord1);
        this._axis1.getProperties().store("P_MAX.DAxis.core.jscrib", Math.max(_coord1, (double)this._axis1.getProperties().get("P_MAX.DAxis.core.jscrib", 10000)));
        point.addChild(coordX);
        Node dataPointElt = dataSetElt.getFirstChild();
        while (dataPointElt != null) {
            if (!(dataPointElt.getNodeType() == 3 || "accessibiliy".equals(dataPointElt.getNodeName()) || "eventHandler".equals(dataPointElt.getNodeName()) || "tooltip".equals(dataPointElt.getNodeName()))) {
                System.out.println("unknow Element in dataPoint" + dataPointElt.getNodeName());
            }
            dataPointElt = dataPointElt.getNextSibling();
        }
        DCurve curve = (DCurve)curveMap.get(categoryId);
        curve.addChild(point);
    }

    public void _dataPointElementAnalysis(Node dataSetElt, DCurve curve, HashMap curveMap) {
        if (this._traceLevel5) {
            this._displayContent((Element)dataSetElt);
        }
        String categoryId = "";
        double _coord1 = 0.0;
        DPoint point = new DPoint();
        Element node = (Element)dataSetElt;
        NamedNodeMap an = node.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if ("categoryId".equals(n3.getNodeName())) {
                categoryId = n3.getNodeValue();
            } else if ("value".equals(n3.getNodeName())) {
                _coord1 = Double.parseDouble(n3.getNodeValue());
            } else {
                System.out.println("Unknown attribute in dataPoint => " + n3.getNodeName());
            }
            ++k;
        }
        DCoord coordX = new DCoord();
        coordX.setAxis(this._axis1);
        coordX.setValue(_coord1);
        this._axis1.getProperties().store("P_MAX.DAxis.core.jscrib", Math.max(_coord1, (double)this._axis1.getProperties().get("P_MAX.DAxis.core.jscrib", 10000)));
        point.addChild(coordX);
        Node dataPointElt = dataSetElt.getFirstChild();
        while (dataPointElt != null) {
            if (!(dataPointElt.getNodeType() == 3 || "accessibiliy".equals(dataPointElt.getNodeName()) || "eventHandler".equals(dataPointElt.getNodeName()) || "tooltip".equals(dataPointElt.getNodeName()))) {
                System.out.println("unknow Element in dataPoint" + dataPointElt.getNodeName());
            }
            dataPointElt = dataPointElt.getNextSibling();
        }
        curve.addChild(point);
        curve.setName(String.valueOf(curve.getName()) + "/" + curveMap.get(categoryId));
    }

    public void _categoriesElementAnalysis(Node dataSetsElt, HashMap curveMap) {
        if (this._traceLevel3) {
            this._displayContent((Element)dataSetsElt);
        }
        this._categoriesFound = true;
        Node categoriesElt = dataSetsElt.getFirstChild();
        while (categoriesElt != null) {
            if (categoriesElt.getNodeType() != 3) {
                if ("category".equals(categoriesElt.getNodeName())) {
                    this._categoryElementAnalysis(categoriesElt, curveMap);
                } else {
                    System.out.println("unknow Element in datcategories" + categoriesElt.getNodeName());
                }
            }
            categoriesElt = categoriesElt.getNextSibling();
        }
    }

    public void _categoryElementAnalysis(Node categoriesElt, HashMap curveMap) {
        if (this._traceLevel4) {
            this._displayContent((Element)categoriesElt);
        }
        String curveId = "";
        String curveLabel = "";
        Element node = (Element)categoriesElt;
        NamedNodeMap an = node.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if ("id".equals(n3.getNodeName())) {
                curveId = n3.getNodeValue();
            } else if ("label".equals(n3.getNodeName())) {
                curveLabel = n3.getNodeValue();
            } else {
                System.out.println("Unknown attribute in category => " + n3.getNodeName());
            }
            ++k;
        }
        if (!this._chartType.equals("T_STACKBARS.DGraphic.core.jscrib")) {
            curveMap.put(curveId, curveLabel);
        } else {
            DCurve newCurve = new DCurve();
            this._createStyleForCurve(newCurve);
            newCurve.setName(curveLabel);
            curveMap.put(curveId, newCurve);
        }
        Node categoryElt = categoriesElt.getFirstChild();
        while (categoryElt != null) {
            if (!(categoryElt.getNodeType() == 3 || "accessibility".equals(categoryElt.getNodeName()) || "eventHandler".equals(categoryElt.getNodeName()) || "tooltip".equals(categoryElt.getNodeName()))) {
                System.out.println("unknow Element in category " + categoryElt.getNodeName());
            }
            categoryElt = categoryElt.getNextSibling();
        }
    }

    public void _dataSetsElementAnalysis(Node dataElt, DGraphic chart, HashMap curveMap) {
        if (this._traceLevel3) {
            this._displayContent((Element)dataElt);
        }
        Node dataSetsElt = dataElt.getFirstChild();
        while (dataSetsElt != null) {
            if (dataSetsElt.getNodeType() != 3) {
                if ("dataSet".equals(dataSetsElt.getNodeName())) {
                    this._dataSetElementAnalysis(dataSetsElt, chart, curveMap);
                } else {
                    System.out.println("Unknown Element in dataSets => " + dataSetsElt.getNodeName());
                }
            }
            dataSetsElt = dataSetsElt.getNextSibling();
        }
    }

    public void _dataElementAnalysis(Node c, DGraphic chart) {
        if (this._traceLevel2) {
            this._displayContent((Element)c);
        }
        HashMap curveMap = new HashMap();
        Node dataElt = c.getFirstChild();
        while (dataElt != null) {
            if (dataElt.getNodeType() != 3 && !"dataSets".equals(dataElt.getNodeName())) {
                if ("categories".equals(dataElt.getNodeName())) {
                    this._categoriesElementAnalysis(dataElt, curveMap);
                } else {
                    System.out.println("Unknown Element in dataSets =>" + dataElt.getNodeName());
                }
            }
            dataElt = dataElt.getNextSibling();
        }
        dataElt = c.getFirstChild();
        while (dataElt != null) {
            if (dataElt.getNodeType() != 3) {
                if ("dataSets".equals(dataElt.getNodeName())) {
                    this._dataSetsElementAnalysis(dataElt, chart, curveMap);
                } else if (!"categories".equals(dataElt.getNodeName())) {
                    System.out.println("Unknown Element in dataSets =>" + dataElt.getNodeName());
                }
            }
            dataElt = dataElt.getNextSibling();
        }
        if (this._chartType.equals("T_STACKBARS.DGraphic.core.jscrib")) {
            Collection curveMapContent = curveMap.values();
            for (DCurve curve : curveMapContent) {
                chart.addChild(curve);
            }
        }
    }

    public void _dataFormatElementAnalysis(Node elt, String _axisNumber) {
        if (this._traceLevel4_5) {
            this._displayContent((Element)elt);
        }
        NamedNodeMap an = elt.getAttributes();
        if (_axisNumber == "axis1" || _axisNumber == "axis" || _axisNumber == "axis3") {
            int k = 0;
            while (k < an.getLength()) {
                Node n3 = an.item(k);
                if ("pattern".equals(n3.getNodeName())) {
                    if (_axisNumber == "axis1") {
                        this._dataFormatAxis1 = n3.getNodeValue();
                    } else if (_axisNumber == "axis2") {
                        this._dataFormatAxis2 = n3.getNodeValue();
                    } else if (_axisNumber == "axis3") {
                        this._dataFormatAxis3 = n3.getNodeValue();
                    }
                } else {
                    System.out.println("Unknon attribute in  numberFormat of " + _axisNumber + " = " + n3.getNodeName());
                }
                ++k;
            }
        } else {
            System.out.println("dataFormat for data");
        }
    }

    public void _primaryDependentAxisElementAnalysis(Node axis) {
        if (this._traceLevel4) {
            this._displayContent((Element)axis);
        }
        this._axis2Found = true;
        NamedNodeMap an = axis.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if ("label".equals(n3.getNodeName())) {
                this._labelAxis2 = n3.getNodeValue();
            } else if (!"id".equals(n3.getNodeName()) && !"scale".equals(n3.getNodeName())) {
                if ("min".equals(n3.getNodeName())) {
                    this._minAxis2 = n3.getNodeValue();
                } else if ("max".equals(n3.getNodeName())) {
                    this._maxAxis2 = n3.getNodeValue();
                } else {
                    System.out.println("Unknon attribute in  primaryDependentAxis = " + n3.getNodeName());
                }
            }
            ++k;
        }
        Node primDepAxis = axis.getFirstChild();
        while (primDepAxis != null) {
            if (primDepAxis.getNodeType() != 3) {
                if ("majorUnit".equals(primDepAxis.getNodeName())) {
                    this._majorUnitElementAnalysis(primDepAxis, "axis2");
                } else if ("minorUnit".equals(primDepAxis.getNodeName())) {
                    this._minorUnitElementAnalysis(primDepAxis, "axis2");
                } else if ("markerLiner".equals(primDepAxis.getNodeName())) {
                    this._markerLineElementAnalysis(primDepAxis, "axis1");
                } else if ("numberFormat".equals(primDepAxis.getNodeName())) {
                    this._numberFormatElementAnalysis(primDepAxis, "axis2");
                } else if ("dataFormat".equals(primDepAxis.getNodeName())) {
                    this._dataFormatElementAnalysis(primDepAxis, "axis2");
                } else if (!("accessibility".equals(primDepAxis.getNodeName()) || "eventHandler".equals(primDepAxis.getNodeName()) || "tooltip".equals(primDepAxis.getNodeName()))) {
                    if ("dataSetAssociations".equals(primDepAxis.getNodeName())) {
                        this._dataSetAssociationsElementAnalysis(primDepAxis, "axis2");
                    } else {
                        System.out.println("Unknown element in PrimaryDependentAxis => " + primDepAxis.getNodeName());
                    }
                }
            }
            primDepAxis = primDepAxis.getNextSibling();
        }
    }

    public void _numberFormatElementAnalysis(Node elt, String _axisNumber) {
        if (this._traceLevel4_5) {
            this._displayContent((Element)elt);
        }
        NamedNodeMap an = elt.getAttributes();
        if (_axisNumber == "axis1" || _axisNumber == "axis" || _axisNumber == "axis3") {
            int k = 0;
            while (k < an.getLength()) {
                Node n3 = an.item(k);
                if ("pattern".equals(n3.getNodeName())) {
                    if (_axisNumber == "axis1") {
                        this._numberFormatAxis1 = n3.getNodeValue();
                    } else if (_axisNumber == "axis2") {
                        this._numberFormatAxis2 = n3.getNodeValue();
                    } else if (_axisNumber == "axis3") {
                        this._numberFormatAxis3 = n3.getNodeValue();
                    }
                } else {
                    System.out.println("Unknon attribute in  numberFormat of " + _axisNumber + " = " + n3.getNodeName());
                }
                ++k;
            }
        } else {
            System.out.println("numberformat for data");
        }
    }

    public void _dataSetAssociationsElementAnalysis(Node elt, String _axisNumber) {
        if (this._traceLevel5) {
            this._displayContent((Element)elt);
        }
        NamedNodeMap an = elt.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if ("dataSetIds".equals(n3.getNodeName())) {
                if (_axisNumber == "axis2") {
                    this._dataSetIdsAxis2 = n3.getNodeValue();
                } else if (_axisNumber == "axis3") {
                    this._dataSetIdsAxis3 = n3.getNodeValue();
                } else {
                    System.out.println("Unknon attribute in  dataSetAssociations = " + n3.getNodeName());
                }
            }
            ++k;
        }
    }

    public void _markerLineElementAnalysis(Node elt, String _axisNumber) {
        if (this._traceLevel5) {
            this._displayContent((Element)elt);
        }
        NamedNodeMap an = elt.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if ("value".equals(n3.getNodeName())) {
                if (_axisNumber == "axis1") {
                    this._markerLineValueAxis1 = n3.getNodeValue();
                } else if (_axisNumber == "axis2") {
                    this._markerLineValueAxis2 = n3.getNodeValue();
                } else if (_axisNumber == "axis3") {
                    this._markerLineValueAxis3 = n3.getNodeValue();
                }
            } else if ("label".equals(n3.getNodeName())) {
                if (_axisNumber == "axis1") {
                    this._markerLineLabelAxis1 = n3.getNodeValue();
                } else if (_axisNumber == "axis2") {
                    this._markerLineLabelAxis2 = n3.getNodeValue();
                } else if (_axisNumber == "axis3") {
                    this._markerLineLabelAxis3 = n3.getNodeValue();
                }
            } else if ("color".equals(n3.getNodeName())) {
                if (_axisNumber == "axis1") {
                    this._markerLineColorAxis1 = n3.getNodeValue();
                } else if (_axisNumber == "axis2") {
                    this._markerLineColorAxis2 = n3.getNodeValue();
                } else if (_axisNumber == "axis3") {
                    this._markerLineColorAxis3 = n3.getNodeValue();
                }
            } else {
                System.out.println("Unknon attribute in  titleBar = " + n3.getNodeName());
            }
            ++k;
        }
    }

    public void _majorUnitElementAnalysis(Node elt, String _axisNumber) {
        if (this._traceLevel5) {
            System.out.println("majorUnit skipped");
            this._displayContent((Element)elt);
        }
        Node unitDef = elt.getFirstChild();
        while (unitDef != null) {
            if (unitDef.getNodeType() != 3) {
                if ("unitDefinition".equals(unitDef.getNodeName())) {
                    this._unitDefinitionElementAnalysis(unitDef, _axisNumber, "majorUnit");
                } else {
                    System.out.println("Unknown element in unitDefinition" + unitDef.getNodeName());
                }
            }
            unitDef = unitDef.getNextSibling();
        }
    }

    public void _minorUnitElementAnalysis(Node elt, String _axisNumber) {
        if (this._traceLevel5) {
            System.out.println("minour8nit skipped");
            this._displayContent((Element)elt);
        }
        Node unitDef = elt.getFirstChild();
        while (unitDef != null) {
            if (unitDef.getNodeType() != 3) {
                if ("unitDefinition".equals(unitDef.getNodeName())) {
                    this._unitDefinitionElementAnalysis(unitDef, _axisNumber, "minorUnit");
                } else {
                    System.out.println("Unknown element in unitDefinition" + unitDef.getNodeName());
                }
            }
            unitDef = unitDef.getNextSibling();
        }
    }

    public void _secondaryDependentAxisElementAnalysis(Node axis) {
        if (this._traceLevel4) {
            this._displayContent((Element)axis);
        }
        this._axis3Found = true;
        NamedNodeMap an = axis.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if ("label".equals(n3.getNodeName())) {
                this._labelAxis3 = n3.getNodeValue();
            } else if (!"id".equals(n3.getNodeName()) && !"scale".equals(n3.getNodeName())) {
                if ("min".equals(n3.getNodeName())) {
                    this._minAxis3 = n3.getNodeValue();
                } else if ("max".equals(n3.getNodeName())) {
                    this._maxAxis3 = n3.getNodeValue();
                } else {
                    System.out.println("Unknon attribute in  secondaryDependentAxis = " + n3.getNodeName());
                }
            }
            ++k;
        }
        Node secDepAxis = axis.getFirstChild();
        while (secDepAxis != null) {
            if (secDepAxis.getNodeType() != 3) {
                if ("majorUnit".equals(secDepAxis.getNodeName())) {
                    this._majorUnitElementAnalysis(secDepAxis, "axis3");
                } else if ("minorUnit".equals(secDepAxis.getNodeName())) {
                    this._minorUnitElementAnalysis(secDepAxis, "axis3");
                } else if ("markerLiner".equals(secDepAxis.getNodeName())) {
                    this._markerLineElementAnalysis(secDepAxis, "axis3");
                } else if ("numberFormat".equals(secDepAxis.getNodeName())) {
                    this._numberFormatElementAnalysis(secDepAxis, "axis2");
                } else if ("dataFormat".equals(secDepAxis.getNodeName())) {
                    this._dataFormatElementAnalysis(secDepAxis, "axis2");
                } else if ("accessibility".equals(secDepAxis.getNodeName())) {
                    this._accessibilityElementAnalysis(secDepAxis);
                } else if ("eventHandler".equals(secDepAxis.getNodeName())) {
                    this._eventHandlerElementAnalysis(secDepAxis);
                } else if ("tooltip".equals(secDepAxis.getNodeName())) {
                    this._tooltipElementAnalysis(secDepAxis);
                } else if ("dataSetAssociations".equals(secDepAxis.getNodeName())) {
                    this._dataSetAssociationsElementAnalysis(secDepAxis, "axis3");
                } else {
                    System.out.println("Unknown element in PrimaryDependentAxis => " + secDepAxis.getNodeName());
                }
            }
            secDepAxis = secDepAxis.getNextSibling();
        }
    }

    public void _independentAxisElementAnalysis(Node axis) {
        if (this._traceLevel4) {
            System.out.println("indepependentAxis study");
            this._displayContent((Element)axis);
        }
        this._axis1Found = true;
        NamedNodeMap an = axis.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if ("label".equals(n3.getNodeName())) {
                this._labelAxis1 = n3.getNodeValue();
            } else if (!"id".equals(n3.getNodeName()) && !"scale".equals(n3.getNodeName())) {
                if ("min".equals(n3.getNodeName())) {
                    this._minAxis1 = n3.getNodeValue();
                } else if ("max".equals(n3.getNodeName())) {
                    this._maxAxis1 = n3.getNodeValue();
                } else {
                    System.out.println("Unknon attribute in  independantAxis = " + n3.getNodeName());
                }
            }
            ++k;
        }
        Node indAxis = axis.getFirstChild();
        while (indAxis != null) {
            if (indAxis.getNodeType() != 3) {
                if ("majorUnit".equals(indAxis.getNodeName())) {
                    this._majorUnitElementAnalysis(indAxis, "axis1");
                } else if ("minorUnit".equals(indAxis.getNodeName())) {
                    this._minorUnitElementAnalysis(indAxis, "axis1");
                } else if ("markerLiner".equals(indAxis.getNodeName())) {
                    this._markerLineElementAnalysis(indAxis, "axis1");
                } else if ("numberFormat".equals(indAxis.getNodeName())) {
                    this._numberFormatElementAnalysis(indAxis, "axis1");
                } else if ("dataFormat".equals(indAxis.getNodeName())) {
                    this._dataFormatElementAnalysis(indAxis, "axis1");
                } else if (!("accessibility".equals(indAxis.getNodeName()) || "eventHandler".equals(indAxis.getNodeName()) || "tooltip".equals(indAxis.getNodeName()))) {
                    System.out.println("Unknown element in independentAxis => " + indAxis.getNodeName());
                }
            }
            indAxis = indAxis.getNextSibling();
        }
    }

    public void _sizeElementAnalysis(Node confElt) {
        if (this._traceLevel3) {
            this._displayContent((Element)confElt);
        }
        NamedNodeMap an = confElt.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if (!"wight".equals(n3.getNodeName()) && !"height".equals(n3.getNodeName())) {
                System.out.println("Unknon attribute in  size = " + n3.getNodeName());
            }
            ++k;
        }
    }

    public void _titleBarElementAnalysis(Node confElt) {
        if (this._traceLevel3) {
            this._displayContent((Element)confElt);
        }
        NamedNodeMap an = confElt.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if ("label".equals(n3.getNodeName())) {
                this._titleBar = n3.getNodeValue();
            } else if (!"withSeparator".equals(n3.getNodeName()) && !"backgroundcolor".equals(n3.getNodeName()) && "show".equals(n3.getNodeName())) {
                if ("false".equals(n3.getNodeValue())) {
                    this._showTitleBar = false;
                } else {
                    System.out.println("Unknon attribute in  titleBar = " + n3.getNodeName());
                }
            }
            ++k;
        }
        Node titleBarElt = confElt.getFirstChild();
        while (titleBarElt != null) {
            if (!(titleBarElt.getNodeType() == 3 || "accessibiliy".equals(titleBarElt.getNodeName()) || "eventHandler".equals(titleBarElt.getNodeName()) || "tooltip".equals(titleBarElt.getNodeName()))) {
                System.out.println("unknow Element in titleBar" + titleBarElt.getNodeName());
            }
            titleBarElt = titleBarElt.getNextSibling();
        }
    }

    public void _createStyleForCurve(DCurve curve) {
        this._m("in _createStypeForCurve");
        DStyle style = new DStyle();
        style.setBackColor(new DColor(this._lastRValue, this._lastGValue, this._lastBValue));
        this._lastRValue += 10;
        this._lastGValue += 50;
        this._lastBValue += 100;
        curve.setStyle(style);
    }

    public void _internationalizationElementAnalysis(Node elt) {
        if (this._traceLevel3) {
            this._displayContent((Element)elt);
        }
    }

    public void _unitDefinitionElementAnalysis(Node elt, String _axisNumber, String _categoryUnit) {
        if (_traceLevel6) {
            this._displayContent((Element)elt);
        }
        NamedNodeMap an = elt.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if (!("value".equals(n3.getNodeName()) || "showTick".equals(n3.getNodeName()) || "showGridLine".equals(n3.getNodeName()))) {
                System.out.println("Unknon attribute in  titleBar = " + n3.getNodeName());
            }
            ++k;
        }
    }

    public void _valueUnitDefinitionAttributeAnalysis(String _categoryUnit, String _axisNumber, String value) {
        if (_categoryUnit == "majorUnit") {
            if (_axisNumber == "axe1") {
                this._valueMajorUnitAxis1 = value;
            } else if (_axisNumber == "axe2") {
                this._valueMajorUnitAxis2 = value;
            } else if (_axisNumber == "axe3") {
                this._valueMajorUnitAxis3 = value;
            }
        } else if (_categoryUnit == "minorUnit") {
            if (_axisNumber == "axe1") {
                this._valueMinorUnitAxis1 = value;
            } else if (_axisNumber == "axe2") {
                this._valueMinorUnitAxis2 = value;
            } else if (_axisNumber == "axe3") {
                this._valueMinorUnitAxis3 = value;
            }
        }
    }

    public void _showGridUnitDefinitionAttributeAnalysis(String _categoryUnit, String _axisNumber, String _showGridValue) {
        if (_categoryUnit == "majorUnit") {
            if (_showGridValue == "true") {
                if (_axisNumber == "axe1") {
                    this._showGridLineMajorUnitAxis1 = true;
                } else if (_axisNumber == "axe2") {
                    this._showGridLineMajorUnitAxis2 = true;
                } else if (_axisNumber == "axe3") {
                    this._showGridLineMajorUnitAxis3 = true;
                }
            } else if (_categoryUnit == "minorUnit" && _showGridValue == "true") {
                if (_axisNumber == "axe1") {
                    this._showGridLineMinorUnitAxis1 = true;
                } else if (_axisNumber == "axe2") {
                    this._showGridLineMinorUnitAxis2 = true;
                } else if (_axisNumber == "axe3") {
                    this._showGridLineMinorUnitAxis3 = true;
                }
            }
        }
    }

    public void _showTickUnitDefinitionAttributeAnalysis(String _categoryUnit, String _axisNumber, String _showGridValue) {
        if (_categoryUnit == "majorUnit") {
            if (_showGridValue == "true") {
                if (_axisNumber == "axe1") {
                    this._showTickMajorUnitAxis1 = true;
                } else if (_axisNumber == "axe2") {
                    this._showTickMajorUnitAxis2 = true;
                } else if (_axisNumber == "axe3") {
                    this._showTickMajorUnitAxis3 = true;
                }
            } else if (_categoryUnit == "minorUnit" && _showGridValue == "true") {
                if (_axisNumber == "axe1") {
                    this._showTickMinorUnitAxis1 = true;
                } else if (_axisNumber == "axe2") {
                    this._showTickMinorUnitAxis2 = true;
                } else if (_axisNumber == "axe3") {
                    this._showTickMinorUnitAxis3 = true;
                }
            }
        }
    }

    public void _dataValueElementAnalysis(Node confElt) {
        if (this._traceLevel3) {
            this._displayContent((Element)confElt);
        }
        Node dataValueElt = confElt.getFirstChild();
        while (dataValueElt != null) {
            if (dataValueElt.getNodeType() != 3) {
                if ("numberFormat".equals(dataValueElt.getNodeName())) {
                    this._numberFormatElementAnalysis(dataValueElt, "datavalue");
                } else {
                    System.out.println("unknow Element in datavalue" + dataValueElt.getNodeName());
                }
            }
            dataValueElt = dataValueElt.getNextSibling();
        }
    }

    public void _eventHandlerElementAnalysis(Node n) {
        if (_traceLevel6) {
            this._displayContent((Element)n);
        }
    }

    public void _legendElementAnalysis(Node confElt) {
        if (this._traceLevel3) {
            this._displayContent((Element)confElt);
        }
        NamedNodeMap an = confElt.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if (!("id".equals(n3.getNodeName()) || "backgroundColor".equals(n3.getNodeName()) || "location".equals(n3.getNodeName()) || "title".equals(n3.getNodeName()) || "wight".equals(n3.getNodeName()) || "height".equals(n3.getNodeName()) || !"show".equals(n3.getNodeName()))) {
                if ("false".equals(n3.getNodeValue())) {
                    this._showLegend = false;
                } else {
                    System.out.println("Unknown attribute in Legend = " + n3.getNodeName());
                }
            }
            ++k;
        }
    }

    public void _timestampElementAnalysis(Node confElt) {
        if (this._traceLevel3) {
            this._displayContent((Element)confElt);
        }
        NamedNodeMap an = confElt.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if (!"show".equals(n3.getNodeName()) && !"prefix".equals(n3.getNodeName())) {
                System.out.println("Unknon attribute in  timestamp = " + n3.getNodeName());
            }
            ++k;
        }
        Node timestampElt = confElt.getFirstChild();
        while (timestampElt != null) {
            if (timestampElt.getNodeType() != 3) {
                if ("dataFormat".equals(timestampElt.getNodeName())) {
                    this._dataFormatElementAnalysis(timestampElt, "timestamp");
                } else {
                    System.out.println("unknow Element in timestamp" + timestampElt.getNodeName());
                }
            }
            timestampElt = timestampElt.getNextSibling();
        }
    }

    public void _chartAreaElementAnalysis(Node confElt) {
        if (this._traceLevel3) {
            this._displayContent((Element)confElt);
        }
        Node chartAreaElt = confElt.getFirstChild();
        while (chartAreaElt != null) {
            if (chartAreaElt.getNodeType() != 3) {
                if ("accessibiliy".equals(chartAreaElt.getNodeName())) {
                    this._accessibilityElementAnalysis(chartAreaElt);
                } else if ("eventHandler".equals(chartAreaElt.getNodeName())) {
                    this._eventHandlerElementAnalysis(chartAreaElt);
                } else if ("tooltip".equals(chartAreaElt.getNodeName())) {
                    this._tooltipElementAnalysis(chartAreaElt);
                } else {
                    System.out.println("unknow Element in chartArea" + chartAreaElt.getNodeName());
                }
            }
            chartAreaElt = chartAreaElt.getNextSibling();
        }
    }

    public void _plotAreaElementAnalysis(Node n) {
        if (this._traceLevel3) {
            this._displayContent((Element)n);
        }
    }

    public void _configurationElementAnalysis(Node c) {
        if (this._traceLevel2) {
            this._displayContent((Element)c);
        }
        Node confElt = c.getFirstChild();
        while (confElt != null) {
            if (confElt.getNodeType() != 3 && !"internationalization".equals(confElt.getNodeName()) && !"size".equals(confElt.getNodeName())) {
                if ("titleBar".equals(confElt.getNodeName())) {
                    this._titleBarElementAnalysis(confElt);
                } else if ("axes".equals(confElt.getNodeName())) {
                    this._axisElementAnalysis(confElt);
                } else if (!("dataValue".equals(confElt.getNodeName()) || "legend".equals(confElt.getNodeName()) || "timestamp".equals(confElt.getNodeName()) || "chartArea".equals(confElt.getNodeName()) || "plotArea".equals(confElt.getNodeName()) || "shapes".equals(confElt.getNodeName()) || "paletes".equals(confElt.getNodeName()) || "preferences".equals(confElt.getNodeName()) || "scripts".equals(confElt.getNodeName()))) {
                    System.out.println("Unknown element in configuration => " + confElt.getNodeName());
                }
            }
            confElt = confElt.getNextSibling();
        }
    }

    public void _shapesElementAnalysis(Node n) {
    }

    public void _palettesElementAnalysis(Node n) {
        if (this._traceLevel3) {
            this._displayContent((Element)n);
        }
    }

    public void _preferencesElementAnalysis(Node confElt) {
        if (this._traceLevel3) {
            this._displayContent((Element)confElt);
        }
        NamedNodeMap an = confElt.getAttributes();
        int k = 0;
        while (k < an.getLength()) {
            Node n3 = an.item(k);
            if (!("url".equals(n3.getNodeName()) || "show".equals(n3.getNodeName()) || "browserCockiesString".equals(n3.getNodeName()) || "updatePreferenceVariable".equals(n3.getNodeName()) || "storedPreferences".equals(n3.getNodeName()))) {
                System.out.println("Unknon attribute in  preferences = " + n3.getNodeName());
            }
            ++k;
        }
        Node preferencesElt = confElt.getFirstChild();
        while (preferencesElt != null) {
            if (preferencesElt.getNodeType() != 3) {
                if ("tooltip".equals(preferencesElt.getNodeName())) {
                    this._tooltipElementAnalysis(preferencesElt);
                } else {
                    System.out.println("unknow Element in preferences" + preferencesElt.getNodeName());
                }
            }
            preferencesElt = preferencesElt.getNextSibling();
        }
    }

    public void _scriptsElementAnalysis(Node confElt) {
        if (this._traceLevel3) {
            this._displayContent((Element)confElt);
        }
        Node scriptsElt = confElt.getFirstChild();
        while (scriptsElt != null) {
            if (scriptsElt.getNodeType() != 3) {
                if ("ecmascript".equals(scriptsElt.getNodeName())) {
                    this._ecmascriptElementAnalysis(scriptsElt);
                } else {
                    System.out.println("unknow Element in scripts" + scriptsElt.getNodeName());
                }
            }
            scriptsElt = scriptsElt.getNextSibling();
        }
    }

    public void _ecmascriptElementAnalysis(Node scriptsElt) {
        this._displayContent((Element)scriptsElt);
    }

    public void _dataSetElementAnalysis(Node dataSetsElt, DGraphic chart, HashMap curveMap) {
        if (this._traceLevel4) {
            this._displayContent((Element)dataSetsElt);
        }
        if (this._categoriesFound) {
            String _curveName = "Unknown curve name ";
            Element node = (Element)dataSetsElt;
            NamedNodeMap an = node.getAttributes();
            int k = 0;
            while (k < an.getLength()) {
                Node n3 = an.item(k);
                if ("label".equals(n3.getNodeName())) {
                    _curveName = n3.getNodeValue();
                }
                ++k;
            }
            Node dataSetElt = dataSetsElt.getFirstChild();
            while (dataSetElt != null) {
                if (dataSetElt.getNodeType() != 3 && "dataPoint".equals(dataSetElt.getNodeName())) {
                    if (!this._chartType.equals("T_STACKBARS.DGraphic.core.jscrib")) {
                        DCurve curve = new DCurve();
                        this._createStyleForCurve(curve);
                        curve.setName(_curveName);
                        this._dataPointElementAnalysis(dataSetElt, curve, curveMap);
                        chart.addChild(curve);
                    } else {
                        this._dataPointElementAnalysis(dataSetElt, curveMap);
                    }
                }
                dataSetElt = dataSetElt.getNextSibling();
            }
        } else {
            String _curveName = "Unknown curve name ";
            DCurve curve = new DCurve();
            Element node = (Element)dataSetsElt;
            NamedNodeMap an = node.getAttributes();
            int k = 0;
            while (k < an.getLength()) {
                Node n3 = an.item(k);
                if ("label".equals(n3.getNodeName())) {
                    _curveName = n3.getNodeValue();
                }
                ++k;
            }
            this._createStyleForCurve(curve);
            curve.setName(_curveName);
            if (this._chartType.equals("T_XY.DGraphic.core.jscrib")) {
                // empty if block
            }
            if (this._inputXsdChartType.equals("area")) {
                curve.setType("AREA_LINE_POINTS.DCurve.core.jscrib");
            } else if (this._inputXsdChartType.equals("line")) {
                curve.setType("LINE.DCurve.core.jscrib");
            } else if (this._inputXsdChartType.equals("scatter")) {
                curve.setType("POINT.DCurve.core.jscrib");
            } else if (this._inputXsdChartType.equals("stackedArea")) {
                curve.setType("STACKED_AREA_LINE_POINTS.DCurve.core.jscrib");
            }
            Node dataSetElt = dataSetsElt.getFirstChild();
            while (dataSetElt != null) {
                if (dataSetElt.getNodeType() != 3) {
                    if ("coordinates".equals(dataSetElt.getNodeName())) {
                        DPoint _newPoint = new DPoint();
                        this._coordinatesElementAnalysis(dataSetElt, _newPoint);
                        curve.addChild(_newPoint);
                    } else if (!("accessibiliy".equals(dataSetElt.getNodeName()) || "eventHandler".equals(dataSetElt.getNodeName()) || "tooltip".equals(dataSetElt.getNodeName()))) {
                        System.out.println("unknown element in dataSets" + dataSetElt.getNodeName());
                    }
                }
                dataSetElt = dataSetElt.getNextSibling();
            }
            if (!this._chartType.equals("T_STACKBARS.DGraphic.core.jscrib")) {
                chart.addChild(curve);
            }
        }
    }

    public void _accessibilityElementAnalysis(Node n) {
        if (_traceLevel6) {
            this._displayContent((Element)n);
        }
    }

    public void _axisInformation() {
        System.out.println("axe 1 " + this._axis1Found + " " + this._labelAxis1 + " " + this._minAxis1 + " " + this._maxAxis1);
        System.out.println("grid " + this._showGridLineMajorUnitAxis1);
        System.out.println("gridMajorUnit " + this._showGridLineMinorUnitAxis1);
        System.out.println("gridMinorUnit " + this._showTickMajorUnitAxis1);
        System.out.println("tick " + this._showTickMinorUnitAxis1);
        System.out.println("value Major Unit " + this._valueMajorUnitAxis1);
        System.out.println("value Minor Unit" + this._valueMinorUnitAxis1);
        System.out.println("markerLine " + this._markerLineValueAxis1);
        System.out.println("marker line label " + this._markerLineLabelAxis1);
        System.out.println("marker line color " + this._markerLineColorAxis1);
        System.out.println("number format " + this._numberFormatAxis1);
        System.out.println("data format " + this._dataFormatAxis1);
        System.out.println("dataSetIds (axes 2 and 3)" + this._dataSetIdsAxis1);
        System.out.println("axe 2 " + this._axis2Found + " " + this._labelAxis2 + " " + this._minAxis2 + " " + this._maxAxis2);
        System.out.println("grid " + this._showGridLineMajorUnitAxis2);
        System.out.println("gridMajorUnit " + this._showGridLineMinorUnitAxis2);
        System.out.println("gridMinorUnit " + this._showTickMajorUnitAxis2);
        System.out.println("tick " + this._showTickMinorUnitAxis2);
        System.out.println("value Major Unit " + this._valueMajorUnitAxis2);
        System.out.println("value Minor Unit" + this._valueMinorUnitAxis2);
        System.out.println("markerLine " + this._markerLineValueAxis2);
        System.out.println("marker line label " + this._markerLineLabelAxis2);
        System.out.println("marker line color " + this._markerLineColorAxis2);
        System.out.println("number format " + this._numberFormatAxis2);
        System.out.println("data format " + this._dataFormatAxis2);
        System.out.println("dataSetIds (axes 2 and 3)" + this._dataSetIdsAxis2);
        System.out.println("axe 3 " + this._axis3Found + " " + this._labelAxis3 + " " + this._minAxis3 + " " + this._maxAxis3);
        System.out.println("grid " + this._showGridLineMajorUnitAxis3);
        System.out.println("gridMajorUnit " + this._showGridLineMinorUnitAxis3);
        System.out.println("gridMinorUnit " + this._showTickMajorUnitAxis3);
        System.out.println("tick " + this._showTickMinorUnitAxis3);
        System.out.println("value Major Unit " + this._valueMajorUnitAxis3);
        System.out.println("value Minor Unit" + this._valueMinorUnitAxis3);
        System.out.println("markerLine " + this._markerLineValueAxis3);
        System.out.println("marker line label " + this._markerLineLabelAxis3);
        System.out.println("marker line color " + this._markerLineColorAxis3);
        System.out.println("number format " + this._numberFormatAxis3);
        System.out.println("data format " + this._dataFormatAxis3);
        System.out.println("dataSetIds (axes 2 and 3)" + this._dataSetIdsAxis3);
    }

    public void _doMethodXsd(DGraphic chart, Object the_arg) {
        this._m("in _doMethodXsd DGraphic");
        Arg arg = (Arg)the_arg;
        NamedNodeMap attr = arg.node.getAttributes();
        if ("horizontalBar".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue()) || "horizontalBar3D".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue())) {
            this._chartType = "T_HBARS.DGraphic.core.jscrib";
        } else if ("verticalBar".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue()) || "verticalBar3D".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue())) {
            this._chartType = "T_HISTOGRAM.DGraphic.core.jscrib";
        } else if ("meter".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue())) {
            this._chartType = "T_METER.DGraphic.core.jscrib";
        } else if ("pie".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue())) {
            this._chartType = "T_SECTORS.DGraphic.core.jscrib";
        } else if ("pie3D".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue())) {
            this._chartType = "T_SECTORS3D.DGraphic.core.jscrib";
        } else if ("verticalStackedBar".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue()) || "horizontalStackedBar".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue()) || "verticalStackedBar3D".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue()) || "horizontalStackedBar3D".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue())) {
            this._chartType = "T_STACKBARS.DGraphic.core.jscrib";
        } else if ("area".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue()) || "line".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue()) || "scatter".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue()) || "stackedArea".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue())) {
            this._chartType = "T_XY.DGraphic.core.jscrib";
        } else {
            System.out.println("Unknown Xsd chart type : " + this.getRequiredAttribut(attr, "type", "chart").getNodeValue());
        }
        this._inputXsdChartType = this.getRequiredAttribut(attr, "type", "chart").getNodeValue();
        if ("horizontalBar3D".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue()) || "verticalBar3D".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue()) || "pie3D".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue()) || "verticalStackedBar3D".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue()) || "horizontalStackedBar3D".equals(this.getRequiredAttribut(attr, "type", "chart").getNodeValue())) {
            this._chart3D = true;
        }
        Node c = arg.node.getFirstChild();
        while (c != null) {
            if (this._traceLevel1) {
                this._displayContent((Element)c);
            }
            if (c.getNodeType() != 3 && !"data".equals(c.getNodeName())) {
                if ("configuration".equals(c.getNodeName())) {
                    this._configurationElementAnalysis(c);
                } else {
                    System.out.println("Unknown element in chart => " + c.getNodeName());
                }
            }
            c = c.getNextSibling();
        }
        if (this._trace) {
            this._axisInformation();
        }
        chart.setTitle(this._titleBar);
        chart.setGraphicType(this._chartType);
        chart.getProperties().store("P_SHOW_TITLED.DGraphic.core.jscrib", this._showTitleBar);
        chart.getProperties().store("P_3D.DGraphic.core.jscrib", this._chart3D);
        chart.getProperties().store("P_SHOW_LEGEND.DGraphic.core.jscrib", this._showLegend);
        this._doMethodXsdAxisGeneration(chart);
        c = arg.node.getFirstChild();
        while (c != null) {
            if (this._traceLevel1) {
                this._displayContent((Element)c);
            }
            if (c.getNodeType() != 3) {
                if ("data".equals(c.getNodeName())) {
                    this._dataElementAnalysis(c, chart);
                } else if (!"configuration".equals(c.getNodeName())) {
                    System.out.println("Unknown element in chart => " + c.getNodeName());
                }
            }
            c = c.getNextSibling();
        }
    }

    public void _doMethodXsdAxisGeneration(DGraphic chart) {
        this._m("in _doMethodXsd for DAxis");
        if (!this._axis1Found && !this._axis2Found) {
            DAxis axis1 = new DAxis("x");
            axis1.getProperties().store("P_MIN.DAxis.core.jscrib", 0);
            axis1.getProperties().store("P_MAX.DAxis.core.jscrib", 1);
            axis1.setTitle("Unknown Label for Axis y");
            this._axis1 = axis1;
            chart.addChild(axis1);
            this._axis1Found = true;
        } else {
            DAxis axis2;
            if (this._axis1Found && "horizontalBar3D".equals(this._inputXsdChartType)) {
                this._axis1Found = false;
            }
            if (this._axis1Found) {
                DAxis axis1 = new DAxis("x");
                this._m("Axis1 created");
                if (this._labelAxis1 != null) {
                    axis1.setTitle(this._labelAxis1);
                } else {
                    axis1.setTitle("Unknown Label for Axis x");
                }
                if (this._minAxis1 != null) {
                    axis1.getProperties().store("P_MIN.DAxis.core.jscrib", Double.parseDouble(this._minAxis1));
                } else {
                    axis1.getProperties().store("P_MIN.DAxis.core.jscrib", 0);
                }
                if (this._maxAxis1 != null) {
                    axis1.getProperties().store("P_MAX.DAxis.core.jscrib", Double.parseDouble(this._maxAxis1));
                } else {
                    axis1.getProperties().store("P_MAX.DAxis.core.jscrib", 1);
                }
                this._axis1 = axis1;
                chart.addChild(axis1);
            }
            if (this._chartType.equals("T_XY.DGraphic.core.jscrib") || this._chartType.equals("T_HBARS.DGraphic.core.jscrib") || this._chartType.equals("T_STACKBARS.DGraphic.core.jscrib") || this._chartType.equals("T_HISTOGRAM.DGraphic.core.jscrib")) {
                if (this._axis2Found) {
                    if (this._axis1Found) {
                        axis2 = new DAxis("y");
                        if (this._minAxis2 != null) {
                            axis2.getProperties().store("P_MIN.DAxis.core.jscrib", Double.parseDouble(this._minAxis2));
                        } else {
                            axis2.getProperties().store("P_MIN.DAxis.core.jscrib", 0);
                        }
                        if (this._maxAxis2 != null) {
                            axis2.getProperties().store("P_MAX.DAxis.core.jscrib", Double.parseDouble(this._maxAxis2));
                        } else {
                            axis2.getProperties().store("P_MAX.DAxis.core.jscrib", 1);
                        }
                        if (this._labelAxis2 != null) {
                            axis2.setTitle(this._labelAxis2);
                        } else {
                            axis2.setTitle("Unknown Label for Axis y");
                        }
                        this._axis2 = axis2;
                        chart.addChild(axis2);
                    } else {
                        DAxis axis1bis = new DAxis("x");
                        if (this._chartType.equals("T_HISTOGRAM.DGraphic.core.jscrib")) {
                            axis1bis.setName("y");
                        }
                        if (this._minAxis2 != null) {
                            axis1bis.getProperties().store("P_MIN.DAxis.core.jscrib", Double.parseDouble(this._minAxis2));
                        } else {
                            axis1bis.getProperties().store("P_MIN.DAxis.core.jscrib", 0);
                        }
                        if (this._maxAxis2 != null) {
                            axis1bis.getProperties().store("P_MAX.DAxis.core.jscrib", Double.parseDouble(this._maxAxis2));
                        } else {
                            axis1bis.getProperties().store("P_MAX.DAxis.core.jscrib", 1);
                        }
                        if (this._labelAxis2 != null) {
                            axis1bis.setTitle(this._labelAxis2);
                        } else {
                            axis1bis.setTitle("Unknown Label for Axis x");
                        }
                        this._axis1 = axis1bis;
                        chart.addChild(axis1bis);
                    }
                }
            } else {
                axis2 = new DAxis("y");
                axis2.getProperties().store("P_MIN.DAxis.core.jscrib", 0);
                axis2.getProperties().store("P_MAX.DAxis.core.jscrib", 1);
                axis2.setTitle("Unknown Label for Axis y");
                this._axis2 = axis2;
                chart.addChild(axis2);
            }
        }
        this._m("exit _doMethodXsd for Daxis ");
    }

    protected Object createObjectForClassName(String class_name, Node node) {
        block28: {
            Class<?> c;
            block27: {
                block26: {
                    c = Class.forName(class_name);
                    if (c == String.class) {
                        return DXsdReader.getNodeText(node);
                    }
                    if (c == Byte.class) {
                        return Byte.decode(DXsdReader.getNodeText(node));
                    }
                    if (c == Short.class) {
                        return Short.decode(DXsdReader.getNodeText(node));
                    }
                    if (c == Integer.class) {
                        return Integer.decode(DXsdReader.getNodeText(node));
                    }
                    if (c == Long.class) {
                        return Long.decode(DXsdReader.getNodeText(node));
                    }
                    if (c == Float.class) {
                        return Float.valueOf(DXsdReader.getNodeText(node));
                    }
                    if (c == Double.class) {
                        return Double.valueOf(DXsdReader.getNodeText(node));
                    }
                    if (c == Boolean.class) {
                        return Boolean.valueOf(DXsdReader.getNodeText(node));
                    }
                    if (IDColor.class.isAssignableFrom(c)) {
                        return this.colorsId.get(DXsdReader.getNodeText(node));
                    }
                    if (IDFont.class.isAssignableFrom(c)) {
                        return this.fontsId.get(DXsdReader.getNodeText(node));
                    }
                    if (IDFont.class.isAssignableFrom(c)) {
                        return this.stylesId.get(DXsdReader.getNodeText(node));
                    }
                    if (!IDStringSerializable.class.isAssignableFrom(c)) break block26;
                    try {
                        IDStringSerializable v = (IDStringSerializable)c.newInstance();
                        Arg arg = new Arg(node);
                        this.invokeDoMethod(v, this, arg);
                        return v;
                    }
                    catch (Exception e) {
                        if (!(e instanceof InstantiationException)) break block26;
                        System.out.println("IDStringSerializable class should have an empty public constructor");
                        return null;
                    }
                }
                if (!IDXsdSerializable.class.isAssignableFrom(c)) break block27;
                try {
                    IDXsdSerializable v = (IDXsdSerializable)c.newInstance();
                    Arg arg = new Arg(node);
                    this.invokeDoMethod(v, this, arg);
                    return v;
                }
                catch (Exception e) {
                    if (e instanceof InstantiationException) {
                        System.out.println("IDXmlSerializable class should have an empty public constructor");
                        return null;
                    }
                }
            }
            try {
                if (c == Class.class) {
                    return Class.forName(DXsdReader.getNodeText(node));
                }
                if (c == DecimalFormat.class) {
                    return new DecimalFormat(DXsdReader.getNodeText(node));
                }
                if (c == SimpleDateFormat.class) {
                    return new SimpleDateFormat(DXsdReader.getNodeText(node));
                }
                if (c == Date.class) {
                    try {
                        return new Date(Long.parseLong(DXsdReader.getNodeText(node)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new DXsdError("Failed to parse Date");
                    }
                }
                System.err.println("(W) don't know how to handle property class '" + c.getName() + "'");
            }
            catch (Exception e) {
                if (!(e instanceof ClassNotFoundException)) break block28;
                System.out.println("(W) Unable to instanciate class = " + class_name);
            }
        }
        return null;
    }

    public static class Arg {
        public Node node;
        public String[] filter_children;
        public String ret_id;

        public Arg(Node n) {
            this.node = n;
            this.ret_id = null;
        }

        public boolean filterChildren(String node_name) {
            if (this.filter_children == null) {
                return false;
            }
            int i = 0;
            while (i < this.filter_children.length) {
                String s = this.filter_children[i];
                if (s != null && s.equals(node_name)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    public static interface IDItemFactory {
        public IDItem createIDItem(Node var1);
    }
}

