/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.extension.internal;

import org.eclipse.tptp.platform.report.extension.internal.DExtensible;
import org.eclipse.tptp.platform.report.extension.internal.DExtensionRegistry;
import org.eclipse.tptp.platform.report.extension.internal.IDExtension;

public class DExtensibleTest1
extends DExtensible {
    private static void testTwoSameExtension() {
        System.out.println("Test: Extension overide");
        Extension1 ext1 = new Extension1();
        Extension2 ext2 = new Extension2();
        DExtensionRegistry.addExtension(ext1, DExtensibleTest1.class);
        DExtensionRegistry.addExtension(ext2, DExtensibleTest1.class);
        DExtensibleTest1 e = new DExtensibleTest1();
        AClass c = new AClass(-1);
        e.invokeDoMethod(c, e, null);
        if (c.value != 2) {
            System.out.println(">> FAILED");
        } else {
            System.out.println("   OK");
        }
        DExtensionRegistry.removeExtension(ext1);
        DExtensionRegistry.removeExtension(ext2);
    }

    private static void testDoMethodRedefinision() {
        System.out.println("Test: doMethod() redefinition without updating DExtensible");
        Extension1 ext1 = new Extension1();
        Extension1_1 ext2 = new Extension1_1();
        System.out.println("-With ext1 registered:");
        DExtensionRegistry.addExtension(ext1, DExtensibleTest1.class);
        DExtensibleTest1 e = new DExtensibleTest1();
        AClass c = new AClass(-1);
        e.invokeDoMethod(c, e, null);
        if (c.value != 1) {
            System.out.println(">> FAILED");
        } else {
            System.out.println("   OK");
        }
        DExtensionRegistry.removeExtension(ext1);
        System.out.println("-With ext1_1 registered:");
        DExtensionRegistry.addExtension(ext2, DExtensibleTest1.class);
        e = new DExtensibleTest1();
        c.value = -1;
        e.invokeDoMethod(c, e, null);
        if (c.value != 11) {
            System.out.println(">> FAILED");
        } else {
            System.out.println("   OK");
        }
        DExtensionRegistry.removeExtension(ext2);
    }

    public static void main(String[] argv) {
        DExtensibleTest1.testTwoSameExtension();
        DExtensibleTest1.testDoMethodRedefinision();
    }

    private static class AClass {
        public int value;

        public AClass(int v) {
            this.value = v;
        }
    }

    public static class Extension1
    implements IDExtension {
        public static final int Value = 1;

        public void updateExtensible(DExtensible ext) {
            if (ext.getClass() == DExtensibleTest1.class) {
                ext.installDoMethods(this);
            }
        }

        public void doMethod(AClass c, DExtensible ext, Object o_arg) {
            System.out.println(" Extension1.doMethod(AClass,,)");
            c.value = 1;
        }
    }

    public static class Extension1_1
    extends Extension1 {
        public static final int Value = 11;

        public void doMethod(AClass c, DExtensible ext, Object o_arg) {
            System.out.println(" Extension1_1.doMethod(AClass,,)");
            c.value = 11;
        }
    }

    public static class Extension2
    implements IDExtension {
        public static final int Value = 2;

        public void updateExtensible(DExtensible ext) {
            ext.installDoMethods(this);
        }

        public void doMethod(AClass c, DExtensible ext, Object o_arg) {
            System.out.println(" Extension2.doMethod(AClass,,)");
            c.value = 2;
        }
    }
}

