/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.alg.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.ModelMap;
import org.eclipse.tptp.platform.report.igc.alg.internal.OvalAlg;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IVector;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.Vector;

public class CircleAlg {
    protected int cx_;
    protected int cy_;
    protected double arc_start_;
    protected double arc_length_;
    protected Model model_;
    protected int istart_;
    protected int iend_;
    protected int ostart_;
    protected int oend_;
    protected static ModelMap models_ = new ModelMap(5, 50, 10);
    protected int curr_index_;
    protected int curr_octant_;
    protected Vector vector_ = new Vector();
    protected byte state_;
    private int curr_ptx_;
    private int curr_pty_;
    private float curr_tgx_;
    private float curr_tgy_;
    private int cnt;

    public CircleAlg() {
        this.setCircle(0, 0, 0);
    }

    public CircleAlg(int cx, int cy, int radius) {
        this.setCircle(cx, cy, radius);
    }

    public CircleAlg(int cx, int cy, int radius, double arc_start, double arc_length) {
        this.setArc(cx, cy, radius, arc_start, arc_length);
    }

    public CircleAlg(CircleAlg c) {
        this.setCircle(c);
    }

    public void setCircle(int cx, int cy, int radius) {
        this.cx_ = cx;
        this.cy_ = cy;
        this.arc_start_ = 0.0;
        this.arc_length_ = Math.PI * 2;
        this.model_ = CircleAlg.GetModel(radius);
        this.istart_ = 0;
        this.ostart_ = 0;
        this.iend_ = 0;
        this.oend_ = 0;
        this.state_ = 1;
    }

    public void setArc(int cx, int cy, int radius, double arc_start, double arc_length) {
        this.cx_ = cx;
        this.cy_ = cy;
        this.arc_start_ = Radian.normalize(arc_start);
        this.arc_length_ = arc_length;
        this.model_ = CircleAlg.GetModel(radius);
        double as = Radian.normalize(this.arc_start_);
        double ae = Radian.normalize(this.arc_start_ + arc_length);
        this.ostart_ = CircleAlg.GetOctant(as);
        this.oend_ = CircleAlg.GetOctant(ae);
        this.istart_ = this.GetIndex(as);
        this.iend_ = this.GetIndex(ae);
        this.state_ = 1;
    }

    public void setCircle(CircleAlg c) {
        this.cx_ = c.cx_;
        this.cy_ = c.cy_;
        this.arc_start_ = c.arc_start_;
        this.arc_length_ = c.arc_length_;
        this.model_ = c.model_;
        this.istart_ = c.istart_;
        this.iend_ = c.iend_;
        this.ostart_ = c.ostart_;
        this.oend_ = c.oend_;
        this.state_ = 1;
    }

    public int getCenterX() {
        return this.cx_;
    }

    public int getCenterY() {
        return this.cy_;
    }

    public int getRadius() {
        return this.model_.radius_;
    }

    public double getArcStart() {
        return this.arc_start_;
    }

    public double getArcLength() {
        return this.arc_length_;
    }

    private static int GetOctant(double angle) {
        if (angle < 0.7853981633974483) {
            return 0;
        }
        if (angle < 1.5707963267948966) {
            return 1;
        }
        if (angle < 2.356194490192345) {
            return 2;
        }
        if (angle < Math.PI) {
            return 3;
        }
        if (angle < 3.9269908169872414) {
            return 4;
        }
        if (angle < 4.71238898038469) {
            return 5;
        }
        if (angle < 5.497787143782138) {
            return 6;
        }
        return 7;
    }

    private static int NextOctant(int octant) {
        return (octant + 1) % 8;
    }

    private static int PrevOctant(int octant) {
        if (--octant < 0) {
            octant = 7;
        }
        return octant;
    }

    private int GetIndex(double angle) {
        int index = angle < 0.7853981633974483 ? (int)((double)(this.model_.size_ - 1) * angle / 0.7853981633974483) : (angle < 1.5707963267948966 ? (int)((double)(this.model_.size_ - 1) * (1.5707963267948966 - angle) / 0.7853981633974483) : (angle < 2.356194490192345 ? (int)((double)(this.model_.size_ - 1) * (angle - 1.5707963267948966) / 0.7853981633974483) : (angle < Math.PI ? (int)((double)(this.model_.size_ - 1) * (Math.PI - angle) / 0.7853981633974483) : (angle < 3.9269908169872414 ? (int)((double)(this.model_.size_ - 1) * (angle - Math.PI) / 0.7853981633974483) : (angle < 4.71238898038469 ? (int)((double)(this.model_.size_ - 1) * (4.71238898038469 - angle) / 0.7853981633974483) : (angle < 5.497787143782138 ? (int)((double)(this.model_.size_ - 1) * (angle - 4.71238898038469) / 0.7853981633974483) : (int)((double)(this.model_.size_ - 1) * (Math.PI * 2 - angle) / 0.7853981633974483)))))));
        return index;
    }

    private static Object GetKey(int radius) {
        return new Integer(radius);
    }

    private static Model GetModel(int radius) {
        Object key = CircleAlg.GetKey(radius);
        Model model = (Model)models_.getModel(key);
        if (model == null) {
            model = new Model(radius);
            models_.addModel(model);
        }
        return model;
    }

    public void restart() {
        this.state_ = 1;
    }

    public void endPathElement(IGC gc) {
    }

    public int getX() {
        return this.curr_ptx_;
    }

    public int getY() {
        return this.curr_pty_;
    }

    public float getTX() {
        return this.curr_tgx_;
    }

    public float getTY() {
        return this.curr_tgy_;
    }

    public boolean nextPoint(IPoint point) {
        switch (this.state_) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.model_.radius_ == 0 || this.arc_length_ == 0.0) {
                    this.state_ = 0;
                    return false;
                }
                this.curr_index_ = this.istart_;
                this.curr_octant_ = this.ostart_;
                this.cnt = 0;
                this.state_ = (byte)2;
            }
        }
        ++this.cnt;
        if (this.cnt > 9 * this.model_.size_) {
            System.out.println("--- obviously there are a bad end condition, stop here");
            System.out.println(" istart=" + this.istart_ + " ostart=" + this.ostart_ + " iend=" + this.iend_ + " oend=" + this.oend_);
            System.out.println(" arc_start_=" + this.arc_start_ + " arc.length=" + this.arc_length_);
            return false;
        }
        this.model_.getPoint(this.curr_index_, this.curr_octant_);
        this.curr_ptx_ = this.cx_ + this.model_.ptx_;
        this.curr_pty_ = this.cy_ - this.model_.pty_;
        this.curr_tgx_ = -this.model_.tgx_;
        this.curr_tgy_ = this.model_.tgy_;
        if (point != null) {
            point.setPoint(this.curr_ptx_, this.curr_pty_);
        }
        if (this.arc_length_ >= 0.0) {
            if ((this.curr_octant_ & 1) == 0) {
                ++this.curr_index_;
                if (this.model_.shared_endpoint_) {
                    if (this.curr_index_ >= this.model_.size_ - 1) {
                        this.curr_index_ = this.model_.size_ - 1;
                        this.curr_octant_ = CircleAlg.NextOctant(this.curr_octant_);
                    }
                } else if (this.curr_index_ >= this.model_.size_) {
                    this.curr_index_ = this.model_.size_ - 1;
                    this.curr_octant_ = CircleAlg.NextOctant(this.curr_octant_);
                }
            } else {
                --this.curr_index_;
                if (this.curr_index_ == 0) {
                    this.curr_octant_ = CircleAlg.NextOctant(this.curr_octant_);
                }
            }
        } else if ((this.curr_octant_ & 1) == 0) {
            --this.curr_index_;
            if (this.curr_index_ < 0) {
                this.curr_index_ = 1;
                this.curr_octant_ = CircleAlg.PrevOctant(this.curr_octant_);
            }
        } else {
            ++this.curr_index_;
            if (this.curr_index_ >= this.model_.size_) {
                this.curr_index_ = this.model_.shared_endpoint_ ? this.model_.size_ - 2 : this.model_.size_ - 1;
                this.curr_octant_ = CircleAlg.PrevOctant(this.curr_octant_);
            }
        }
        if (this.curr_octant_ == this.oend_ && this.curr_index_ == this.iend_) {
            this.state_ = 0;
        }
        return true;
    }

    public void getCurrentTangent(IVector vector) {
        vector.setVector(this.curr_tgx_, this.curr_tgy_);
    }

    public static boolean Contains(int x, int y, int cx, int cy, int radius) {
        if (x < cx - radius || y < cy - radius || x > cx + radius || y > cy + radius) {
            return false;
        }
        int dx = x - cx;
        int dy = y - cy;
        int pr2 = dx * dx + dy * dy;
        return pr2 <= radius * radius;
    }

    public static boolean Contains(int x, int y, int cx, int cy, int radius, double arc_start, double arc_length) {
        if (x < cx - radius || y < cy - radius || x > cx + radius || y > cy + radius) {
            return false;
        }
        int dx = x - cx;
        int dy = y - cy;
        int pr2 = dx * dx + dy * dy;
        if (pr2 > radius * radius) {
            return false;
        }
        if (arc_length >= Math.PI * 2 || -arc_length <= Math.PI * 2) {
            return true;
        }
        double angle = Math.atan2(dy, dx);
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (arc_length == 0.0) {
            return angle == arc_start;
        }
        if (arc_length > 0.0) {
            if (angle < arc_start) {
                angle += Math.PI * 2;
            }
            return angle <= arc_start + arc_length;
        }
        if (angle > arc_start) {
            angle -= Math.PI * 2;
        }
        return angle >= arc_start + arc_length;
    }

    public boolean contains(int x, int y) {
        return CircleAlg.Contains(x, y, this.cx_, this.cy_, this.model_.radius_, this.arc_start_, this.arc_length_);
    }

    public boolean contains(IPoint p) {
        return CircleAlg.Contains(p.getX(), p.getY(), this.cx_, this.cy_, this.model_.radius_, this.arc_start_, this.arc_length_);
    }

    public IRect getBounds() {
        int r = this.model_.radius_;
        int r2 = r << 1;
        return new Rect(this.cx_ - r, this.cy_ - r, r2, r2);
    }

    public void fillCircle(IGCDirect gc) {
        CircleAlg.FillCircle(gc, this.model_, this.cx_, this.cy_);
    }

    public void fill(IGCDirect gd) {
        CircleAlg.FillArc(gd, this.cx_, this.cy_, this.model_.radius_, this.arc_start_, this.arc_length_);
    }

    public static void FillCircle(IGCDirect gc, int cx, int cy, int radius) {
        CircleAlg.FillCircle(gc, CircleAlg.GetModel(radius), cx, cy);
    }

    protected static void FillCircle(IGCDirect gc, Model model, int cx, int cy) {
        int lx = model.px_[0];
        int ly = model.py_[0];
        gc.drawHLineDirect(cx - lx, cx + lx, cy);
        int lty = lx;
        int lxx = ly;
        int px = lx;
        int py = ly;
        int index = 1;
        while (index < model.size_) {
            px = model.px_[index];
            py = model.py_[index];
            gc.drawHLineDirect(cx - px, cx + px, cy + py);
            gc.drawHLineDirect(cx - px, cx + px, cy - py);
            if (px != lty) {
                gc.drawHLineDirect(cx - lxx, cx + lxx, cy + lty);
                gc.drawHLineDirect(cx - lxx, cx + lxx, cy - lty);
                lty = px;
                lxx = py;
            } else if (py > lxx) {
                lxx = py;
            }
            ++index;
        }
        if (px != py) {
            gc.drawHLineDirect(cx - lxx, cx + lxx, cy + lty);
            gc.drawHLineDirect(cx - lxx, cx + lxx, cy - lty);
        }
    }

    public static void FillArc(IGCDirect gd, int cx, int cy, int radius, double arc_start, double arc_length) {
        if (arc_length >= Math.PI * 2 || arc_length <= Math.PI * -2) {
            CircleAlg.FillCircle(gd, cx, cy, radius);
        } else {
            OvalAlg.FillArc(gd, cx, cy, radius, radius, arc_start, arc_length);
        }
    }

    private static class Model
    extends ModelMap.AbstractModel {
        int radius_;
        int[] px_;
        int[] py_;
        float[] tx_;
        float[] ty_;
        int size_;
        boolean shared_endpoint_;
        int usage_;
        int ptx_;
        int pty_;
        float tgx_;
        float tgy_;

        public Model(int radius) {
            this.radius_ = radius;
            this.computePoints();
            this.usage_ = 1;
        }

        public Object getKey() {
            return CircleAlg.GetKey(this.radius_);
        }

        public void getPoint(int index, int octant) {
            switch (octant) {
                case 0: {
                    this.ptx_ = this.px_[index];
                    this.pty_ = this.py_[index];
                    this.tgx_ = this.tx_[index];
                    this.tgy_ = this.ty_[index];
                    return;
                }
                case 1: {
                    this.ptx_ = this.py_[index];
                    this.pty_ = this.px_[index];
                    this.tgx_ = -this.ty_[index];
                    this.tgy_ = -this.tx_[index];
                    return;
                }
                case 2: {
                    this.ptx_ = -this.py_[index];
                    this.pty_ = this.px_[index];
                    this.tgx_ = -this.ty_[index];
                    this.tgy_ = this.tx_[index];
                    return;
                }
                case 3: {
                    this.ptx_ = -this.px_[index];
                    this.pty_ = this.py_[index];
                    this.tgx_ = this.tx_[index];
                    this.tgy_ = -this.ty_[index];
                    return;
                }
                case 4: {
                    this.ptx_ = -this.px_[index];
                    this.pty_ = -this.py_[index];
                    this.tgx_ = -this.tx_[index];
                    this.tgy_ = -this.ty_[index];
                    return;
                }
                case 5: {
                    this.ptx_ = -this.py_[index];
                    this.pty_ = -this.px_[index];
                    this.tgx_ = this.ty_[index];
                    this.tgy_ = this.tx_[index];
                    return;
                }
                case 6: {
                    this.ptx_ = this.py_[index];
                    this.pty_ = -this.px_[index];
                    this.tgx_ = this.ty_[index];
                    this.tgy_ = -this.tx_[index];
                    return;
                }
                case 7: {
                    this.ptx_ = this.px_[index];
                    this.pty_ = -this.py_[index];
                    this.tgx_ = -this.tx_[index];
                    this.tgy_ = this.ty_[index];
                    return;
                }
            }
        }

        private void computePoints() {
            if (this.radius_ == 0) {
                this.px_ = new int[1];
                this.px_[0] = 0;
                this.py_ = new int[1];
                this.py_[0] = 0;
                this.size_ = 1;
                return;
            }
            int size = this.radius_;
            int d = 3 - 2 * this.radius_;
            int x = this.radius_;
            int y = 0;
            this.size_ = 0;
            this.px_ = new int[size];
            this.py_ = new int[size];
            int di = 10 - 4 * this.radius_;
            int ri = 6;
            x = 0;
            y = this.radius_;
            while (x <= y) {
                this.px_[this.size_] = y--;
                this.py_[this.size_] = x;
                ++this.size_;
                if (d >= 0) {
                    d += di;
                    di += 8;
                } else {
                    d += ri;
                    di += 4;
                }
                ri += 4;
                ++x;
            }
            int[] np = new int[this.size_];
            int i = 0;
            while (i < this.size_) {
                np[i] = this.px_[i];
                ++i;
            }
            this.px_ = np;
            np = new int[this.size_];
            i = 0;
            while (i < this.size_) {
                np[i] = this.py_[i];
                ++i;
            }
            this.py_ = np;
            this.shared_endpoint_ = this.px_[this.size_ - 1] == this.py_[this.size_ - 1];
            this.tx_ = new float[this.size_];
            this.ty_ = new float[this.size_];
            i = 0;
            while (i < this.size_) {
                int px = this.px_[i];
                int py = this.py_[i];
                float norm = (float)Math.sqrt(px * px + py * py);
                if (norm == 0.0f) {
                    this.ty_[i] = 0.0f;
                    this.tx_[i] = 0.0f;
                } else {
                    this.tx_[i] = (float)(-py) / norm;
                    this.ty_[i] = (float)px / norm;
                }
                ++i;
            }
        }
    }
}

