/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.alg.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.LineAlg;
import org.eclipse.tptp.platform.report.igc.alg.internal.ModelMap;
import org.eclipse.tptp.platform.report.igc.internal.IGC;
import org.eclipse.tptp.platform.report.igc.internal.IGCDirect;
import org.eclipse.tptp.platform.report.igc.internal.IPoint;
import org.eclipse.tptp.platform.report.igc.internal.IRect;
import org.eclipse.tptp.platform.report.igc.internal.IVector;
import org.eclipse.tptp.platform.report.igc.util.internal.Radian;
import org.eclipse.tptp.platform.report.igc.util.internal.Rect;
import org.eclipse.tptp.platform.report.igc.util.internal.Vector;

public class OvalAlg {
    protected int cx_;
    protected int cy_;
    protected double arc_start_;
    protected double arc_length_;
    protected Model model_;
    protected int istart_;
    protected int iend_;
    protected int qstart_;
    protected int qend_;
    protected static ModelMap models_ = new ModelMap(5, 50, 10);
    protected int curr_index_;
    protected int curr_quadrant_;
    protected Vector vector_ = new Vector();
    protected byte state_;
    private int curr_ptx_;
    private int curr_pty_;
    private float curr_tgx_;
    private float curr_tgy_;
    private int cnt;

    public OvalAlg() {
        this.setOval(0, 0, 0, 0);
    }

    public OvalAlg(int cx, int cy, int xradius, int yradius) {
        this.setOval(cx, cy, xradius, yradius);
    }

    public OvalAlg(int cx, int cy, int xradius, int yradius, double arc_start, double arc_length) {
        this.setArc(cx, cy, xradius, yradius, arc_start, arc_length);
    }

    public OvalAlg(OvalAlg c) {
        this.setOval(c);
    }

    public void setOval(int cx, int cy, int xradius, int yradius) {
        this.cx_ = cx;
        this.cy_ = cy;
        this.arc_start_ = 0.0;
        this.arc_length_ = Math.PI * 2;
        this.model_ = OvalAlg.GetModel(xradius, yradius);
        this.istart_ = 0;
        this.qstart_ = 0;
        this.iend_ = 0;
        this.qend_ = 0;
        this.state_ = 1;
    }

    public void setArc(int cx, int cy, int xradius, int yradius, double arc_start, double arc_length) {
        this.cx_ = cx;
        this.cy_ = cy;
        this.arc_start_ = Radian.normalize(arc_start);
        this.arc_length_ = arc_length;
        this.model_ = OvalAlg.GetModel(xradius, yradius);
        double as = Radian.normalize(this.arc_start_);
        double ae = Radian.normalize(this.arc_start_ + arc_length);
        this.qstart_ = OvalAlg.GetQuadrant(as);
        this.qend_ = OvalAlg.GetQuadrant(ae);
        this.istart_ = OvalAlg.GetIndex(this.model_, as);
        this.iend_ = OvalAlg.GetIndex(this.model_, ae);
        this.state_ = 1;
    }

    public void setOval(OvalAlg c) {
        this.cx_ = c.cx_;
        this.cy_ = c.cy_;
        this.arc_start_ = c.arc_start_;
        this.arc_length_ = c.arc_length_;
        this.model_ = c.model_;
        this.istart_ = c.istart_;
        this.iend_ = c.iend_;
        this.qstart_ = c.qstart_;
        this.qend_ = c.qend_;
        this.state_ = 1;
    }

    public int getCenterX() {
        return this.cx_;
    }

    public int getCenterY() {
        return this.cy_;
    }

    public int getRadiusX() {
        return this.model_.rx_;
    }

    public int getRadiusY() {
        return this.model_.ry_;
    }

    public double getArcStart() {
        return this.arc_start_;
    }

    public double getArcLength() {
        return this.arc_length_;
    }

    private static int GetQuadrant(double angle) {
        if (angle < 1.5707963267948966) {
            return 0;
        }
        if (angle < Math.PI) {
            return 1;
        }
        if (angle < 4.71238898038469) {
            return 2;
        }
        return 3;
    }

    private static int NextQuadrant(int quadrant) {
        return (quadrant + 1) % 4;
    }

    private static int PrevQuadrant(int quadrant) {
        if (--quadrant < 0) {
            quadrant = 3;
        }
        return quadrant;
    }

    private static int GetIndex(Model model, double angle) {
        int index = angle < 1.5707963267948966 ? (int)Math.round((double)(model.size_ - 1) * angle / 1.5707963267948966) : (angle < Math.PI ? (int)Math.round((double)(model.size_ - 1) * (Math.PI - angle) / 1.5707963267948966) : (angle < 4.71238898038469 ? (int)Math.round((double)(model.size_ - 1) * (angle - Math.PI) / 1.5707963267948966) : (int)Math.round((double)(model.size_ - 1) * (Math.PI * 2 - angle) / 1.5707963267948966)));
        return index;
    }

    private static Object GetKey(int xradius, int yradius) {
        return String.valueOf(Integer.toString(xradius)) + ":" + Integer.toString(yradius);
    }

    private static Model GetModel(int xradius, int yradius) {
        Object key = OvalAlg.GetKey(xradius, yradius);
        Model model = (Model)models_.getModel(key);
        if (model == null) {
            model = new Model(xradius, yradius);
            models_.addModel(model);
        }
        return model;
    }

    public void restart() {
        this.state_ = 1;
    }

    public void endPathElement(IGC gc) {
    }

    public int getX() {
        return this.curr_ptx_;
    }

    public int getY() {
        return this.curr_pty_;
    }

    public float getTX() {
        return this.curr_tgx_;
    }

    public float getTY() {
        return this.curr_tgy_;
    }

    public boolean nextPoint(IPoint point) {
        switch (this.state_) {
            case 0: {
                return false;
            }
            case 1: {
                if (this.model_.rx_ == 0 || this.model_.ry_ == 0 || this.arc_length_ == 0.0) {
                    this.state_ = 0;
                    return false;
                }
                this.curr_index_ = this.istart_;
                this.curr_quadrant_ = this.qstart_;
                this.cnt = 0;
                this.state_ = (byte)2;
            }
        }
        ++this.cnt;
        if (this.cnt > 5 * this.model_.size_) {
            System.out.println("--- obviously there are a bad end condition, stop here");
            System.out.println(" istart=" + this.istart_ + " qstart=" + this.qstart_ + " iend=" + this.iend_ + " qend=" + this.qend_ + "  /size=" + this.model_.size_);
            System.out.println(" arc_start_=" + this.arc_start_ + " arc.length=" + (this.arc_start_ + this.arc_length_));
            return false;
        }
        this.model_.getPoint(this.curr_index_, this.curr_quadrant_);
        this.curr_ptx_ = this.cx_ + this.model_.ptx_;
        this.curr_pty_ = this.cy_ - this.model_.pty_;
        this.curr_tgx_ = -this.model_.tgx_;
        this.curr_tgy_ = this.model_.tgy_;
        if (point != null) {
            point.setPoint(this.curr_ptx_, this.curr_pty_);
        }
        if (this.arc_length_ >= 0.0) {
            if ((this.curr_quadrant_ & 1) == 0) {
                ++this.curr_index_;
                if (this.curr_index_ >= this.model_.size_ - 1) {
                    this.curr_index_ = this.model_.size_ - 1;
                    this.curr_quadrant_ = OvalAlg.NextQuadrant(this.curr_quadrant_);
                }
            } else {
                --this.curr_index_;
                if (this.curr_index_ == 0) {
                    this.curr_quadrant_ = OvalAlg.NextQuadrant(this.curr_quadrant_);
                }
            }
        } else if ((this.curr_quadrant_ & 1) == 0) {
            --this.curr_index_;
            if (this.curr_index_ < 0) {
                this.curr_index_ = 1;
                this.curr_quadrant_ = OvalAlg.PrevQuadrant(this.curr_quadrant_);
            }
        } else {
            ++this.curr_index_;
            if (this.curr_index_ >= this.model_.size_) {
                this.curr_index_ = this.model_.size_ - 2;
                this.curr_quadrant_ = OvalAlg.PrevQuadrant(this.curr_quadrant_);
            }
        }
        if (this.curr_quadrant_ == this.qend_ && this.curr_index_ == this.iend_) {
            this.state_ = 0;
        }
        return true;
    }

    public void getCurrentTangent(IVector vector) {
        vector.setVector(this.curr_tgx_, this.curr_tgy_);
    }

    public static boolean Contains(int x, int y, int cx, int cy, int xradius, int yradius) {
        if (x < cx - xradius || y < cy - yradius || x > cx + xradius || y > cy + yradius) {
            return false;
        }
        int dx = x - cx;
        int dy = y - cy;
        int pr2 = dx * dx + dy * dy;
        double a = Math.atan2(dy, dx);
        double r = (double)xradius * Math.cos(a) + (double)yradius * Math.sin(a);
        return !((double)pr2 > r * r);
    }

    public static boolean Contains(int x, int y, int cx, int cy, int xradius, int yradius, double arc_start, double arc_length) {
        if (x < cx - xradius || y < cy - yradius || x > cx + xradius || y > cy + yradius) {
            return false;
        }
        int dx = x - cx;
        int dy = y - cy;
        int pr2 = dx * dx + dy * dy;
        double angle = Math.atan2(dy, dx);
        double r = (double)xradius * Math.cos(angle) + (double)yradius * Math.sin(angle);
        if ((double)pr2 > r * r) {
            return false;
        }
        if (arc_length >= Math.PI * 2 || -arc_length <= Math.PI * 2) {
            return true;
        }
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        if (arc_length == 0.0) {
            return angle == arc_start;
        }
        if (arc_length > 0.0) {
            if (angle < arc_start) {
                angle += Math.PI * 2;
            }
            return angle <= arc_start + arc_length;
        }
        if (angle > arc_start) {
            angle -= Math.PI * 2;
        }
        return angle >= arc_start + arc_length;
    }

    public boolean contains(int x, int y) {
        return OvalAlg.Contains(x, y, this.cx_, this.cy_, this.model_.rx_, this.model_.ry_, this.arc_start_, this.arc_length_);
    }

    public boolean contains(IPoint p) {
        return OvalAlg.Contains(p.getX(), p.getY(), this.cx_, this.cy_, this.model_.rx_, this.model_.ry_, this.arc_start_, this.arc_length_);
    }

    public IRect getBounds() {
        int rx = this.model_.rx_;
        int ry = this.model_.ry_;
        return new Rect(this.cx_ - rx, this.cy_ - ry, 2 * rx, 2 * ry);
    }

    public void fillOval(IGCDirect gc) {
        this.model_.fillOval(gc, this.cx_, this.cy_);
    }

    public void fillArc(IGCDirect gc) {
        this.model_.fillArc(gc, this.cx_, this.cy_, this.arc_start_, this.arc_length_);
    }

    public static void FillArc(IGCDirect gd, int cx, int cy, int xradius, int yradius, double arc_start, double arc_length) {
        OvalAlg.GetModel(xradius, yradius).fillArc(gd, cx, cy, arc_start, arc_length);
    }

    public static void FillOval(IGCDirect gc, int cx, int cy, int xradius, int yradius) {
        OvalAlg.GetModel(xradius, yradius).fillOval(gc, cx, cy);
    }

    private static class Model
    extends ModelMap.AbstractModel {
        int rx_;
        int ry_;
        int[] px_;
        int[] py_;
        float[] tx_;
        float[] ty_;
        int size_;
        int usage_;
        int ptx_;
        int pty_;
        float tgx_;
        float tgy_;

        public Model(int rx, int ry) {
            this.rx_ = rx;
            this.ry_ = ry;
            this.computePoints();
            this.usage_ = 1;
        }

        public Object getKey() {
            return OvalAlg.GetKey(this.rx_, this.ry_);
        }

        public void getPoint(int index, int quadrant) {
            switch (quadrant) {
                case 0: {
                    this.ptx_ = this.px_[index];
                    this.pty_ = this.py_[index];
                    this.tgx_ = this.tx_[index];
                    this.tgy_ = this.ty_[index];
                    return;
                }
                case 1: {
                    this.ptx_ = -this.px_[index];
                    this.pty_ = this.py_[index];
                    this.tgx_ = this.tx_[index];
                    this.tgy_ = -this.ty_[index];
                    return;
                }
                case 2: {
                    this.ptx_ = -this.px_[index];
                    this.pty_ = -this.py_[index];
                    this.tgx_ = -this.tx_[index];
                    this.tgy_ = -this.ty_[index];
                    return;
                }
                case 3: {
                    this.ptx_ = this.px_[index];
                    this.pty_ = -this.py_[index];
                    this.tgx_ = -this.tx_[index];
                    this.tgy_ = this.ty_[index];
                    return;
                }
            }
        }

        private void computePoints() {
            if (this.rx_ == 0 || this.ry_ == 0) {
                this.px_ = new int[1];
                this.px_[0] = 0;
                this.py_ = new int[1];
                this.py_[0] = 0;
                this.size_ = 1;
                return;
            }
            int size = Math.max(this.rx_, this.ry_);
            int[] px1 = new int[size];
            int[] py1 = new int[size];
            long _2a2 = 2 * this.rx_ * this.rx_;
            long _2b2 = 2 * this.ry_ * this.ry_;
            int x = this.rx_;
            int y = 0;
            long xchg = this.ry_ * this.ry_ * (1 - 2 * this.rx_);
            long ychg = this.rx_ * this.rx_;
            long err = 0L;
            long stopx = _2b2 * (long)this.rx_;
            long stopy = 0L;
            int arc1 = 0;
            while (stopx >= stopy) {
                px1[arc1] = x--;
                py1[arc1] = y++;
                ++arc1;
                stopy += _2a2;
                if (2L * (err += (ychg += _2a2)) + xchg <= 0L) continue;
                stopx -= _2b2;
                err += xchg;
                xchg += _2b2;
            }
            x = 0;
            y = this.ry_;
            int[] px2 = new int[size];
            int[] py2 = new int[size];
            int arc2 = 0;
            xchg = this.ry_ * this.ry_;
            ychg = this.rx_ * this.rx_ * (1 - 2 * this.ry_);
            err = 0L;
            stopx = 0L;
            stopy = _2a2 * (long)this.ry_;
            while (stopx <= stopy) {
                px2[arc2] = x++;
                py2[arc2] = y--;
                ++arc2;
                stopx += _2b2;
                if (2L * (err += (xchg += _2b2)) + ychg <= 0L) continue;
                stopy -= _2a2;
                err += ychg;
                ychg += _2a2;
            }
            this.size_ = arc1 + arc2;
            this.px_ = new int[this.size_];
            this.py_ = new int[this.size_];
            int i = 0;
            while (i < arc1) {
                this.px_[i] = px1[i];
                this.py_[i] = py1[i];
                ++i;
            }
            i = arc2 - 1;
            int j = arc1;
            while (i >= 0) {
                this.px_[j] = px2[i];
                this.py_[j] = py2[i];
                --i;
                ++j;
            }
            this.tx_ = new float[this.size_];
            this.ty_ = new float[this.size_];
            double inv_rx2 = 2.0 / (double)(this.rx_ * this.rx_);
            double inv_ry2 = 2.0 / (double)(this.ry_ * this.ry_);
            int i2 = 0;
            while (i2 < this.size_) {
                int cfr_ignored_0 = this.px_[i2];
                int cfr_ignored_1 = this.py_[i2];
                double tx = (double)this.px_[i2] * inv_rx2;
                double ty = (double)this.py_[i2] * inv_ry2;
                double n = Math.sqrt(tx * tx + ty * ty);
                if (n == 0.0) {
                    this.ty_[i2] = 0.0f;
                    this.tx_[i2] = 0.0f;
                } else {
                    this.tx_[i2] = -((float)(ty / n));
                    this.ty_[i2] = (float)(tx / n);
                }
                ++i2;
            }
        }

        public void fillOval(IGCDirect gd, int cx, int cy) {
            int px = this.px_[0];
            int py = this.py_[0];
            gd.drawHLineDirect(cx - px, cx + px, cy);
            int ly = py;
            int index = 1;
            while (index < this.size_) {
                px = this.px_[index];
                py = this.py_[index];
                if (py != ly) {
                    int lx = cx - px;
                    int rx = cx + px;
                    gd.drawHLineDirect(lx, rx, cy + py);
                    gd.drawHLineDirect(lx, rx, cy - py);
                    ly = py;
                }
                ++index;
            }
        }

        public void fillQuadrant01(IGCDirect gc, int cx, int cy) {
            int px = this.px_[0];
            int py = this.py_[0];
            gc.drawHLineDirect(cx - px, cx + px, cy);
            int ly = py;
            int index = 1;
            while (index < this.size_) {
                px = this.px_[index];
                py = this.py_[index];
                if (py != ly) {
                    gc.drawHLineDirect(cx - px, cx + px, cy - py);
                    ly = py;
                }
                ++index;
            }
        }

        public void fillQuadrant23(IGCDirect gc, int cx, int cy) {
            int px = this.px_[0];
            int py = this.py_[0];
            gc.drawHLineDirect(cx - px, cx + px, cy);
            int ly = py;
            int index = 1;
            while (index < this.size_) {
                px = this.px_[index];
                py = this.py_[index];
                if (py != ly) {
                    gc.drawHLineDirect(cx - px, cx + px, cy + py);
                    ly = py;
                }
                ++index;
            }
        }

        public void fillQuadrant12(IGCDirect gc, int cx, int cy) {
            int px = this.px_[0];
            int py = this.py_[0];
            gc.drawHLineDirect(cx - px, cx, cy);
            int ly = py;
            int index = 1;
            while (index < this.size_) {
                px = this.px_[index];
                py = this.py_[index];
                if (py != ly) {
                    int lx = cx - px;
                    gc.drawHLineDirect(lx, cx, cy - py);
                    gc.drawHLineDirect(lx, cx, cy + py);
                    ly = py;
                }
                ++index;
            }
        }

        public void fillQuadrant30(IGCDirect gc, int cx, int cy) {
            int px = this.px_[0];
            int py = this.py_[0];
            gc.drawHLineDirect(cx, cx + px, cy);
            int ly = py;
            int index = 1;
            while (index < this.size_) {
                px = this.px_[index];
                py = this.py_[index];
                if (py != ly) {
                    int rx = cx + px;
                    gc.drawHLineDirect(cx, rx, cy - py);
                    gc.drawHLineDirect(cx, rx, cy + py);
                    ly = py;
                }
                ++index;
            }
        }

        protected void fillQuadrant0(IGCDirect gc, int cx, int cy) {
            int px = this.px_[0];
            int py = this.py_[0];
            gc.drawHLineDirect(cx, cx + px, cy);
            int ly = py;
            int index = 1;
            while (index < this.size_) {
                px = this.px_[index];
                py = this.py_[index];
                if (py != ly) {
                    gc.drawHLineDirect(cx, cx + px, cy - py);
                    ly = py;
                }
                ++index;
            }
        }

        public void fillQuadrant1(IGCDirect gc, int cx, int cy) {
            int px = this.px_[0];
            int py = this.py_[0];
            gc.drawHLineDirect(cx - px, cx, cy);
            int ly = py;
            int index = 1;
            while (index < this.size_) {
                px = this.px_[index];
                py = this.py_[index];
                if (py != ly) {
                    gc.drawHLineDirect(cx - px, cx, cy - py);
                    ly = py;
                }
                ++index;
            }
        }

        public void fillQuadrant2(IGCDirect gc, int cx, int cy) {
            int px = this.px_[0];
            int py = this.py_[0];
            gc.drawHLineDirect(cx - px, cx, cy);
            int ly = py;
            int index = 1;
            while (index < this.size_) {
                px = this.px_[index];
                py = this.py_[index];
                if (py != ly) {
                    gc.drawHLineDirect(cx - px, cx, cy + py);
                    ly = py;
                }
                ++index;
            }
        }

        public void fillQuadrant3(IGCDirect gc, int cx, int cy) {
            int px = this.px_[0];
            int py = this.py_[0];
            gc.drawHLineDirect(cx, cx + px, cy);
            int ly = py;
            int index = 1;
            while (index < this.size_) {
                px = this.px_[index];
                py = this.py_[index];
                if (py != ly) {
                    gc.drawHLineDirect(cx, cx + px, cy + py);
                    ly = py;
                }
                ++index;
            }
        }

        public void fillArc(IGCDirect gc, int cx, int cy, double arc_start, double arc_length) {
            double aalen = Math.abs(arc_length);
            double ast = Radian.normalize(arc_start);
            if (aalen == 0.0) {
                return;
            }
            if (aalen >= Math.PI * 2) {
                this.fillOval(gc, cx, cy);
                return;
            }
            if (ast == 0.0 && arc_length == Math.PI || ast == Math.PI && arc_length == -Math.PI) {
                this.fillQuadrant01(gc, cx, cy);
                return;
            }
            if (ast == 0.0 && arc_length == -Math.PI || ast == Math.PI && arc_length == Math.PI) {
                this.fillQuadrant23(gc, cx, cy);
                return;
            }
            if (ast == 1.5707963267948966 && arc_length == Math.PI || ast == 4.71238898038469 && arc_length == -Math.PI) {
                this.fillQuadrant12(gc, cx, cy);
                return;
            }
            if (ast == 4.71238898038469 && arc_length == Math.PI || ast == 1.5707963267948966 && arc_length == -Math.PI) {
                this.fillQuadrant30(gc, cx, cy);
                return;
            }
            if (ast == 0.0 && arc_length == 1.5707963267948966 || ast == 1.5707963267948966 && arc_length == -1.5707963267948966) {
                this.fillQuadrant0(gc, cx, cy);
                return;
            }
            if (ast == 1.5707963267948966 && arc_length == 1.5707963267948966 || ast == Math.PI && arc_length == -1.5707963267948966) {
                this.fillQuadrant1(gc, cx, cy);
                return;
            }
            if (ast == Math.PI && arc_length == 1.5707963267948966 || ast == 4.71238898038469 && arc_length == -1.5707963267948966) {
                this.fillQuadrant2(gc, cx, cy);
                return;
            }
            if (ast == Math.PI && arc_length == 1.5707963267948966 || ast == 4.71238898038469 && arc_length == -1.5707963267948966) {
                this.fillQuadrant3(gc, cx, cy);
                return;
            }
            double aed = ast + arc_length;
            double naed = Radian.normalize(aed);
            int qs = OvalAlg.GetQuadrant(ast);
            int qe = OvalAlg.GetQuadrant(naed);
            System.out.println("OvalAlg.Model.fillArc() qs=" + qs + " qe=" + qe);
            switch (qs) {
                case 0: {
                    switch (qe) {
                        case 0: {
                            if (arc_length >= 0.0) {
                                if (ast <= naed) {
                                    this.fillArc00Tiny(gc, cx, cy, ast, naed);
                                } else {
                                    this.fillArc00Full(gc, cx, cy, ast, naed);
                                }
                            } else if (ast <= naed) {
                                this.fillArc00Full(gc, cx, cy, naed, ast);
                            } else {
                                this.fillArc00Tiny(gc, cx, cy, naed, ast);
                            }
                            return;
                        }
                        case 1: {
                            if (arc_length >= 0.0) {
                                this.fillArc01Top(gc, cx, cy, ast, naed);
                            } else {
                                this.fillArc01Bottom(gc, cx, cy, ast, naed);
                            }
                            return;
                        }
                        case 2: {
                            if (arc_length >= 0.0) {
                                this.fillArc02Top(gc, cx, cy, ast, naed);
                            } else {
                                this.fillArc02Bottom(gc, cx, cy, ast, naed);
                            }
                            return;
                        }
                        case 3: {
                            if (arc_length >= 0.0) {
                                this.fillArc03Left(gc, cx, cy, ast, naed);
                            } else {
                                this.fillArc03Right(gc, cx, cy, ast, naed);
                            }
                            return;
                        }
                    }
                }
                case 1: {
                    switch (qe) {
                        case 0: {
                            if (arc_length >= 0.0) {
                                this.fillArc01Bottom(gc, cx, cy, naed, ast);
                            } else {
                                this.fillArc01Top(gc, cx, cy, naed, ast);
                            }
                            return;
                        }
                        case 1: {
                            if (arc_length >= 0.0) {
                                if (ast <= naed) {
                                    this.fillArc11Tiny(gc, cx, cy, ast, naed);
                                } else {
                                    this.fillArc11Full(gc, cx, cy, ast, naed);
                                }
                            } else if (ast <= naed) {
                                this.fillArc11Full(gc, cx, cy, naed, ast);
                            } else {
                                this.fillArc11Tiny(gc, cx, cy, naed, ast);
                            }
                            return;
                        }
                        case 2: {
                            if (arc_length >= 0.0) {
                                this.fillArc12Left(gc, cx, cy, ast, naed);
                            } else {
                                this.fillArc12Right(gc, cx, cy, ast, naed);
                            }
                            return;
                        }
                        case 3: {
                            if (arc_length >= 0.0) {
                                this.fillArc13Left(gc, cx, cy, ast, naed);
                            } else {
                                this.fillArc13Right(gc, cx, cy, ast, naed);
                            }
                            return;
                        }
                    }
                }
                case 2: {
                    switch (qe) {
                        case 0: {
                            if (arc_length >= 0.0) {
                                this.fillArc02Bottom(gc, cx, cy, naed, ast);
                            } else {
                                this.fillArc02Top(gc, cx, cy, naed, ast);
                            }
                            return;
                        }
                        case 1: {
                            if (arc_length >= 0.0) {
                                this.fillArc12Right(gc, cx, cy, naed, ast);
                            } else {
                                this.fillArc12Left(gc, cx, cy, naed, ast);
                            }
                            return;
                        }
                        case 2: {
                            if (arc_length >= 0.0) {
                                if (ast <= naed) {
                                    this.fillArc22Tiny(gc, cx, cy, ast, naed);
                                } else {
                                    this.fillArc22Full(gc, cx, cy, ast, naed);
                                }
                            } else if (ast <= naed) {
                                this.fillArc22Full(gc, cx, cy, naed, ast);
                            } else {
                                this.fillArc22Tiny(gc, cx, cy, naed, ast);
                            }
                            return;
                        }
                        case 3: {
                            if (arc_length >= 0.0) {
                                this.fillArc23Bottom(gc, cx, cy, ast, naed);
                            } else {
                                this.fillArc23Top(gc, cx, cy, ast, naed);
                            }
                            return;
                        }
                    }
                }
                case 3: {
                    switch (qe) {
                        case 0: {
                            if (arc_length >= 0.0) {
                                this.fillArc03Right(gc, cx, cy, naed, ast);
                            } else {
                                this.fillArc03Left(gc, cx, cy, naed, ast);
                            }
                            return;
                        }
                        case 1: {
                            if (arc_length >= 0.0) {
                                this.fillArc13Right(gc, cx, cy, naed, ast);
                            } else {
                                this.fillArc13Left(gc, cx, cy, naed, ast);
                            }
                            return;
                        }
                        case 2: {
                            if (arc_length >= 0.0) {
                                this.fillArc23Top(gc, cx, cy, naed, ast);
                            } else {
                                this.fillArc23Bottom(gc, cx, cy, naed, ast);
                            }
                            return;
                        }
                        case 3: {
                            if (arc_length >= 0.0) {
                                if (ast <= naed) {
                                    this.fillArc33Tiny(gc, cx, cy, ast, naed);
                                } else {
                                    this.fillArc33Full(gc, cx, cy, ast, naed);
                                }
                            } else if (ast <= naed) {
                                this.fillArc33Full(gc, cx, cy, naed, ast);
                            } else {
                                this.fillArc33Tiny(gc, cx, cy, naed, ast);
                            }
                            return;
                        }
                    }
                }
            }
        }

        private void fillArc_Bottom(IGCDirect gd, int cx, int cy, int yscan, int curr_index) {
            int ytop = cy + this.ry_;
            while (yscan <= ytop) {
                gd.drawHLineDirect(cx - this.px_[curr_index], cx + this.px_[curr_index], yscan);
                ++yscan;
                while (curr_index < this.size_ && cy + this.py_[curr_index] < yscan) {
                    ++curr_index;
                }
            }
        }

        private void fillArc_Top(IGCDirect gd, int cx, int cy, int yscan, int curr_index) {
            int ybtm = cy - this.ry_;
            while (yscan >= ybtm) {
                gd.drawHLineDirect(cx - this.px_[curr_index], cx + this.px_[curr_index], yscan);
                --yscan;
                while (curr_index < this.size_ && cy - this.py_[curr_index] > yscan) {
                    ++curr_index;
                }
            }
        }

        private int fillArc_BtmLeftArcToRightLine(IGCDirect gd, int cx, int cy, int yscan, int ystop, int ic, LineAlg lr) {
            while (yscan <= ystop) {
                int rx = lr.getX();
                while (lr.getY() <= yscan && lr.nextPoint(null)) {
                    if (lr.getY() > yscan) break;
                    int x = lr.getX();
                    if (x <= rx) continue;
                    rx = x;
                }
                gd.drawHLineDirect(cx - this.px_[ic], rx, yscan);
                ++yscan;
                while (ic < this.size_ && cy + this.py_[ic] < yscan) {
                    ++ic;
                }
            }
            return ic;
        }

        private int fillArc_TopLeftArcToRightLine(IGCDirect gd, int cx, int cy, int yscan, int ystop, int ic, LineAlg lr) {
            while (yscan >= ystop) {
                int rx = lr.getX();
                while (lr.getY() >= yscan && lr.nextPoint(null)) {
                    if (lr.getY() < yscan) break;
                    int x = lr.getX();
                    if (x <= rx) continue;
                    rx = x;
                }
                gd.drawHLineDirect(cx - this.px_[ic], rx, yscan);
                --yscan;
                while (ic < this.size_ && cy - this.py_[ic] > yscan) {
                    ++ic;
                }
            }
            return ic;
        }

        private void fillArc_BtmLeftLineToRightLine(IGCDirect gd, int yscan, int ystop, LineAlg ll, LineAlg lr) {
            while (yscan <= ystop) {
                int lx = ll.getX();
                while (ll.getY() <= yscan && ll.nextPoint(null)) {
                    if (ll.getY() > yscan) break;
                    int x = ll.getX();
                    if (x >= lx) continue;
                    lx = x;
                }
                int rx = lr.getX();
                while (lr.getY() <= yscan && lr.nextPoint(null)) {
                    if (lr.getY() > yscan) break;
                    int x = lr.getX();
                    if (x <= rx) continue;
                    rx = x;
                }
                gd.drawHLineDirect(lx, rx, yscan);
                ++yscan;
            }
        }

        private void fillArc_TopLeftLineToRightLine(IGCDirect gd, int yscan, int ystop, LineAlg ll, LineAlg lr) {
            while (yscan >= ystop) {
                int lx = ll.getX();
                while (ll.getY() >= yscan && ll.nextPoint(null)) {
                    if (ll.getY() < yscan) break;
                    int x = ll.getX();
                    if (x >= lx) continue;
                    lx = x;
                }
                int rx = lr.getX();
                while (lr.getY() >= yscan && lr.nextPoint(null)) {
                    if (lr.getY() < yscan) break;
                    int x = lr.getX();
                    if (x <= rx) continue;
                    rx = x;
                }
                gd.drawHLineDirect(lx, rx, yscan);
                --yscan;
            }
        }

        private int fillArc_BtmLeftLineToRightArc(IGCDirect gd, int cx, int cy, int yscan, int ystop, LineAlg ll, int ic) {
            while (yscan <= ystop) {
                int lx = ll.getX();
                while (ll.getY() <= yscan && ll.nextPoint(null)) {
                    if (ll.getY() > yscan) break;
                    int x = ll.getX();
                    if (x >= lx) continue;
                    lx = x;
                }
                gd.drawHLineDirect(lx, cx + this.px_[ic], yscan);
                ++yscan;
                while (ic < this.size_ && cy + this.py_[ic] < yscan) {
                    ++ic;
                }
            }
            return ic;
        }

        private int fillArc_TopLeftLineToRightArc(IGCDirect gd, int cx, int cy, int yscan, int ystop, LineAlg ll, int ic) {
            while (yscan >= ystop) {
                int lx = ll.getX();
                while (ll.getY() >= yscan && ll.nextPoint(null)) {
                    if (ll.getY() < yscan) break;
                    int x = ll.getX();
                    if (x >= lx) continue;
                    lx = x;
                }
                gd.drawHLineDirect(lx, cx + this.px_[ic], yscan);
                --yscan;
                while (ic < this.size_ && cy - this.py_[ic] > yscan) {
                    ++ic;
                }
            }
            return ic;
        }

        private int fillArc_BtmLeftArcToRightLine_LeftLineToRightArc(IGCDirect gd, int cx, int cy, int yscan, int ystop, int ic, LineAlg lr, LineAlg ll) {
            while (yscan <= ystop) {
                int rx = lr.getX();
                while (lr.getY() <= yscan && lr.nextPoint(null)) {
                    if (lr.getY() > yscan) break;
                    int x = lr.getX();
                    if (x <= rx) continue;
                    rx = x;
                }
                int lx = ll.getX();
                while (ll.getY() <= yscan && ll.nextPoint(null)) {
                    if (ll.getY() > yscan) break;
                    int x = ll.getX();
                    if (x >= lx) continue;
                    lx = x;
                }
                if (rx == lx || rx == lx - 1) {
                    gd.drawHLineDirect(cx - this.px_[ic], cx + this.px_[ic], yscan);
                } else {
                    gd.drawHLineDirect(cx - this.px_[ic], rx, yscan);
                    gd.drawHLineDirect(lx, cx + this.px_[ic], yscan);
                }
                ++yscan;
                while (ic < this.size_ && cy + this.py_[ic] < yscan) {
                    ++ic;
                }
            }
            return ic;
        }

        private int fillArc_TopLeftArcToRightLine_LeftLineToRightArc(IGCDirect gd, int cx, int cy, int yscan, int ystop, int ic, LineAlg lr, LineAlg ll) {
            while (yscan >= ystop) {
                int rx = lr.getX();
                while (lr.getY() >= yscan && lr.nextPoint(null)) {
                    if (lr.getY() < yscan) break;
                    int x = lr.getX();
                    if (x <= rx) continue;
                    rx = x;
                }
                int lx = ll.getX();
                while (ll.getY() >= yscan && ll.nextPoint(null)) {
                    if (ll.getY() < yscan) break;
                    int x = ll.getX();
                    if (x >= lx) continue;
                    lx = x;
                }
                if (rx == lx || rx == lx - 1) {
                    gd.drawHLineDirect(cx - this.px_[ic], cx + this.px_[ic], yscan);
                } else {
                    gd.drawHLineDirect(cx - this.px_[ic], rx, yscan);
                    gd.drawHLineDirect(lx, cx + this.px_[ic], yscan);
                }
                --yscan;
                while (ic < this.size_ && cy - this.py_[ic] > yscan) {
                    ++ic;
                }
            }
            return ic;
        }

        private void fillArc00Tiny(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int iast = OvalAlg.GetIndex(this, nast);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yast = cy - this.py_[iast];
            int yaed = cy - this.py_[iaed];
            LineAlg ll = new LineAlg(cx, cy, cx + this.px_[iaed], yaed);
            LineAlg lr = new LineAlg(cx, cy, cx + this.px_[iast], yast);
            ll.nextPoint(null);
            lr.nextPoint(null);
            this.fillArc_TopLeftLineToRightLine(gd, cy, yast + 1, ll, lr);
            this.fillArc_TopLeftLineToRightArc(gd, cx, cy, yast, yaed, ll, iast);
        }

        private void fillArc00Full(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int ystop2;
            int ystop1;
            this.fillQuadrant23(gd, cx, cy);
            int iast = OvalAlg.GetIndex(this, nast);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yast = cy - this.py_[iast];
            int yaed = cy - this.py_[iaed];
            if (yast >= yaed) {
                ystop1 = yast;
                ystop2 = yaed;
            } else {
                ystop1 = yaed;
                ystop2 = yast;
            }
            int yscan = cy - 1;
            LineAlg lr = new LineAlg(cx, cy, cx + this.px_[iast], yast);
            LineAlg ll = new LineAlg(cx, cy, cx + this.px_[iaed], yaed);
            lr.nextPoint(null);
            ll.nextPoint(null);
            int ic = this.fillArc_TopLeftArcToRightLine_LeftLineToRightArc(gd, cx, cy, yscan, ystop1, 1, lr, ll);
            ic = this.fillArc_TopLeftArcToRightLine(gd, cx, cy, ystop1 - 1, ystop2, ic, lr);
            this.fillArc_Top(gd, cx, cy, ystop2 - 1, ic);
        }

        private void fillArc01Top(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int ystop2;
            int ystop1;
            int iaed;
            int yaed;
            int iast = OvalAlg.GetIndex(this, nast);
            int yast = cy - this.py_[iast];
            if (yast >= (yaed = cy - this.py_[iaed = OvalAlg.GetIndex(this, naed)])) {
                ystop1 = yast;
                ystop2 = yaed;
            } else {
                ystop1 = yaed;
                ystop2 = yast;
            }
            LineAlg ll = new LineAlg(cx, cy, cx - this.px_[iaed], cy - this.py_[iaed]);
            LineAlg lr = new LineAlg(cx, cy, cx + this.px_[iast], cy - this.py_[iast]);
            lr.nextPoint(null);
            ll.nextPoint(null);
            this.fillArc_TopLeftLineToRightLine(gd, cy, ystop1 + 1, ll, lr);
            int ic = ystop1 == yast ? this.fillArc_TopLeftLineToRightArc(gd, cx, cy, ystop1, ystop2 + 1, ll, iast) : this.fillArc_TopLeftArcToRightLine(gd, cx, cy, ystop1, ystop2 + 1, iaed, lr);
            this.fillArc_Top(gd, cx, cy, ystop2, ic);
        }

        private void fillArc01Bottom(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int ystop2;
            int ystop1;
            this.fillQuadrant23(gd, cx, cy);
            int iast = OvalAlg.GetIndex(this, nast);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yast = cy - this.py_[iast];
            int yaed = cy - this.py_[iaed];
            if (yast >= yaed) {
                ystop1 = yast;
                ystop2 = yaed;
            } else {
                ystop1 = yaed;
                ystop2 = yast;
            }
            LineAlg ll = new LineAlg(cx, cy, cx + this.px_[iast], cy - this.py_[iast]);
            LineAlg lr = new LineAlg(cx, cy, cx - this.px_[iaed], cy - this.py_[iaed]);
            lr.nextPoint(null);
            ll.nextPoint(null);
            int ic = this.fillArc_TopLeftArcToRightLine_LeftLineToRightArc(gd, cx, cy, cy - 1, ystop1, 1, lr, ll);
            ic = ystop1 == yast ? this.fillArc_TopLeftArcToRightLine(gd, cx, cy, ystop1 - 1, ystop2, ic, lr) : this.fillArc_TopLeftLineToRightArc(gd, cx, cy, ystop1 - 1, ystop2, ll, ic);
        }

        private void fillArc02Top(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int iast = OvalAlg.GetIndex(this, nast);
            int yast = cy - this.py_[iast];
            LineAlg lr = new LineAlg(cx, cy, cx + this.px_[iast], yast);
            lr.nextPoint(null);
            int ic = this.fillArc_TopLeftArcToRightLine(gd, cx, cy, cy, yast, 0, lr);
            this.fillArc_Top(gd, cx, cy, yast - 1, ic);
            int iaed = OvalAlg.GetIndex(this, naed);
            if (iaed > 0) {
                int yaed = cy + this.py_[iaed];
                lr.setLine(cx, cy, cx - this.px_[iaed], yaed);
                lr.nextPoint(null);
                this.fillArc_BtmLeftArcToRightLine(gd, cx, cy, cy + 1, yaed, 1, lr);
            }
        }

        private void fillArc02Bottom(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int iast = OvalAlg.GetIndex(this, nast);
            LineAlg ll = null;
            if (iast > 0) {
                int yast = cy - this.py_[iast];
                ll = new LineAlg(cx, cy, cx + this.px_[iast], yast);
                ll.nextPoint(null);
                this.fillArc_TopLeftLineToRightArc(gd, cx, cy, cy, yast, ll, 0);
            }
            int iaed = OvalAlg.GetIndex(this, naed);
            int yaed = cy + this.py_[iaed];
            if (ll != null) {
                ll.setLine(cx, cy, cx - this.px_[iaed], yaed);
            } else {
                ll = new LineAlg(cx, cy, cx - this.px_[iaed], yaed);
            }
            ll.nextPoint(null);
            int ic = this.fillArc_BtmLeftLineToRightArc(gd, cx, cy, cy + 1, yaed, ll, 1);
            this.fillArc_Bottom(gd, cx, cy, yaed + 1, ic);
        }

        private void fillArc03Right(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int iast = OvalAlg.GetIndex(this, nast);
            int yast = cy - this.py_[iast];
            LineAlg ll = new LineAlg(cx, cy, cx + this.px_[iast], yast);
            ll.nextPoint(null);
            this.fillArc_TopLeftLineToRightArc(gd, cx, cy, cy, yast, ll, 0);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yaed = cy + this.py_[iaed];
            ll.setLine(cx, cy, cx + this.px_[iaed], yaed);
            ll.nextPoint(null);
            this.fillArc_BtmLeftLineToRightArc(gd, cx, cy, cy + 1, yaed, ll, 1);
        }

        private void fillArc03Left(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int iast = OvalAlg.GetIndex(this, nast);
            int ystop = cy - this.py_[iast];
            LineAlg lr = new LineAlg(cx, cy, cx + this.px_[iast], ystop);
            lr.nextPoint(null);
            int ic = 0;
            ic = this.fillArc_TopLeftArcToRightLine(gd, cx, cy, cy, ystop, 0, lr);
            this.fillArc_Top(gd, cx, cy, ystop - 1, ic);
            int iaed = OvalAlg.GetIndex(this, naed);
            int cfr_ignored_0 = cy + 1;
            ic = 1;
            ystop = cy + this.py_[iaed];
            lr.setLine(cx, cy, cx + this.px_[iaed], ystop);
            lr.nextPoint(null);
            ic = this.fillArc_BtmLeftArcToRightLine(gd, cx, cy, cy + 1, ystop, ic, lr);
            this.fillArc_Bottom(gd, cx, cy, ystop + 1, ic);
        }

        private void fillArc11Tiny(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int iast = OvalAlg.GetIndex(this, nast);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yast = cy - this.py_[iast];
            int yaed = cy - this.py_[iaed];
            int yscan = cy;
            LineAlg lr = new LineAlg(cx, cy, cx - this.px_[iast], yast);
            LineAlg ll = new LineAlg(cx, cy, cx - this.px_[iaed], yaed);
            lr.nextPoint(null);
            ll.nextPoint(null);
            this.fillArc_TopLeftLineToRightLine(gd, yscan, yaed + 1, ll, lr);
            this.fillArc_TopLeftArcToRightLine(gd, cx, cy, yaed, yast, iaed, lr);
        }

        private void fillArc11Full(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int ystop2;
            int ystop1;
            this.fillQuadrant23(gd, cx, cy);
            int iast = OvalAlg.GetIndex(this, nast);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yast = cy - this.py_[iast];
            int yaed = cy - this.py_[iaed];
            if (yast >= yaed) {
                ystop1 = yast;
                ystop2 = yaed;
            } else {
                ystop1 = yaed;
                ystop2 = yast;
            }
            LineAlg lr = new LineAlg(cx, cy, cx - this.px_[iast], yast);
            LineAlg ll = new LineAlg(cx, cy, cx - this.px_[iaed], yaed);
            lr.nextPoint(null);
            ll.nextPoint(null);
            int ic = this.fillArc_TopLeftArcToRightLine_LeftLineToRightArc(gd, cx, cy, cy - 1, ystop1, 1, lr, ll);
            ic = this.fillArc_TopLeftLineToRightArc(gd, cx, cy, ystop1 - 1, ystop2, ll, ic);
            this.fillArc_Top(gd, cx, cy, ystop2 - 1, ic);
        }

        private void fillArc12Left(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int iast = OvalAlg.GetIndex(this, nast);
            int yast = cy - this.py_[iast];
            LineAlg lr = new LineAlg(cx, cy, cx - this.px_[iast], yast);
            lr.nextPoint(null);
            this.fillArc_TopLeftArcToRightLine(gd, cx, cy, cy, yast, 0, lr);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yaed = cy + this.py_[iaed];
            lr.setLine(cx, cy, cx - this.px_[iaed], yaed);
            lr.nextPoint(null);
            this.fillArc_BtmLeftArcToRightLine(gd, cx, cy, cy + 1, yaed, 1, lr);
        }

        private void fillArc12Right(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int iast = OvalAlg.GetIndex(this, nast);
            int yast = cy - this.py_[iast];
            LineAlg ll = new LineAlg(cx, cy, cx - this.px_[iast], yast);
            ll.nextPoint(null);
            int ic = this.fillArc_TopLeftLineToRightArc(gd, cx, cy, cy, yast, ll, 0);
            this.fillArc_Top(gd, cx, cy, yast - 1, ic);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yaed = cy + this.py_[iaed];
            ll.setLine(cx, cy, cx - this.px_[iaed], yaed);
            ll.nextPoint(null);
            ic = this.fillArc_BtmLeftLineToRightArc(gd, cx, cy, cy + 1, yaed, ll, 1);
            this.fillArc_Bottom(gd, cx, cy, yaed + 1, ic);
        }

        private void fillArc13Left(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int iast = OvalAlg.GetIndex(this, nast);
            int yast = cy - this.py_[iast];
            LineAlg lr = new LineAlg(cx, cy, cx - this.px_[iast], yast);
            lr.nextPoint(null);
            this.fillArc_TopLeftArcToRightLine(gd, cx, cy, cy, yast, 0, lr);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yaed = cy + this.py_[iaed];
            lr.setLine(cx, cy, cx + this.px_[iaed], yaed);
            lr.nextPoint(null);
            int ic = this.fillArc_BtmLeftArcToRightLine(gd, cx, cy, cy + 1, yaed, 1, lr);
            this.fillArc_Bottom(gd, cx, cy, yaed + 1, ic);
        }

        private void fillArc13Right(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int iast = OvalAlg.GetIndex(this, nast);
            int yast = cy - this.py_[iast];
            LineAlg ll = new LineAlg(cx, cy, cx - this.px_[iast], yast);
            ll.nextPoint(null);
            int ic = this.fillArc_TopLeftLineToRightArc(gd, cx, cy, cy, yast, ll, 0);
            this.fillArc_Top(gd, cx, cy, yast - 1, ic);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yaed = cy + this.py_[iaed];
            ll.setLine(cx, cy, cx + this.px_[iaed], yaed);
            ll.nextPoint(null);
            this.fillArc_BtmLeftLineToRightArc(gd, cx, cy, cy + 1, yaed, ll, 1);
        }

        private void fillArc22Tiny(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int iast = OvalAlg.GetIndex(this, nast);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yast = cy + this.py_[iast];
            int yaed = cy + this.py_[iaed];
            LineAlg ll = new LineAlg(cx, cy, cx - this.px_[iast], yast);
            LineAlg lr = new LineAlg(cx, cy, cx - this.px_[iaed], yaed);
            lr.nextPoint(null);
            ll.nextPoint(null);
            this.fillArc_BtmLeftLineToRightLine(gd, cy, yast - 1, ll, lr);
            this.fillArc_BtmLeftArcToRightLine(gd, cx, cy, yast, yaed, iast, lr);
        }

        private void fillArc22Full(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int ystop2;
            int ystop1;
            this.fillQuadrant01(gd, cx, cy);
            int iast = OvalAlg.GetIndex(this, nast);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yast = cy + this.py_[iast];
            int yaed = cy + this.py_[iaed];
            if (yast <= yaed) {
                ystop1 = yast;
                ystop2 = yaed;
            } else {
                ystop1 = yaed;
                ystop2 = yast;
            }
            int yscan = cy + 1;
            LineAlg ll = new LineAlg(cx, cy, cx - this.px_[iast], yast);
            LineAlg lr = new LineAlg(cx, cy, cx - this.px_[iaed], yaed);
            lr.nextPoint(null);
            ll.nextPoint(null);
            int ic = this.fillArc_BtmLeftArcToRightLine_LeftLineToRightArc(gd, cx, cy, yscan, ystop1, 1, lr, ll);
            ic = this.fillArc_BtmLeftLineToRightArc(gd, cx, cy, ystop1 + 1, ystop2, ll, ic);
            this.fillArc_Bottom(gd, cx, cy, ystop2 + 1, ic);
        }

        private void fillArc23Bottom(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int ystop2;
            int ystop1;
            int iaed;
            int yaed;
            int iast = OvalAlg.GetIndex(this, nast);
            int yast = cy + this.py_[iast];
            if (yast <= (yaed = cy + this.py_[iaed = OvalAlg.GetIndex(this, naed)])) {
                ystop1 = yast;
                ystop2 = yaed;
            } else {
                ystop1 = yaed;
                ystop2 = yast;
            }
            LineAlg ll = new LineAlg(cx, cy, cx - this.px_[iast], yast);
            LineAlg lr = new LineAlg(cx, cy, cx + this.px_[iaed], yaed);
            lr.nextPoint(null);
            ll.nextPoint(null);
            this.fillArc_BtmLeftLineToRightLine(gd, cy, ystop1 - 1, ll, lr);
            int ic = ystop1 == yast ? this.fillArc_BtmLeftArcToRightLine(gd, cx, cy, ystop1, ystop2 - 1, iast, lr) : this.fillArc_BtmLeftLineToRightArc(gd, cx, cy, ystop1, ystop2 - 1, ll, iaed);
            this.fillArc_Bottom(gd, cx, cy, ystop2, ic);
        }

        private void fillArc23Top(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int ystop2;
            int ystop1;
            this.fillQuadrant01(gd, cx, cy);
            int iast = OvalAlg.GetIndex(this, nast);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yast = cy + this.py_[iast];
            int yaed = cy + this.py_[iaed];
            if (yast <= yaed) {
                ystop1 = yast;
                ystop2 = yaed;
            } else {
                ystop1 = yaed;
                ystop2 = yast;
            }
            LineAlg lr = new LineAlg(cx, cy, cx - this.px_[iast], yast);
            LineAlg ll = new LineAlg(cx, cy, cx + this.px_[iaed], yaed);
            lr.nextPoint(null);
            ll.nextPoint(null);
            int ic = this.fillArc_BtmLeftArcToRightLine_LeftLineToRightArc(gd, cx, cy, cy + 1, ystop1, 1, lr, ll);
            if (ystop1 == yast) {
                this.fillArc_BtmLeftLineToRightArc(gd, cx, cy, ystop1 + 1, ystop2, ll, ic);
            } else {
                this.fillArc_BtmLeftArcToRightLine(gd, cx, cy, ystop1 + 1, ystop2, ic, lr);
            }
        }

        private void fillArc33Tiny(IGCDirect gd, int cx, int cy, double nast, double naed) {
            System.out.println("fillArc33 Tinu");
            int iast = OvalAlg.GetIndex(this, nast);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yast = cy + this.py_[iast];
            int yaed = cy + this.py_[iaed];
            LineAlg ll = new LineAlg(cx, cy, cx + this.px_[iast], yast);
            LineAlg lr = new LineAlg(cx, cy, cx + this.px_[iaed], yaed);
            lr.nextPoint(null);
            ll.nextPoint(null);
            this.fillArc_BtmLeftLineToRightLine(gd, cy, yaed - 1, ll, lr);
            this.fillArc_BtmLeftLineToRightArc(gd, cx, cy, yaed, yast, ll, iaed);
        }

        private void fillArc33Full(IGCDirect gd, int cx, int cy, double nast, double naed) {
            int ystop2;
            int ystop1;
            System.out.println("fillArc33 Full");
            this.fillQuadrant01(gd, cx, cy);
            int iast = OvalAlg.GetIndex(this, nast);
            int iaed = OvalAlg.GetIndex(this, naed);
            int yast = cy + this.py_[iast];
            int yaed = cy + this.py_[iaed];
            if (yast <= yaed) {
                ystop1 = yast;
                ystop2 = yaed;
            } else {
                ystop1 = yaed;
                ystop2 = yast;
            }
            int yscan = cy + 1;
            LineAlg ll = new LineAlg(cx, cy, cx + this.px_[iast], yast);
            LineAlg lr = new LineAlg(cx, cy, cx + this.px_[iaed], yaed);
            lr.nextPoint(null);
            ll.nextPoint(null);
            int ic = this.fillArc_BtmLeftArcToRightLine_LeftLineToRightArc(gd, cx, cy, yscan, ystop1, 1, lr, ll);
            ic = this.fillArc_BtmLeftArcToRightLine(gd, cx, cy, ystop1 + 1, ystop2, ic, lr);
            this.fillArc_Bottom(gd, cx, cy, ystop2 + 1, ic);
        }
    }
}

