/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.report.igc.alg.internal;

import org.eclipse.tptp.platform.report.igc.alg.internal.SplineAlg;

public class Spline3Alg
extends SplineAlg {
    protected int xa_;
    protected int ya_;
    protected int xb_;
    protected int yb_;
    protected int xc_;
    protected int yc_;

    public Spline3Alg(int _xa, int _ya, int _xb, int _yb, int _xc, int _yc) {
        this.xa_ = _xa;
        this.ya_ = _ya;
        this.xb_ = _xb;
        this.yb_ = _yb;
        this.xc_ = _xc;
        this.yc_ = _yc;
        this.state_ = 0;
    }

    public Spline3Alg() {
    }

    public void setSpline(int _xa, int _ya, int _xb, int _yb, int _xc, int _yc) {
        this.xa_ = _xa;
        this.ya_ = _ya;
        this.xb_ = _xb;
        this.yb_ = _yb;
        this.xc_ = _xc;
        this.yc_ = _yc;
        this.state_ = 0;
    }

    public void setHullPath(boolean b) {
        this.flags_ = b ? (byte)(this.flags_ | 8) : (byte)(this.flags_ & 0xFFFFFFF7);
        this.flags_ = (byte)(this.flags_ & 0xFFFFFFFD);
    }

    public int getXA() {
        return this.xa_;
    }

    public int getYA() {
        return this.ya_;
    }

    public int getXB() {
        return this.xb_;
    }

    public int getYB() {
        return this.yb_;
    }

    public int getXC() {
        return this.xc_;
    }

    public int getYC() {
        return this.yc_;
    }

    protected int divide(int index, double xa, double ya, double xb, double yb, double xc, double yc, int level) {
        if (level < 5) {
            double xab = (xa + xb) / 2.0;
            double yab = (ya + yb) / 2.0;
            double xbc = (xb + xc) / 2.0;
            double ybc = (yb + yc) / 2.0;
            double xp = (xa + xb * 2.0 + xc) / 4.0;
            double yp = (ya + yb * 2.0 + yc) / 4.0;
            index = this.divide(index, xa, ya, xab, yab, xp, yp, level + 1);
            this.points_[index++] = (int)Math.round(xp);
            this.points_[index++] = (int)Math.round(yp);
            index = this.divide(index, xp, yp, xbc, ybc, xc, yc, level + 1);
        }
        return index;
    }

    protected void prepareDPoints() {
        if (this.points_ == null) {
            this.points_ = new int[66];
            this.state_ = (byte)-1;
        }
        if ((this.flags_ & 8) != 0) {
            this.points_[0] = this.xa_;
            this.points_[1] = this.ya_;
            this.points_[2] = this.xb_;
            this.points_[3] = this.yb_;
            this.points_[4] = this.xc_;
            this.points_[5] = this.yc_;
            this.num_points_ = 6;
        } else {
            this.points_[0] = this.xa_;
            this.points_[1] = this.ya_;
            int i = this.divide(2, this.xa_, this.ya_, this.xb_, this.yb_, this.xc_, this.yc_, 0);
            this.points_[i++] = this.xc_;
            this.points_[i++] = this.yc_;
            this.num_points_ = i;
        }
        this.flags_ = (byte)(this.flags_ & 0xFFFFFFFD);
    }
}

